/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.io.IOError;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.yoko.orb.CORBA.InputStream;
import org.apache.yoko.orb.CORBA.ORB;
import org.apache.yoko.orb.OB.IORUtil;
import org.apache.yoko.orb.OB.Version;
import org.apache.yoko.orb.OCI.ConFactory;
import org.apache.yoko.orb.OCI.ConFactoryRegistry;
import org.apache.yoko.orb.OCI.ConFactoryRegistryHelper;
import org.apache.yoko.util.Assert;
import org.apache.yoko.util.Hex;
import org.apache.yoko.util.HexConverter;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.UserException;
import org.omg.IOP.IOR;
import org.omg.IOP.IORHelper;
import org.omg.IOP.TaggedComponent;
import org.omg.IOP.TaggedComponentHelper;
import org.omg.IOP.TaggedProfile;

public class IORDump {
    public static String describeIor(org.omg.CORBA.ORB orb, IOR ior) {
        try {
            return IORDump.describeIor(new StringBuilder(), orb, ior).toString();
        }
        catch (Throwable t) {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            pw.println(t);
            t.printStackTrace(pw);
            return sw.toString();
        }
    }

    private static StringBuilder describeIor(StringBuilder sb, org.omg.CORBA.ORB orb, IOR ior) {
        sb.append("type_id: ").append(ior.type_id).append('\n');
        ConFactoryRegistry conFactoryRegistry = null;
        try {
            Object obj = orb.resolve_initial_references("OCIConFactoryRegistry");
            conFactoryRegistry = ConFactoryRegistryHelper.narrow(obj);
        }
        catch (InvalidName ex) {
            throw Assert.fail((Throwable)ex);
        }
        ConFactory[] factories = conFactoryRegistry.get_factories();
        int count = 1;
        for (TaggedProfile p : ior.profiles) {
            IORDump.describeProfile(sb, factories, p, count++);
        }
        return sb;
    }

    private static void describeProfile(StringBuilder sb, ConFactory[] factories, TaggedProfile p, int index) {
        sb.append("Profile #").append(index).append(": ");
        if (p.tag == 1) {
            sb.append("multiple components");
            InputStream in = new InputStream(p.profile_data);
            in._OB_readEndian();
            int cnt = in.read_ulong();
            if (cnt == 0) {
                sb.append('\n');
            } else {
                for (int j = 0; j < cnt; ++j) {
                    TaggedComponent comp = TaggedComponentHelper.read((org.omg.CORBA.portable.InputStream)in);
                    IORUtil.describe_component(comp, sb);
                }
            }
        } else {
            Optional<ConFactory> factory = Arrays.stream(factories).filter(f -> f.tag() == p.tag).findAny();
            if (factory.isPresent()) {
                ConFactory f2 = factory.get();
                sb.append(f2.id()).append('\n');
                String desc = f2.describe_profile(p);
                sb.append(desc);
            } else {
                sb.append("unknown profile tag ").append(p.tag).append('\n');
                sb.append("profile_data: (").append(p.profile_data.length).append(")\n");
                Hex.formatHexPara((byte[])p.profile_data, (StringBuilder)sb);
            }
        }
    }

    private static String describeIorString(org.omg.CORBA.ORB orb, String ref, boolean describeByteOrder) {
        if (!ref.startsWith("IOR:")) {
            return "IOR is invalid\n";
        }
        byte[] data = HexConverter.asciiToOctets((String)ref, (int)4);
        InputStream in = new InputStream(data);
        StringBuilder sb = new StringBuilder();
        if (describeByteOrder) {
            sb.append("byteorder: ");
            boolean endian = in.read_boolean();
            in._OB_swap(endian);
            sb.append((endian ? "little" : "big") + " endian\n");
        } else {
            in._OB_readEndian();
        }
        IORDump.describeIor(sb, orb, IORHelper.read((org.omg.CORBA.portable.InputStream)in));
        return sb.toString();
    }

    private static void usage() {
        System.err.println("Usage:");
        System.err.println("org.apache.yoko.orb.OB.IORDump [options] [-f FILE ... | IOR ...]\n\nOptions:\n-h, --help          Show this message.\n-v, --version       Show Yoko version.\n-f                  Read IORs from files instead of from the\n                    command line.");
    }

    private static int run(org.omg.CORBA.ORB orb, String[] args) throws UserException {
        int i;
        boolean files = false;
        block12: for (i = 0; i < args.length && args[i].charAt(0) == '-'; ++i) {
            switch (args[i]) {
                case "--help": 
                case "-h": {
                    IORDump.usage();
                    return 0;
                }
                case "--version": 
                case "-v": {
                    System.out.println("Yoko " + Version.getVersion());
                    return 0;
                }
                case "-f": {
                    files = true;
                    continue block12;
                }
                default: {
                    System.err.println("IORDump: unknown option `" + args[i] + "'");
                    IORDump.usage();
                    return 1;
                }
            }
        }
        if (i == args.length) {
            System.err.println("IORDump: no IORs");
            System.err.println();
            IORDump.usage();
            return 1;
        }
        AtomicInteger count = new AtomicInteger(1);
        Stream<String> remainingArgs = Arrays.stream(args).skip(i);
        if (files) {
            remainingArgs.map(x$0 -> Paths.get(x$0, new String[0])).flatMap(IORDump::lines).forEach(line -> IORDump.printIorString(orb, line, count.getAndIncrement()));
        } else {
            remainingArgs.forEach(arg -> IORDump.printIorString(orb, arg, count.getAndIncrement()));
        }
        return 0;
    }

    static Stream<String> lines(Path p) {
        try {
            return Files.lines(p);
        }
        catch (IOException e) {
            System.err.println("IORDump: can't open '" + p + "': " + e);
            throw new IOError(e);
        }
    }

    private static void printIorString(org.omg.CORBA.ORB orb, String ior, int index) {
        if (index > 1) {
            System.out.println();
        }
        System.out.println("IOR #" + index + ':');
        try {
            if (ior.startsWith("IOR:")) {
                System.out.println(IORDump.describeIorString(orb, ior, true));
            } else {
                Object obj = orb.string_to_object(ior);
                String s = orb.object_to_string(obj);
                System.out.println(IORDump.describeIorString(orb, s, false));
            }
        }
        catch (BAD_PARAM ex) {
            System.err.println("IOR is invalid: " + ior);
        }
    }

    public static void main(String ... args) {
        int status;
        Properties props = new Properties();
        props.putAll((Map<?, ?>)System.getProperties());
        props.put("org.omg.CORBA.ORBClass", "org.apache.yoko.orb.CORBA.ORB");
        props.put("org.omg.CORBA.ORBSingletonClass", "org.apache.yoko.orb.CORBA.ORBSingleton");
        org.omg.CORBA.ORB orb = null;
        try {
            args = ORB.ParseArgs(args, props, null);
            orb = org.omg.CORBA.ORB.init((String[])args, (Properties)props);
            status = IORDump.run(orb, args);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            status = 1;
        }
        if (orb != null) {
            try {
                orb.destroy();
            }
            catch (Exception ex) {
                ex.printStackTrace();
                status = 1;
            }
        }
        System.exit(status);
    }
}

