/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.orb.OB;

import java.util.function.BiConsumer;
import org.apache.yoko.orb.OB.CodeSetInfo;
import org.apache.yoko.util.Hex;
import org.omg.CONV_FRAME.CodeSetComponentInfo;
import org.omg.CONV_FRAME.CodeSetComponentInfoHelper;
import org.omg.CORBA.portable.InputStream;
import org.omg.CSIIOP.CompoundSecMech;
import org.omg.CSIIOP.CompoundSecMechList;
import org.omg.CSIIOP.CompoundSecMechListHelper;
import org.omg.CSIIOP.SECIOP_SEC_TRANS;
import org.omg.CSIIOP.SECIOP_SEC_TRANSHelper;
import org.omg.CSIIOP.ServiceConfiguration;
import org.omg.CSIIOP.TLS_SEC_TRANS;
import org.omg.CSIIOP.TLS_SEC_TRANSHelper;
import org.omg.CSIIOP.TransportAddress;
import org.omg.IOP.TaggedComponent;

public final class IORUtil {
    private static void describeCSISecMechList(TaggedComponent component, StringBuilder sb) {
        org.apache.yoko.orb.CORBA.InputStream in = new org.apache.yoko.orb.CORBA.InputStream(component.component_data);
        in._OB_readEndian();
        CompoundSecMechList info = CompoundSecMechListHelper.read((InputStream)in);
        sb.append("CSI Security Mechanism List Components:\n");
        sb.append("    stateful: " + info.stateful + "\n");
        sb.append("    mechanism_list:\n");
        for (CompoundSecMech mech : info.mechanism_list) {
            sb.append("        target_requires: ");
            IORUtil.describeTransportFlags(mech.target_requires, sb);
            sb.append("\n");
            if (mech.transport_mech != null) {
                if (mech.transport_mech.tag == 34) {
                    sb.append("            Null Transport\n");
                } else if (mech.transport_mech.tag == 36) {
                    IORUtil.describeTLS_SEC_TRANS(mech.transport_mech, sb);
                } else if (mech.transport_mech.tag == 35) {
                    IORUtil.describeSECIOP_SEC_TRANS(mech.transport_mech, sb);
                }
            }
            if (mech.as_context_mech != null) {
                sb.append("            as_context_mech:\n");
                sb.append("                supports: ");
                IORUtil.describeTransportFlags(mech.as_context_mech.target_supports, sb);
                sb.append("\n");
                sb.append("                requires: ");
                IORUtil.describeTransportFlags(mech.as_context_mech.target_requires, sb);
                sb.append("\n");
                sb.append("                client_authentication_mech: ");
                Hex.formatHexLine((byte[])mech.as_context_mech.client_authentication_mech, (StringBuilder)sb);
                sb.append("\n");
                sb.append("                target_name: ");
                Hex.formatHexLine((byte[])mech.as_context_mech.target_name, (StringBuilder)sb);
                sb.append("\n");
            }
            if (mech.sas_context_mech == null) continue;
            sb.append("            sas_context_mech:\n");
            sb.append("                supports: ");
            IORUtil.describeTransportFlags(mech.sas_context_mech.target_supports, sb);
            sb.append("\n");
            sb.append("                requires: ");
            IORUtil.describeTransportFlags(mech.sas_context_mech.target_requires, sb);
            sb.append("\n");
            sb.append("                privilege_authorities:\n");
            for (ServiceConfiguration auth : mech.sas_context_mech.privilege_authorities) {
                sb.append("                    syntax: " + auth.syntax + "\n");
                sb.append("                    name: ");
                Hex.formatHexLine((byte[])auth.name, (StringBuilder)sb);
                sb.append("\n");
            }
            sb.append("                supported_naming_mechanisms:\n");
            for (byte[] namingMech : mech.sas_context_mech.supported_naming_mechanisms) {
                sb.append("                    ");
                Hex.formatHexLine((byte[])namingMech, (StringBuilder)sb);
                sb.append("\n");
            }
            sb.append("                supported_identity_type: ");
            IORUtil.describeIdentityToken(mech.sas_context_mech.supported_identity_types, sb);
            sb.append("\n");
        }
    }

    private static void describeTransportFlags(int flag, StringBuilder sb) {
        if ((1 & flag) != 0) {
            sb.append("NoProtection ");
        }
        if ((2 & flag) != 0) {
            sb.append("Integrity ");
        }
        if ((4 & flag) != 0) {
            sb.append("Confidentiality ");
        }
        if ((8 & flag) != 0) {
            sb.append("DetectReplay ");
        }
        if ((0x10 & flag) != 0) {
            sb.append("DetectMisordering ");
        }
        if ((0x20 & flag) != 0) {
            sb.append("EstablishTrustInTarget ");
        }
        if ((0x40 & flag) != 0) {
            sb.append("EstablishTrustInClient ");
        }
        if ((0x80 & flag) != 0) {
            sb.append("NoDelegation ");
        }
        if ((0x100 & flag) != 0) {
            sb.append("SimpleDelegation ");
        }
        if ((0x200 & flag) != 0) {
            sb.append("CompositeDelegation ");
        }
        if ((0x400 & flag) != 0) {
            sb.append("IdentityAssertion ");
        }
        if ((0x800 & flag) != 0) {
            sb.append("DelegationByClient ");
        }
    }

    private static void describeIdentityToken(int flag, StringBuilder sb) {
        if (flag == 0) {
            sb.append("Absent");
            return;
        }
        if ((1 & flag) != 0) {
            sb.append("Anonymous ");
        }
        if ((2 & flag) != 0) {
            sb.append("PrincipalName ");
        }
        if ((4 & flag) != 0) {
            sb.append("X509CertChain ");
        }
        if ((8 & flag) != 0) {
            sb.append("DistinguishedName ");
        }
    }

    private static void describeTLS_SEC_TRANS(TaggedComponent component, StringBuilder sb) {
        org.apache.yoko.orb.CORBA.InputStream in = new org.apache.yoko.orb.CORBA.InputStream(component.component_data);
        in._OB_readEndian();
        TLS_SEC_TRANS info = TLS_SEC_TRANSHelper.read((InputStream)in);
        sb.append("        TLS_SEC_TRANS component:\n");
        sb.append("            target_supports: ");
        IORUtil.describeTransportFlags(info.target_supports, sb);
        sb.append("\n");
        sb.append("            target_requires: ");
        IORUtil.describeTransportFlags(info.target_requires, sb);
        sb.append("\n");
        sb.append("            addresses:\n");
        for (TransportAddress address : info.addresses) {
            sb.append("                host_name: ").append(address.host_name).append("\n");
            sb.append("                port: ").append(address.port).append("\n");
        }
    }

    private static void describeSECIOP_SEC_TRANS(TaggedComponent component, StringBuilder sb) {
        org.apache.yoko.orb.CORBA.InputStream in = new org.apache.yoko.orb.CORBA.InputStream(component.component_data);
        in._OB_readEndian();
        SECIOP_SEC_TRANS info = SECIOP_SEC_TRANSHelper.read((InputStream)in);
        sb.append("        SECIOP_SEC_TRANS component:\n");
        sb.append("            target_supports: ");
        IORUtil.describeTransportFlags(info.target_supports, sb);
        sb.append("\n");
        sb.append("            target_requires: ");
        IORUtil.describeTransportFlags(info.target_requires, sb);
        sb.append("\n");
        sb.append("            mech_oid: ");
        Hex.formatHexLine((byte[])info.mech_oid, (StringBuilder)sb);
        sb.append("\n");
        sb.append("            target_name: ");
        Hex.formatHexLine((byte[])info.target_name, (StringBuilder)sb);
        sb.append("\n");
        sb.append("            addresses:\n");
        for (TransportAddress address : info.addresses) {
            sb.append("                host_name: ").append(address.host_name).append("\n");
            sb.append("                port: ").append(address.port).append("\n");
        }
    }

    private static void describeCodeSets(TaggedComponent component, StringBuilder sb) {
        int i;
        org.apache.yoko.orb.CORBA.InputStream in = new org.apache.yoko.orb.CORBA.InputStream(component.component_data);
        in._OB_readEndian();
        CodeSetComponentInfo info = CodeSetComponentInfoHelper.read((InputStream)in);
        sb.append("Native char codeset: \n");
        CodeSetInfo charInfo = CodeSetInfo.forRegistryId(info.ForCharData.native_code_set);
        if (charInfo != null) {
            sb.append("  \"").append(charInfo.description).append("\"\n");
        } else if (info.ForCharData.native_code_set == 0) {
            sb.append("  [No codeset information]\n");
        } else {
            sb.append("  [Unknown codeset id: ").append(info.ForCharData.native_code_set).append("]\n");
        }
        for (i = 0; i < info.ForCharData.conversion_code_sets.length; ++i) {
            charInfo = CodeSetInfo.forRegistryId(info.ForCharData.conversion_code_sets[i]);
            if (i == 0) {
                sb.append("Char conversion codesets:\n");
            }
            if (charInfo != null) {
                sb.append("  \"").append(charInfo.description).append("\"\n");
                continue;
            }
            sb.append("  [Unknown codeset id: ").append(info.ForCharData.conversion_code_sets[i]).append("]\n");
        }
        sb.append("Native wchar codeset: \n");
        charInfo = CodeSetInfo.forRegistryId(info.ForWcharData.native_code_set);
        if (charInfo != null) {
            sb.append("  \"").append(charInfo.description).append("\"\n");
        } else if (info.ForWcharData.native_code_set == 0) {
            sb.append("  [No codeset information]\n");
        } else {
            sb.append("  [Unknown codeset id: ").append(info.ForWcharData.native_code_set).append("]\n");
        }
        for (i = 0; i < info.ForWcharData.conversion_code_sets.length; ++i) {
            if (i == 0) {
                sb.append("Wchar conversion codesets:\n");
            }
            if ((charInfo = CodeSetInfo.forRegistryId(info.ForWcharData.conversion_code_sets[i])) != null) {
                sb.append("  \"").append(charInfo.description).append("\"\n");
                continue;
            }
            sb.append("  [Unknown codeset id: ").append(info.ForWcharData.conversion_code_sets[i]).append("]\n");
        }
    }

    private static void describeGenericComponent(TaggedComponent component, String name, StringBuilder sb) {
        sb.append("Component: ").append(name).append('\n');
        sb.append("Component data: (").append(component.component_data.length).append(")\n");
        Hex.formatHexPara((byte[])component.component_data, (int)0, (int)component.component_data.length, (StringBuilder)sb).append('\n');
    }

    private static void describeJavaCodebase(TaggedComponent component, StringBuilder sb) {
        org.apache.yoko.orb.CORBA.InputStream in = new org.apache.yoko.orb.CORBA.InputStream(component.component_data);
        in._OB_readEndian();
        String codebase = in.read_string();
        sb.append("Component: TAG_JAVA_CODEBASE = '").append(codebase).append("'\n");
    }

    private static void describeAlternateIiop(TaggedComponent component, StringBuilder sb) {
        org.apache.yoko.orb.CORBA.InputStream in = new org.apache.yoko.orb.CORBA.InputStream(component.component_data);
        in._OB_readEndian();
        String host = in.read_string();
        int port = 0xFFFF & in.read_ushort();
        sb.append("Alternate IIOP address:\n");
        sb.append("  host: ").append(host).append('\n');
        sb.append("  port: ").append(port).append('\n');
    }

    private static void describeOrbType(TaggedComponent component, StringBuilder sb) {
        org.apache.yoko.orb.CORBA.InputStream in = new org.apache.yoko.orb.CORBA.InputStream(component.component_data);
        in._OB_readEndian();
        sb.append("Component: TAG_ORB_TYPE = 0x").append(Integer.toHexString(in.read_ulong())).append('\n');
    }

    private static void describeUnknown(TaggedComponent component, StringBuilder sb) {
        IORUtil.describeGenericComponent(component, String.format("unknown (tag = 0x%x)", component.tag), sb);
    }

    public static void describe_component(TaggedComponent component, StringBuilder sb) {
        TagComp.findById(component.tag).describe(component, sb);
    }

    private static enum TagComp {
        _TAG_POLICIES,
        _TAG_ASSOCIATION_OPTIONS,
        _TAG_SEC_NAME,
        _TAG_SPKM_1_SEC_MECH,
        _TAG_SPKM_2_SEC_MECH,
        _TAG_KerberosV5_SEC_MECH,
        _TAG_CSI_ECMA_Secret_SEC_MECH,
        _TAG_CSI_ECMA_Hybrid_SEC_MECH,
        _TAG_OTS_POLICY,
        _TAG_INV_POLICY,
        _TAG_SECIOP_SEC_TRANS,
        _TAG_NULL_TAG,
        _TAG_TLS_SEC_TRANS,
        _TAG_SSL_SEC_TRANS,
        _TAG_CSI_ECMA_Public_SEC_MECH,
        _TAG_GENERIC_SEC_MECH,
        _TAG_COMPLETE_OBJECT_KEY,
        _TAG_ENDPOINT_ID_POSITION,
        _TAG_LOCATION_POLICY,
        _TAG_DCE_STRING_BINDING,
        _TAG_DCE_BINDING_NAME,
        _TAG_DCE_NO_PIPES,
        _TAG_DCE_SEC_MECH,
        _TAG_CODE_SETS((x$0, x$1) -> IORUtil.access$600(x$0, x$1)),
        _TAG_ORB_TYPE((x$0, x$1) -> IORUtil.access$500(x$0, x$1)),
        _TAG_ALTERNATE_IIOP_ADDRESS((x$0, x$1) -> IORUtil.access$400(x$0, x$1)),
        _TAG_CSI_SEC_MECH_LIST((x$0, x$1) -> IORUtil.access$300(x$0, x$1)),
        _TAG_JAVA_CODEBASE((x$0, x$1) -> IORUtil.access$200(x$0, x$1)),
        _UNKNOWN((x$0, x$1) -> IORUtil.access$100(x$0, x$1));

        final BiConsumer<TaggedComponent, StringBuilder> describer;

        private TagComp(BiConsumer<TaggedComponent, StringBuilder> describer) {
            this.describer = describer;
        }

        private TagComp() {
            this(null);
        }

        void describe(TaggedComponent component, StringBuilder sb) {
            if (null == this.describer) {
                IORUtil.describeGenericComponent(component, this.toString(), sb);
            } else {
                this.describer.accept(component, sb);
            }
        }

        public String toString() {
            return super.toString().substring(1);
        }

        static TagComp findById(int id) {
            switch (id) {
                case 2: {
                    return _TAG_POLICIES;
                }
                case 13: {
                    return _TAG_ASSOCIATION_OPTIONS;
                }
                case 14: {
                    return _TAG_SEC_NAME;
                }
                case 15: {
                    return _TAG_SPKM_1_SEC_MECH;
                }
                case 16: {
                    return _TAG_SPKM_2_SEC_MECH;
                }
                case 17: {
                    return _TAG_KerberosV5_SEC_MECH;
                }
                case 18: {
                    return _TAG_CSI_ECMA_Secret_SEC_MECH;
                }
                case 19: {
                    return _TAG_CSI_ECMA_Hybrid_SEC_MECH;
                }
                case 31: {
                    return _TAG_OTS_POLICY;
                }
                case 32: {
                    return _TAG_INV_POLICY;
                }
                case 35: {
                    return _TAG_SECIOP_SEC_TRANS;
                }
                case 34: {
                    return _TAG_NULL_TAG;
                }
                case 36: {
                    return _TAG_TLS_SEC_TRANS;
                }
                case 20: {
                    return _TAG_SSL_SEC_TRANS;
                }
                case 21: {
                    return _TAG_CSI_ECMA_Public_SEC_MECH;
                }
                case 22: {
                    return _TAG_GENERIC_SEC_MECH;
                }
                case 5: {
                    return _TAG_COMPLETE_OBJECT_KEY;
                }
                case 6: {
                    return _TAG_ENDPOINT_ID_POSITION;
                }
                case 12: {
                    return _TAG_LOCATION_POLICY;
                }
                case 100: {
                    return _TAG_DCE_STRING_BINDING;
                }
                case 101: {
                    return _TAG_DCE_BINDING_NAME;
                }
                case 102: {
                    return _TAG_DCE_NO_PIPES;
                }
                case 103: {
                    return _TAG_DCE_SEC_MECH;
                }
                case 1: {
                    return _TAG_CODE_SETS;
                }
                case 0: {
                    return _TAG_ORB_TYPE;
                }
                case 3: {
                    return _TAG_ALTERNATE_IIOP_ADDRESS;
                }
                case 33: {
                    return _TAG_CSI_SEC_MECH_LIST;
                }
                case 25: {
                    return _TAG_JAVA_CODEBASE;
                }
            }
            return _UNKNOWN;
        }
    }
}

