/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.saml.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import jakarta.servlet.http.HttpServletRequest;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.saml.saml2.binding.decoding.impl.HTTPPostDecoder;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Saml20HTTPPostDecoder
extends HTTPPostDecoder {
    private static TraceComponent tc = Tr.register(Saml20HTTPPostDecoder.class, (String)"SAML20", (String)"com.ibm.ws.security.saml.sso20.internal.resources.SamlSso20Messages");
    String acsUrl;
    static final long serialVersionUID = 4236811823149592648L;

    public Saml20HTTPPostDecoder(String acsUrl) {
        this.acsUrl = acsUrl;
    }

    protected String getActualReceiverEndpointURI(MessageContext messageContext) throws MessageDecodingException {
        return this.acsUrl;
    }

    protected InputStream getBase64DecodedMessage(HttpServletRequest request) throws MessageDecodingException {
        InputStream inputStream = super.getBase64DecodedMessage(request);
        if (tc.isDebugEnabled() && inputStream instanceof ByteArrayInputStream) {
            ByteArrayInputStream byteStream = (ByteArrayInputStream)inputStream;
            int iAvailable = byteStream.available();
            if (iAvailable > 0) {
                byte[] bytes = new byte[iAvailable];
                byteStream.read(bytes, 0, iAvailable);
                byteStream.reset();
                Tr.debug((TraceComponent)tc, (String)("decoded saml response:" + new String(bytes, StandardCharsets.UTF_8)), (Object[])new Object[0]);
            } else {
                Tr.debug((TraceComponent)tc, (String)("decoded saml response has bytes count:" + iAvailable), (Object[])new Object[0]);
            }
        }
        return inputStream;
    }
}

