/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.filter;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.filter.FilterException;
import com.ibm.ws.security.oauth20.filter.IPAddressRange;
import com.ibm.ws.security.oauth20.filter.IValue;
import java.net.InetAddress;
import java.net.UnknownHostException;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ValueIPAddress
implements IValue {
    private InetAddress myIP;
    static final long serialVersionUID = 970090485864813666L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    /*
     * WARNING - void declaration
     */
    public ValueIPAddress(String ip) throws FilterException {
        try {
            this.myIP = InetAddress.getByName(ip);
        }
        catch (UnknownHostException unknownHostException) {
            void e;
            FFDCFilter.processException((Throwable)unknownHostException, (String)"com.ibm.ws.security.oauth20.filter.ValueIPAddress", (String)"31", (Object)this, (Object[])new Object[]{ip});
            String msg = TraceNLS.getFormattedMessage(this.getClass(), (String)"com.ibm.ws.security.oauth20.internal.tai.resources.OAuthTaiMessages", (String)"security.tai.ipstring.convert.error", (Object[])new Object[]{ip}, (String)"CWTAI0045E: Cannot convert   the   IP string {0} to an IP address.");
            throw new FilterException(msg, (Throwable)e);
        }
    }

    @Override
    public boolean equals(IValue ip) {
        if (ip.getClass() != ValueIPAddress.class) {
            return false;
        }
        return ((ValueIPAddress)ip).getIP().equals(this.getIP());
    }

    @Override
    public boolean greaterThan(IValue ip) {
        if (ip.getClass() != ValueIPAddress.class) {
            return false;
        }
        return IPAddressRange.greaterThan(this.getIP(), ((ValueIPAddress)ip).getIP());
    }

    @Override
    public boolean lessThan(IValue ip) {
        if (ip.getClass() != ValueIPAddress.class) {
            return false;
        }
        return IPAddressRange.lessThan(this.getIP(), ((ValueIPAddress)ip).getIP());
    }

    @Override
    public boolean containedBy(IValue ip) {
        return this.equals(ip);
    }

    public String toString() {
        return this.getIP().toString();
    }

    protected InetAddress getIP() {
        return this.myIP;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.security.oauth20.filter.ValueIPAddress", ValueIPAddress.class, null, null);
    }
}

