/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.tools;

import com.ibm.ws.jaxws.tools.WsToolsUtils;
import com.ibm.ws.jaxws.tools.internal.JaxWsToolsUtil;
import com.sun.tools.ws.wscompile.WsimportTool;
import java.io.File;
import java.io.OutputStream;
import java.io.PrintStream;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Arrays;

public class WsImport {
    private static final PrintStream err = System.err;

    public static void main(String[] args) {
        if (WsToolsUtils.isTargetRequired(args)) {
            String errMsg = JaxWsToolsUtil.formatMessage("error.parameter.target.missed");
            err.println(errMsg);
            System.exit(1);
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                System.setProperty("javax.xml.accessExternalSchema", "all");
                return null;
            }
        });
        if (WsToolsUtils.getMajorJavaVersion() > 8) {
            String classpathValue = null;
            Class<?> JAXB = null;
            Class<?> WebService2 = null;
            Class<?> Service2 = null;
            try {
                JAXB = Thread.currentThread().getContextClassLoader().loadClass("javax.xml.bind.JAXB");
                WebService2 = Thread.currentThread().getContextClassLoader().loadClass("javax.jws.WebService");
                Service2 = Thread.currentThread().getContextClassLoader().loadClass("javax.xml.ws.Service");
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
                System.exit(2);
            }
            classpathValue = WsToolsUtils.getJarFileOfClass(JAXB);
            classpathValue = classpathValue + File.pathSeparator + WsToolsUtils.getJarFileOfClass(WebService2);
            classpathValue = classpathValue + File.pathSeparator + WsToolsUtils.getJarFileOfClass(Service2);
            if (classpathValue != null) {
                boolean classpathSet = false;
                for (int i = 0; i < args.length; ++i) {
                    if (!args[i].equals("-cp") && !args[i].equals("-classpath")) continue;
                    args[i + 1] = args[i + 1] + File.pathSeparator + classpathValue;
                    classpathSet = true;
                }
                if (!classpathSet && args.length > 0) {
                    args = Arrays.copyOf(args, args.length + 2);
                    args[args.length - 1] = args[args.length - 3];
                    args[args.length - 2] = classpathValue;
                    args[args.length - 3] = "-classpath";
                }
            }
        }
        System.exit(new WsimportTool((OutputStream)System.out).run(args) ? 0 : 1);
    }
}

