/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.EnvConfigSource;
import io.smallrye.config.common.utils.StringUtil;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;

class PropertyNamesConfigSourceInterceptor
implements ConfigSourceInterceptor {
    private static final long serialVersionUID = 5263983885197566053L;
    private final Set<String> dottedProperties = new HashSet<String>();

    public PropertyNamesConfigSourceInterceptor(Set<String> properties, List<ConfigSource> sources) {
        HashSet envProperties = new HashSet();
        for (ConfigSource source : sources) {
            if (!(source instanceof EnvConfigSource)) continue;
            envProperties.addAll(source.getPropertyNames());
        }
        properties.removeAll(envProperties);
        HashSet<String> overrides = new HashSet<String>();
        block1: for (String property : properties) {
            for (String envProperty : envProperties) {
                if (!envProperty.equalsIgnoreCase(StringUtil.replaceNonAlphanumericByUnderscores(property))) continue;
                overrides.add(envProperty);
                continue block1;
            }
        }
        envProperties.removeAll(overrides);
        for (String envProperty : envProperties) {
            this.dottedProperties.add(PropertyNamesConfigSourceInterceptor.toLowerCaseAndDotted(envProperty));
        }
    }

    @Override
    public ConfigValue getValue(ConfigSourceInterceptorContext context, String name) {
        return context.proceed(name);
    }

    @Override
    public Iterator<String> iterateNames(ConfigSourceInterceptorContext context) {
        HashSet<String> names = new HashSet<String>();
        Iterator<String> namesIterator = context.iterateNames();
        while (namesIterator.hasNext()) {
            names.add(namesIterator.next());
        }
        names.addAll(this.dottedProperties);
        return names.iterator();
    }

    private static String toLowerCaseAndDotted(String name) {
        int length = name.length();
        boolean quotesOpen = false;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < length; ++i) {
            char c = name.charAt(i);
            if ('_' == c) {
                int j = i + 1;
                if (j < length) {
                    if ('_' == name.charAt(j) && !quotesOpen) {
                        sb.append(".");
                        sb.append("\"");
                        i = j;
                        quotesOpen = true;
                        continue;
                    }
                    if ('_' == name.charAt(j) && quotesOpen) {
                        sb.append("\"");
                        sb.append(".");
                        i = j;
                        quotesOpen = false;
                        continue;
                    }
                    sb.append(".");
                    continue;
                }
                sb.append(".");
                continue;
            }
            sb.append(Character.toLowerCase(c));
        }
        return sb.toString();
    }
}

