/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.reactive.streams.utils;

import io.smallrye.reactive.streams.utils.SubscriptionObserver;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public class CouplingProcessor<I, O>
implements Publisher<O> {
    private final SubscriptionObserver<I> controller;
    private final Publisher<O> publisher;

    public CouplingProcessor(Publisher<I> source, Subscriber<I> subscriber, Publisher<O> publisher) {
        this.controller = new SubscriptionObserver<I>(source, subscriber);
        this.publisher = publisher;
        this.controller.run();
    }

    public synchronized void subscribe(Subscriber<? super O> subscriber) {
        SubscriptionObserver<O> observer = new SubscriptionObserver<O>(this.publisher, subscriber);
        this.controller.setObserver(observer);
        observer.setObserver(this.controller);
        observer.run();
    }
}

