/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.openidconnect.jose4j;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.openidconnect.clients.common.OidcClientRequest;
import com.ibm.ws.security.openidconnect.token.IDTokenValidationFailedException;
import com.ibm.ws.security.openidconnect.token.JWT;
import com.ibm.ws.security.openidconnect.token.JWTTokenValidationFailedException;
import com.ibm.ws.security.openidconnect.token.JsonTokenUtil;
import java.security.InvalidKeyException;
import java.security.Key;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.joda.time.Instant;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.InvalidJwtSignatureException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class Jose4jValidator {
    private static final TraceComponent tc = Tr.register(Jose4jValidator.class, (String)"OpenIdConnect", (String)"com.ibm.ws.security.openidconnect.common.internal.resources.OidcCommonMessages");
    private String clientId = null;
    private String issuers = null;
    private String signingAlgorithm = "none";
    private final Key key;
    private long clockSkewInSeconds = 0L;
    boolean rpSpecifiedSigningAlgorithm = true;
    OidcClientRequest oidcClientRequest = null;
    static final long serialVersionUID = -2306444385157029447L;

    public Jose4jValidator(Key key, long clockSkewInSeconds, String issuers, String clientId, String signatureAlgorithm, OidcClientRequest oidcClientRequest) {
        this.key = key;
        this.clockSkewInSeconds = clockSkewInSeconds;
        this.issuers = issuers;
        this.clientId = clientId;
        this.signingAlgorithm = signatureAlgorithm;
        this.oidcClientRequest = oidcClientRequest;
    }

    @FFDCIgnore(value={InvalidJwtSignatureException.class})
    public JwtClaims parseJwtWithValidation(String jwtString, JwtContext jwtContext, JsonWebSignature signature) throws JWTTokenValidationFailedException, IllegalStateException, Exception {
        this.verifyHeaderType(signature.getHeader("typ"));
        JwtClaims jwtClaims = jwtContext.getJwtClaims();
        String issuer = jwtClaims.getIssuer();
        List audiences = jwtClaims.getAudience();
        String okAudience = this.clientId;
        if (this.oidcClientRequest.getTokenType().equalsIgnoreCase("Json Web Token")) {
            if (this.oidcClientRequest.disableIssChecking()) {
                if (issuer != null && !issuer.isEmpty()) {
                    throw JWTTokenValidationFailedException.format("PROPAGATION_TOKEN_ISS_CLAIM_NOT_REQUIRED_ERR", "iss", "disableIssChecking");
                }
            } else {
                this.checkIssuer(this.clientId, this.issuers, issuer);
            }
            List<String> allowedAudiences = this.oidcClientRequest.getAudiences();
            if (!audiences.isEmpty()) {
                String strOkAudience;
                String string = strOkAudience = this.oidcClientRequest.allowedAllAudiences() ? (String)audiences.get(0) : this.jwtAudienceElementCheck(allowedAudiences, audiences);
                if (strOkAudience == null) {
                    String aud = this.array2String(audiences);
                    throw JWTTokenValidationFailedException.format("OIDC_JWT_VERIFY_AUD_ERR", aud, this.clientId, allowedAudiences == null ? null : this.array2String(allowedAudiences));
                }
                okAudience = strOkAudience;
            } else if (!this.oidcClientRequest.allowedAllAudiences() && allowedAudiences != null) {
                String strAllowedAudiences = this.array2String(allowedAudiences);
                throw JWTTokenValidationFailedException.format("OIDC_JWT_MISSING_AUD", this.clientId, strAllowedAudiences);
            }
        } else {
            if (jwtClaims.getIssuedAt() == null) {
                throw this.oidcClientRequest.errorCommon(true, tc, "OIDC_ID_VERIFY_IAT_ERR", new Object[]{this.clientId});
            }
            this.verifyIssForIdToken(issuer);
            this.verifyAudForIdToken(audiences);
            String azp = (String)jwtClaims.getClaimValue("azp");
            if (azp != null && !azp.equals(this.clientId)) {
                throw this.oidcClientRequest.errorCommon(true, tc, "OIDC_IDTOKEN_VERIFY_AUD_AZP_ERR", new Object[]{azp, this.clientId});
            }
        }
        this.verifyIatAndExpClaims(jwtClaims);
        NumericDate nbf = jwtClaims.getNotBefore();
        if (nbf != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"nbf = ", (Object[])new Object[]{nbf});
            }
            NumericDate currentSkewTime = NumericDate.now();
            currentSkewTime.addSeconds(this.clockSkewInSeconds);
            if (nbf.isAfter(currentSkewTime)) {
                Object[] objects = new Object[]{new Date(nbf.getValueInMillis()).toString(), new Date(currentSkewTime.getValueInMillis()).toString()};
                throw this.oidcClientRequest.errorCommon(true, tc, "PROPAGATION_TOKEN_NBF_ERR", objects);
            }
        }
        this.verifyEventsClaim(jwtClaims);
        this.verifySignAlgOnly(signature);
        JwtConsumerBuilder builder = new JwtConsumerBuilder();
        builder.setRequireExpirationTime().setAllowedClockSkewInSeconds(Long.valueOf(this.clockSkewInSeconds).intValue()).setExpectedAudience(new String[]{okAudience}).setExpectedIssuer(false, issuer);
        if (!this.oidcClientRequest.getTokenType().equalsIgnoreCase("Json Web Token")) {
            builder.setRequireSubject();
        }
        if (audiences.isEmpty()) {
            builder.setSkipDefaultAudienceValidation();
        }
        if (!this.rpSpecifiedSigningAlgorithm) {
            builder.setDisableRequireSignature().setSkipSignatureVerification();
        } else {
            builder.setVerificationKey(this.key).setRelaxVerificationKeyValidation();
        }
        JwtConsumer jwtConsumer = builder.build();
        Object token = ThreadIdentityManager.runAsServer();
        try {
            JwtContext validatedJwtContext = jwtConsumer.process(jwtString);
            jwtClaims = validatedJwtContext.getJwtClaims();
        }
        catch (InvalidJwtSignatureException e) {
            Object[] objs = new Object[]{this.clientId, e.getLocalizedMessage(), this.signingAlgorithm};
            this.oidcClientRequest.errorCommon(new String[]{"OIDC_IDTOKEN_SIGNATURE_VERIFY_ERR", "OIDC_JWT_SIGNATURE_VERIFY_ERR"}, objs);
            if ("ID Token".equals(this.oidcClientRequest.getTokenType())) {
                throw new IDTokenValidationFailedException(e.getMessage(), (Exception)((Object)e));
            }
            throw new JWTTokenValidationFailedException(e.getMessage(), (Exception)((Object)e));
        }
        catch (Exception e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.openidconnect.jose4j.Jose4jValidator", (String)"209", (Object)this, (Object[])new Object[]{jwtString, jwtContext, signature});
            Throwable cause = this.getRootCause(e);
            if (cause instanceof InvalidKeyException) {
                if (cause.getMessage().contains("No installed provider")) {
                    this.oidcClientRequest.errorCommon("JWK_ENDPOINT_MISSING_ERR", new Object[0]);
                    if ("ID Token".equals(this.oidcClientRequest.getTokenType())) {
                        throw new IDTokenValidationFailedException(e.getMessage(), e);
                    }
                    throw new JWTTokenValidationFailedException(e.getMessage(), e);
                }
                throw e;
            }
            throw e;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
        return jwtClaims;
    }

    public void verifyHeaderType(String type) throws JWTTokenValidationFailedException {
        if ("logout+jwt".equals(type)) {
            String errMsg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_HAS_LOGOUT_TOKEN_TYP_HEADER", (Object[])new Object[]{type});
            throw new JWTTokenValidationFailedException(errMsg);
        }
    }

    public void verifyIssForIdToken(String issuer) throws IDTokenValidationFailedException, Exception {
        if (!JWT.checkIssuer(this.clientId, this.issuers, issuer)) {
            String errMsg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_MISSING_ISSUER", (Object[])new Object[0]);
            throw new Exception(errMsg);
        }
    }

    public void verifyAudForIdToken(List<String> audiences) throws IDTokenValidationFailedException {
        if (audiences != null && !audiences.isEmpty() && !this.multipleAudienceElementCheck(this.clientId, audiences)) {
            String aud = this.array2String(audiences);
            throw IDTokenValidationFailedException.format("OIDC_IDTOKEN_VERIFY_AUD_ERR", aud, this.clientId);
        }
    }

    public void verifyIatAndExpClaims(JwtClaims jwtClaims) throws MalformedClaimException, JWTTokenValidationFailedException {
        NumericDate issueAtClaim = jwtClaims.getIssuedAt();
        NumericDate expirationClaim = jwtClaims.getExpirationTime();
        this.verifyIatAndExpClaims(issueAtClaim, expirationClaim, jwtClaims.getSubject());
    }

    public void verifyIatAndExpClaims(NumericDate issueAtClaim, NumericDate expirationClaim, String subject) throws JWTTokenValidationFailedException {
        Instant issuedAt = null;
        Instant expiration = null;
        if (issueAtClaim == null) {
            if (expirationClaim != null) {
                issuedAt = new Instant(0L);
                expiration = new Instant(expirationClaim.getValueInMillis());
            }
        } else {
            issuedAt = new Instant(issueAtClaim.getValueInMillis());
            expiration = expirationClaim == null ? new Instant(Long.MAX_VALUE) : new Instant(expirationClaim.getValueInMillis());
        }
        if (issuedAt != null && (issuedAt.isAfter(expiration) || !JsonTokenUtil.isCurrentTimeInInterval(this.clockSkewInSeconds, issuedAt.getMillis(), expiration.getMillis()))) {
            Object[] objects = new Object[]{this.clientId, subject, new Instant(System.currentTimeMillis()), expiration, issuedAt};
            String msgCode = "OIDC_JWT_VERIFY_STATE_ERR";
            if (this.oidcClientRequest != null) {
                String failMsg = Tr.formatMessage((TraceComponent)tc, (String)msgCode, (Object[])objects);
                this.oidcClientRequest.setRsFailMsg("Expired Token", failMsg);
                throw this.oidcClientRequest.errorCommon(true, tc, msgCode, objects);
            }
            Tr.error((TraceComponent)tc, (String)msgCode, (Object[])objects);
            throw JWTTokenValidationFailedException.format(tc, msgCode, objects);
        }
    }

    public void verifyEventsClaim(JwtClaims jwtClaims) throws MalformedClaimException, JWTTokenValidationFailedException {
        Map events = (Map)jwtClaims.getClaimValue("events", Map.class);
        if (events == null) {
            return;
        }
        if (events.containsKey("http://schemas.openid.net/event/backchannel-logout")) {
            String errMsg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_HAS_LOGOUT_TOKEN_EVENTS_CLAIM", (Object[])new Object[]{events});
            throw new JWTTokenValidationFailedException(errMsg);
        }
    }

    /*
     * WARNING - void declaration
     */
    public JwtClaims validateJwsSignature(JsonWebSignature signature, String jwtString) throws JWTTokenValidationFailedException, InvalidJwtException {
        this.verifySignAlgOnly(signature);
        JwtConsumerBuilder builder = new JwtConsumerBuilder();
        builder.setSkipAllDefaultValidators();
        if (!this.rpSpecifiedSigningAlgorithm) {
            builder.setDisableRequireSignature().setSkipSignatureVerification();
        } else {
            builder.setVerificationKey(this.key).setRelaxVerificationKeyValidation();
        }
        JwtConsumer jwtConsumer = builder.build();
        Object token = ThreadIdentityManager.runAsServer();
        try {
            JwtContext validatedJwtContext = jwtConsumer.process(jwtString);
            JwtClaims jwtClaims = validatedJwtContext.getJwtClaims();
            return jwtClaims;
        }
        catch (InvalidJwtSignatureException validatedJwtContext) {
            void e;
            FFDCFilter.processException((Throwable)validatedJwtContext, (String)"com.ibm.ws.security.openidconnect.jose4j.Jose4jValidator", (String)"337", (Object)this, (Object[])new Object[]{signature, jwtString});
            Object[] objs = new Object[]{this.clientId, e.getLocalizedMessage(), this.signingAlgorithm};
            if (this.oidcClientRequest != null) {
                this.oidcClientRequest.errorCommon(new String[]{"OIDC_IDTOKEN_SIGNATURE_VERIFY_ERR", "OIDC_JWT_SIGNATURE_VERIFY_ERR"}, objs);
                if ("ID Token".equals(this.oidcClientRequest.getTokenType())) {
                    throw new IDTokenValidationFailedException(e.getMessage(), (Exception)e);
                }
                throw new JWTTokenValidationFailedException(e.getMessage(), (Exception)e);
            }
            throw new JWTTokenValidationFailedException(e.getMessage(), (Exception)e);
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    String jwtAudienceElementCheck(List<String> allowedAudiences, List<String> audiences) {
        if (allowedAudiences == null) {
            for (String audience : audiences) {
                if (!this.oidcClientRequest.isPreServiceUrl(audience)) continue;
                return audience;
            }
            return null;
        }
        for (String audience : audiences) {
            for (String allowedAud : allowedAudiences) {
                if (allowedAud == null || !allowedAud.equals(audience)) continue;
                return audience;
            }
        }
        return null;
    }

    Throwable getRootCause(Exception e) {
        Exception rootCause = null;
        Throwable tmpCause = e;
        while (tmpCause != null) {
            rootCause = tmpCause;
            tmpCause = rootCause.getCause();
        }
        return rootCause;
    }

    public void verifySignAlgOnly(JsonWebSignature signature) throws JWTTokenValidationFailedException {
        String algHeader = signature.getAlgorithmHeaderValue();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Signing Algorithm from header: " + algHeader), (Object[])new Object[0]);
        }
        boolean bl = this.rpSpecifiedSigningAlgorithm = !this.signingAlgorithm.equals("none");
        if (this.rpSpecifiedSigningAlgorithm) {
            if (signature.getEncodedSignature().isEmpty()) {
                Object[] objects = new Object[]{this.clientId, this.signingAlgorithm};
                if (this.oidcClientRequest != null) {
                    throw this.oidcClientRequest.errorCommon(true, tc, new String[]{"OIDC_IDTOKEN_SIGNATURE_VERIFY_MISSING_SIGNATURE_ERR", "OIDC_JWT_SIGNATURE_VERIFY_MISSING_SIGNATURE_ERR"}, objects);
                }
                String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"OIDC_JWT_SIGNATURE_VERIFY_MISSING_SIGNATURE_ERR", (Object[])objects);
                Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
                throw new JWTTokenValidationFailedException(errorMsg);
            }
            if (!this.signingAlgorithm.equals(algHeader)) {
                Object[] objects = new Object[]{this.clientId, this.signingAlgorithm, algHeader};
                if (this.oidcClientRequest != null) {
                    throw this.oidcClientRequest.errorCommon(true, tc, new String[]{"OIDC_IDTOKEN_SIGNATURE_VERIFY_ERR_ALG_MISMATCH", "OIDC_JWT_SIGNATURE_VERIFY_ERR_ALG_MISMATCH"}, objects);
                }
                String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"OIDC_JWT_SIGNATURE_VERIFY_ERR_ALG_MISMATCH", (Object[])objects);
                Tr.error((TraceComponent)tc, (String)errorMsg, (Object[])new Object[0]);
                throw new JWTTokenValidationFailedException(errorMsg);
            }
        }
    }

    boolean multipleAudienceElementCheck(String clientId, List<String> audList) {
        Iterator<String> it = audList.iterator();
        while (it.hasNext()) {
            if (!it.next().equals(clientId)) continue;
            return true;
        }
        return false;
    }

    String array2String(List<String> strings) {
        String result = "";
        for (String string : strings) {
            if (result.isEmpty()) {
                result = string;
                continue;
            }
            result = result + ", " + string;
        }
        return result;
    }

    String array2String(String[] strings) {
        String result = "";
        for (String string : strings) {
            result = result.isEmpty() ? string : result + ", " + string;
        }
        return result;
    }

    protected boolean checkIssuer(String clientId, String issuers, String issuer) throws JWTTokenValidationFailedException {
        boolean isIssuer = false;
        if (issuer != null) {
            if (issuer.equals(issuers)) {
                isIssuer = true;
            } else if (issuers != null) {
                StringTokenizer st = new StringTokenizer(issuers, " ,");
                while (st.hasMoreTokens()) {
                    String iss = st.nextToken();
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Token:" + iss), (Object[])new Object[0]);
                    }
                    if (!issuer.equals(iss)) continue;
                    isIssuer = true;
                    break;
                }
            }
        }
        if (!isIssuer) {
            String issuerIdentifierAttr = "issuerIdentifier";
            throw JWTTokenValidationFailedException.format("TOKEN_ISSUER_NOT_TRUSTED", clientId, issuer, issuers, "issuerIdentifier");
        }
        return isIssuer;
    }
}

