/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.app.manager.ear.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfoFactoryImpl;
import com.ibm.ws.app.manager.module.DeployedAppInfo;
import com.ibm.ws.app.manager.module.DeployedAppMBeanRuntime;
import com.ibm.ws.app.manager.module.DeployedAppServices;
import com.ibm.ws.app.manager.module.internal.ContextRootUtil;
import com.ibm.ws.app.manager.module.internal.DeployedAppInfoBase;
import com.ibm.ws.app.manager.module.internal.DeployedModuleInfoImpl;
import com.ibm.ws.app.manager.module.internal.ModuleClassLoaderFactory;
import com.ibm.ws.app.manager.module.internal.ModuleHandler;
import com.ibm.ws.app.manager.module.internal.ModuleInfoUtils;
import com.ibm.ws.app.manager.module.internal.SimpleDeployedAppInfoBase;
import com.ibm.ws.container.service.annocache.AnnotationsBetaHelper;
import com.ibm.ws.container.service.annotations.ContainerAnnotations;
import com.ibm.ws.container.service.app.deploy.ApplicationClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ClientModuleInfo;
import com.ibm.ws.container.service.app.deploy.ConnectorModuleInfo;
import com.ibm.ws.container.service.app.deploy.ContainerInfo;
import com.ibm.ws.container.service.app.deploy.EJBModuleInfo;
import com.ibm.ws.container.service.app.deploy.ModuleClassesContainerInfo;
import com.ibm.ws.container.service.app.deploy.ModuleInfo;
import com.ibm.ws.container.service.app.deploy.WebModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.AppClassLoaderFactory;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedApplicationInfo;
import com.ibm.ws.container.service.app.deploy.extended.ExtendedModuleInfo;
import com.ibm.ws.container.service.app.deploy.extended.ManifestClassPathHelper;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.javaee.dd.app.Application;
import com.ibm.ws.javaee.dd.app.Module;
import com.ibm.ws.javaee.ddmodel.DDParser;
import com.ibm.ws.javaee.version.JavaEEVersion;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.DefaultNotification;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import com.ibm.wsspi.application.handler.ApplicationInformation;
import com.ibm.wsspi.application.handler.ApplicationMonitoringInformation;
import com.ibm.wsspi.application.handler.DefaultApplicationMonitoringInformation;
import com.ibm.wsspi.classloading.ClassLoaderConfiguration;
import com.ibm.wsspi.classloading.ClassLoaderIdentity;
import com.ibm.wsspi.classloading.GatewayConfiguration;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.security.ProtectionDomain;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.osgi.framework.ServiceRegistration;

@TraceObjectField(fieldName="_tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class EARDeployedAppInfo
extends DeployedAppInfoBase {
    private static final TraceComponent _tc = Tr.register(EARDeployedAppInfo.class, (String[])new String[]{"webcontainer", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.war.internal.resources.Messages", (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo");
    private final ModuleHandler webModuleHandler;
    private final ModuleHandler ejbModuleHandler;
    private final ModuleHandler clientModuleHandler;
    private final ModuleHandler connectorModuleHandler;
    private static final String WAR_CLASS_PATH_LOADER_CONFIG = "webModuleClassPathLoader";
    private final ClassPathLoader classPathLoader;
    private final DeployedAppMBeanRuntime appMBeanRuntime;
    private ServiceRegistration<?> mbeanServiceReg;
    private final Container preExpansionAppContainer;
    private final Application appDD;
    private boolean ddInitializeInOrder;
    private final String appPreferredName;
    private final boolean altDDEnabled;
    private final AppLibsInfo appLibsInfo;
    private static final String DEFAULT_CLIENT_MODULE = "defaultClientModule";
    private final String appConfigDefaultClientModule;
    private static final String CONTEXT_ROOT = "context-root";
    private final ClassLoaderIdentity appClassLoaderId;
    private ClassLoader appClassLoader;
    private ProtectionDomain protectionDomain;
    private static final List<String> DYNAMIC_IMPORTS = Collections.unmodifiableList(Arrays.asList("*"));
    private int connectorModuleCount;
    private int ejbModuleCount;
    private List<ContainerInfo> classpathContainerInfos;
    private final ManifestClassPathInfos manifestClassPathInfos = new ManifestClassPathInfos();
    private static final List<String> EJB_ANNOTATIONS = new ArrayList<String>();
    private static final String WEB_MODULE_DOMAIN = "WebModule";
    private static final String CLIENT_MODULE_DOMAIN = "ClientModule";
    static final long serialVersionUID = -7830026482426934226L;

    public ClassLoader createAppClassLoader() {
        return this.getAppClassLoader();
    }

    private ClassLoaderIdentity getAppClassLoaderId() {
        this.getAppClassLoader();
        return this.appClassLoaderId;
    }

    private ClassLoader getAppClassLoader() {
        if (this.appClassLoader == null) {
            this.appClassLoader = this.basicCreateAppClassLoader();
        }
        return this.appClassLoader;
    }

    private ClassLoader basicCreateAppClassLoader() {
        String appPrefix = _tc.isDebugEnabled() ? "Application [ " + this.getName() + " ]: " : null;
        if (appPrefix != null) {
            Tr.debug((TraceComponent)_tc, (String)(appPrefix + "Class loader ID [ " + this.appClassLoaderId + " ]"), (Object[])new Object[0]);
        }
        ArrayList<Container> classLoaderContainers = new ArrayList<Container>();
        ArrayList<Container> nativeLibraryContainers = new ArrayList<Container>();
        for (ContainerInfo classesContainerInfo : this.getClasspathContainerInfos()) {
            Container classesContainer = classesContainerInfo.getContainer();
            classLoaderContainers.add(classesContainer);
            if (classesContainerInfo.getType() != ContainerInfo.Type.RAR_MODULE) continue;
            nativeLibraryContainers.add(classesContainer);
        }
        GatewayConfiguration gatewayConfig = this.classLoadingService.createGatewayConfiguration();
        gatewayConfig.setApplicationName(this.getName());
        gatewayConfig.setDynamicImportPackage(DYNAMIC_IMPORTS);
        this.protectionDomain = this.getProtectionDomain();
        if (appPrefix != null) {
            Tr.debug((TraceComponent)_tc, (String)(appPrefix + "Protection domain [ " + this.protectionDomain + " ]"), (Object[])new Object[0]);
        }
        ClassLoaderConfiguration appClassLoaderConfig = this.classLoadingService.createClassLoaderConfiguration();
        appClassLoaderConfig.setId(this.appClassLoaderId);
        appClassLoaderConfig.setProtectionDomain(this.protectionDomain);
        appClassLoaderConfig.setNativeLibraryContainers(nativeLibraryContainers);
        ClassLoader useAppClassLoader = this.createTopLevelClassLoader(classLoaderContainers, gatewayConfig, appClassLoaderConfig);
        if (appPrefix != null) {
            Tr.debug((TraceComponent)_tc, (String)(appPrefix + "Class loader [ " + useAppClassLoader + " ]"), (Object[])new Object[0]);
        }
        return useAppClassLoader;
    }

    EARDeployedAppInfo(ApplicationInformation<DeployedAppInfo> appInfo, Application appDD, EARDeployedAppInfoFactoryImpl factory, DeployedAppServices deployedAppServices, Container preExpansionAppContainer) throws UnableToAdaptException {
        super(appInfo, deployedAppServices);
        String appName;
        this.webModuleHandler = factory.webModuleHandler;
        this.ejbModuleHandler = factory.ejbModuleHandler;
        this.clientModuleHandler = factory.clientModuleHandler;
        this.connectorModuleHandler = factory.connectorModuleHandler;
        this.appMBeanRuntime = factory.appMBeanRuntime;
        this.classPathLoader = ClassPathLoader.convert(appInfo.getConfigProperty(WAR_CLASS_PATH_LOADER_CONFIG));
        this.appDD = appDD;
        this.altDDEnabled = factory.platformVersion.compareTo(JavaEEVersion.VERSION_7_0) >= 0;
        this.preExpansionAppContainer = preExpansionAppContainer;
        String string = appName = appDD == null ? null : appDD.getApplicationName();
        if (appName == null && (appName = ModuleInfoUtils.getModuleURIFromLocation((String)appInfo.getLocation())).endsWith(".ear")) {
            appName = appName.substring(0, appName.length() - ".ear".length());
        }
        this.appPreferredName = appName;
        this.appLibsInfo = this.createAppLibsInfo();
        this.appClassLoaderId = this.classLoadingService.createIdentity("EARApplication", this.getName());
        this.appConfigDefaultClientModule = (String)appInfo.getConfigProperty(DEFAULT_CLIENT_MODULE);
        this.createModules();
        Object appConfigContextRoot = appInfo.getConfigProperty(CONTEXT_ROOT);
        if (appConfigContextRoot != null) {
            Tr.warning((TraceComponent)_tc, (String)"warning.context.root.not.used", (Object[])new Object[]{appConfigContextRoot, this.appPreferredName});
        }
    }

    protected ExtendedApplicationInfo createApplicationInfo() {
        Container appLibContainer = this.appLibsInfo != null ? this.appLibsInfo.getLibsContainer() : null;
        return this.appInfoFactory.createEARApplicationInfo(this.getName(), this.appPreferredName, this.getContainer(), (ApplicationClassesContainerInfo)this, this.getConfigHelper(), appLibContainer, (AppClassLoaderFactory)this);
    }

    private AppLibsInfo createAppLibsInfo() {
        Container libDirContainer;
        Entry libDirEntry;
        String libDir;
        if (this.appDD != null && this.appDD.getLibraryDirectory() != null) {
            libDir = this.appDD.getLibraryDirectory();
            if (libDir.length() == 0) {
                return null;
            }
        } else {
            libDir = "lib";
        }
        if ((libDirEntry = this.getContainer().getEntry(libDir)) == null) {
            return null;
        }
        try {
            libDirContainer = (Container)libDirEntry.adapt(Container.class);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo", (String)"342", (Object)((Object)this), (Object[])new Object[0]);
            return null;
        }
        EarManifestClassPathConsumer manifestClassPathConsumer = new EarManifestClassPathConsumer(this.classPathLoader);
        AppLibsInfo result = new AppLibsInfo(libDirContainer, manifestClassPathConsumer);
        this.manifestClassPathInfos.addAll(manifestClassPathConsumer.getManifestClassPaths());
        return result;
    }

    public List<ContainerInfo> getLibraryClassesContainerInfo() {
        List sharedLibsInfos = super.getLibraryClassesContainerInfo();
        if (this.appLibsInfo == null) {
            return sharedLibsInfos;
        }
        List<ContainerInfo> appLibsInfos = this.appLibsInfo.getLibsInfos();
        if (appLibsInfos.isEmpty()) {
            return sharedLibsInfos;
        }
        if (sharedLibsInfos.isEmpty()) {
            return Collections.unmodifiableList(appLibsInfos);
        }
        ArrayList<ContainerInfo> infos = new ArrayList<ContainerInfo>(appLibsInfos.size() + sharedLibsInfos.size());
        infos.addAll(appLibsInfos);
        infos.addAll(sharedLibsInfos);
        return Collections.unmodifiableList(infos);
    }

    private boolean createModules() {
        String appPrefix = _tc.isDebugEnabled() ? "Application [ " + this.getName() + " ]: " : null;
        if (this.appDD != null) {
            if (appPrefix != null) {
                Tr.debug((TraceComponent)_tc, (String)(appPrefix + "Modules specified by descriptor"), (Object[])new Object[0]);
            }
            this.ddInitializeInOrder = this.appDD.isSetInitializeInOrder() && this.appDD.isInitializeInOrder();
            HashSet<String> moduleURIs = new HashSet<String>();
            for (Module ddModule : this.appDD.getModules()) {
                this.createModule(ddModule, moduleURIs);
            }
        } else {
            if (appPrefix != null) {
                Tr.debug((TraceComponent)_tc, (String)(appPrefix + "Modules specified by extension and by annotations"), (Object[])new Object[0]);
            }
            this.searchForModules();
        }
        this.ensureUniqueModuleNames();
        if (appPrefix != null) {
            Tr.debug((TraceComponent)_tc, (String)(appPrefix + "Modules [ " + Integer.valueOf(this.moduleContainerInfos.size()) + " ]"), (Object[])new Object[0]);
        }
        return true;
    }

    private void searchForModules() {
        String libsPath;
        String libDir = null;
        String libDirSlash = null;
        if (this.appLibsInfo != null && (libsPath = this.appLibsInfo.getLibsContainer().getPath()).length() > 0) {
            libDir = libsPath;
            if (libDir.endsWith("/")) {
                libDir = libDir.substring(0, libDir.length() - 1);
            }
            if (!libDir.startsWith("/")) {
                libDir = "/" + libDir;
            }
            libDirSlash = libDir + "/";
        }
        this.searchForModules(libDir, libDirSlash, this.getContainer());
    }

    /*
     * WARNING - void declaration
     */
    private void searchForModules(String libDir, String libDirSlash, Container container) {
        for (Entry childEntry : container) {
            Container childContainer;
            String childPath = childEntry.getPath();
            if (libDir != null && (childPath.equals(libDir) || childPath.startsWith(libDirSlash))) {
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)_tc, (String)("Skipping library container [ " + childPath + " ]"), (Object[])new Object[0]);
                continue;
            }
            try {
                childContainer = (Container)childEntry.adapt(Container.class);
            }
            catch (UnableToAdaptException unableToAdaptException) {
                void e;
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo", (String)"605", (Object)((Object)this), (Object[])new Object[]{libDir, libDirSlash, container});
                Tr.error((TraceComponent)_tc, (String)"error.application.library.container", (Object[])new Object[]{this.getName(), childPath, e});
                continue;
            }
            if (childContainer == null) {
                if (!_tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)_tc, (String)("Skipping non-container [ " + childPath + " ]"), (Object[])new Object[0]);
                continue;
            }
            if (childContainer.isRoot()) {
                this.createModuleContainerInfo(childEntry, childPath, childContainer);
                continue;
            }
            this.searchForModules(libDir, libDirSlash, childContainer);
        }
    }

    private void ensureUniqueModuleNames() {
        HashSet<String> usedNames = new HashSet<String>();
        ArrayList<SimpleDeployedAppInfoBase.ModuleContainerInfoBase> unresolvedModuleInfos = new ArrayList<SimpleDeployedAppInfoBase.ModuleContainerInfoBase>();
        for (SimpleDeployedAppInfoBase.ModuleContainerInfoBase modInfo : this.moduleContainerInfos) {
            if (modInfo instanceof SimpleDeployedAppInfoBase.EJBModuleContainerInfo && usedNames.add(modInfo.moduleName)) {
                if (!TraceComponent.isAnyTracingEnabled() || !_tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)_tc, (String)("Keep " + modInfo.getModuleURI() + "(" + modInfo.getType() + ") as " + modInfo.moduleName), (Object[])new Object[0]);
                continue;
            }
            unresolvedModuleInfos.add(modInfo);
        }
        for (SimpleDeployedAppInfoBase.ModuleContainerInfoBase modInfo : unresolvedModuleInfos) {
            String newModuleName;
            if (usedNames.add(modInfo.moduleName)) {
                if (!TraceComponent.isAnyTracingEnabled() || !_tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)_tc, (String)("Keep " + modInfo.getModuleURI() + "(" + modInfo.getType() + ") as " + modInfo.moduleName), (Object[])new Object[0]);
                continue;
            }
            if (usedNames.add(modInfo.getModuleURI())) {
                newModuleName = modInfo.getModuleURI();
            } else {
                int number = 2;
                do {
                    newModuleName = modInfo.moduleName + '_' + number;
                    ++number;
                } while (!usedNames.add(newModuleName));
            }
            if (TraceComponent.isAnyTracingEnabled() && _tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Update " + modInfo.getModuleURI() + " (" + modInfo.getType() + ") from " + modInfo.moduleName + " to " + newModuleName), (Object[])new Object[0]);
            }
            modInfo.setModuleName(newModuleName);
        }
    }

    public List<ModuleClassesContainerInfo> getModuleClassesContainerInfo() {
        return Collections.unmodifiableList(new ArrayList(this.moduleContainerInfos));
    }

    public void createModuleContainerInfo(ModuleHandler moduleHandler, Container moduleContainer, Entry altDDEntry, String moduleURI, SimpleDeployedAppInfoBase.ManifestClassPathProvider moduleClassesInfo, String contextRoot, String mainClass, boolean checkForDDOrAnnotations) throws UnableToAdaptException {
        EarManifestClassPathConsumer manifestClassPathConsumer = new EarManifestClassPathConsumer(this.classPathLoader);
        if (moduleHandler == this.connectorModuleHandler) {
            SimpleDeployedAppInfoBase.ConnectorModuleContainerInfo mci = new SimpleDeployedAppInfoBase.ConnectorModuleContainerInfo(moduleHandler, this.deployedAppServices.getModuleMetaDataExtenders("connector"), this.deployedAppServices.getNestedModuleMetaDataFactories("connector"), moduleContainer, altDDEntry, moduleURI, (ModuleClassLoaderFactory)this, moduleClassesInfo, (SimpleDeployedAppInfoBase.ManifestClassPathConsumer)manifestClassPathConsumer);
            if (this.ddInitializeInOrder) {
                this.moduleContainerInfos.add(mci);
            } else {
                this.moduleContainerInfos.add(this.connectorModuleCount, mci);
                ++this.connectorModuleCount;
            }
            this.manifestClassPathInfos.addAll(manifestClassPathConsumer.getManifestClassPaths());
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Added connector module [ " + mci.moduleName + " ] with module uri [ " + mci.getModuleURI() + " ] at [ " + moduleContainer.getPath() + " ]"), (Object[])new Object[0]);
            }
        } else if (moduleHandler == this.ejbModuleHandler) {
            SimpleDeployedAppInfoBase.EJBModuleContainerInfo mci = new SimpleDeployedAppInfoBase.EJBModuleContainerInfo(moduleHandler, this.deployedAppServices.getModuleMetaDataExtenders("ejb"), this.deployedAppServices.getNestedModuleMetaDataFactories("ejb"), moduleContainer, altDDEntry, moduleURI, (ModuleClassLoaderFactory)this, moduleClassesInfo, (SimpleDeployedAppInfoBase.ManifestClassPathConsumer)manifestClassPathConsumer);
            if (!checkForDDOrAnnotations || mci.moduleDD != null || this.hasAnnotations(mci.getContainer(), EJB_ANNOTATIONS)) {
                if (this.ddInitializeInOrder) {
                    this.moduleContainerInfos.add(mci);
                } else {
                    this.moduleContainerInfos.add(this.connectorModuleCount + this.ejbModuleCount, mci);
                    ++this.ejbModuleCount;
                }
                this.manifestClassPathInfos.addAll(manifestClassPathConsumer.getManifestClassPaths());
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("Added ejb module [ " + mci.moduleName + " ] with module uri [ " + mci.getModuleURI() + " ] at [ " + moduleContainer.getPath() + " ]"), (Object[])new Object[0]);
                }
            }
        } else if (moduleHandler == this.clientModuleHandler) {
            String mfMainClass = mainClass;
            if (mfMainClass == null) {
                if (checkForDDOrAnnotations) {
                    throw new IllegalArgumentException();
                }
                mfMainClass = this.getMFMainClass(moduleContainer, "/META-INF/MANIFEST.MF", true);
            }
            if (mfMainClass != null) {
                SimpleDeployedAppInfoBase.ClientModuleContainerInfo mci = new SimpleDeployedAppInfoBase.ClientModuleContainerInfo(moduleHandler, this.deployedAppServices.getModuleMetaDataExtenders("client"), this.deployedAppServices.getNestedModuleMetaDataFactories("client"), moduleContainer, altDDEntry, moduleURI, (ModuleClassLoaderFactory)this, moduleClassesInfo, mfMainClass, DEFAULT_MANIFEST_CLASS_PATH_CONSUMER);
                this.moduleContainerInfos.add(mci);
                this.manifestClassPathInfos.addAll(manifestClassPathConsumer.getManifestClassPaths());
                if (_tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)_tc, (String)("Added client module [ " + mci.moduleName + " ] with module uri [ " + mci.getModuleURI() + " ] at [ " + moduleContainer.getPath() + " ]"), (Object[])new Object[0]);
                }
            }
        } else if (moduleHandler == this.webModuleHandler) {
            SimpleDeployedAppInfoBase.WebModuleContainerInfo mci = new SimpleDeployedAppInfoBase.WebModuleContainerInfo(moduleHandler, this.deployedAppServices.getModuleMetaDataExtenders("web"), this.deployedAppServices.getNestedModuleMetaDataFactories("web"), moduleContainer, altDDEntry, moduleURI, (ModuleClassLoaderFactory)this, moduleClassesInfo, contextRoot, (SimpleDeployedAppInfoBase.ManifestClassPathConsumer)manifestClassPathConsumer);
            this.moduleContainerInfos.add(mci);
            this.manifestClassPathInfos.addAll(manifestClassPathConsumer.getManifestClassPaths());
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Added web module [ " + mci.moduleName + " ] with web-uri [ " + mci.getModuleURI() + " ] and context-root [ " + mci.contextRoot + " ] at [ " + moduleContainer.getPath() + " ]"), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createModule(Module ddModule, Set<String> uniqueModuleURIs) {
        Container moduleContainer;
        Entry entry;
        String moduleTypeTag;
        ModuleHandler moduleHandler;
        String contextRoot;
        String modulePath = ddModule.getModulePath();
        if (ddModule.getModuleType() == 3) {
            contextRoot = ContextRootUtil.getContextRoot((String)ddModule.getContextRoot());
            moduleHandler = this.webModuleHandler;
            moduleTypeTag = "web";
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Application descriptor provides web module with web-uri [ " + modulePath + " ] and context-root [ " + contextRoot + " ]"), (Object[])new Object[0]);
            }
        } else if (ddModule.getModuleType() == 1) {
            moduleHandler = this.ejbModuleHandler;
            moduleTypeTag = "ejb";
            contextRoot = null;
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Application descriptor provides ejb module with module uri [ " + modulePath + " ]"), (Object[])new Object[0]);
            }
        } else if (ddModule.getModuleType() == 2 && this.clientModuleHandler != null) {
            moduleHandler = this.clientModuleHandler;
            moduleTypeTag = "client";
            contextRoot = null;
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Application descriptor provides client module with module uri [ " + modulePath + " ]"), (Object[])new Object[0]);
            }
            if (this.appConfigDefaultClientModule != null && !this.appConfigDefaultClientModule.equals(modulePath)) {
                return;
            }
        } else if (ddModule.getModuleType() == 0) {
            moduleHandler = this.connectorModuleHandler;
            moduleTypeTag = "connector";
            contextRoot = null;
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Application descriptor provides connector module with module uri [ " + modulePath + " ]"), (Object[])new Object[0]);
            }
        } else {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Application " + this.getName() + ": unsupported module " + modulePath + " of type " + ddModule.getModuleType()), (Object[])new Object[0]);
            }
            return;
        }
        if ((entry = this.getContainer().getEntry(modulePath)) == null) {
            Tr.error((TraceComponent)_tc, (String)"error.module.locate.failed", (Object[])new Object[]{this.getName(), modulePath, moduleTypeTag});
            return;
        }
        String entryPath = entry.getPath();
        if (!uniqueModuleURIs.add(entryPath)) {
            Tr.warning((TraceComponent)_tc, (String)"error.module.uri.duplicate", (Object[])new Object[]{this.getName(), modulePath});
            return;
        }
        try {
            moduleContainer = (Container)entry.adapt(Container.class);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            void e;
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo", (String)"828", (Object)((Object)this), (Object[])new Object[]{ddModule, uniqueModuleURIs});
            Tr.error((TraceComponent)_tc, (String)"error.module.container", (Object[])new Object[]{this.getName(), modulePath, moduleTypeTag, e});
            return;
        }
        if (moduleContainer == null) {
            Tr.error((TraceComponent)_tc, (String)"error.module.container.null", (Object[])new Object[]{this.getName(), modulePath, moduleTypeTag});
            return;
        }
        if (!moduleContainer.isRoot()) {
            throw new IllegalStateException("module container should be a root");
        }
        if (moduleHandler == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("A module handler for " + moduleTypeTag + " modules was not configured."), (Object[])new Object[0]);
            }
            return;
        }
        String moduleURI = entryPath.substring(1);
        Entry altDDEntry = null;
        if (ddModule.getAltDD() != null && this.altDDEnabled && (altDDEntry = this.getContainer().getEntry(ddModule.getAltDD())) == null) {
            Tr.error((TraceComponent)_tc, (String)"error.module.locate.failed", (Object[])new Object[]{this.getName(), ddModule.getAltDD(), moduleTypeTag});
            return;
        }
        try {
            this.createModuleContainerInfo(moduleHandler, moduleContainer, altDDEntry, moduleURI, this.moduleClassesInfo, contextRoot, null, false);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            void e;
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo", (String)"868", (Object)((Object)this), (Object[])new Object[]{ddModule, uniqueModuleURIs});
            this.handleUnableToAdaptException((UnableToAdaptException)e, modulePath, moduleTypeTag);
        }
    }

    private void handleUnableToAdaptException(UnableToAdaptException e, String entryPath, String moduleTypeTag) {
        Throwable cause = e.getCause();
        Object causeMessage = cause instanceof DDParser.ParseException ? cause.getMessage() : e;
        Tr.error((TraceComponent)_tc, (String)"error.module.container", (Object[])new Object[]{this.getName(), entryPath, moduleTypeTag, causeMessage});
    }

    /*
     * WARNING - void declaration
     */
    private void createModuleContainerInfo(Entry entry, String entryPath, Container moduleContainer) {
        String moduleTypeTag;
        ModuleHandler moduleHandler;
        String lowerEntryPath = entryPath.toLowerCase();
        String mainClass = null;
        if (lowerEntryPath.endsWith(".war")) {
            moduleHandler = this.webModuleHandler;
            moduleTypeTag = "web";
        } else if (lowerEntryPath.endsWith(".jar")) {
            boolean hasAppClientXML = moduleContainer.getEntry("/META-INF/application-client.xml") != null;
            mainClass = this.getMFMainClass(moduleContainer, entryPath, hasAppClientXML);
            if (mainClass != null) {
                if (this.appConfigDefaultClientModule == null || this.appConfigDefaultClientModule.equals(entryPath.substring(1))) {
                    moduleHandler = this.clientModuleHandler;
                    moduleTypeTag = "client";
                } else {
                    moduleHandler = null;
                    moduleTypeTag = "unknown";
                }
            } else if (hasAppClientXML) {
                moduleHandler = null;
                moduleTypeTag = "unknown";
            } else {
                moduleHandler = this.ejbModuleHandler;
                moduleTypeTag = "ejb";
            }
        } else if (lowerEntryPath.endsWith(".rar")) {
            moduleHandler = this.connectorModuleHandler;
            moduleTypeTag = "connector";
        } else {
            moduleHandler = null;
            moduleTypeTag = "unknown";
        }
        if (moduleHandler == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Skipping non-module container [ " + entryPath + " ]"), (Object[])new Object[0]);
            }
            return;
        }
        String moduleURI = entryPath.substring(1);
        try {
            this.createModuleContainerInfo(moduleHandler, moduleContainer, null, moduleURI, this.moduleClassesInfo, null, mainClass, true);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            void e;
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo", (String)"929", (Object)((Object)this), (Object[])new Object[]{entry, entryPath, moduleContainer});
            this.handleUnableToAdaptException((UnableToAdaptException)e, entryPath, moduleTypeTag);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getMFMainClass(Container appEntryContainer, String entryPath, boolean required) {
        String mfMainClass = null;
        try {
            block12: {
                String entry = "/META-INF/MANIFEST.MF";
                Entry manifestEntry = appEntryContainer.getEntry(entry);
                if (manifestEntry != null) {
                    InputStream is = null;
                    try {
                        is = (InputStream)manifestEntry.adapt(InputStream.class);
                        if (is == null) {
                            throw new FileNotFoundException(entry);
                        }
                        Manifest manifest = new Manifest(is);
                        mfMainClass = manifest.getMainAttributes().getValue(Attributes.Name.MAIN_CLASS);
                        if ("".equals(mfMainClass)) {
                            mfMainClass = null;
                        }
                        if (is == null) break block12;
                    }
                    catch (Throwable throwable) {
                        if (is == null) throw throwable;
                        try {
                            is.close();
                            throw throwable;
                        }
                        catch (IOException iOException) {
                            FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo", (String)"965", (Object)((Object)this), (Object[])new Object[]{appEntryContainer, entryPath, required});
                        }
                        throw throwable;
                    }
                    try {
                        is.close();
                    }
                    catch (IOException iOException) {
                        FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo", (String)"965", (Object)((Object)this), (Object[])new Object[]{appEntryContainer, entryPath, required});
                    }
                }
            }
            if (mfMainClass != null) return mfMainClass;
            if (!required) return mfMainClass;
            Tr.error((TraceComponent)_tc, (String)"error.module.manifest.read.no.mainclass", (Object[])new Object[]{this.getName(), entryPath});
            return mfMainClass;
        }
        catch (IOException entry) {
            void ioe;
            FFDCFilter.processException((Throwable)entry, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo", (String)"974", (Object)((Object)this), (Object[])new Object[]{appEntryContainer, entryPath, required});
            Tr.error((TraceComponent)_tc, (String)"error.module.manifest.read.failed", (Object[])new Object[]{this.getName(), entryPath, ioe});
            return mfMainClass;
        }
        catch (UnableToAdaptException ioe) {
            void uae;
            FFDCFilter.processException((Throwable)ioe, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo", (String)"976", (Object)((Object)this), (Object[])new Object[]{appEntryContainer, entryPath, required});
            Tr.error((TraceComponent)_tc, (String)"error.module.manifest.read.failed", (Object[])new Object[]{this.getName(), entryPath, uae});
        }
        return mfMainClass;
    }

    public boolean hasModules() {
        return !this.moduleContainerInfos.isEmpty();
    }

    protected void registerApplicationMBean() {
        if (this.appMBeanRuntime != null) {
            ArrayList<ExtendedModuleInfo> deployedModuleInfos = new ArrayList<ExtendedModuleInfo>();
            for (DeployedModuleInfoImpl moduleInfoImpl : this.modulesDeployed) {
                deployedModuleInfos.add(moduleInfoImpl.getModuleInfo());
            }
            this.mbeanServiceReg = this.appMBeanRuntime.registerApplicationMBean(this.getName(), this.getContainer(), this.appDD != null ? "/META-INF/application.xml" : null, deployedModuleInfos);
        }
    }

    protected void deregisterApplicationMBean() {
        if (this.mbeanServiceReg != null) {
            ServiceRegistration<?> mbeanReg = this.mbeanServiceReg;
            this.mbeanServiceReg = null;
            mbeanReg.unregister();
        }
    }

    public ApplicationMonitoringInformation createApplicationMonitoringInformation() {
        HashSet<DefaultNotification> notificationsToMonitor = new HashSet<DefaultNotification>();
        if (this.appDD != null) {
            notificationsToMonitor.add(new DefaultNotification(this.getContainer(), "/META-INF/application.xml"));
        }
        if (this.appLibsInfo != null) {
            String libDirectory = this.appLibsInfo.getLibsContainer().getPath();
            if (!libDirectory.startsWith("/")) {
                libDirectory = "/" + libDirectory;
            }
            notificationsToMonitor.add(new DefaultNotification(this.getContainer(), libDirectory));
        }
        for (SimpleDeployedAppInfoBase.ModuleContainerInfoBase modInfo : this.moduleContainerInfos) {
            if (modInfo instanceof SimpleDeployedAppInfoBase.WebModuleContainerInfo) {
                notificationsToMonitor.add(new DefaultNotification(modInfo.getContainer(), "/WEB-INF"));
                continue;
            }
            if (!(modInfo instanceof SimpleDeployedAppInfoBase.ConnectorModuleContainerInfo)) continue;
            notificationsToMonitor.add(new DefaultNotification(modInfo.getContainer(), "/META-INF"));
        }
        for (ContainerInfo classpathContainerInfo : this.getClasspathContainerInfos()) {
            notificationsToMonitor.add(new DefaultNotification(classpathContainerInfo.getContainer(), "/"));
        }
        if (this.preExpansionAppContainer != null) {
            notificationsToMonitor.add(new DefaultNotification(this.preExpansionAppContainer, "/"));
        }
        return new DefaultApplicationMonitoringInformation(notificationsToMonitor, true);
    }

    private List<ContainerInfo> getClasspathContainerInfos() {
        if (this.classpathContainerInfos == null) {
            ArrayList<ContainerInfo> containerInfos = new ArrayList<ContainerInfo>();
            this.addEJBJarContainerInfos(containerInfos);
            this.addEARLibContainerInfos(containerInfos);
            this.addConnectorContainerInfos(containerInfos);
            this.checkClientJarContainerInfos(containerInfos);
            this.manifestClassPathInfos.addTo(containerInfos);
            this.classpathContainerInfos = containerInfos;
        }
        return this.classpathContainerInfos;
    }

    private void addEJBJarContainerInfos(List<ContainerInfo> classpathContainerInfos) {
        this.addModuleContainerInfos(classpathContainerInfos, SimpleDeployedAppInfoBase.EJBModuleContainerInfo.class);
    }

    private void addEARLibContainerInfos(List<ContainerInfo> classpathContainerInfos) {
        if (this.appLibsInfo != null) {
            for (ContainerInfo c : this.appLibsInfo.getLibsInfos()) {
                if (this.manifestClassPathInfos.contains(c)) continue;
                classpathContainerInfos.add(c);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkClientJarContainerInfos(List<ContainerInfo> classpathContainerInfos) {
        boolean found = false;
        try {
            for (SimpleDeployedAppInfoBase.ModuleContainerInfoBase modInfo : this.moduleContainerInfos) {
                if (!(modInfo instanceof SimpleDeployedAppInfoBase.ClientModuleContainerInfo)) continue;
                if (this.appConfigDefaultClientModule == null) {
                    if (found) {
                        Tr.error((TraceComponent)_tc, (String)"error.module.no.defaultclient", (Object[])new Object[0]);
                    }
                    found = true;
                    continue;
                }
                if (!this.appConfigDefaultClientModule.equals(modInfo.getModuleURI())) continue;
                if (found) {
                    Tr.error((TraceComponent)_tc, (String)"error.module.dup.client", (Object[])new Object[]{this.appConfigDefaultClientModule});
                }
                found = true;
            }
            if (!found && this.appConfigDefaultClientModule != null) {
                Tr.error((TraceComponent)_tc, (String)"error.module.client.notfound", (Object[])new Object[]{this.appConfigDefaultClientModule});
            }
        }
        catch (Throwable throwable) {
            void th;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo", (String)"1165", (Object)((Object)this), (Object[])new Object[]{classpathContainerInfos});
            Tr.error((TraceComponent)_tc, (String)"error.application.libraries", (Object[])new Object[]{this.getName(), th});
        }
    }

    private void addConnectorContainerInfos(List<ContainerInfo> classpathContainerInfos) {
        this.addModuleContainerInfos(classpathContainerInfos, SimpleDeployedAppInfoBase.ConnectorModuleContainerInfo.class);
    }

    /*
     * WARNING - void declaration
     */
    private void addModuleContainerInfos(List<ContainerInfo> classpathContainerInfos, Class<?> type) {
        try {
            for (SimpleDeployedAppInfoBase.ModuleContainerInfoBase modInfo : this.moduleContainerInfos) {
                if (!type.isInstance(modInfo)) continue;
                for (ContainerInfo c : modInfo.getClassesContainerInfo()) {
                    if (this.manifestClassPathInfos.contains(c)) continue;
                    classpathContainerInfos.add(c);
                }
            }
        }
        catch (Throwable throwable) {
            void th;
            FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo", (String)"1186", (Object)((Object)this), (Object[])new Object[]{classpathContainerInfos, type});
            Tr.error((TraceComponent)_tc, (String)"error.application.libraries", (Object[])new Object[]{this.getName(), th});
        }
    }

    private String getFullPath(Container useContainer) {
        StringBuilder pathBuilder = new StringBuilder();
        try {
            Entry entry;
            while ((entry = (Entry)useContainer.adapt(Entry.class)) != null) {
                pathBuilder.insert(0, entry.getPath());
                useContainer = entry.getRoot();
            }
        }
        catch (UnableToAdaptException entry) {
            FFDCFilter.processException((Throwable)entry, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo", (String)"1212", (Object)((Object)this), (Object[])new Object[]{useContainer});
            return null;
        }
        return pathBuilder.toString();
    }

    private boolean hasAnnotations(Container moduleContainer, List<String> useAnnotationTypeNames) {
        if (AnnotationsBetaHelper.getLibertyBeta()) {
            return this.hasAnnotationsPostBeta(moduleContainer, useAnnotationTypeNames);
        }
        return this.hasAnnotationsPreBeta(moduleContainer, useAnnotationTypeNames);
    }

    /*
     * WARNING - void declaration
     */
    private boolean hasAnnotationsPreBeta(Container moduleContainer, List<String> useAnnotationTypeNames) {
        ContainerAnnotations ca;
        block5: {
            ca = null;
            try {
                ca = (ContainerAnnotations)moduleContainer.adapt(ContainerAnnotations.class);
            }
            catch (UnableToAdaptException unableToAdaptException) {
                void e;
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo", (String)"1251", (Object)((Object)this), (Object[])new Object[]{moduleContainer, useAnnotationTypeNames});
                Tr.error((TraceComponent)_tc, (String)"error.module.class.source", (Object[])new Object[]{this.getName(), moduleContainer.getPath(), "EJB", e});
                if (!_tc.isDebugEnabled()) break block5;
                Tr.debug((TraceComponent)_tc, (String)"Selected [ 0 ] EJB annotation cases: Error obtaining annotation targets", (Object[])new Object[0]);
            }
        }
        if (ca != null && ca.hasSpecifiedAnnotations(useAnnotationTypeNames, this.applicationInformation.getUseJandex())) {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)("Select EJB module [ " + moduleContainer.getPath() + " ]: EJB annotations were detected:"), (Object[])new Object[0]);
            }
            return true;
        }
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)("Reject EJB module [ " + moduleContainer.getPath() + " ]: No descriptor and no EJB annotations"), (Object[])new Object[0]);
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private boolean hasAnnotationsPostBeta(Container moduleContainer, List<String> annotationClassNames) {
        com.ibm.ws.container.service.annocache.ContainerAnnotations containerAnnotations;
        String methodName = "hasAnnotations";
        String appName = this.getName();
        String modImmediatePath = moduleContainer.getPath();
        String modFullPath = this.getFullPath(moduleContainer);
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)(methodName + ": AppName [ " + appName + " ]"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)_tc, (String)(methodName + ": ModImmediatePath [ " + modImmediatePath + " ]"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)_tc, (String)(methodName + ": ModFullPath [ " + modFullPath + " ]"), (Object[])new Object[0]);
        }
        if (modFullPath == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)(methodName + ": Failed to obtain module path"), (Object[])new Object[0]);
            }
        } else if (modFullPath.isEmpty()) {
            modFullPath = null;
        }
        try {
            containerAnnotations = (com.ibm.ws.container.service.annocache.ContainerAnnotations)moduleContainer.adapt(com.ibm.ws.container.service.annocache.ContainerAnnotations.class);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            void e;
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo", (String)"1308", (Object)((Object)this), (Object[])new Object[]{moduleContainer, annotationClassNames});
            Tr.error((TraceComponent)_tc, (String)"error.module.class.source", (Object[])new Object[]{appName, modImmediatePath, "EJB", e});
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)(methodName + ": [ false ]: Error obtaining annotations"), (Object[])new Object[0]);
            }
            return false;
        }
        if (containerAnnotations == null) {
            if (_tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)_tc, (String)(methodName + ": [ false ]: Unexpected null annotations"), (Object[])new Object[0]);
            }
            return false;
        }
        containerAnnotations.setAppName(appName);
        containerAnnotations.setModName(modFullPath);
        containerAnnotations.setUseJandex(this.applicationInformation.getUseJandex());
        boolean selected = containerAnnotations.hasSpecifiedAnnotations(annotationClassNames);
        if (_tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)_tc, (String)(methodName + ": [ " + appName + " ] [ " + modFullPath + " ] [ " + Boolean.valueOf(selected) + " ]"), (Object[])new Object[0]);
        }
        return selected;
    }

    public ClassLoader createModuleClassLoader(ModuleInfo moduleInfo, List<ContainerInfo> moduleClassesInfos) {
        if (moduleInfo instanceof WebModuleInfo) {
            return this.createModuleChildClassLoader(WEB_MODULE_DOMAIN, moduleInfo, moduleClassesInfos);
        }
        if (moduleInfo instanceof EJBModuleInfo) {
            return this.createEJBModuleClassLoader((EJBModuleInfo)moduleInfo);
        }
        if (moduleInfo instanceof ClientModuleInfo) {
            return this.createModuleChildClassLoader(CLIENT_MODULE_DOMAIN, moduleInfo, moduleClassesInfos);
        }
        if (moduleInfo instanceof ConnectorModuleInfo) {
            return this.createConnectorModuleClassLoader((ConnectorModuleInfo)moduleInfo);
        }
        return null;
    }

    private ClassLoader createEJBModuleClassLoader(EJBModuleInfo ejbModuleInfo) {
        return this.getAppClassLoader();
    }

    private ClassLoader createConnectorModuleClassLoader(ConnectorModuleInfo connectorModuleInfo) {
        return this.getAppClassLoader();
    }

    private ClassLoader createModuleChildClassLoader(String moduleDomain, ModuleInfo moduleInfo, List<ContainerInfo> classesContainerInfo) {
        String moduleName = moduleInfo.getName();
        String moduleUri = moduleInfo.getURI();
        String modulePrefix = _tc.isDebugEnabled() ? moduleDomain + " [ " + moduleName + " ]: " : null;
        ArrayList<Container> classesContainers = new ArrayList<Container>(classesContainerInfo.size());
        for (ContainerInfo containerInfo : classesContainerInfo) {
            if (containerInfo.getType() == ContainerInfo.Type.MANIFEST_CLASSPATH && this.manifestClassPathInfos.contains(containerInfo)) continue;
            classesContainers.add(containerInfo.getContainer());
        }
        ClassLoaderIdentity appClassLoaderId = this.getAppClassLoaderId();
        if (modulePrefix != null) {
            Tr.debug((TraceComponent)_tc, (String)(modulePrefix + "Application class loader ID [ " + appClassLoaderId + " ]"), (Object[])new Object[0]);
        }
        ClassLoaderIdentity moduleClassLoaderId = this.classLoadingService.createIdentity(moduleDomain, this.getName() + "#" + moduleUri);
        if (modulePrefix != null) {
            Tr.debug((TraceComponent)_tc, (String)(modulePrefix + "Module class loader ID [ " + moduleClassLoaderId + " ]"), (Object[])new Object[0]);
        }
        ClassLoaderConfiguration moduleClassLoaderConfig = this.classLoadingService.createClassLoaderConfiguration();
        moduleClassLoaderConfig.setId(moduleClassLoaderId);
        moduleClassLoaderConfig.setParentId(appClassLoaderId);
        moduleClassLoaderConfig.setDelegateToParentAfterCheckingLocalClasspath(this.isDelegateLast);
        moduleClassLoaderConfig.setIncludeAppExtensions(true);
        moduleClassLoaderConfig.setProtectionDomain(this.protectionDomain);
        if (modulePrefix != null) {
            Tr.debug((TraceComponent)_tc, (String)(modulePrefix + "isDelegateLast [ " + Boolean.valueOf(this.isDelegateLast) + " ]"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)_tc, (String)(modulePrefix + "includeAppExtensions [ true ]"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)_tc, (String)(modulePrefix + "protectionDomain [ " + this.protectionDomain + " ]"), (Object[])new Object[0]);
        }
        ClassLoader moduleClassLoader = this.classLoadingService.createChildClassLoader(classesContainers, moduleClassLoaderConfig);
        this.associateClassLoaderWithApp(moduleClassLoader);
        if (modulePrefix != null) {
            Tr.debug((TraceComponent)_tc, (String)(modulePrefix + " Class loader [ " + moduleClassLoader + " ]"), (Object[])new Object[0]);
        }
        return moduleClassLoader;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        EJB_ANNOTATIONS.add("javax.ejb.MessageDriven");
        EJB_ANNOTATIONS.add("javax.ejb.Stateless");
        EJB_ANNOTATIONS.add("javax.ejb.Stateful");
        EJB_ANNOTATIONS.add("javax.ejb.Singleton");
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private class ManifestClassPathInfos {
        private final Set<ContainerInfo> classPathInfos = new LinkedHashSet<ContainerInfo>();
        static final long serialVersionUID = -5580262515665075810L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private ManifestClassPathInfos() {
        }

        void addAll(List<ContainerInfo> containerInfos) {
            this.classPathInfos.addAll(containerInfos);
        }

        void addTo(List<ContainerInfo> containerInfos) {
            if (this.classPathInfos.isEmpty()) {
                return;
            }
            LinkedHashSet<String> shouldAdd = new LinkedHashSet<String>();
            for (ContainerInfo c : containerInfos) {
                String name = null;
                if (c.getType() == ContainerInfo.Type.EAR_LIB) {
                    try {
                        Entry e = (Entry)c.getContainer().adapt(Entry.class);
                        name = e.getPath();
                    }
                    catch (UnableToAdaptException unableToAdaptException) {
                        FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo$ManifestClassPathInfos", (String)"1085", (Object)this, (Object[])new Object[]{containerInfos});
                    }
                } else {
                    name = c.getName();
                }
                if (name == null) continue;
                if (!name.startsWith("/")) {
                    name = "/" + name;
                }
                shouldAdd.add(name);
            }
            for (ContainerInfo c : this.classPathInfos) {
                if (!shouldAdd.add(c.getName())) continue;
                containerInfos.add(c);
            }
        }

        boolean contains(ContainerInfo manifestClassPath) {
            return this.classPathInfos.contains(manifestClassPath);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(ManifestClassPathInfos.class, (String[])new String[]{"webcontainer", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.war.internal.resources.Messages", (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo$ManifestClassPathInfos");
        }
    }

    static enum ClassPathLoader {
        WAR,
        EAR;


        public static ClassPathLoader convert(Object config) {
            if (!(config instanceof String)) {
                return WAR;
            }
            try {
                return ClassPathLoader.valueOf(((String)config).toUpperCase());
            }
            catch (IllegalArgumentException e) {
                return WAR;
            }
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class AppLibsInfo {
        private final Container libsContainer;
        private final List<ContainerInfo> libsInfos;
        static final long serialVersionUID = 2631748713101665881L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public AppLibsInfo(Container libsContainer, SimpleDeployedAppInfoBase.ManifestClassPathConsumer manifestClassPathConsumer) {
            this.libsContainer = libsContainer;
            String libsPath = libsContainer.getPath();
            ArrayList<ContainerInfo> useLibsInfos = new ArrayList<ContainerInfo>();
            ArrayList resolvedManifestIdentities = new ArrayList();
            for (Entry libEntry : libsContainer) {
                Container libContainer;
                String libEntryName = libEntry.getName();
                if (!libEntryName.toLowerCase().endsWith(".jar")) continue;
                try {
                    libContainer = (Container)libEntry.adapt(Container.class);
                }
                catch (UnableToAdaptException unableToAdaptException) {
                    FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo$AppLibsInfo", (String)"430", (Object)this, (Object[])new Object[]{libsContainer, manifestClassPathConsumer});
                    libContainer = null;
                }
                if (libContainer == null) continue;
                String libName = "EAR" + libsPath + libEntryName;
                EARLibContainerInfo libInfo = new EARLibContainerInfo(libName, libContainer);
                useLibsInfos.add(libInfo);
                try {
                    ArrayList manifestClassPaths = new ArrayList();
                    ManifestClassPathHelper.addCompleteJarEntryUrls(manifestClassPaths, (Entry)libEntry, (Container)libContainer, resolvedManifestIdentities);
                    manifestClassPathConsumer.consume(manifestClassPaths, useLibsInfos);
                }
                catch (UnableToAdaptException unableToAdaptException) {
                    FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo$AppLibsInfo", (String)"459", (Object)this, (Object[])new Object[]{libsContainer, manifestClassPathConsumer});
                }
            }
            this.libsInfos = useLibsInfos;
        }

        public Container getLibsContainer() {
            return this.libsContainer;
        }

        public List<ContainerInfo> getLibsInfos() {
            return this.libsInfos;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(AppLibsInfo.class, (String[])new String[]{"webcontainer", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.war.internal.resources.Messages", (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo$AppLibsInfo");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    static class EarManifestClassPathConsumer
    implements SimpleDeployedAppInfoBase.ManifestClassPathConsumer {
        private final ClassPathLoader classPathLoader;
        private final List<ContainerInfo> manifestClassPaths = new ArrayList<ContainerInfo>();
        static final long serialVersionUID = -3585366079333462016L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public EarManifestClassPathConsumer(ClassPathLoader classPathLoader) {
            this.classPathLoader = classPathLoader;
        }

        public void consume(List<ContainerInfo> manifestClassPaths, List<ContainerInfo> destination) {
            if (this.classPathLoader == ClassPathLoader.EAR) {
                this.manifestClassPaths.addAll(manifestClassPaths);
            }
            SimpleDeployedAppInfoBase.DEFAULT_MANIFEST_CLASS_PATH_CONSUMER.consume(manifestClassPaths, destination);
        }

        public List<ContainerInfo> getManifestClassPaths() {
            return this.manifestClassPaths;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(EarManifestClassPathConsumer.class, (String[])new String[]{"webcontainer", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.war.internal.resources.Messages", (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo$EarManifestClassPathConsumer");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class EARLibContainerInfo
    implements ContainerInfo {
        private final String name;
        private final Container container;
        static final long serialVersionUID = 8012257478505585977L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public EARLibContainerInfo(String name, Container container) {
            this.name = name;
            this.container = container;
        }

        public ContainerInfo.Type getType() {
            return ContainerInfo.Type.EAR_LIB;
        }

        public String getName() {
            return this.name;
        }

        public Container getContainer() {
            return this.container;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register(EARLibContainerInfo.class, (String[])new String[]{"webcontainer", "applications", "app.manager"}, (String)"com.ibm.ws.app.manager.war.internal.resources.Messages", (String)"com.ibm.ws.app.manager.ear.internal.EARDeployedAppInfo$EARLibContainerInfo");
        }
    }
}

