/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.custom.jdbc.impl;

import com.ibm.tx.config.ConfigurationProviderManager;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.recoverylog.custom.jdbc.impl.SQLRetriableLog;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import java.sql.BatchUpdateException;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.SQLTransientException;
import java.time.Duration;
import java.util.List;

public abstract class SQLRetry {
    private static final TraceComponent tc = Tr.register(SQLRetry.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    private Throwable _nonTransientException;
    private static boolean _logRetriesEnabled;
    protected int _retryLimit;
    protected Duration _retryInterval;

    public boolean retryAndReport(SQLRetriableLog recoveryLog, String serverName, SQLException currentSqlEx) {
        boolean theReturn = this.retryAndReport(recoveryLog, serverName, currentSqlEx, this._retryLimit, this._retryInterval);
        return theReturn;
    }

    private boolean retryAndReport(SQLRetriableLog recoveryLog, String serverName, SQLException currentSqlEx, int retryLimit, Duration retryInterval) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"retryAndReport ", (Object[])new Object[]{recoveryLog, serverName, currentSqlEx, retryLimit, retryInterval});
        }
        boolean failAndReport = true;
        if (currentSqlEx != null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Set the exception that will be reported: " + currentSqlEx), (Object[])new Object[0]);
            }
            this._nonTransientException = currentSqlEx;
            failAndReport = this.retryAfterSQLException(recoveryLog, currentSqlEx, retryLimit, retryInterval);
        }
        if (failAndReport) {
            Tr.debug((TraceComponent)tc, (String)("Cannot recover from SQLException when " + this.getOperationDescription() + " for server " + serverName + " Exception: " + this._nonTransientException), (Object[])new Object[0]);
        } else {
            Tr.debug((TraceComponent)tc, (String)("Have recovered from SQLException when " + this.getOperationDescription() + " server " + serverName), (Object[])new Object[0]);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"retryAndReport", (Object)(!failAndReport ? 1 : 0));
        }
        return !failAndReport;
    }

    public boolean retryAfterSQLException(SQLRetriableLog retriableLog, SQLException sqlex) {
        boolean failAndReport = this.retryAfterSQLException(retriableLog, sqlex, this._retryLimit, this._retryInterval);
        return failAndReport;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean retryAfterSQLException(SQLRetriableLog retriableLog, SQLException sqlex, int retryLimit, Duration retryInterval) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"retryAfterSQLException ", (Object[])new Object[]{retriableLog, sqlex, retryLimit, retryInterval});
        }
        boolean shouldRetry = true;
        boolean failAndReport = false;
        int operationRetries = 0;
        int initialIsolation = 0;
        Connection conn = null;
        while (shouldRetry && !failAndReport) {
            if (FrameworkState.isStopping()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Not retrying because the server is stopping", (Object[])new Object[0]);
                }
                failAndReport = true;
                continue;
            }
            if (operationRetries++ < retryLimit) {
                initialIsolation = 4;
                shouldRetry = SQLRetry.isSQLErrorTransient(sqlex);
                if (shouldRetry) {
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Try to reexecute the SQL, attempt number: " + operationRetries), (Object[])new Object[0]);
                    }
                    try {
                        conn = retriableLog.getConnection();
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Acquired connection in Database retry scenario", (Object[])new Object[0]);
                        }
                        initialIsolation = retriableLog.prepareConnectionForBatch(conn);
                        this.retryCode(conn);
                        conn.commit();
                        shouldRetry = false;
                        continue;
                    }
                    catch (SQLException sqlex2) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("reset the sqlex to " + sqlex2), (Object[])new Object[0]);
                        }
                        sqlex = sqlex2;
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("sleeping for " + retryInterval.getSeconds() + " seconds"), (Object[])new Object[0]);
                        }
                        try {
                            Thread.sleep(retryInterval.toMillis());
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                    catch (Throwable exc) {
                        if (tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"Failed got exception: ", (Object[])new Object[]{exc});
                        }
                        failAndReport = true;
                        this._nonTransientException = exc;
                        continue;
                    }
                    finally {
                        if (conn != null) {
                            block40: {
                                if (shouldRetry) {
                                    try {
                                        conn.rollback();
                                    }
                                    catch (Throwable exc) {
                                        if (!tc.isDebugEnabled()) break block40;
                                        Tr.debug((TraceComponent)tc, (String)("Rollback Failed, when handling SQLException, got exception: " + exc), (Object[])new Object[0]);
                                    }
                                }
                            }
                            try {
                                retriableLog.closeConnectionAfterBatch(conn, initialIsolation);
                            }
                            catch (Throwable exc) {
                                if (!tc.isDebugEnabled()) continue;
                                Tr.debug((TraceComponent)tc, (String)("Close Failed, when handling SQLException, got exception: " + exc), (Object[])new Object[0]);
                            }
                            continue;
                        }
                        if (!tc.isDebugEnabled()) continue;
                        Tr.debug((TraceComponent)tc, (String)"Connection was NULL", (Object[])new Object[0]);
                        continue;
                    }
                }
                failAndReport = true;
                continue;
            }
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exceeded number of retry attempts", (Object[])new Object[0]);
            }
            failAndReport = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"retryAfterSQLException", (Object)failAndReport);
        }
        return failAndReport;
    }

    public void setNonTransientException(Throwable nonTransientException) {
        this._nonTransientException = nonTransientException;
    }

    public Throwable getNonTransientException() {
        return this._nonTransientException;
    }

    public abstract void retryCode(Connection var1) throws SQLException, Exception;

    public abstract String getOperationDescription();

    protected static boolean isSQLErrorTransient(SQLException sqlex) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isSQLErrorTransient ", (Object[])new Object[]{sqlex});
        }
        boolean retryBatch = false;
        boolean isRetriableSqlCodeList = false;
        boolean isNonRetriableSqlCodeList = false;
        List retriableSqlCodesList = null;
        List nonRetriableSqlCodesList = null;
        boolean delveIntoException = true;
        int sqlErrorCode = sqlex.getErrorCode();
        if (tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)" SQL exception:", (Object[])new Object[0]);
            Tr.event((TraceComponent)tc, (String)(" Message: " + sqlex.getMessage()), (Object[])new Object[0]);
            Tr.event((TraceComponent)tc, (String)(" SQLSTATE: " + sqlex.getSQLState()), (Object[])new Object[0]);
            Tr.event((TraceComponent)tc, (String)(" Error code: " + sqlErrorCode), (Object[])new Object[0]);
        }
        if (!_logRetriesEnabled) {
            retriableSqlCodesList = ConfigurationProviderManager.getConfigurationProvider().getRetriableSqlCodes();
            boolean foundRetriableSqlCode = false;
            if (retriableSqlCodesList != null && !retriableSqlCodesList.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("There are retriable sqlcodes in " + retriableSqlCodesList), (Object[])new Object[0]);
                }
                isRetriableSqlCodeList = true;
                foundRetriableSqlCode = SQLRetry.isErrorCodeInCodeList(retriableSqlCodesList, sqlErrorCode);
            }
            if (foundRetriableSqlCode || sqlex instanceof SQLTransientException) {
                retryBatch = true;
                delveIntoException = false;
            }
        } else {
            nonRetriableSqlCodesList = ConfigurationProviderManager.getConfigurationProvider().getNonRetriableSqlCodes();
            if (nonRetriableSqlCodesList != null && !nonRetriableSqlCodesList.isEmpty()) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("There are non-retriable sqlcodes in " + nonRetriableSqlCodesList), (Object[])new Object[0]);
                }
                isNonRetriableSqlCodeList = true;
                if (SQLRetry.isErrorCodeInCodeList(nonRetriableSqlCodesList, sqlErrorCode)) {
                    retryBatch = false;
                    delveIntoException = false;
                } else {
                    retryBatch = true;
                    delveIntoException = true;
                }
            } else {
                retryBatch = true;
                delveIntoException = false;
            }
        }
        if (delveIntoException && sqlex instanceof BatchUpdateException) {
            if (tc.isDebugEnabled() && sqlex instanceof SQLTransientException) {
                Tr.debug((TraceComponent)tc, (String)"Exception is not considered transient but does implement SQLTransientException!", (Object[])new Object[0]);
            }
            BatchUpdateException buex = (BatchUpdateException)sqlex;
            Tr.event((TraceComponent)tc, (String)"BatchUpdateException: Update Counts - ", (Object[])new Object[0]);
            int[] updateCounts = buex.getUpdateCounts();
            for (int i = 0; i < updateCounts.length; ++i) {
                Tr.event((TraceComponent)tc, (String)("   Statement " + i + ":" + updateCounts[i]), (Object[])new Object[0]);
            }
            for (SQLException nextex = buex.getNextException(); nextex != null; nextex = nextex.getNextException()) {
                sqlErrorCode = nextex.getErrorCode();
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)" SQL exception:", (Object[])new Object[0]);
                    Tr.event((TraceComponent)tc, (String)(" Message: " + nextex.getMessage()), (Object[])new Object[0]);
                    Tr.event((TraceComponent)tc, (String)(" SQLSTATE: " + nextex.getSQLState()), (Object[])new Object[0]);
                    Tr.event((TraceComponent)tc, (String)(" Error code: " + sqlErrorCode), (Object[])new Object[0]);
                }
                if (!_logRetriesEnabled) {
                    if (nextex instanceof SQLTransientException) {
                        retryBatch = true;
                        break;
                    }
                    if (!isRetriableSqlCodeList || !SQLRetry.isErrorCodeInCodeList(retriableSqlCodesList, sqlErrorCode)) continue;
                    retryBatch = true;
                    break;
                }
                if (!isNonRetriableSqlCodeList || !SQLRetry.isErrorCodeInCodeList(nonRetriableSqlCodesList, sqlErrorCode)) continue;
                retryBatch = false;
                break;
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isSQLErrorTransient", (Object)retryBatch);
        }
        return retryBatch;
    }

    private static boolean isErrorCodeInCodeList(List<Integer> sqlCodesList, int sqlErrorCode) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"isErrorCodeInCodeList ", (Object[])new Object[]{sqlCodesList, sqlErrorCode});
        }
        boolean codeIsInList = false;
        if (sqlCodesList == null || sqlCodesList.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The list is null or empty", (Object[])new Object[0]);
            }
        } else if (sqlCodesList.contains(sqlErrorCode)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The error code is in the list", (Object[])new Object[0]);
            }
            codeIsInList = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"isErrorCodeInCodeList", (Object)codeIsInList);
        }
        return codeIsInList;
    }

    public static boolean isLogRetriesEnabled() {
        return _logRetriesEnabled;
    }

    public static void setLogRetriesEnabled(boolean logRetriesEnabled) {
        _logRetriesEnabled = logRetriesEnabled;
    }
}

