/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.h2internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.http.channel.h2internal.Constants;
import com.ibm.ws.http.channel.h2internal.H2ConnectionLinkProxy;
import com.ibm.ws.http.channel.h2internal.H2InboundLink;
import com.ibm.ws.http.channel.h2internal.H2StreamProcessor;
import com.ibm.ws.http.channel.h2internal.H2TCPConnectionContext;
import com.ibm.ws.http.channel.h2internal.exceptions.FlowControlException;
import com.ibm.ws.http.channel.h2internal.exceptions.Http2Exception;
import com.ibm.ws.http.channel.h2internal.exceptions.StreamClosedException;
import com.ibm.ws.http.channel.h2internal.frames.Frame;
import com.ibm.ws.http.channel.h2internal.frames.FrameContinuation;
import com.ibm.ws.http.channel.h2internal.frames.FrameData;
import com.ibm.ws.http.channel.h2internal.frames.FrameHeaders;
import com.ibm.ws.http.channel.h2internal.frames.FrameRstStream;
import com.ibm.ws.http.channel.h2internal.hpack.H2HeaderField;
import com.ibm.ws.http.channel.h2internal.hpack.H2HeaderTable;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundChannel;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundLink;
import com.ibm.ws.http.channel.internal.inbound.HttpInboundServiceContextImpl;
import com.ibm.ws.http2.GrpcServletServices;
import com.ibm.ws.http2.upgrade.H2Exception;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;

public class H2HttpInboundLinkWrap
extends HttpInboundLink {
    Integer streamID = null;
    public H2InboundLink muxLink = null;
    H2TCPConnectionContext h2TCPConnectionContext = null;
    H2ConnectionLinkProxy h2ConnectionProxy = null;
    VirtualConnection vc = null;
    boolean isPushPromise = false;
    private Boolean isGrpc = null;
    private HashMap<String, String> pseudoHeaders = null;
    private ArrayList<H2HeaderField> headers = null;
    private int headersLength = 0;
    private int h2ContentLength = -1;
    private HttpInboundServiceContextImpl httpInboundServiceContextImpl = null;
    private static final TraceComponent tc = Tr.register(H2HttpInboundLinkWrap.class, (String)"HTTPChannel", (String)"com.ibm.ws.http.channel.internal.resources.httpchannelmessages");

    public H2HttpInboundLinkWrap(HttpInboundChannel channel, VirtualConnection v, Integer id, H2InboundLink link) {
        super(channel, v);
        this.streamID = id;
        this.muxLink = link;
        this.vc = v;
        this.h2TCPConnectionContext = new H2TCPConnectionContext(this.streamID, this.muxLink, v);
        this.h2ConnectionProxy = new H2ConnectionLinkProxy(this);
        this.httpInboundServiceContextImpl = (HttpInboundServiceContextImpl)this.getChannelAccessor();
    }

    public boolean setAndGetIsGrpc() {
        if (this.isGrpc == null) {
            if (GrpcServletServices.getServletGrpcServices() != null) {
                Map<String, GrpcServletServices.ServiceInformation> servicePaths = GrpcServletServices.getServletGrpcServices();
                if (servicePaths != null && !servicePaths.isEmpty()) {
                    this.isGrpc = this.routeGrpcServletRequest(servicePaths);
                    this.setIsGrpcInParentLink(this.isGrpc);
                } else {
                    this.isGrpc = false;
                }
            } else {
                this.isGrpc = false;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            String currentURL = this.pseudoHeaders == null ? "UNSET_HEADERS" : this.pseudoHeaders.get(":path");
            Tr.exit((TraceComponent)tc, (String)("setAndGetIsGrpc returning " + this.isGrpc + " for request path " + currentURL));
        }
        return this.isGrpc;
    }

    private boolean routeGrpcServletRequest(Map<String, GrpcServletServices.ServiceInformation> servicePaths) {
        String requestContentType = this.getContentType();
        if (requestContentType != null && servicePaths != null && "application/grpc".equalsIgnoreCase(requestContentType = requestContentType.toLowerCase())) {
            String currentURL;
            String searchURL = currentURL = this.pseudoHeaders.get(":path");
            searchURL = searchURL.substring(1);
            int index = searchURL.lastIndexOf(47);
            GrpcServletServices.ServiceInformation info = servicePaths.get(searchURL = searchURL.substring(0, index));
            if (info != null) {
                String contextRoot = info.getContextRoot();
                if (contextRoot != null && !"/".equals(contextRoot)) {
                    String newPath = contextRoot + currentURL;
                    this.pseudoHeaders.put(":path", newPath);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("Inbound gRPC request translated from " + currentURL + " to " + newPath), (Object[])new Object[0]);
                    }
                }
                return true;
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Inbound gRPC request URL did not match any registered services: " + currentURL), (Object[])new Object[0]);
            }
        }
        return false;
    }

    public void setH2ContentLength(int len) {
        this.h2ContentLength = len;
    }

    public int getH2ContentLength() {
        return this.h2ContentLength;
    }

    public H2TCPConnectionContext getConnectionContext() {
        return this.h2TCPConnectionContext;
    }

    public void closeDeviceLink(Exception e) {
    }

    public ConnectionLink getDeviceLink() {
        return this.h2ConnectionProxy;
    }

    @Override
    public void destroy(Exception e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Destroying wrapped H2 inbound link: " + (Object)((Object)this) + " " + this.getVirtualConnection()), (Object[])new Object[0]);
        }
        super.destroy(e);
        this.vc = null;
        this.streamID = null;
        this.muxLink = null;
        this.h2TCPConnectionContext = null;
        this.h2ConnectionProxy = null;
        this.vc = null;
    }

    public ArrayList<Frame> prepareHeaders(byte[] marshalledHeaders, boolean complete) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("prepareHeaders entry: stream: marked as complete: " + complete), (Object[])new Object[0]);
        }
        int maxFrameSize = this.muxLink.getRemoteConnectionSettings().getMaxFrameSize();
        ArrayList<Frame> frameList = new ArrayList<Frame>();
        boolean endHeaders = true;
        if (marshalledHeaders.length > maxFrameSize) {
            int remaining = marshalledHeaders.length;
            int frameSize = maxFrameSize;
            int position = 0;
            endHeaders = false;
            byte[] firstFragment = Arrays.copyOfRange(marshalledHeaders, position, frameSize);
            FrameHeaders fh = new FrameHeaders(this.streamID, firstFragment, complete, endHeaders);
            frameList.add(fh);
            remaining -= frameSize;
            while (remaining > 0) {
                frameSize = remaining >= maxFrameSize ? maxFrameSize : remaining;
                byte[] fragment = Arrays.copyOfRange(marshalledHeaders, position += frameSize, position + frameSize);
                endHeaders = (remaining -= frameSize) == 0;
                FrameContinuation continued = new FrameContinuation((int)this.streamID, fragment, endHeaders, false, false);
                frameList.add(continued);
                if (!endHeaders) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("prepareHeaders exit : " + frameList), (Object[])new Object[0]);
                }
                return frameList;
            }
        }
        FrameHeaders fh = new FrameHeaders(this.streamID, marshalledHeaders, complete, endHeaders);
        frameList.add(fh);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("prepareHeaders exit : " + frameList), (Object[])new Object[0]);
        }
        return frameList;
    }

    public ArrayList<Frame> prepareBody(WsByteBuffer[] wsbb, int length, boolean isFinalWrite) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("prepareBody entry : final write: " + isFinalWrite), (Object[])new Object[0]);
        }
        ArrayList<Frame> dataFrames = new ArrayList<Frame>();
        if (wsbb == null || length == 0) {
            FrameData dataFrame = new FrameData(this.streamID, null, 0, isFinalWrite);
            dataFrames.add(dataFrame);
            return dataFrames;
        }
        boolean endStream = isFinalWrite;
        boolean lastData = false;
        int lengthWritten = 0;
        if (wsbb.length > 1) {
            endStream = false;
        }
        for (int i = 0; i < wsbb.length; ++i) {
            WsByteBuffer b = wsbb[i];
            if (b == null) continue;
            lengthWritten += b.remaining();
            if (b.remaining() == 0) continue;
            if (lengthWritten >= length) {
                lastData = true;
                endStream = lastData && isFinalWrite;
            }
            FrameData dataFrame = new FrameData(this.streamID, b, b.remaining(), endStream);
            dataFrames.add(dataFrame);
            if (!lastData) continue;
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("prepareBody exit : " + dataFrames), (Object[])new Object[0]);
            }
            return dataFrames;
        }
        return dataFrames;
    }

    public int getStreamId() {
        return this.streamID;
    }

    public H2HeaderTable getReadTable() {
        return this.muxLink.getReadTable();
    }

    public H2HeaderTable getWriteTable() {
        return this.muxLink.getWriteTable();
    }

    public void setPushPromise(boolean isPushPromise) {
        this.isPushPromise = isPushPromise;
    }

    public boolean isPushPromise() {
        return this.isPushPromise;
    }

    public void setHeadersLength(int len) {
        this.headersLength = len;
    }

    public int getHeadersLength() {
        return this.headersLength;
    }

    @Override
    public void close(VirtualConnection inVC, Exception e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("close(vc, e) called H2InboundLink: " + (Object)((Object)this) + " " + inVC), (Object[])new Object[0]);
        }
        if (this.streamID == 0 || this.streamID % 2 == 1) {
            if (e == null || e instanceof Http2Exception) {
                Http2Exception h2ex = (Http2Exception)e;
                if (e != null && !h2ex.isConnectionError()) {
                    H2StreamProcessor h2sp = this.muxLink.getStreamProcessor(this.streamID);
                    if (h2sp != null && !h2sp.isStreamClosed()) {
                        try {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)("close: attempting to reset stream: " + this.streamID + " with exception: " + e), (Object[])new Object[0]);
                            }
                            FrameRstStream reset = new FrameRstStream(this.streamID, h2ex.getErrorCode(), false);
                            h2sp.processNextFrame(reset, Constants.Direction.WRITING_OUT);
                        }
                        catch (Http2Exception h2e) {
                            if (this.httpInboundServiceContextImpl != null) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    Tr.debug((TraceComponent)tc, (String)"close: (1)httpInboundServiceContextImpl.clear()", (Object[])new Object[0]);
                                }
                                this.httpInboundServiceContextImpl.clear();
                                this.httpInboundServiceContextImpl = null;
                            }
                            this.muxLink.close(inVC, e);
                        }
                    }
                } else {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("close: closing with exception: " + e), (Object[])new Object[0]);
                    }
                    if (this.httpInboundServiceContextImpl != null) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)"close: (2)httpInboundServiceContextImpl.clear()", (Object[])new Object[0]);
                        }
                        this.httpInboundServiceContextImpl.clear();
                        this.httpInboundServiceContextImpl = null;
                    }
                    this.muxLink.close(inVC, e);
                }
            } else {
                H2StreamProcessor h2sp = this.muxLink.getStreamProcessor(this.streamID);
                if (h2sp != null && !h2sp.isStreamClosed()) {
                    try {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("close: attempting to reset stream: " + this.streamID), (Object[])new Object[0]);
                        }
                        int PROTOCOL_ERROR = 1;
                        FrameRstStream reset = new FrameRstStream(this.streamID, PROTOCOL_ERROR, false);
                        h2sp.processNextFrame(reset, Constants.Direction.WRITING_OUT);
                    }
                    catch (Http2Exception h2e) {
                        if (this.httpInboundServiceContextImpl != null) {
                            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                Tr.debug((TraceComponent)tc, (String)"close: (3)httpInboundServiceContextImpl.clear()", (Object[])new Object[0]);
                            }
                            this.httpInboundServiceContextImpl.clear();
                            this.httpInboundServiceContextImpl = null;
                        }
                        this.muxLink.close(inVC, e);
                    }
                }
                if (this.httpInboundServiceContextImpl != null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"close: (4)httpInboundServiceContextImpl.clear()", (Object[])new Object[0]);
                    }
                    this.httpInboundServiceContextImpl.clear();
                    this.httpInboundServiceContextImpl = null;
                }
                this.muxLink.close(inVC, null);
            }
        } else {
            H2StreamProcessor h2sp = this.muxLink.getStreamProcessor(this.streamID);
            if (h2sp != null && !h2sp.isStreamClosed() && !h2sp.isHalfClosed()) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("close: attempting to reset stream: " + this.streamID), (Object[])new Object[0]);
                }
                int PROTOCOL_ERROR = 1;
                FrameRstStream reset = new FrameRstStream(this.streamID, PROTOCOL_ERROR, false);
                try {
                    h2sp.processNextFrame(reset, Constants.Direction.WRITING_OUT);
                }
                catch (Http2Exception http2Exception) {
                    // empty catch block
                }
            }
        }
    }

    @FFDCIgnore(value={IOException.class})
    public void writeFramesSync(CopyOnWriteArrayList<Frame> frames) throws IOException {
        if (frames == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"writeFramesSync entry: # of frames: 0 - returning", (Object[])new Object[0]);
            }
            return;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("writeFramesSync entry: # of frames: " + frames.size()), (Object[])new Object[0]);
        }
        Iterator<Frame> i = frames.iterator();
        while (i.hasNext()) {
            try {
                Frame currentFrame = i.next();
                H2StreamProcessor streamProcessor = this.muxLink.getStreamProcessor(this.streamID);
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("writeFramesSync processing frame ID: " + (Object)((Object)currentFrame.getFrameType())), (Object[])new Object[0]);
                }
                if (streamProcessor != null) {
                    streamProcessor.processNextFrame(currentFrame, Constants.Direction.WRITING_OUT);
                    continue;
                }
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("writeFramesSync stream " + this.streamID + " was already closed; cannot write"), (Object[])new Object[0]);
            }
            catch (FlowControlException | StreamClosedException e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("write failed with a FlowControlException: " + e.getErrorString()), (Object[])new Object[0]);
                }
                IOException ioe = new IOException(new H2Exception(e.getMessage()));
                throw ioe;
            }
            catch (Http2Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("processRead an error occurred processing a frame: " + e.getErrorString()), (Object[])new Object[0]);
                }
                this.muxLink.close(this.vc, e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"writeFramesSync exit", (Object[])new Object[0]);
        }
    }

    public void setReadPseudoHeaders(HashMap<String, String> pseudoHeaders) {
        this.pseudoHeaders = pseudoHeaders;
    }

    public HashMap<String, String> getReadPseudoHeaders() {
        return this.pseudoHeaders;
    }

    public void setReadHeaders(ArrayList<H2HeaderField> headers) {
        this.headers = headers;
    }

    public ArrayList<H2HeaderField> getReadHeaders() {
        return this.headers;
    }

    public HttpRequestMessage getRequest() {
        return this.httpInboundServiceContextImpl.getRequest();
    }

    private String getContentType() {
        for (H2HeaderField header : this.headers) {
            if (!header.getName().equalsIgnoreCase(HttpHeaderKeys.HDR_CONTENT_TYPE.getName())) continue;
            return header.getValue();
        }
        return null;
    }

    public void setAndStoreNewBodyBuffer(WsByteBuffer buffer) {
        this.httpInboundServiceContextImpl.storeBuffer(buffer);
    }

    public void invokeAppComplete() {
        if (this.httpInboundServiceContextImpl != null && this.httpInboundServiceContextImpl.getAppReadCallback() != null) {
            this.httpInboundServiceContextImpl.getAppReadCallback().complete(this.vc);
        }
    }

    public void countDownFirstReadLatch(boolean force) {
        H2StreamProcessor h2sp = this.muxLink.getStreamProcessor(this.streamID);
        if (h2sp != null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("calling h2sp to count down firstReadLatch; force: " + force), (Object[])new Object[0]);
            }
            h2sp.countDownFirstReadLatch(force);
        }
    }
}

