/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.http.channel.internal.values;

import com.ibm.ws.http.channel.internal.values.AccessLogData;
import com.ibm.wsspi.http.channel.HttpRequestMessage;
import com.ibm.wsspi.http.channel.HttpResponseMessage;
import java.util.Objects;
import java.util.concurrent.TimeUnit;

public class AccessLogElapsedRequestTime
extends AccessLogData {
    public AccessLogElapsedRequestTime() {
        super("%{R}W");
    }

    @Override
    public Object init(String rawToken) {
        if ("R".equals(rawToken)) {
            return null;
        }
        return rawToken;
    }

    @Override
    public boolean set(StringBuilder accessLogEntry, HttpResponseMessage response, HttpRequestMessage request, Object data) {
        long elapsedRequestTime = AccessLogElapsedRequestTime.getElapsedRequestTime(response, request, data);
        if (elapsedRequestTime > 0L) {
            accessLogEntry.append(elapsedRequestTime);
        } else {
            accessLogEntry.append("-");
        }
        return true;
    }

    public static long getElapsedRequestTime(HttpResponseMessage response, HttpRequestMessage request, Object data) {
        long startTime = 0L;
        long endTime = 0L;
        if (Objects.nonNull(request)) {
            HttpRequestMessage message = request;
            startTime = message.getStartTime();
            endTime = message.getEndTime();
        }
        if (startTime != 0L && endTime >= startTime) {
            long elapsedTime = endTime - startTime;
            return TimeUnit.NANOSECONDS.toMicros(elapsedTime);
        }
        return -1L;
    }
}

