/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.http.netty.channel.utils;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.http.channel.internal.HttpChannelConfig;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.regex.Pattern;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HeaderValidator {
    private static boolean disabledUntilRFE;
    private static final Pattern TCHAR_PATTERN;
    private static final char CR = '\r';
    private static final char LF = '\n';
    private static final char TAB = '\t';
    private static final char SPACE = ' ';
    static final long serialVersionUID = 4503841118975752134L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private HeaderValidator() {
    }

    public static String process(String token, FieldType type, HttpChannelConfig config) {
        String normalized;
        if (type == FieldType.NAME && token == null) {
            throw new IllegalArgumentException("Header name must not be null");
        }
        String string = normalized = token == null ? "" : token.trim();
        if (!disabledUntilRFE && type == FieldType.NAME) {
            normalized = normalized.toLowerCase();
        }
        return HeaderValidator.validate(normalized, type, config);
    }

    private static String validate(String token, FieldType type, HttpChannelConfig config) {
        char lastChar;
        if (!config.isHeaderValidationEnabled()) {
            return token;
        }
        if (type == FieldType.NAME && !TCHAR_PATTERN.matcher(token).matches()) {
            throw new IllegalArgumentException("Invalid header name: " + token);
        }
        if (!(token.isEmpty() || (lastChar = token.charAt(token.length() - 1)) != '\r' && lastChar != '\n')) {
            throw new IllegalArgumentException("Illegal trailing EOL in header field: " + token);
        }
        StringBuilder sb = new StringBuilder(token.length());
        String error = null;
        for (int i = 0; i < token.length(); ++i) {
            char next;
            char c = token.charAt(i);
            if (c == '\r') {
                if (i + 1 >= token.length() || token.charAt(i + 1) != '\n') {
                    error = "Invalid CR not followed by LF in header " + token;
                }
            } else if (c == '\n' && i + 1 < token.length() && (next = token.charAt(i + 1)) != ' ' && next != '\t') {
                error = "Invalid LF not followed by whitespace in header " + token;
            }
            if (c >= ' ' && c < '\u007f') {
                sb.append(c);
            } else if (c == '\r' || c == '\n') {
                sb.append(' ');
            } else {
                int maskedCode = c & 0xFF;
                if (maskedCode == 13 || maskedCode == 10) {
                    sb.append('?');
                } else {
                    sb.append(c);
                }
            }
            if (error != null) break;
        }
        if (error != null) {
            throw new IllegalArgumentException(error);
        }
        return sb.toString();
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.http.netty.channel.utils.HeaderValidator", HeaderValidator.class, null, null);
        disabledUntilRFE = true;
        TCHAR_PATTERN = Pattern.compile("^[!#$%&'*+\\-\\.\\^_`|~0-9a-zA-Z]+$");
    }

    public static enum FieldType {
        NAME,
        VALUE;

    }
}

