/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.http.netty.cookie;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.http.channel.internal.HttpChannelConfig;
import com.ibm.ws.http.channel.internal.cookies.CookieUtils;
import com.ibm.ws.http.channel.internal.cookies.SameSiteCookieUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.genericbnf.HeaderKeys;
import com.ibm.wsspi.http.HttpCookie;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import io.openliberty.http.netty.cookie.SameSite;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public final class CookieEncoder {
    private static final String EXPIRES_ATTRIBUTE = "expires";
    private static final String SAMESITE_ATTRIBUTE = "samesite";
    private static final String PARTITIONED_ATTRIBUTE = "partitioned";
    private static final SimpleDateFormat RFC1123_DATE_FORMAT;
    private static final int MAX_MAX_AGE_SECONDS = Integer.MAX_VALUE;
    static final long serialVersionUID = -5002335828493965776L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private CookieEncoder() {
    }

    public static List<String> encodeAllCookies(List<HttpCookie> cookies, HeaderKeys header, HttpChannelConfig config, String userAgent) {
        if (cookies == null || cookies.isEmpty()) {
            return Collections.emptyList();
        }
        boolean filterDuplicates = config.doNotAllowDuplicateSetCookies() && (header == HttpHeaderKeys.HDR_SET_COOKIE || header == HttpHeaderKeys.HDR_SET_COOKIE2);
        LinkedHashMap<String, String> duplicatesMap = new LinkedHashMap<String, String>();
        ArrayList<String> results = new ArrayList<String>();
        for (HttpCookie cookie : cookies) {
            String encoded = CookieEncoder.encodeCookie(cookie, header, config, userAgent);
            if (encoded == null || encoded.isEmpty()) continue;
            if (filterDuplicates) {
                duplicatesMap.put(cookie.getName(), encoded);
                continue;
            }
            results.add(encoded);
        }
        if (filterDuplicates) {
            results.addAll(duplicatesMap.values());
        }
        return results;
    }

    public static String encodeCookie(HttpCookie cookie, HeaderKeys header, HttpChannelConfig config, String userAgent) {
        if (cookie == null || header == null) {
            return null;
        }
        CookieEncoder.applyCookiePolicy(cookie, config, userAgent);
        CookieEncoder.ensureCookieVersion(cookie, config);
        return CookieUtils.toString(cookie, header, config.isv0CookieDateRFC1123compat(), config.shouldSkipCookiePathQuotes());
    }

    private static void applyCookiePolicy(HttpCookie cookie, HttpChannelConfig config, String userAgent) {
        if (cookie == null) {
            return;
        }
        CookieEncoder.applySameSiteAttribute(cookie, config, userAgent);
        CookieEncoder.applyPartitionedAttribute(cookie, config);
    }

    private static void ensureCookieVersion(HttpCookie cookie, HttpChannelConfig config) {
        if (cookie.getVersion() < 0) {
            cookie.setVersion(0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void applySameSiteAttribute(HttpCookie cookie, HttpChannelConfig config, String userAgent) {
        String originalSameSite = cookie.getAttribute(SAMESITE_ATTRIBUTE);
        boolean serverInjectedSameSite = false;
        if (originalSameSite == null) {
            serverInjectedSameSite = CookieEncoder.applySameSiteConfiguration(cookie, config);
            originalSameSite = cookie.getAttribute(SAMESITE_ATTRIBUTE);
        }
        if (originalSameSite == null || originalSameSite.isEmpty()) {
            return;
        }
        try {
            if (serverInjectedSameSite) {
                SameSite sameSite = SameSite.from(originalSameSite);
                if (sameSite.requiresSecure() && !cookie.isSecure()) {
                    cookie.setSecure(true);
                }
                cookie.setAttribute(SAMESITE_ATTRIBUTE, sameSite.toString());
            }
        }
        catch (IllegalArgumentException isIncompatible) {
            FFDCFilter.processException((Throwable)isIncompatible, (String)"io.openliberty.http.netty.cookie.CookieEncoder", (String)"194", null, (Object[])new Object[]{cookie, config, userAgent});
            cookie.setAttribute(SAMESITE_ATTRIBUTE, null);
        }
        finally {
            if (originalSameSite.equalsIgnoreCase(SameSite.NONE.name()) && userAgent != null && (isIncompatible = SameSiteCookieUtils.isSameSiteNoneIncompatible(userAgent))) {
                cookie.setAttribute(SAMESITE_ATTRIBUTE, null);
                cookie.setAttribute(PARTITIONED_ATTRIBUTE, null);
            }
        }
    }

    private static boolean applySameSiteConfiguration(HttpCookie cookie, HttpChannelConfig config) {
        if (!config.useSameSiteConfig()) {
            return false;
        }
        String name = cookie.getName();
        String defaultSameSite = config.getSameSiteCookies().get(name);
        if (defaultSameSite == null && config.onlySameSiteStar()) {
            defaultSameSite = config.getSameSiteCookies().get("*");
        }
        if (defaultSameSite == null) {
            defaultSameSite = CookieEncoder.matchSameSitePattern(name, config);
        }
        if (defaultSameSite != null && !defaultSameSite.isEmpty()) {
            cookie.setAttribute(SAMESITE_ATTRIBUTE, defaultSameSite);
        }
        return true;
    }

    private static String matchSameSitePattern(String name, HttpChannelConfig config) {
        for (Pattern pattern : config.getSameSitePatterns().keySet()) {
            Matcher matcher = pattern.matcher(name);
            if (!matcher.matches()) continue;
            return config.getSameSitePatterns().get(pattern);
        }
        return null;
    }

    private static void applyPartitionedAttribute(HttpCookie cookie, HttpChannelConfig config) {
        String partitioned;
        String sameSiteValue;
        if (config.getPartitioned() && (sameSiteValue = cookie.getAttribute(SAMESITE_ATTRIBUTE)) != null && sameSiteValue.equalsIgnoreCase(SameSite.NONE.name()) && (partitioned = cookie.getAttribute(PARTITIONED_ATTRIBUTE)) == null) {
            cookie.setAttribute(PARTITIONED_ATTRIBUTE, "");
        }
        CookieEncoder.enforcePartitionedPolicy(cookie);
    }

    private static void enforcePartitionedPolicy(HttpCookie cookie) {
        String sameSiteValue = cookie.getAttribute(SAMESITE_ATTRIBUTE);
        boolean isNone = sameSiteValue != null && sameSiteValue.equalsIgnoreCase("none");
        String partitionedValue = cookie.getAttribute(PARTITIONED_ATTRIBUTE);
        if (!isNone && partitionedValue != null && !partitionedValue.equalsIgnoreCase("false")) {
            cookie.setAttribute(PARTITIONED_ATTRIBUTE, "false");
        }
    }

    private static void handleExpiresToMaxAge(HttpCookie cookie) {
        boolean hasMaxAge;
        boolean hasExpires = cookie.getAttribute(EXPIRES_ATTRIBUTE) != null;
        boolean bl = hasMaxAge = cookie.getMaxAge() > -1;
        if (hasExpires && !hasMaxAge) {
            String expires = cookie.getAttribute(EXPIRES_ATTRIBUTE);
            Date expiresDate = CookieEncoder.parseExpires(expires);
            if (expiresDate != null) {
                long currentTime = System.currentTimeMillis();
                long maxAgeSeconds = TimeUnit.MILLISECONDS.toSeconds(expiresDate.getTime() - currentTime);
                if (maxAgeSeconds > Integer.MAX_VALUE) {
                    maxAgeSeconds = Integer.MAX_VALUE;
                } else if (maxAgeSeconds < 0L) {
                    maxAgeSeconds = 0L;
                }
                cookie.setMaxAge((int)maxAgeSeconds);
                cookie.setAttribute(EXPIRES_ATTRIBUTE, null);
            } else {
                cookie.setMaxAge(0);
            }
        }
    }

    private static Date parseExpires(String expires) {
        try {
            return RFC1123_DATE_FORMAT.parse(expires);
        }
        catch (ParseException parseException) {
            FFDCFilter.processException((Throwable)parseException, (String)"io.openliberty.http.netty.cookie.CookieEncoder", (String)"312", null, (Object[])new Object[]{expires});
            return null;
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.http.netty.cookie.CookieEncoder", CookieEncoder.class, null, null);
        RFC1123_DATE_FORMAT = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz");
    }
}

