/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.http.netty.cookie;

public enum SameSite {
    LAX("Lax"),
    NONE("None"),
    STRICT("Strict");

    private final String name;

    private SameSite(String name) {
        this.name = name;
    }

    public static SameSite from(String value) {
        String normalized;
        if (value == null || value.trim().isEmpty()) {
            throw new IllegalArgumentException("SameSite value cannot be null or empty");
        }
        switch (normalized = value.trim().toLowerCase()) {
            case "lax": {
                return LAX;
            }
            case "strict": {
                return STRICT;
            }
            case "none": {
                return NONE;
            }
        }
        throw new IllegalArgumentException("Unknown SameSite value: " + value);
    }

    public static SameSite fromOrDefault(String value, SameSite defaultValue) {
        if (value == null || value.trim().isEmpty()) {
            return defaultValue;
        }
        try {
            return SameSite.from(value);
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public boolean requiresSecure() {
        return this == NONE;
    }

    public String toString() {
        return this.name;
    }
}

