/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.http.netty.quiesce;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.HttpToHttp2ConnectionHandler;
import io.netty.util.concurrent.GenericFutureListener;
import io.openliberty.http.netty.quiesce.QuiesceContextHolder;
import java.util.concurrent.Callable;

public enum QuiesceStrategy {
    HTTP2_GOAWAY(() -> {
        ChannelHandlerContext h2Ctx;
        Channel ch = QuiesceContextHolder.getChannel();
        if (ch == null || !ch.isActive()) {
            return null;
        }
        HttpToHttp2ConnectionHandler h2Handler = (HttpToHttp2ConnectionHandler)ch.pipeline().get(HttpToHttp2ConnectionHandler.class);
        if (h2Handler != null && (h2Ctx = ch.pipeline().context((ChannelHandler)h2Handler)) != null) {
            Http2Connection connection = h2Handler.connection();
            int lastStreamId = connection.remote().lastStreamKnownByPeer();
            long errorCode = Http2Error.NO_ERROR.code();
            ByteBuf debugData = h2Ctx.alloc().buffer(0);
            h2Handler.encoder().writeGoAway(h2Ctx, lastStreamId, errorCode, debugData, h2Ctx.newPromise());
            h2Ctx.flush();
        }
        return null;
    }),
    WEBSOCKET_CLOSE(() -> {
        Channel ch = QuiesceContextHolder.getChannel();
        if (ch == null || !ch.isActive()) {
            return null;
        }
        ch.writeAndFlush((Object)new CloseWebSocketFrame(1001, "Server shutting down")).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        return null;
    }),
    NO_OP(() -> null);

    private final Callable<Void> task;

    private QuiesceStrategy(Callable<Void> task) {
        this.task = task;
    }

    public Callable<Void> getTask() {
        return this.task;
    }
}

