/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.health40.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.kernel.security.thread.ThreadIdentityManager;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.io.File;
import java.io.IOException;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class HealthFileUtils {
    private static final TraceComponent tc = Tr.register(HealthFileUtils.class, (String)"HEALTH", (String)"io.openliberty.microprofile.health.resources.Health");
    private static volatile File healthDirFile;
    private static volatile File startedFile;
    private static volatile File readyFile;
    private static volatile File liveFile;
    static final long serialVersionUID = -8165767059518629075L;

    public static File getHealthDirFile() {
        if (healthDirFile == null) {
            String serverOutputDir = System.getProperty("server.output.dir");
            if (serverOutputDir == null || serverOutputDir.trim().isEmpty()) {
                String wlpOutputDirEnv = System.getenv("WLP_OUTPUT_DIR");
                if (wlpOutputDirEnv == null || wlpOutputDirEnv.trim().isEmpty()) {
                    Tr.warning((TraceComponent)tc, (String)"file.healthcheck.health.directory.resolution.fail.CWMMH0102W", (Object[])new Object[0]);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"The server was unable to resolve server.output.dir property nor the WLP_OUTPUT_DIR environment variable.", (Object[])new Object[0]);
                    }
                    return null;
                }
                String serverName = System.getProperty("wlp.server.name");
                if ((serverName == null || serverName.trim().isEmpty()) && ((serverName = System.getenv("SERVER_NAME")) == null || serverName.trim().isEmpty())) {
                    Tr.warning((TraceComponent)tc, (String)"file.healthcheck.health.directory.resolution.fail.CWMMH0102W", (Object[])new Object[0]);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"The server was unable to resolve wlp.server.name property nor the SERVER_NAME environment variable.", (Object[])new Object[0]);
                    }
                    return null;
                }
                serverOutputDir = wlpOutputDirEnv.trim() + System.getProperty("file.separator") + serverName.trim();
            }
            File serverConfigDirFile = new File(serverOutputDir);
            healthDirFile = new File(serverConfigDirFile, "health");
        }
        return healthDirFile;
    }

    public static File getStartFile() {
        if (startedFile == null) {
            File healthDirFile = HealthFileUtils.getHealthDirFile();
            startedFile = new File(healthDirFile, HealthCheckFileName.STARTED_FILE.getFileName());
        }
        return startedFile;
    }

    public static File getReadyFile() {
        if (readyFile == null) {
            File healthDirFile = HealthFileUtils.getHealthDirFile();
            readyFile = new File(healthDirFile, HealthCheckFileName.READY_FILE.getFileName());
        }
        return readyFile;
    }

    public static File getLiveFile() {
        if (liveFile == null) {
            File healthDirFile = HealthFileUtils.getHealthDirFile();
            liveFile = new File(healthDirFile, HealthCheckFileName.LIVE_FILE.getFileName());
        }
        return liveFile;
    }

    public static boolean isValidSystem() throws IOException {
        healthDirFile = HealthFileUtils.getHealthDirFile();
        if (healthDirFile == null) {
            return false;
        }
        if (!healthDirFile.exists()) {
            if (!HealthFileUtils.createDirectory(healthDirFile)) {
                Tr.warning((TraceComponent)tc, (String)"file.healthcheck.health.directory.create.fail.CWMMH0100W", (Object[])new Object[]{healthDirFile.getAbsolutePath()});
                return false;
            }
            if (!HealthFileUtils.canWriteToDirectory(healthDirFile)) {
                Tr.warning((TraceComponent)tc, (String)"file.healthcheck.health.directory.write.fail.CWMMH0101W", (Object[])new Object[]{healthDirFile.getAbsolutePath()});
            }
        } else {
            File[] fileArr;
            healthDirFile.deleteOnExit();
            for (File f : fileArr = healthDirFile.listFiles()) {
                if (!f.getName().equals(HealthCheckFileName.STARTED_FILE.getFileName()) && !f.getName().equals(HealthCheckFileName.LIVE_FILE.getFileName()) && !f.getName().equals(HealthCheckFileName.READY_FILE.getFileName())) continue;
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Detected existing file [" + f.getAbsolutePath() + "]"), (Object[])new Object[0]);
                }
                if (f.isDirectory()) {
                    Tr.warning((TraceComponent)tc, (String)"file.healthcheck.file.name.conflict.CWMMH0105W", (Object[])new Object[]{f.getAbsolutePath()});
                    return false;
                }
                if (HealthFileUtils.deleteFiles(f)) continue;
                Tr.warning((TraceComponent)tc, (String)"file.healthcheck.file.delete.fail.CWMMH0106W", (Object[])new Object[]{f.getAbsolutePath()});
                return false;
            }
            if (!HealthFileUtils.canWriteToDirectory(healthDirFile)) {
                Tr.warning((TraceComponent)tc, (String)"file.healthcheck.health.directory.write.fail.CWMMH0101W=CWMMH0101W", (Object[])new Object[]{healthDirFile.getAbsolutePath()});
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean canWriteToDirectory(File parentDir) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            File tempFile = File.createTempFile("test", null);
            if (!tempFile.canWrite()) {
                boolean bl = false;
                return bl;
            }
            if (!tempFile.delete() && TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unable to delete temp file that was crated. Temp file: " + tempFile.getAbsolutePath()), (Object[])new Object[0]);
            }
            boolean bl = true;
            return bl;
        }
        catch (IOException | SecurityException tempFile) {
            FFDCFilter.processException((Throwable)tempFile, (String)"io.openliberty.microprofile.health40.internal.HealthFileUtils", (String)"212", null, (Object[])new Object[]{parentDir});
            boolean bl = false;
            return bl;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean createFile(File file) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            file.deleteOnExit();
            boolean bl = file.createNewFile();
            return bl;
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"io.openliberty.microprofile.health40.internal.HealthFileUtils", (String)"225", null, (Object[])new Object[]{file});
            boolean bl = false;
            return bl;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean createDirectory(File file) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            file.deleteOnExit();
            boolean bl = file.mkdir();
            return bl;
        }
        catch (SecurityException securityException) {
            FFDCFilter.processException((Throwable)securityException, (String)"io.openliberty.microprofile.health40.internal.HealthFileUtils", (String)"238", null, (Object[])new Object[]{file});
            boolean bl = false;
            return bl;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean deleteFiles(File file) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            boolean bl = file.delete();
            return bl;
        }
        catch (SecurityException securityException) {
            FFDCFilter.processException((Throwable)securityException, (String)"io.openliberty.microprofile.health40.internal.HealthFileUtils", (String)"250", null, (Object[])new Object[]{file});
            boolean bl = false;
            return bl;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean setLastModified(File file) {
        Object token = ThreadIdentityManager.runAsServer();
        try {
            boolean ret;
            boolean bl = ret = file.setLastModified(System.currentTimeMillis());
            return bl;
        }
        catch (Exception ret) {
            FFDCFilter.processException((Throwable)ret, (String)"io.openliberty.microprofile.health40.internal.HealthFileUtils", (String)"264", null, (Object[])new Object[]{file});
            boolean bl = false;
            return bl;
        }
        finally {
            ThreadIdentityManager.reset((Object)token);
        }
    }

    static enum HealthCheckFileName {
        STARTED_FILE("started"),
        READY_FILE("ready"),
        LIVE_FILE("live");

        private final String fileName;

        private HealthCheckFileName(String fileName) {
            this.fileName = fileName;
        }

        String getFileName() {
            return this.fileName;
        }
    }
}

