/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jca.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.jca.internal.BootstrapContextImpl;
import com.ibm.ws.jca.internal.Utils;
import com.ibm.ws.jca.security.JCASecurityContext;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.threadcontext.ThreadContext;
import com.ibm.wsspi.threadcontext.ThreadContextDescriptor;
import com.ibm.wsspi.threadcontext.jca.JCAContextProvider;
import io.openliberty.checkpoint.spi.CheckpointHook;
import io.openliberty.checkpoint.spi.CheckpointPhase;
import java.io.Serializable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.resource.ResourceException;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.resource.spi.work.ExecutionContext;
import javax.resource.spi.work.HintsContext;
import javax.resource.spi.work.TransactionContext;
import javax.resource.spi.work.Work;
import javax.resource.spi.work.WorkCompletedException;
import javax.resource.spi.work.WorkContext;
import javax.resource.spi.work.WorkContextLifecycleListener;
import javax.resource.spi.work.WorkContextProvider;
import javax.resource.spi.work.WorkEvent;
import javax.resource.spi.work.WorkException;
import javax.resource.spi.work.WorkListener;
import javax.resource.spi.work.WorkRejectedException;

@TraceObjectField(fieldName="TC", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class WorkProxy
implements Callable<Void>,
Runnable {
    private static final TraceComponent TC = Tr.register(WorkProxy.class, (String)"WAS.j2c", (String)"com.ibm.ws.jca.internal.resources.J2CAMessages");
    private final BootstrapContextImpl bootstrapContext;
    private final ExecutionContext executionContext;
    private final Map<String, String> executionProperties = new HashMap<String, String>();
    private Throwable hintsContextSetupFailure;
    private final ConcurrentLinkedQueue<Work> runningWork;
    protected Work work;
    private final long startTimeout;
    private final BlockingQueue<Object> startupDurationQueue = new LinkedBlockingQueue<Object>();
    private final ThreadContextDescriptor threadContextDescriptor;
    private final long timeAccepted;
    private final List<WorkContext> workContexts;
    private static final long fudgeFactor = 100L;
    protected WorkListener lsnr;
    static final long serialVersionUID = 8349319849320045318L;

    public WorkProxy(Work theWork, long theStartTimeout, ExecutionContext theContext, WorkListener theListener, BootstrapContextImpl bootstrapContext, ConcurrentLinkedQueue<Work> runningWork, boolean applyDefaultContext) throws Exception {
        String identityNameKey;
        this.work = theWork;
        this.startTimeout = theStartTimeout;
        this.executionContext = theContext;
        this.lsnr = theListener;
        this.bootstrapContext = bootstrapContext;
        this.runningWork = runningWork;
        if (!CheckpointPhase.getPhase().restored()) {
            CheckpointHookForNewWorkProxy.add(bootstrapContext.resourceAdapterID, this.work.toString());
            throw new WorkRejectedException(Utils.getMessage("J2CA8602.work.submit.not.supported.checkpoint", this.work, bootstrapContext.resourceAdapterID));
        }
        boolean isWorkContextProvider = this.work instanceof WorkContextProvider;
        List<WorkContext> list = this.workContexts = isWorkContextProvider ? ((WorkContextProvider)this.work).getWorkContexts() : null;
        if (isWorkContextProvider && this.executionContext != null) {
            WorkRejectedException wrex = new WorkRejectedException(Utils.getMessage("J2CA8623.execution.context.conflict", bootstrapContext.resourceAdapterID), "0");
            if (this.lsnr != null) {
                this.lsnr.workRejected(new WorkEvent((Object)this.work, 2, this.work, (WorkException)wrex));
            }
            throw wrex;
        }
        String workName = null;
        if (this.workContexts != null) {
            for (WorkContext workContext : this.workContexts) {
                if (!(workContext instanceof HintsContext)) continue;
                Map hints = ((HintsContext)workContext).getHints();
                Serializable value = (Serializable)hints.get("javax.resource.Name");
                if (value == null || value instanceof String) {
                    workName = (String)((Object)value);
                } else {
                    this.hintsContextSetupFailure = new ClassCastException(Tr.formatMessage((TraceComponent)TC, (String)"J2CA8687.hint.datatype.invalid", (Object[])new Object[]{"HintsContext.NAME_HINT", String.class.getName(), bootstrapContext.resourceAdapterID, value, value.getClass().getName()}));
                }
                value = (Serializable)hints.get("javax.resource.LongRunning");
                if (value instanceof Boolean) {
                    String key = bootstrapContext.eeVersion < 9 ? "javax.enterprise.concurrent.LONGRUNNING_HINT" : "jakarta.enterprise.concurrent.LONGRUNNING_HINT";
                    this.executionProperties.put(key, value.toString());
                    continue;
                }
                if (value == null) continue;
                this.hintsContextSetupFailure = new ClassCastException(Tr.formatMessage((TraceComponent)TC, (String)"J2CA8687.hint.datatype.invalid", (Object[])new Object[]{"HintsContext.LONGRUNNING_HINT", Boolean.class.getName(), bootstrapContext.resourceAdapterID, value, value.getClass().getName()}));
            }
        }
        String string = identityNameKey = bootstrapContext.eeVersion < 9 ? "javax.enterprise.concurrent.IDENTITY_NAME" : "jakarta.enterprise.concurrent.IDENTITY_NAME";
        this.executionProperties.put(identityNameKey, workName == null ? (this.work == null ? null : this.work.getClass().getName()) : workName);
        this.executionProperties.put("com.ibm.ws.concurrent.TASK_OWNER", bootstrapContext.resourceAdapterID);
        if (bootstrapContext.propagateThreadContext) {
            if (applyDefaultContext) {
                this.executionProperties.put("com.ibm.ws.concurrent.DEFAULT_CONTEXT", "UNCONFIGURED_CONTEXT_TYPES");
            } else {
                this.executionProperties.put("com.ibm.ws.concurrent.SKIP_CONTEXT_PROVIDERS", "com.ibm.ws.transaction.context.provider");
            }
        } else {
            this.executionProperties.put("com.ibm.ws.concurrent.DEFAULT_CONTEXT", "ALL_CONTEXT_TYPES");
        }
        this.threadContextDescriptor = bootstrapContext.contextSvc.captureThreadContext(this.executionProperties, new Map[0]);
        if (this.work instanceof ResourceAdapterAssociation && bootstrapContext.resourceAdapter != null) {
            ((ResourceAdapterAssociation)this.work).setResourceAdapter(bootstrapContext.resourceAdapter);
        }
        if (this.lsnr != null) {
            WorkEvent event = new WorkEvent((Object)this.work, 1, this.work, null);
            this.lsnr.workAccepted(event);
        }
        this.timeAccepted = System.currentTimeMillis();
    }

    /*
     * WARNING - void declaration
     */
    private ThreadContextDescriptor appendInflowContext() throws WorkCompletedException {
        ThreadContextDescriptor merged = this.threadContextDescriptor.clone();
        HashSet<String> inflowContext = new HashSet<String>();
        if (this.workContexts != null) {
            for (WorkContext workContext : this.workContexts) {
                ThreadContext context;
                if (workContext instanceof HintsContext) {
                    if (this.hintsContextSetupFailure == null) continue;
                    throw this.contextSetupFailure(workContext, "3", this.hintsContextSetupFailure);
                }
                JCAContextProvider provider2 = this.bootstrapContext.getJCAContextProvider(workContext.getClass());
                if (provider2 == null) {
                    throw this.contextSetupFailure(workContext, "1", null);
                }
                try {
                    context = provider2.getInflowContext((Object)workContext, this.executionProperties);
                }
                catch (Throwable throwable) {
                    void x;
                    FFDCFilter.processException((Throwable)throwable, (String)"com.ibm.ws.jca.internal.WorkProxy", (String)"212", (Object)this, (Object[])new Object[0]);
                    throw this.contextSetupFailure(workContext, "3", (Throwable)x);
                }
                String workContextProviderName = this.bootstrapContext.getJCAContextProviderName(workContext.getClass());
                if (!inflowContext.add(workContextProviderName)) {
                    throw this.contextSetupFailure(workContext, "2", null);
                }
                merged.set(workContextProviderName, context);
            }
        }
        if (this.executionContext != null && inflowContext.isEmpty() && (this.executionContext.getXid() != null || this.executionContext.getTransactionTimeout() != -1L)) {
            ThreadContext context;
            JCAContextProvider provider = this.bootstrapContext.getJCAContextProvider(TransactionContext.class);
            if (provider == null) {
                throw this.contextSetupFailure(this.executionContext, "1", null);
            }
            try {
                context = provider.getInflowContext((Object)this.executionContext, this.executionProperties);
            }
            catch (Throwable provider2) {
                void x;
                FFDCFilter.processException((Throwable)provider2, (String)"com.ibm.ws.jca.internal.WorkProxy", (String)"231", (Object)this, (Object[])new Object[0]);
                throw this.contextSetupFailure(this.executionContext, "3", (Throwable)x);
            }
            String executionContextHandlerName = this.bootstrapContext.getJCAContextProviderName(TransactionContext.class);
            merged.set(executionContextHandlerName, context);
        }
        return merged;
    }

    @Override
    @ManualTrace
    @FFDCIgnore(value={Throwable.class})
    public Void call() throws WorkException {
        boolean trace = TraceComponent.isAnyTracingEnabled();
        if (trace && TC.isEntryEnabled()) {
            Tr.entry((Object)this, (TraceComponent)TC, (String)"call", (Object[])new Object[]{this.work, this.lsnr});
        }
        long currentTime = System.currentTimeMillis();
        long startupDuration = currentTime - this.timeAccepted;
        if (this.startTimeout != Long.MAX_VALUE && startupDuration > this.startTimeout && this.startTimeout >= 0L) {
            if (startupDuration < 100L) {
                startupDuration = -1L;
            } else {
                WorkRejectedException wrex = new WorkRejectedException(Utils.getMessage("J2CA8600.work.start.timeout", this.work, this.bootstrapContext.resourceAdapterID, this.startTimeout), "1");
                if (this.lsnr != null) {
                    WorkEvent event = new WorkEvent((Object)this.work, 2, this.work, (WorkException)wrex, startupDuration);
                    this.lsnr.workRejected(event);
                }
                this.startupDurationQueue.add(wrex);
                if (trace && TC.isEntryEnabled()) {
                    Tr.exit((Object)this, (TraceComponent)TC, (String)"call", (Object)wrex);
                }
                throw wrex;
            }
        }
        this.startupDurationQueue.add(startupDuration);
        if (this.lsnr != null) {
            WorkEvent event = new WorkEvent((Object)this.work, 3, this.work, null, startupDuration);
            this.lsnr.workStarted(event);
        }
        WorkCompletedException wcex = null;
        try {
            ThreadContextDescriptor mergedThreadContextDescriptor = this.work instanceof WorkContextProvider || this.executionContext != null ? this.appendInflowContext() : this.threadContextDescriptor;
            Runnable contextualWork = (Runnable)this.bootstrapContext.contextSvc.createContextualProxy(mergedThreadContextDescriptor, (Object)this, Runnable.class);
            this.runningWork.add(this.work);
            if (trace && TC.isDebugEnabled()) {
                Tr.debug((Object)this, (TraceComponent)TC, (String)"Actual call to work.run", (Object[])new Object[0]);
            }
            contextualWork.run();
        }
        catch (Throwable ex) {
            ex = ex instanceof RejectedExecutionException ? ex.getCause() : ex;
            String errorCode = ex instanceof ResourceException ? ((ResourceException)ex).getErrorCode() : "0";
            wcex = (WorkCompletedException)(ex instanceof WorkCompletedException ? ex : new WorkCompletedException(ex.getMessage(), errorCode).initCause(ex));
            if (!this.runningWork.contains(this.work)) {
                FFDCFilter.processException((Throwable)ex, (String)this.getClass().getName(), (String)"326", (Object)this);
                Tr.error((TraceComponent)TC, (String)"J2CA8688.work.setup.failed", (Object[])new Object[]{ex.getMessage() == null ? ex.getClass().getName() : ex.getMessage()});
            }
            if (trace && TC.isEntryEnabled()) {
                Tr.exit((Object)this, (TraceComponent)TC, (String)"call", (Object)Utils.toString(ex));
            }
            throw wcex;
        }
        finally {
            this.runningWork.remove(this.work);
            if (this.lsnr != null) {
                WorkEvent event = new WorkEvent((Object)this.work, 4, this.work, (WorkException)wcex, startupDuration);
                this.lsnr.workCompleted(event);
            }
        }
        if (trace && TC.isEntryEnabled()) {
            Tr.exit((Object)this, (TraceComponent)TC, (String)"call");
        }
        return null;
    }

    private WorkCompletedException contextSetupFailure(Object context, String errorCode, Throwable cause) {
        if (context instanceof WorkContextLifecycleListener) {
            ((WorkContextLifecycleListener)context).contextSetupFailed(errorCode);
        }
        String message = null;
        if ("2".equals(errorCode)) {
            message = Utils.getMessage("J2CA8624.work.context.duplicate", this.bootstrapContext.resourceAdapterID, context.getClass().getName());
        } else if ("1".equals(errorCode)) {
            message = Utils.getMessage("J2CA8625.work.context.unavailable", this.bootstrapContext.resourceAdapterID, context.getClass().getName());
        } else if (cause != null) {
            message = cause.getMessage();
        }
        WorkCompletedException wcex = new WorkCompletedException(message, errorCode);
        if (cause != null) {
            wcex.initCause(cause);
        }
        return wcex;
    }

    @Override
    public void run() {
        JCASecurityContext ctx = this.bootstrapContext.getJCASecurityContext();
        if (ctx != null) {
            ctx.runInInboundSecurityContext((Runnable)this.work);
        } else {
            this.work.run();
        }
    }

    Long waitForStart() throws InterruptedException, WorkRejectedException {
        long timeout = this.startTimeout == -1L ? Long.MAX_VALUE : (this.startTimeout < 100L ? 100L : this.startTimeout);
        Object o = this.startupDurationQueue.poll(timeout, TimeUnit.MILLISECONDS);
        if (o instanceof WorkRejectedException) {
            throw (WorkRejectedException)o;
        }
        return (Long)o;
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class CheckpointHookForNewWorkProxy
    implements CheckpointHook {
        private final String raId;
        private final String workId;
        private static final AtomicBoolean alreadyAdded;
        static final long serialVersionUID = -2325312914971771374L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public void prepare() {
            throw new IllegalStateException(Utils.getMessage("J2CA8601.work.submit.failed.checkpoint", this.raId, this.workId));
        }

        private CheckpointHookForNewWorkProxy(String raId, String workId) {
            this.raId = raId;
            this.workId = workId;
        }

        private static void add(String raId, String workId) {
            if (alreadyAdded.compareAndSet(false, true)) {
                CheckpointPhase.getPhase().addMultiThreadedHook((CheckpointHook)new CheckpointHookForNewWorkProxy(raId, workId));
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jca.internal.WorkProxy$CheckpointHookForNewWorkProxy", CheckpointHookForNewWorkProxy.class, (String)"WAS.j2c", (String)"com.ibm.ws.jca.internal.resources.J2CAMessages");
            alreadyAdded = new AtomicBoolean(false);
        }
    }
}

