/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.microprofile.faulttolerance20.state.impl;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.microprofile.faulttolerance.spi.CircuitBreakerPolicy;
import com.ibm.ws.microprofile.faulttolerance.spi.MetricRecorder;
import com.ibm.ws.microprofile.faulttolerance20.impl.MethodResult;
import com.ibm.ws.microprofile.faulttolerance20.state.CircuitBreakerState;
import com.ibm.ws.microprofile.faulttolerance20.state.impl.CircuitBreakerRollingWindow;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.time.Duration;
import java.util.concurrent.atomic.AtomicReference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class CircuitBreakerStateImpl
implements CircuitBreakerState {
    private static final TraceComponent tc = Tr.register(CircuitBreakerStateImpl.class, (String)"FAULTTOLERANCE", null);
    private final CircuitBreakerPolicy policy;
    private final MetricRecorder metricRecorder;
    private final AtomicReference<State> state;
    private final long policyDelayNanos;
    private final CircuitBreakerRollingWindow rollingWindow;
    private int halfOpenRunningExecutions;
    private int halfOpenSuccessfulExecutions;
    private long halfOpenLastExecutionStarted;
    private long openStateStartTime;
    static final long serialVersionUID = 6623915330072259846L;

    public CircuitBreakerStateImpl(CircuitBreakerPolicy policy, MetricRecorder metricRecorder) {
        this.policy = policy;
        this.metricRecorder = metricRecorder;
        this.policyDelayNanos = policy.getDelay().toNanos();
        this.state = new AtomicReference<State>(State.CLOSED);
        this.rollingWindow = new CircuitBreakerRollingWindow(policy.getRequestVolumeThreshold(), policy.getFailureRatio());
        this.halfOpenRunningExecutions = 0;
        this.halfOpenSuccessfulExecutions = 0;
        this.halfOpenLastExecutionStarted = 0L;
        this.openStateStartTime = 0L;
    }

    @Override
    public boolean requestPermissionToExecute() {
        boolean result;
        if (this.state.get() == State.CLOSED) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Allowing execution in closed state", (Object[])new Object[0]);
            }
            result = true;
        } else {
            result = this.synchronizedRequestPermissionToExecute();
        }
        if (!result) {
            this.metricRecorder.incrementCircuitBreakerCallsCircuitOpenCount();
        }
        return result;
    }

    @Override
    public void recordResult(MethodResult<?> result) {
        CircuitBreakerResult cbResult = this.getCircuitBreakerResult(result);
        if (this.state.get() == State.OPEN) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Recording result {0} in open state", (Object[])new Object[]{cbResult});
            }
        } else {
            this.synchronizedRecordResult(cbResult);
        }
        if (cbResult == CircuitBreakerResult.SUCCESS) {
            this.metricRecorder.incrementCircuitBreakerCallsSuccessCount();
        } else {
            this.metricRecorder.incrementCircuitBreakerCallsFailureCount();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean synchronizedRequestPermissionToExecute() {
        boolean result = false;
        CircuitBreakerStateImpl circuitBreakerStateImpl = this;
        synchronized (circuitBreakerStateImpl) {
            switch (this.state.get()) {
                case CLOSED: {
                    result = true;
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)"Allowing execution in closed state", (Object[])new Object[0]);
                    break;
                }
                case HALF_OPEN: {
                    if (this.halfOpenRunningExecutions < this.policy.getSuccessThreshold()) {
                        ++this.halfOpenRunningExecutions;
                        this.halfOpenLastExecutionStarted = System.nanoTime();
                        result = true;
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                        Tr.debug((TraceComponent)tc, (String)"Allowing execution in half-open state. Now running ({0}/{1})", (Object[])new Object[]{this.halfOpenRunningExecutions, this.policy.getSuccessThreshold()});
                        break;
                    }
                    long nanoTimeOfThisMethod = System.nanoTime();
                    if (nanoTimeOfThisMethod - this.halfOpenLastExecutionStarted > this.policyDelayNanos) {
                        this.halfOpenLastExecutionStarted = System.nanoTime();
                        result = true;
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                        Tr.debug((TraceComponent)tc, (String)"Allowing execution in half-open state because enough time has passed without a trial executions completing. Time since the last execution started {0}, time required to allow an extra execution: {1} , nanotimestamp when the last execution started: {2}, current nanotimestamp {3}", (Object[])new Object[]{Duration.ofNanos(nanoTimeOfThisMethod - this.halfOpenLastExecutionStarted), Duration.ofNanos(this.policyDelayNanos), this.halfOpenLastExecutionStarted, nanoTimeOfThisMethod});
                        break;
                    }
                    result = false;
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)"Denying execution in half-open state, trial execution limit reached", (Object[])new Object[0]);
                    break;
                }
                case OPEN: {
                    long nanoTimeOfThisMethod = System.nanoTime();
                    if (nanoTimeOfThisMethod - this.openStateStartTime > this.policyDelayNanos) {
                        this.stateHalfOpen();
                        ++this.halfOpenRunningExecutions;
                        this.halfOpenLastExecutionStarted = System.nanoTime();
                        result = true;
                        if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                        Tr.debug((TraceComponent)tc, (String)"Allowing execution because we just changed to half-open state. Time since we opened: {0}, time required to half-open: {1}, nanotimestamp when we opened: {2}, current nanotimestamp {3}", (Object[])new Object[]{Duration.ofNanos(nanoTimeOfThisMethod - this.openStateStartTime), Duration.ofNanos(this.policyDelayNanos), this.openStateStartTime, nanoTimeOfThisMethod});
                        break;
                    }
                    result = false;
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)"Denying execution in open state", (Object[])new Object[0]);
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void synchronizedRecordResult(CircuitBreakerResult result) {
        CircuitBreakerStateImpl circuitBreakerStateImpl = this;
        synchronized (circuitBreakerStateImpl) {
            switch (this.state.get()) {
                case CLOSED: {
                    this.rollingWindow.record(result);
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Recording result {0} in closed state: {1}", (Object[])new Object[]{result, this.rollingWindow});
                    }
                    if (!this.rollingWindow.isOverThreshold()) break;
                    this.stateOpen();
                    break;
                }
                case HALF_OPEN: {
                    if (result == CircuitBreakerResult.FAILURE) {
                        this.stateOpen();
                        break;
                    }
                    --this.halfOpenRunningExecutions;
                    ++this.halfOpenSuccessfulExecutions;
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Recording result {0} in half-open state. Running executions: {1}, Current results: ({2}/{3})", (Object[])new Object[]{result, this.halfOpenRunningExecutions, this.halfOpenSuccessfulExecutions, this.policy.getSuccessThreshold()});
                    }
                    if (this.halfOpenSuccessfulExecutions < this.policy.getSuccessThreshold()) break;
                    this.stateClosed();
                    break;
                }
                case OPEN: {
                    if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break;
                    Tr.debug((TraceComponent)tc, (String)"Recording result {0} in open state", (Object[])new Object[]{result});
                }
            }
        }
    }

    @Trivial
    private void stateClosed() {
        this.rollingWindow.clear();
        this.state.set(State.CLOSED);
        this.metricRecorder.reportCircuitClosed();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Transitioned to Closed state", (Object[])new Object[0]);
        }
    }

    @Trivial
    private void stateHalfOpen() {
        this.halfOpenRunningExecutions = 0;
        this.halfOpenSuccessfulExecutions = 0;
        this.state.set(State.HALF_OPEN);
        this.metricRecorder.reportCircuitHalfOpen();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Transitioned to Half Open state", (Object[])new Object[0]);
        }
    }

    @Trivial
    private void stateOpen() {
        this.openStateStartTime = System.nanoTime();
        this.state.set(State.OPEN);
        this.metricRecorder.reportCircuitOpen();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Transitioned to Open state. nanotimestamp: {0}", (Object[])new Object[]{this.openStateStartTime});
        }
    }

    @Trivial
    private CircuitBreakerResult getCircuitBreakerResult(MethodResult<?> result) {
        CircuitBreakerResult cbResult = !result.isFailure() ? CircuitBreakerResult.SUCCESS : (this.isSkipOn(result.getFailure()) ? CircuitBreakerResult.SUCCESS : (this.isFailOn(result.getFailure()) ? CircuitBreakerResult.FAILURE : CircuitBreakerResult.SUCCESS));
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Circuit breaker considers {0} to be {1}", (Object[])new Object[]{result, cbResult});
        }
        return cbResult;
    }

    private boolean isSkipOn(Throwable methodException) {
        for (Class skipExClazz : this.policy.getSkipOn()) {
            if (!skipExClazz.isInstance(methodException)) continue;
            return true;
        }
        return false;
    }

    private boolean isFailOn(Throwable methodException) {
        for (Class failExClazz : this.policy.getFailOn()) {
            if (!failExClazz.isInstance(methodException)) continue;
            return true;
        }
        return false;
    }

    private static enum State {
        OPEN,
        HALF_OPEN,
        CLOSED;

    }

    public static enum CircuitBreakerResult {
        SUCCESS,
        FAILURE;

    }
}

