/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxrs.monitor;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class RestRouteCache {
    private final ConcurrentHashMap<RestRouteKey, String> routes = new ConcurrentHashMap();
    private final ReferenceQueue<Class<?>> referenceQueue = new ReferenceQueue();
    static final long serialVersionUID = 8665434166826979610L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public String getRoute(Class<?> restClass, Method restMethod) {
        this.evictGarbageCollectedEntries();
        return this.routes.get(new RestRouteKey(restClass, restMethod));
    }

    public void putRoute(Class<?> restClass, Method restMethod, String route) {
        this.evictGarbageCollectedEntries();
        this.routes.put(new RestRouteKey(this.referenceQueue, restClass, restMethod), route);
    }

    private void evictGarbageCollectedEntries() {
        RestRouteKeyWeakReference key;
        while ((key = (RestRouteKeyWeakReference)this.referenceQueue.poll()) != null) {
            this.routes.remove(key.getOwningKey());
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxrs.monitor.RestRouteCache", RestRouteCache.class, null, null);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class RestRouteKey {
        private final RestRouteKeyWeakReference<Class<?>> restClassRef;
        private final RestRouteKeyWeakReference<Method> restMethodRef;
        private final int hash;
        static final long serialVersionUID = 1993972394673035186L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        RestRouteKey(Class<?> restClass, Method restMethod) {
            this.restClassRef = new RestRouteKeyWeakReference(restClass, this);
            this.restMethodRef = new RestRouteKeyWeakReference<Method>(restMethod, this);
            this.hash = Objects.hash(restClass, restMethod);
        }

        RestRouteKey(ReferenceQueue<Class<?>> referenceQueue, Class<?> restClass, Method restMethod) {
            this.restClassRef = new RestRouteKeyWeakReference(restClass, this, referenceQueue);
            this.restMethodRef = new RestRouteKeyWeakReference<Method>(restMethod, this);
            this.hash = Objects.hash(restClass, restMethod);
        }

        public int hashCode() {
            return this.hash;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RestRouteKey other = (RestRouteKey)obj;
            if (!this.restClassRef.equals(other.restClassRef)) {
                return false;
            }
            return this.restMethodRef.equals(other.restMethodRef);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxrs.monitor.RestRouteCache$RestRouteKey", RestRouteKey.class, null, null);
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static class RestRouteKeyWeakReference<T>
    extends WeakReference<T> {
        private final RestRouteKey owningKey;
        static final long serialVersionUID = -7399835644074625108L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        RestRouteKeyWeakReference(T referent, RestRouteKey owningKey) {
            super(referent);
            this.owningKey = owningKey;
        }

        RestRouteKeyWeakReference(T referent, RestRouteKey owningKey, ReferenceQueue<T> referenceQueue) {
            super(referent, referenceQueue);
            this.owningKey = owningKey;
        }

        RestRouteKey getOwningKey() {
            return this.owningKey;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof RestRouteKeyWeakReference) {
                return this.get() == ((RestRouteKeyWeakReference)obj).get();
            }
            return false;
        }

        public String toString() {
            Object referent = this.get();
            return "RestRouteKeyWeakReference: " + referent;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.jaxrs.monitor.RestRouteCache$RestRouteKeyWeakReference", RestRouteKeyWeakReference.class, null, null);
        }
    }
}

