/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenAPIVersion
implements Comparable<OpenAPIVersion> {
    private static final Pattern VERSION_PATTERN;
    private int major;
    private int minor;
    private int patch;
    private String versionString;
    static final long serialVersionUID = -7369894152145462464L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    @FFDCIgnore(value={NumberFormatException.class})
    public static Optional<OpenAPIVersion> parse(String versionString) {
        if (versionString == null) {
            return Optional.empty();
        }
        Matcher matcher = VERSION_PATTERN.matcher(versionString = versionString.trim());
        if (!matcher.matches()) {
            return Optional.empty();
        }
        String major = matcher.group(1);
        String minor = matcher.group(2);
        String patch = matcher.group(3);
        try {
            return Optional.of(new OpenAPIVersion(Integer.parseInt(major), Integer.parseInt(minor), patch == null ? -1 : Integer.parseInt(patch)));
        }
        catch (NumberFormatException e) {
            return Optional.empty();
        }
    }

    public OpenAPIVersion(int major, int minor) {
        this(major, minor, -1);
    }

    public OpenAPIVersion(int major, int minor, int patch) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.versionString = major + "." + minor + (patch == -1 ? "" : "." + patch);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    public int getPatch() {
        return this.patch;
    }

    public String toString() {
        return this.versionString;
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OpenAPIVersion other = (OpenAPIVersion)obj;
        return this.major == other.major && this.minor == other.minor && this.patch == other.patch;
    }

    @Override
    public int compareTo(OpenAPIVersion o) {
        int compare = 0;
        compare = Integer.compare(this.major, o.major);
        if (compare == 0) {
            compare = Integer.compare(this.minor, o.minor);
        }
        if (compare == 0) {
            compare = Integer.compare(this.patch, o.patch);
        }
        return compare;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.microprofile.openapi20.internal.OpenAPIVersion", OpenAPIVersion.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
        VERSION_PATTERN = Pattern.compile("([0-9]+)\\.([0-9]+)(?:\\.([0-9]+))?");
    }
}

