/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.encryption.support;

import com.google.common.base.Strings;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.constraint.NonnullElements;
import net.shibboleth.utilities.java.support.annotation.constraint.NotLive;
import net.shibboleth.utilities.java.support.annotation.constraint.Unmodifiable;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.primitive.StringSupport;
import org.opensaml.xmlsec.encryption.DataReference;
import org.opensaml.xmlsec.encryption.EncryptedData;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.encryption.support.EncryptedKeyResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;

public abstract class AbstractEncryptedKeyResolver
implements EncryptedKeyResolver {
    private final Set<String> recipients;

    public AbstractEncryptedKeyResolver() {
        this.recipients = Collections.emptySet();
    }

    public AbstractEncryptedKeyResolver(@Nullable Set<String> newRecipents) {
        this.recipients = Collections.unmodifiableSet(new HashSet(StringSupport.normalizeStringCollection(newRecipents)));
    }

    public AbstractEncryptedKeyResolver(@Nullable String recipient) {
        String trimmed = StringSupport.trimOrNull((String)recipient);
        this.recipients = trimmed != null ? Collections.singleton(trimmed) : Collections.emptySet();
    }

    @Override
    @Nonnull
    @NonnullElements
    @Unmodifiable
    @NotLive
    public Set<String> getRecipients() {
        return this.recipients;
    }

    protected boolean matchRecipient(@Nullable String recipient) {
        String trimmedRecipient = StringSupport.trimOrNull((String)recipient);
        if (trimmedRecipient == null) {
            return true;
        }
        Set<String> ourRecipients = this.getRecipients();
        if (ourRecipients.isEmpty()) {
            return true;
        }
        return ourRecipients.contains(trimmedRecipient);
    }

    protected boolean matchCarriedKeyName(@Nonnull EncryptedData encryptedData, @Nonnull EncryptedKey encryptedKey) {
        Constraint.isNotNull((Object)encryptedData, (String)"EncryptedData cannot be null");
        Constraint.isNotNull((Object)encryptedKey, (String)"EncryptedKey cannot be null");
        if (encryptedKey.getCarriedKeyName() == null || Strings.isNullOrEmpty((String)encryptedKey.getCarriedKeyName().getValue())) {
            return true;
        }
        if (encryptedData.getKeyInfo() == null || encryptedData.getKeyInfo().getKeyNames().isEmpty()) {
            return false;
        }
        String keyCarriedKeyName = encryptedKey.getCarriedKeyName().getValue();
        List<String> dataKeyNames = KeyInfoSupport.getKeyNames(encryptedData.getKeyInfo());
        return dataKeyNames.contains(keyCarriedKeyName);
    }

    protected boolean matchDataReference(@Nonnull EncryptedData encryptedData, @Nonnull EncryptedKey encryptedKey) {
        Constraint.isNotNull((Object)encryptedData, (String)"EncryptedData cannot be null");
        Constraint.isNotNull((Object)encryptedKey, (String)"EncryptedKey cannot be null");
        if (encryptedKey.getReferenceList() == null || encryptedKey.getReferenceList().getDataReferences().isEmpty()) {
            return true;
        }
        if (Strings.isNullOrEmpty((String)encryptedData.getID())) {
            return false;
        }
        List<DataReference> drlist = encryptedKey.getReferenceList().getDataReferences();
        for (DataReference dr : drlist) {
            if (Strings.isNullOrEmpty((String)dr.getURI()) || !dr.getURI().startsWith("#") || dr.resolveIDFromRoot(dr.getURI().substring(1)) != encryptedData) continue;
            return true;
        }
        return false;
    }
}

