/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xmlsec.keyinfo.impl;

import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.utilities.java.support.annotation.ParameterName;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.criteria.KeyNameCriterion;
import org.opensaml.security.criteria.PublicKeyCriterion;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolutionMode;
import org.opensaml.xmlsec.keyinfo.impl.BasicProviderKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.KeyInfoProvider;
import org.opensaml.xmlsec.keyinfo.impl.KeyInfoResolutionContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalKeyInfoCredentialResolver
extends BasicProviderKeyInfoCredentialResolver {
    private final Logger log = LoggerFactory.getLogger(LocalKeyInfoCredentialResolver.class);
    private final CredentialResolver localCredResolver;

    public LocalKeyInfoCredentialResolver(@Nonnull @ParameterName(name="keyInfoProviders") List<KeyInfoProvider> keyInfoProviders, @Nonnull @ParameterName(name="localCredentialResolver") CredentialResolver localCredentialResolver) {
        super(keyInfoProviders);
        this.localCredResolver = (CredentialResolver)Constraint.isNotNull((Object)localCredentialResolver, (String)"Local credential resolver cannot be null");
    }

    @Nonnull
    public CredentialResolver getLocalCredentialResolver() {
        return this.localCredResolver;
    }

    @Override
    protected void postProcess(@Nonnull KeyInfoResolutionContext kiContext, @Nullable CriteriaSet criteriaSet, @Nonnull List<Credential> credentials) throws ResolverException {
        KeyInfoCredentialResolutionMode.Mode mode = criteriaSet.contains(KeyInfoCredentialResolutionMode.class) ? ((KeyInfoCredentialResolutionMode)criteriaSet.get(KeyInfoCredentialResolutionMode.class)).getMode() : KeyInfoCredentialResolutionMode.Mode.LOCAL;
        this.log.debug("Resolution mode in effect is: {}", (Object)mode);
        if (KeyInfoCredentialResolutionMode.Mode.PUBLIC == mode) {
            this.log.debug("Criteria indicates PUBLIC resolution mode, skipping explicit local credential resolution");
            return;
        }
        ArrayList<Credential> results = new ArrayList<Credential>();
        for (Credential inputCred : credentials) {
            if (this.isLocalCredential(inputCred)) {
                this.log.debug("Input credential was local, including in results");
                results.add(inputCred);
                continue;
            }
            if (inputCred.getPublicKey() == null) continue;
            Collection<? extends Credential> localCreds = this.resolveByPublicKey(inputCred.getPublicKey());
            if (!localCreds.isEmpty()) {
                this.log.debug("Input credential was public, resolved to local credential(s), adding to results");
                results.addAll(localCreds);
                continue;
            }
            if (KeyInfoCredentialResolutionMode.Mode.BOTH == mode) {
                this.log.debug("Input credential was public, did not resolve to local credential(s), BOTH mode in effect, including in results");
                results.add(inputCred);
                continue;
            }
            this.log.debug("Input credential was public, did not resolve to local credential(s), LOCAL mode in effect, omitting from results");
        }
        for (String keyName : kiContext.getKeyNames()) {
            results.addAll(this.resolveByKeyName(keyName));
        }
        credentials.clear();
        credentials.addAll(results);
    }

    protected boolean isLocalCredential(@Nonnull Credential credential) {
        return credential.getPrivateKey() != null || credential.getSecretKey() != null;
    }

    @Nonnull
    protected Collection<? extends Credential> resolveByKeyName(@Nonnull String keyName) throws ResolverException {
        ArrayList<Credential> localCreds = new ArrayList<Credential>();
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new KeyNameCriterion(keyName)});
        for (Credential cred : this.getLocalCredentialResolver().resolve(criteriaSet)) {
            if (!this.isLocalCredential(cred)) continue;
            localCreds.add(cred);
        }
        return localCreds;
    }

    @Nonnull
    protected Collection<? extends Credential> resolveByPublicKey(@Nonnull PublicKey publicKey) throws ResolverException {
        ArrayList<Credential> localCreds = new ArrayList<Credential>();
        CriteriaSet criteriaSet = new CriteriaSet(new Criterion[]{new PublicKeyCriterion(publicKey)});
        for (Credential cred : this.getLocalCredentialResolver().resolve(criteriaSet)) {
            if (!this.isLocalCredential(cred)) continue;
            localCreds.add(cred);
        }
        return localCreds;
    }
}

