/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.jaxws.endpoint;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.jaxws.endpoint.WebServicesConfigHolder;
import com.ibm.ws.jaxws.internal.ConfigValidation;
import com.ibm.ws.jaxws.internal.WebServiceConfig;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPid={"com.ibm.ws.jaxws.config"}, configurationPolicy=ConfigurationPolicy.REQUIRE, service={WebServiceConfig.class}, immediate=true, property={"service.vendor=IBM"})
public class WebServiceConfigImpl
extends WebServiceConfig {
    private static final TraceComponent tc = Tr.register(WebServiceConfigImpl.class, (String)"JaxWsCommon", (String)"com.ibm.ws.jaxws.internal.resources.JaxWsCommonMessages");
    private static boolean issuedBetaMessage;
    static final long serialVersionUID = 4036226316379046057L;

    private void betaFenceCheck() throws UnsupportedOperationException {
        if (!ProductInfo.getBetaEdition()) {
            throw new UnsupportedOperationException("The webService configuration is in beta and is not available.");
        }
        if (!issuedBetaMessage) {
            Tr.debug((TraceComponent)tc, (String)("BETA: A webService configuration beta method has been invoked for the class " + this.getClass().getName() + " for the first time."), (Object[])new Object[0]);
            issuedBetaMessage = !issuedBetaMessage;
        }
    }

    @Deprecated
    @Activate
    public WebServiceConfigImpl(Map<String, Object> properties) {
        this.betaFenceCheck();
        if (tc.isDebugEnabled() && TraceComponent.isAnyTracingEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("ConfigImpl activate - " + properties), (Object[])new Object[0]);
        }
        if (!WebServicesConfigHolder.checkConfig(properties)) {
            return;
        }
        String portName = this.getPortName(properties);
        WebServicesConfigHolder.addConfig(this.toString(), portName, this.filterProps(properties));
    }

    @Override
    @Deprecated
    @Modified
    protected void modified(Map<String, Object> properties) {
        this.betaFenceCheck();
        if (tc.isDebugEnabled() && TraceComponent.isAnyTracingEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("entering modified - " + properties), (Object[])new Object[0]);
        }
        if (properties == null) {
            if (tc.isDebugEnabled() && TraceComponent.isAnyTracingEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"properites are null returning", (Object[])new Object[0]);
            }
            return;
        }
        WebServicesConfigHolder.removeConfig(this.toString());
        String portName = this.getPortName(properties);
        WebServicesConfigHolder.addConfig(this.toString(), portName, this.filterProps(properties));
    }

    @Override
    @Deprecated
    @Deactivate
    protected void deactivate() {
        this.betaFenceCheck();
        if (tc.isDebugEnabled() && TraceComponent.isAnyTracingEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"entering deactivate", (Object[])new Object[0]);
        }
        WebServicesConfigHolder.removeConfig(this.toString());
    }

    @Override
    protected Map<String, Object> filterProps(Map<String, Object> props) {
        HashMap<String, Object> filteredProps = new HashMap<String, Object>();
        for (String key : props.keySet()) {
            if (key == null) continue;
            if (tc.isDebugEnabled() && TraceComponent.isAnyTracingEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("key: " + key + " value: " + props.get(key) + " of type " + props.get(key).getClass()), (Object[])new Object[0]);
            }
            if (propertiesToRemove.contains(key) || key.compareTo("enableSchemaValidation") == 0 && !ConfigValidation.validateEnableSchemaValidation((Boolean)props.get(key)) || key.compareTo("ignoreUnexpectedElements") == 0 && !ConfigValidation.validateIgnoreUnexpectedElements((Boolean)props.get(key)) || key.compareTo("enableDefaultValidation") == 0 && !ConfigValidation.validateEnableDefaultValidation((Boolean)props.get(key))) continue;
            filteredProps.put(key, props.get(key));
        }
        return filteredProps;
    }

    private String getPortName(Map<String, Object> props) {
        if (props == null) {
            return null;
        }
        if (props.keySet().contains("portName")) {
            return props.get("portName").toString();
        }
        return "default";
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        propertiesToRemove.add("portName");
        issuedBetaMessage = false;
    }
}

