/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.webcontainer60.session.impl;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ws.session.SessionContext;
import com.ibm.ws.session.SessionManagerConfig;
import com.ibm.ws.session.utils.LoggingUtil;
import com.ibm.ws.webcontainer.session.impl.SessionAffinityManagerImpl;
import com.ibm.wsspi.session.IStore;
import com.ibm.wsspi.session.SessionAffinityContext;
import com.ibm.wsspi.webcontainer.servlet.IExtendedResponse;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.SessionCookieConfig;
import jakarta.servlet.http.Cookie;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;

public class SessionAffinityManagerImpl60
extends SessionAffinityManagerImpl {
    private static final String methodClassName = "SessionAffinityManagerImpl60";

    public SessionAffinityManagerImpl60(SessionManagerConfig smc, SessionContext sctx, IStore istore) {
        super(smc, sctx, istore);
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, methodClassName, "Clone ID of this server=" + this._cloneID);
        }
    }

    public void setCookie(ServletRequest request, ServletResponse response, SessionAffinityContext affinityContext, Object session) {
        Cookie cookie;
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.entering(methodClassName, "setCookie");
        }
        if ((cookie = super.cookieGenerator(request, response, affinityContext, session)) != null) {
            SessionCookieConfig scc = this._smc.getSessionCookieConfig();
            Map cookieAttrs = scc.getAttributes();
            if (cookieAttrs != null) {
                ArrayList<String> preDefinedAttList = new ArrayList<String>(Arrays.asList("COMMENT", "DOMAIN", "HTTPONLY", "MAX-AGE", "PATH", "SECURE"));
                for (Map.Entry entry : cookieAttrs.entrySet()) {
                    String key = (String)entry.getKey();
                    if (preDefinedAttList.contains(key.toUpperCase(Locale.ENGLISH))) continue;
                    String value = (String)entry.getValue();
                    if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
                        LoggingUtil.SESSION_LOGGER_CORE.logp(Level.FINE, methodClassName, "setCookie", "setAttribute (" + key + "," + value + ")");
                    }
                    cookie.setAttribute(key, value);
                }
            }
            ((IExtendedResponse)response).addSessionCookie(cookie);
        }
        if (TraceComponent.isAnyTracingEnabled() && LoggingUtil.SESSION_LOGGER_CORE.isLoggable(Level.FINE)) {
            LoggingUtil.SESSION_LOGGER_CORE.exiting(methodClassName, "setCookie [" + String.valueOf(cookie) + "]");
        }
    }
}

