/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.utilities.java.support.security.impl;

import jakarta.annotation.Nonnull;
import java.security.SecureRandom;
import java.util.Random;
import net.shibboleth.utilities.java.support.annotation.constraint.NotEmpty;
import net.shibboleth.utilities.java.support.logic.Constraint;
import net.shibboleth.utilities.java.support.security.IdentifierGenerationStrategy;
import org.apache.commons.codec.BinaryEncoder;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.binary.StringUtils;

public class RandomIdentifierGenerationStrategy
implements IdentifierGenerationStrategy {
    private final Random random;
    private final int sizeOfIdentifier;
    private final BinaryEncoder encoder;

    public RandomIdentifierGenerationStrategy() {
        this(16);
    }

    public RandomIdentifierGenerationStrategy(int identifierSize) {
        this.random = new SecureRandom();
        this.sizeOfIdentifier = Constraint.isGreaterThan(0, identifierSize, "Number of bytes in the identifier must be greater than 0");
        this.encoder = new Hex();
    }

    public RandomIdentifierGenerationStrategy(@Nonnull Random source, int identifierSize, @Nonnull BinaryEncoder identifierEncoder) {
        this.random = Constraint.isNotNull(source, "Random number source can not be null");
        this.sizeOfIdentifier = Constraint.isGreaterThan(0, identifierSize, "Number of bytes in the identifier must be greater than 0");
        this.encoder = Constraint.isNotNull(identifierEncoder, "Identifier is encoder can not be null");
    }

    @Override
    @Nonnull
    @NotEmpty
    public String generateIdentifier() {
        return this.generateIdentifier(true);
    }

    @Override
    @Nonnull
    @NotEmpty
    public String generateIdentifier(boolean xmlSafe) {
        byte[] buf = new byte[this.sizeOfIdentifier];
        this.random.nextBytes(buf);
        try {
            if (xmlSafe) {
                return "_" + StringUtils.newStringUsAscii((byte[])this.encoder.encode(buf));
            }
            return StringUtils.newStringUsAscii((byte[])this.encoder.encode(buf));
        }
        catch (EncoderException e) {
            throw new RuntimeException(e);
        }
    }
}

