/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.server.resourcefactory;

import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.spi.HttpResponse;
import org.jboss.resteasy.spi.ResourceFactory;
import org.jboss.resteasy.spi.ResteasyProviderFactory;

public class JndiComponentResourceFactory
implements ResourceFactory {
    private String jndiName;
    private InitialContext ctx;
    private volatile Object reference;
    private Class<?> scannable;
    private boolean cache;

    public JndiComponentResourceFactory(String jndiName, Class<?> scannable, boolean cacheReference) {
        this.jndiName = jndiName;
        this.scannable = scannable;
        this.cache = cacheReference;
        try {
            this.ctx = new InitialContext();
        }
        catch (NamingException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void registered(ResteasyProviderFactory factory) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object createResource(HttpRequest request, HttpResponse response, ResteasyProviderFactory factory) {
        Object ref = this.reference;
        if (ref == null) {
            try {
                ref = this.ctx.lookup(this.jndiName);
            }
            catch (NamingException e) {
                throw new RuntimeException(e);
            }
            if (this.cache) {
                JndiComponentResourceFactory jndiComponentResourceFactory = this;
                synchronized (jndiComponentResourceFactory) {
                    this.reference = ref;
                }
            }
        }
        return ref;
    }

    @Override
    public void unregistered() {
    }

    @Override
    public Class<?> getScannableClass() {
        return this.scannable;
    }

    @Override
    public void requestFinished(HttpRequest request, HttpResponse response, Object resource) {
    }
}

