/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.sso.common.saml.propagation;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.security.WSSecurityException;
import com.ibm.websphere.security.auth.WSSubject;
import com.ibm.websphere.security.saml2.Saml20Token;
import com.ibm.ws.common.encoder.Base64Coder;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.sso.common.saml.propagation.SamlCommonUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.zip.GZIPOutputStream;
import javax.security.auth.Subject;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class PropagationHelperImpl {
    protected static final TraceComponent tc = Tr.register(PropagationHelperImpl.class, (String)"SAML_PROPAGATION", (String)"com.ibm.ws.security.sso.common.internal.resources.SAMLPropagationMessages");
    static final long serialVersionUID = 8052339425626931531L;

    public static String getSAMLAsString() {
        Saml20Token token = PropagationHelperImpl.getSaml20Token();
        String samlString = null;
        if (token != null) {
            samlString = token.getSAMLAsString();
        }
        return samlString;
    }

    public static Saml20Token getSaml20Token() {
        Saml20Token token = PropagationHelperImpl.getSaml20TokenFromSubject();
        return token;
    }

    public static String getEncodedSaml20Token(boolean isCompressed) {
        String base64Saml = null;
        String samlString = PropagationHelperImpl.getSAMLAsString();
        if (samlString != null) {
            if (isCompressed) {
                byte[] compressedTokenBytes = PropagationHelperImpl.compressSamlToken(samlString);
                base64Saml = Base64Coder.base64EncodeToString((byte[])compressedTokenBytes);
            } else {
                byte[] output = samlString.getBytes(StandardCharsets.UTF_8);
                if (output != null) {
                    base64Saml = Base64Coder.base64EncodeToString((byte[])output);
                } else if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Error while trying to get token bytes using utf-8:", (Object[])new Object[0]);
                }
            }
        }
        return base64Saml;
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] compressSamlToken(String tokenString) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            GZIPOutputStream gzip = new GZIPOutputStream(out);
            byte[] output = null;
            if (tokenString != null) {
                output = tokenString.getBytes(StandardCharsets.UTF_8);
            }
            if (output != null) {
                gzip.write(output);
            } else if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Error while trying to get token bytes using utf-8:", (Object[])new Object[0]);
            }
            gzip.close();
        }
        catch (IOException output) {
            void e;
            FFDCFilter.processException((Throwable)output, (String)"com.ibm.ws.security.sso.common.saml.propagation.PropagationHelperImpl", (String)"94", null, (Object[])new Object[]{tokenString});
            Tr.warning((TraceComponent)tc, (String)"failed_to_extract_saml_token_from_subject", (Object[])new Object[]{e.getLocalizedMessage()});
        }
        return out.toByteArray();
    }

    /*
     * WARNING - void declaration
     */
    private static Saml20Token getSaml20TokenFromSubject() {
        Saml20Token samlToken = null;
        try {
            Subject subject = WSSubject.getRunAsSubject();
            samlToken = SamlCommonUtil.getSaml20TokenFromSubject(subject, false);
        }
        catch (WSSecurityException subject) {
            void e;
            FFDCFilter.processException((Throwable)subject, (String)"com.ibm.ws.security.sso.common.saml.propagation.PropagationHelperImpl", (String)"111", null, (Object[])new Object[0]);
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Exception while getting SAML token from subject:", (Object[])new Object[]{e.getCause()});
            }
            Tr.warning((TraceComponent)tc, (String)"failed_to_extract_saml_token_from_subject", (Object[])new Object[]{e.getLocalizedMessage()});
        }
        return samlToken;
    }
}

