/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.exporter.sender.okhttp.internal;

import io.opentelemetry.api.internal.InstrumentationUtil;
import io.opentelemetry.exporter.internal.RetryUtil;
import io.opentelemetry.exporter.internal.compression.Compressor;
import io.opentelemetry.exporter.internal.http.HttpSender;
import io.opentelemetry.exporter.internal.marshal.Marshaler;
import io.opentelemetry.exporter.sender.okhttp.internal.OkHttpUtil;
import io.opentelemetry.exporter.sender.okhttp.internal.RetryInterceptor;
import io.opentelemetry.sdk.common.CompletableResultCode;
import io.opentelemetry.sdk.common.export.ProxyOptions;
import io.opentelemetry.sdk.common.export.RetryPolicy;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.net.ssl.SSLContext;
import javax.net.ssl.X509TrustManager;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.ConnectionSpec;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import okio.BufferedSink;
import okio.Okio;
import okio.Sink;

public final class OkHttpHttpSender
implements HttpSender {
    private final OkHttpClient client;
    private final HttpUrl url;
    @Nullable
    private final Compressor compressor;
    private final boolean exportAsJson;
    private final Supplier<Map<String, List<String>>> headerSupplier;
    private final MediaType mediaType;

    public OkHttpHttpSender(String endpoint, @Nullable Compressor compressor, boolean exportAsJson, String contentType, long timeoutNanos, long connectionTimeoutNanos, Supplier<Map<String, List<String>>> headerSupplier, @Nullable ProxyOptions proxyOptions, @Nullable RetryPolicy retryPolicy, @Nullable SSLContext sslContext, @Nullable X509TrustManager trustManager) {
        boolean isPlainHttp;
        int callTimeoutMillis = (int)Math.min(Duration.ofNanos(timeoutNanos).toMillis(), Integer.MAX_VALUE);
        int connectTimeoutMillis = (int)Math.min(Duration.ofNanos(connectionTimeoutNanos).toMillis(), Integer.MAX_VALUE);
        OkHttpClient.Builder builder = new OkHttpClient.Builder().dispatcher(OkHttpUtil.newDispatcher()).connectTimeout(Duration.ofMillis(connectTimeoutMillis)).callTimeout(Duration.ofMillis(callTimeoutMillis));
        if (proxyOptions != null) {
            builder.proxySelector(proxyOptions.getProxySelector());
        }
        if (retryPolicy != null) {
            builder.addInterceptor((Interceptor)new RetryInterceptor(retryPolicy, OkHttpHttpSender::isRetryable));
        }
        if (isPlainHttp = endpoint.startsWith("http://")) {
            builder.connectionSpecs(Collections.singletonList(ConnectionSpec.CLEARTEXT));
        } else if (sslContext != null && trustManager != null) {
            builder.sslSocketFactory(sslContext.getSocketFactory(), trustManager);
        }
        this.client = builder.build();
        this.url = HttpUrl.get((String)endpoint);
        this.compressor = compressor;
        this.exportAsJson = exportAsJson;
        this.mediaType = MediaType.parse((String)contentType);
        this.headerSupplier = headerSupplier;
    }

    @Override
    public void send(Marshaler marshaler, int contentLength, final Consumer<HttpSender.Response> onResponse, final Consumer<Throwable> onError) {
        Request.Builder requestBuilder = new Request.Builder().url(this.url);
        Map<String, List<String>> headers = this.headerSupplier.get();
        if (headers != null) {
            headers.forEach((key, values) -> values.forEach(value -> requestBuilder.addHeader(key, value)));
        }
        RawRequestBody body = new RawRequestBody(marshaler, this.exportAsJson, contentLength, this.mediaType);
        if (this.compressor != null) {
            requestBuilder.addHeader("Content-Encoding", this.compressor.getEncoding());
            requestBuilder.post((RequestBody)new CompressedRequestBody(this.compressor, body));
        } else {
            requestBuilder.post((RequestBody)body);
        }
        InstrumentationUtil.suppressInstrumentation(() -> this.client.newCall(requestBuilder.build()).enqueue(new Callback(){

            public void onFailure(Call call, IOException e) {
                onError.accept(e);
            }

            public void onResponse(Call call, final Response response) {
                try (final ResponseBody body = response.body();){
                    onResponse.accept(new HttpSender.Response(){
                        @Nullable
                        private byte[] bodyBytes;

                        @Override
                        public int statusCode() {
                            return response.code();
                        }

                        @Override
                        public String statusMessage() {
                            return response.message();
                        }

                        @Override
                        public byte[] responseBody() throws IOException {
                            if (this.bodyBytes == null) {
                                this.bodyBytes = body.bytes();
                            }
                            return this.bodyBytes;
                        }
                    });
                }
            }
        }));
    }

    @Override
    public CompletableResultCode shutdown() {
        this.client.dispatcher().cancelAll();
        this.client.dispatcher().executorService().shutdownNow();
        this.client.connectionPool().evictAll();
        return CompletableResultCode.ofSuccess();
    }

    static boolean isRetryable(Response response) {
        return RetryUtil.retryableHttpResponseCodes().contains(response.code());
    }

    private static class RawRequestBody
    extends RequestBody {
        private final Marshaler marshaler;
        private final boolean exportAsJson;
        private final int contentLength;
        private final MediaType mediaType;

        private RawRequestBody(Marshaler marshaler, boolean exportAsJson, int contentLength, MediaType mediaType) {
            this.marshaler = marshaler;
            this.exportAsJson = exportAsJson;
            this.contentLength = contentLength;
            this.mediaType = mediaType;
        }

        public long contentLength() {
            return this.contentLength;
        }

        public MediaType contentType() {
            return this.mediaType;
        }

        public void writeTo(BufferedSink bufferedSink) throws IOException {
            if (this.exportAsJson) {
                this.marshaler.writeJsonTo(bufferedSink.outputStream());
            } else {
                this.marshaler.writeBinaryTo(bufferedSink.outputStream());
            }
        }
    }

    private static class CompressedRequestBody
    extends RequestBody {
        private final Compressor compressor;
        private final RequestBody requestBody;

        private CompressedRequestBody(Compressor compressor, RequestBody requestBody) {
            this.compressor = compressor;
            this.requestBody = requestBody;
        }

        public MediaType contentType() {
            return this.requestBody.contentType();
        }

        public long contentLength() {
            return -1L;
        }

        public void writeTo(BufferedSink bufferedSink) throws IOException {
            BufferedSink compressedSink = Okio.buffer((Sink)Okio.sink((OutputStream)this.compressor.compress(bufferedSink.outputStream())));
            this.requestBody.writeTo(compressedSink);
            compressedSink.close();
        }
    }
}

