/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.microprofile.openapi20.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.openapi20.internal.merge.ModelEquality;
import io.openliberty.microprofile.openapi20.internal.services.OpenAPIInfoConfig;
import io.openliberty.microprofile.openapi20.internal.services.OpenAPIModelOperations;
import io.smallrye.openapi.runtime.OpenApiRuntimeException;
import java.io.IOException;
import java.util.Dictionary;
import java.util.Map;
import java.util.Optional;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.models.info.Contact;
import org.eclipse.microprofile.openapi.models.info.Info;
import org.eclipse.microprofile.openapi.models.info.License;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Modified;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class OpenAPIInfoConfigImpl
implements OpenAPIInfoConfig {
    private static final TraceComponent tc = Tr.register(OpenAPIInfoConfigImpl.class, (String)"MPOPENAPI", (String)"io.openliberty.microprofile.openapi.internal.resources.OpenAPI");
    protected static final String INFO_KEY = "info";
    protected static final String TITLE_KEY = "title";
    protected static final String DESCRIPTION_KEY = "description";
    protected static final String TERMS_OF_SERVICE_KEY = "termsOfService";
    protected static final String CONTACT_NAME_KEY = "contactName";
    protected static final String CONTACT_URL_KEY = "contactUrl";
    protected static final String CONTACT_EMAIL_KEY = "contactEmail";
    protected static final String LICENSE_NAME_KEY = "licenseName";
    protected static final String LICENSE_URL_KEY = "licenseUrl";
    protected static final String LICENSE_IDENTIFIER_KEY = "licenseIdentifier";
    protected static final String SUMMARY_KEY = "summary";
    protected static final String VERSION_KEY = "version";
    private volatile Optional<Info> info;
    private Optional<Info> lastMpConfigInfo;
    private Optional<String> lastMpConfigString;
    @Reference
    protected ConfigurationAdmin configAdmin;
    @Reference
    protected OpenAPIModelOperations modelOps;
    static final long serialVersionUID = 1621412434085720895L;

    @Activate
    @Modified
    protected void activate(Map<?, ?> properties) {
        Configuration infoConfig;
        String infoPid = (String)properties.get(INFO_KEY);
        if (infoPid == null) {
            this.info = Optional.empty();
            return;
        }
        try {
            infoConfig = this.configAdmin.getConfiguration(infoPid, null);
        }
        catch (IOException iOException) {
            FFDCFilter.processException((Throwable)iOException, (String)"io.openliberty.microprofile.openapi20.internal.OpenAPIInfoConfigImpl", (String)"86", (Object)this, (Object[])new Object[]{properties});
            this.info = Optional.empty();
            return;
        }
        Dictionary infoProperties = infoConfig.getProperties();
        if (infoProperties == null) {
            this.info = Optional.empty();
            return;
        }
        Optional<Info> newInfo = this.parseInfoProperties(infoProperties);
        if (!OpenAPIInfoConfigImpl.equals(this.info, newInfo)) {
            this.info = newInfo;
            this.info.ifPresent(info -> this.warnIfMpConfigIgnored((Info)info, ConfigProvider.getConfig()));
        }
    }

    protected Optional<Info> parseInfoProperties(Dictionary<String, Object> infoProperties) {
        String title = (String)infoProperties.get(TITLE_KEY);
        String version = (String)infoProperties.get(VERSION_KEY);
        if (title == null || title.trim().isEmpty() || version == null || version.trim().isEmpty()) {
            Tr.warning((TraceComponent)tc, (String)"OPENAPI_INFO_INVALID_SERVERXML_CWWKO1683W", (Object[])new Object[0]);
            return Optional.empty();
        }
        Info info = OASFactory.createInfo();
        info.setTitle(title);
        info.setVersion(version);
        info.setDescription((String)infoProperties.get(DESCRIPTION_KEY));
        info.setTermsOfService((String)infoProperties.get(TERMS_OF_SERVICE_KEY));
        String contactName = (String)infoProperties.get(CONTACT_NAME_KEY);
        String contactUrl = (String)infoProperties.get(CONTACT_URL_KEY);
        String contactEmail = (String)infoProperties.get(CONTACT_EMAIL_KEY);
        if (contactName != null || contactUrl != null || contactEmail != null) {
            Contact contact = OASFactory.createContact();
            contact.setName(contactName);
            contact.setEmail(contactEmail);
            contact.setUrl(contactUrl);
            info.setContact(contact);
        }
        String licenseName = (String)infoProperties.get(LICENSE_NAME_KEY);
        String licenseUrl = (String)infoProperties.get(LICENSE_URL_KEY);
        if (licenseName != null || licenseUrl != null) {
            License license = OASFactory.createLicense();
            license.setName(licenseName);
            license.setUrl(licenseUrl);
            info.setLicense(license);
        }
        return Optional.of(info);
    }

    private static boolean equals(Optional<Info> a, Optional<Info> b) {
        if (a == null) {
            return b == null;
        }
        if (b == null) {
            return false;
        }
        if (!a.isPresent()) {
            return !b.isPresent();
        }
        if (!b.isPresent()) {
            return false;
        }
        return ModelEquality.equals(a.get(), b.get());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Info> readMpConfig(Config mpConfig) {
        Optional mpConfigString = mpConfig.getOptionalValue("mp.openapi.extensions.liberty.merged.info", String.class);
        OpenAPIInfoConfigImpl openAPIInfoConfigImpl = this;
        synchronized (openAPIInfoConfigImpl) {
            if (!mpConfigString.equals(this.lastMpConfigString)) {
                this.lastMpConfigString = mpConfigString;
                this.lastMpConfigInfo = mpConfigString.flatMap(string -> this.readJsonString((String)string, WarningMode.LOG_WARNINGS));
            }
            return this.lastMpConfigInfo;
        }
    }

    @FFDCIgnore(value={OpenApiRuntimeException.class})
    private Optional<Info> readJsonString(String infoJson, WarningMode warningMode) {
        try {
            Info info = this.modelOps.parseInfo(infoJson);
            if (info.getTitle() != null && info.getVersion() != null) {
                return Optional.of(info);
            }
            if (warningMode == WarningMode.LOG_WARNINGS) {
                Tr.warning((TraceComponent)tc, (String)"OPENAPI_MERGE_INFO_INVALID_CWWKO1664W", (Object[])new Object[]{"mp.openapi.extensions.liberty.merged.info", infoJson});
            }
            return Optional.empty();
        }
        catch (OpenApiRuntimeException ex) {
            if (warningMode == WarningMode.LOG_WARNINGS) {
                Tr.warning((TraceComponent)tc, (String)"OPENAPI_MERGE_INFO_PARSE_ERROR_CWWKO1665W", (Object[])new Object[]{"mp.openapi.extensions.liberty.merged.info", infoJson, ex.toString()});
            }
            return Optional.empty();
        }
    }

    private void warnIfMpConfigIgnored(Info infoFromServerXml, Config mpConfig) {
        mpConfig.getOptionalValue("mp.openapi.extensions.liberty.merged.info", String.class).ifPresent(json -> {
            Optional<Info> mpConfigInfo = this.readJsonString((String)json, WarningMode.SUPPRESS_WARNINGS);
            if (mpConfigInfo.isPresent() && ModelEquality.equals(infoFromServerXml, mpConfigInfo.get())) {
                Tr.info((TraceComponent)tc, (String)"OPENAPI_MP_CONFIG_REDUNDANT_CWWKO1685I", (Object[])new Object[]{"mp.openapi.extensions.liberty.merged.info"});
            } else {
                Tr.warning((TraceComponent)tc, (String)"OPENAPI_MP_CONFIG_CONFLICTS_CWWKO1686W", (Object[])new Object[]{"mp.openapi.extensions.liberty.merged.info"});
            }
        });
    }

    @Override
    public Optional<Info> getInfo() {
        Optional<Info> serverXmlInfo = this.info;
        if (serverXmlInfo.isPresent()) {
            return serverXmlInfo;
        }
        return this.readMpConfig(ConfigProvider.getConfig());
    }

    private static enum WarningMode {
        LOG_WARNINGS,
        SUPPRESS_WARNINGS;

    }
}

