/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.openapi.model;

import io.smallrye.openapi.model.BaseModel;
import io.smallrye.openapi.model.ModelLogging;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.eclipse.microprofile.openapi.OASFactory;
import org.eclipse.microprofile.openapi.OASFilter;
import org.eclipse.microprofile.openapi.models.Constructible;
import org.eclipse.microprofile.openapi.models.media.Schema;
import org.eclipse.microprofile.openapi.models.parameters.Parameter;
import org.eclipse.microprofile.openapi.models.security.SecurityRequirement;
import org.eclipse.microprofile.openapi.models.servers.Server;
import org.eclipse.microprofile.openapi.models.tags.Tag;

class BaseModelSupport {
    private BaseModelSupport() {
    }

    static int hash(Map<Object, Object> stack, BaseModel<?> model) {
        int result = 0;
        if (!stack.containsKey(model)) {
            stack.put(model, model);
            for (Map.Entry<String, Object> e : model.getProperties().entrySet()) {
                result = 31 * result + BaseModelSupport.hash(stack, e);
            }
            stack.remove(model);
        }
        return result;
    }

    private static int hash(Map<Object, Object> stack, Map.Entry<String, Object> entry) {
        int result = entry.getKey().hashCode();
        result = 31 * result + BaseModelSupport.hash(stack, entry.getValue());
        return result;
    }

    private static int hash(Map<Object, Object> stack, Object value) {
        int result = 0;
        if (value instanceof BaseModel) {
            result = BaseModelSupport.hash(stack, (BaseModel)value);
        } else if (value instanceof Map) {
            Map map = (Map)value;
            for (Map.Entry<String, Object> entry : map.entrySet()) {
                result = 31 * result + BaseModelSupport.hash(stack, entry);
            }
        } else if (value instanceof List) {
            List list = (List)value;
            for (Object e : list) {
                result = 31 * result + BaseModelSupport.hash(stack, e);
            }
        } else {
            result = Objects.hash(value);
        }
        return result;
    }

    static int filter(OASFilter filter, Map<Object, Object> stack, Map<String, Object> map) {
        Iterator<Map.Entry<String, Object>> cursor = map.entrySet().iterator();
        int modCount = 0;
        while (cursor.hasNext()) {
            Map.Entry<String, Object> entry = cursor.next();
            Object value = entry.getValue();
            if (stack.containsKey(value)) {
                ModelLogging.logger.cylicReferenceDetected();
                continue;
            }
            if (value instanceof BaseModel) {
                stack.put(value, value);
                Object replacement = ((BaseModel)value).filter(filter, stack);
                if (replacement == null) {
                    cursor.remove();
                    ++modCount;
                } else if (replacement != value) {
                    entry.setValue(replacement);
                    ++modCount;
                }
                stack.remove(value);
                continue;
            }
            if (value instanceof List) {
                List listValue = (List)value;
                modCount += BaseModelSupport.filter(filter, stack, listValue);
                continue;
            }
            if (!(value instanceof Map)) continue;
            Map mapValue = (Map)value;
            modCount += BaseModelSupport.filter(filter, stack, mapValue);
        }
        return modCount;
    }

    private static int filter(OASFilter filter, Map<Object, Object> stack, List<Object> list) {
        ListIterator<Object> cursor = list.listIterator();
        int modCount = 0;
        while (cursor.hasNext()) {
            Object value = cursor.next();
            if (stack.containsKey(value)) {
                ModelLogging.logger.cylicReferenceDetected();
                continue;
            }
            if (!(value instanceof BaseModel)) continue;
            stack.put(value, value);
            Object replacement = ((BaseModel)value).filter(filter, stack);
            if (replacement == null) {
                cursor.remove();
                ++modCount;
            } else if (replacement != value) {
                cursor.set(replacement);
                ++modCount;
            }
            stack.remove(value);
        }
        return modCount;
    }

    static <O extends Constructible> O deepCopy(O other, Class<O> type, boolean unmodifiable) {
        BaseModel result = (BaseModel)OASFactory.createObject(type);
        if (other instanceof BaseModel) {
            BaseModel otherImpl = (BaseModel)other;
            result.getProperties().putAll(BaseModelSupport.deepCopy(otherImpl.getProperties(), unmodifiable));
            if (unmodifiable) {
                result.setUnmodifiable();
            }
        } else if (other != null) {
            throw new UnsupportedOperationException("Only BaseModel types may be copied: " + String.valueOf(other.getClass()));
        }
        return (O)((Constructible)result);
    }

    private static <K, V> Map<K, V> deepCopy(Map<K, V> map, boolean unmodifiable) {
        LinkedHashMap<K, V> clone = new LinkedHashMap<K, V>(map.size());
        for (Map.Entry<K, V> entry : map.entrySet()) {
            clone.put(entry.getKey(), BaseModelSupport.deepCopy(entry.getValue(), unmodifiable));
        }
        return unmodifiable ? Collections.unmodifiableMap(clone) : clone;
    }

    private static <T> List<T> deepCopy(List<T> list, boolean unmodifiable) {
        ArrayList<T> clone = new ArrayList<T>(list.size());
        for (T value : list) {
            clone.add(BaseModelSupport.deepCopy(value, unmodifiable));
        }
        return unmodifiable ? Collections.unmodifiableList(clone) : clone;
    }

    private static <T, N extends Constructible> T deepCopy(T value, boolean unmodifiable) {
        if (value instanceof Map) {
            return (T)BaseModelSupport.deepCopy((Map)value, unmodifiable);
        }
        if (value instanceof List) {
            return (T)BaseModelSupport.deepCopy((List)value, unmodifiable);
        }
        if (value instanceof BaseModel) {
            Constructible nested = (Constructible)value;
            Class nestedType = nested.getClass();
            return (T)BaseModelSupport.deepCopy(nested, BaseModelSupport.findConstructible(nestedType), unmodifiable);
        }
        if (value instanceof Constructible) {
            return value;
        }
        return value;
    }

    private static <C extends Constructible> Class<C> findConstructible(Class<?> type) {
        for (Class<?> i : type.getInterfaces()) {
            if (Constructible.class.equals(i)) {
                return type;
            }
            Class<C> result = BaseModelSupport.findConstructible(i);
            if (result == null) continue;
            return result;
        }
        Class<?> parent = type.getSuperclass();
        if (parent == null && type.isInterface()) {
            return null;
        }
        if (parent == null || Object.class.equals(parent)) {
            throw new IllegalStateException("Failed to find direct Constructible interface: " + String.valueOf(type));
        }
        return BaseModelSupport.findConstructible(parent);
    }

    public static <C extends Constructible, T> T mergeObjects(T object1, T object2) {
        if (object1 == object2) {
            return object1;
        }
        if (object1 == null) {
            return object2;
        }
        if (object2 == null) {
            return object1;
        }
        if (!object1.getClass().equals(object2.getClass())) {
            return object2;
        }
        if (object1 instanceof BaseModel) {
            BaseModel model1 = (BaseModel)object1;
            BaseModel model2 = (BaseModel)object2;
            model1.merge(model2);
            return object1;
        }
        if (object1 instanceof List) {
            List result = BaseModelSupport.mergeLists((List)object1, (List)object2);
            return (T)result;
        }
        if (object1 instanceof Map) {
            Map result = BaseModelSupport.mergeMaps((Map)object1, (Map)object2);
            return (T)result;
        }
        return object1;
    }

    private static Map mergeMaps(Map values1, Map values2) {
        if (values1 == values2) {
            return values1;
        }
        if (values1 == null) {
            return values2;
        }
        if (values2 == null) {
            return values1;
        }
        LinkedHashMap result = new LinkedHashMap(values1);
        Set entrySet = values2.entrySet();
        for (Map.Entry entry : entrySet) {
            Object pval1;
            Object key = entry.getKey();
            Object pval2 = entry.getValue();
            Object value = result.containsKey(key) ? ((pval1 = result.get(key)) instanceof Map ? BaseModelSupport.mergeMaps((Map)pval1, (Map)pval2) : (pval1 instanceof List ? BaseModelSupport.mergeLists((List)pval1, (List)pval2) : (pval1 instanceof Constructible ? BaseModelSupport.mergeObjects(pval1, pval2) : pval2))) : pval2;
            result.put(key, value);
        }
        return result;
    }

    private static List mergeLists(List values1, List values2) {
        if (Objects.equals(values1, values2)) {
            return values1;
        }
        if (values2 == null) {
            return values1;
        }
        if (values1 == null || values1.isEmpty()) {
            return values2;
        }
        Object firstEntry = values1.get(0);
        if (Set.of(String.class, Schema.SchemaType.class).contains(firstEntry.getClass())) {
            return BaseModelSupport.mergeListsWithUnique(values1, values2);
        }
        if (firstEntry instanceof Tag) {
            return BaseModelSupport.mergeTagLists(values1, values2);
        }
        if (firstEntry instanceof Server) {
            return BaseModelSupport.mergeServerLists(values1, values2);
        }
        if (firstEntry instanceof SecurityRequirement) {
            return BaseModelSupport.mergeSecurityRequirementLists(values1, values2);
        }
        if (firstEntry instanceof Parameter) {
            return BaseModelSupport.mergeParameterLists(values1, values2);
        }
        ArrayList merged = new ArrayList(values1.size() + values2.size());
        merged.addAll(values1);
        merged.addAll(values2);
        return merged;
    }

    private static <T> List<T> mergeListsWithUnique(List<T> values1, List<T> values2) {
        LinkedHashSet<T> set = new LinkedHashSet<T>();
        set.addAll(values1);
        set.addAll(values2);
        return new ArrayList(set);
    }

    private static List<Tag> mergeTagLists(List<Tag> values1, List<Tag> values2) {
        values1 = new ArrayList<Tag>(values1);
        for (Tag value2 : values2) {
            Tag match = null;
            for (Tag value1 : values1) {
                if (value1.getName() == null || !value1.getName().equals(value2.getName())) continue;
                match = value1;
                break;
            }
            if (match == null) {
                values1.add(value2);
                continue;
            }
            BaseModelSupport.mergeObjects(match, value2);
        }
        return values1;
    }

    private static List<Server> mergeServerLists(List<Server> values1, List<Server> values2) {
        values1 = new ArrayList<Server>(values1);
        for (Server value2 : values2) {
            Server match = null;
            for (Server value1 : values1) {
                if (value1.getUrl() == null || !value1.getUrl().equals(value2.getUrl())) continue;
                match = value1;
                break;
            }
            if (match == null) {
                values1.add(value2);
                continue;
            }
            BaseModelSupport.mergeObjects(match, value2);
        }
        return values1;
    }

    private static List<SecurityRequirement> mergeSecurityRequirementLists(List<SecurityRequirement> values1, List<SecurityRequirement> values2) {
        values1 = new ArrayList<SecurityRequirement>(values1);
        for (SecurityRequirement value2 : values2) {
            if (values1.contains(value2)) continue;
            values1.add(value2);
        }
        return values1;
    }

    private static List<Parameter> mergeParameterLists(List<Parameter> values1, List<Parameter> values2) {
        ArrayList<Parameter> mutableValues = new ArrayList<Parameter>(values1);
        values2.stream().filter(v -> Objects.nonNull(v.getName())).filter(v -> Objects.nonNull(v.getIn())).forEach(value2 -> {
            Optional<Parameter> match = mutableValues.stream().filter(value1 -> Objects.equals(value1.getName(), value2.getName())).filter(value1 -> Objects.equals(value1.getIn(), value2.getIn())).findFirst();
            if (match.isPresent()) {
                BaseModelSupport.mergeObjects(match.get(), value2);
            } else {
                mutableValues.add((Parameter)value2);
            }
        });
        return mutableValues;
    }
}

