/*
 * Decompiled with CFR 0.152.
 */
package graphql.introspection;

import graphql.PublicApi;
import graphql.com.google.common.collect.ImmutableList;
import graphql.language.Argument;
import graphql.language.AstPrinter;
import graphql.language.BooleanValue;
import graphql.language.Document;
import graphql.language.Field;
import graphql.language.FragmentDefinition;
import graphql.language.FragmentSpread;
import graphql.language.OperationDefinition;
import graphql.language.SelectionSet;
import graphql.language.TypeName;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

@PublicApi
public class IntrospectionQueryBuilder {
    @SafeVarargs
    private static <T> List<T> filter(T ... args) {
        return Arrays.stream(args).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public static Document buildDocument(Options options) {
        SelectionSet schemaSelectionSet = SelectionSet.newSelectionSet().selections(IntrospectionQueryBuilder.filter(options.schemaDescription ? Field.newField("description").build() : null, Field.newField("queryType", SelectionSet.newSelectionSet().selection(Field.newField("name").build()).build()).build(), Field.newField("mutationType", SelectionSet.newSelectionSet().selection(Field.newField("name").build()).build()).build(), Field.newField("subscriptionType", SelectionSet.newSelectionSet().selection(Field.newField("name").build()).build()).build(), Field.newField("types", SelectionSet.newSelectionSet().selection(FragmentSpread.newFragmentSpread("FullType").build()).build()).build(), Field.newField("directives", SelectionSet.newSelectionSet().selections(IntrospectionQueryBuilder.filter(Field.newField("name").build(), options.descriptions ? Field.newField("description").build() : null, Field.newField("locations").build(), Field.newField("args").arguments(IntrospectionQueryBuilder.filter(options.inputValueDeprecation ? Argument.newArgument("includeDeprecated", BooleanValue.of(true)).build() : null)).selectionSet(SelectionSet.newSelectionSet().selection(FragmentSpread.newFragmentSpread("InputValue").build()).build()).build(), options.directiveIsRepeatable ? Field.newField("isRepeatable").build() : null)).build()).build())).build();
        SelectionSet fullTypeSelectionSet = SelectionSet.newSelectionSet().selections(IntrospectionQueryBuilder.filter(Field.newField("kind").build(), Field.newField("name").build(), options.descriptions ? Field.newField("description").build() : null, options.specifiedByUrl ? Field.newField("specifiedByURL").build() : null, Field.newField("fields").arguments(ImmutableList.of(Argument.newArgument("includeDeprecated", BooleanValue.of(true)).build())).selectionSet(SelectionSet.newSelectionSet().selections(IntrospectionQueryBuilder.filter(Field.newField("name").build(), options.descriptions ? Field.newField("description").build() : null, Field.newField("args").arguments(IntrospectionQueryBuilder.filter(options.inputValueDeprecation ? Argument.newArgument("includeDeprecated", BooleanValue.of(true)).build() : null)).selectionSet(SelectionSet.newSelectionSet().selection(FragmentSpread.newFragmentSpread("InputValue").build()).build()).build(), Field.newField("type", SelectionSet.newSelectionSet().selection(FragmentSpread.newFragmentSpread("TypeRef").build()).build()).build(), Field.newField("isDeprecated").build(), Field.newField("deprecationReason").build())).build()).build(), Field.newField("inputFields").arguments(IntrospectionQueryBuilder.filter(options.inputValueDeprecation ? Argument.newArgument("includeDeprecated", BooleanValue.of(true)).build() : null)).selectionSet(SelectionSet.newSelectionSet().selection(FragmentSpread.newFragmentSpread("InputValue").build()).build()).build(), Field.newField("interfaces", SelectionSet.newSelectionSet().selection(FragmentSpread.newFragmentSpread("TypeRef").build()).build()).build(), Field.newField("enumValues").arguments(ImmutableList.of(Argument.newArgument("includeDeprecated", BooleanValue.of(true)).build())).selectionSet(SelectionSet.newSelectionSet().selections(IntrospectionQueryBuilder.filter(Field.newField("name").build(), options.descriptions ? Field.newField("description").build() : null, Field.newField("isDeprecated").build(), Field.newField("deprecationReason").build())).build()).build(), Field.newField("possibleTypes", SelectionSet.newSelectionSet().selection(FragmentSpread.newFragmentSpread("TypeRef").build()).build()).build())).build();
        SelectionSet inputValueSelectionSet = SelectionSet.newSelectionSet().selections(IntrospectionQueryBuilder.filter(Field.newField("name").build(), options.descriptions ? Field.newField("description").build() : null, Field.newField("type", SelectionSet.newSelectionSet().selection(FragmentSpread.newFragmentSpread("TypeRef").build()).build()).build(), Field.newField("defaultValue").build(), options.inputValueDeprecation ? Field.newField("isDeprecated").build() : null, options.inputValueDeprecation ? Field.newField("deprecationReason").build() : null)).build();
        SelectionSet typeRefSelectionSet = SelectionSet.newSelectionSet().selections(IntrospectionQueryBuilder.filter(Field.newField("kind").build(), Field.newField("name").build())).build();
        for (int i = options.typeRefFragmentDepth; i > 0; --i) {
            typeRefSelectionSet = SelectionSet.newSelectionSet().selections(IntrospectionQueryBuilder.filter(Field.newField("kind").build(), Field.newField("name").build(), Field.newField("ofType", typeRefSelectionSet).build())).build();
        }
        return Document.newDocument().definition(OperationDefinition.newOperationDefinition().operation(OperationDefinition.Operation.QUERY).name("IntrospectionQuery").selectionSet(SelectionSet.newSelectionSet().selection(Field.newField("__schema", schemaSelectionSet).build()).build()).build()).definition(FragmentDefinition.newFragmentDefinition().name("FullType").typeCondition(TypeName.newTypeName().name("__Type").build()).selectionSet(fullTypeSelectionSet).build()).definition(FragmentDefinition.newFragmentDefinition().name("InputValue").typeCondition(TypeName.newTypeName().name("__InputValue").build()).selectionSet(inputValueSelectionSet).build()).definition(FragmentDefinition.newFragmentDefinition().name("TypeRef").typeCondition(TypeName.newTypeName().name("__Type").build()).selectionSet(typeRefSelectionSet).build()).build();
    }

    public static String build(Options options) {
        return AstPrinter.printAst(IntrospectionQueryBuilder.buildDocument(options));
    }

    public static String build() {
        return IntrospectionQueryBuilder.build(Options.defaultOptions());
    }

    public static class Options {
        private final boolean descriptions;
        private final boolean specifiedByUrl;
        private final boolean directiveIsRepeatable;
        private final boolean schemaDescription;
        private final boolean inputValueDeprecation;
        private final int typeRefFragmentDepth;

        private Options(boolean descriptions, boolean specifiedByUrl, boolean directiveIsRepeatable, boolean schemaDescription, boolean inputValueDeprecation, int typeRefFragmentDepth) {
            this.descriptions = descriptions;
            this.specifiedByUrl = specifiedByUrl;
            this.directiveIsRepeatable = directiveIsRepeatable;
            this.schemaDescription = schemaDescription;
            this.inputValueDeprecation = inputValueDeprecation;
            this.typeRefFragmentDepth = typeRefFragmentDepth;
        }

        public boolean isDescriptions() {
            return this.descriptions;
        }

        public boolean isSpecifiedByUrl() {
            return this.specifiedByUrl;
        }

        public boolean isDirectiveIsRepeatable() {
            return this.directiveIsRepeatable;
        }

        public boolean isSchemaDescription() {
            return this.schemaDescription;
        }

        public boolean isInputValueDeprecation() {
            return this.inputValueDeprecation;
        }

        public int getTypeRefFragmentDepth() {
            return this.typeRefFragmentDepth;
        }

        public static Options defaultOptions() {
            return new Options(true, false, true, false, true, 7);
        }

        public Options descriptions(boolean flag) {
            return new Options(flag, this.specifiedByUrl, this.directiveIsRepeatable, this.schemaDescription, this.inputValueDeprecation, this.typeRefFragmentDepth);
        }

        public Options specifiedByUrl(boolean flag) {
            return new Options(this.descriptions, flag, this.directiveIsRepeatable, this.schemaDescription, this.inputValueDeprecation, this.typeRefFragmentDepth);
        }

        public Options directiveIsRepeatable(boolean flag) {
            return new Options(this.descriptions, this.specifiedByUrl, flag, this.schemaDescription, this.inputValueDeprecation, this.typeRefFragmentDepth);
        }

        public Options schemaDescription(boolean flag) {
            return new Options(this.descriptions, this.specifiedByUrl, this.directiveIsRepeatable, flag, this.inputValueDeprecation, this.typeRefFragmentDepth);
        }

        public Options inputValueDeprecation(boolean flag) {
            return new Options(this.descriptions, this.specifiedByUrl, this.directiveIsRepeatable, this.schemaDescription, flag, this.typeRefFragmentDepth);
        }

        public Options typeRefFragmentDepth(int typeRefFragmentDepth) {
            return new Options(this.descriptions, this.specifiedByUrl, this.directiveIsRepeatable, this.schemaDescription, this.inputValueDeprecation, typeRefFragmentDepth);
        }
    }
}

