/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sib.api.jms.impl;

import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.sib.utils.ras.SibTr;
import jakarta.jms.ConnectionMetaData;
import jakarta.jms.JMSException;
import java.util.Enumeration;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JmsMetaDataImpl
implements ConnectionMetaData {
    private static TraceComponent tc = SibTr.register(JmsMetaDataImpl.class, (String)"SIBJms_Internal", (String)"com.ibm.websphere.sib.api.jms.CWSIAJMSMessages");
    private static int jmsMajorVersion = -1;
    private static int jmsMinorVersion = -1;
    private static String provName = null;
    private static String provVersion = null;
    private static int provMajorVersion = -1;
    private static int provMinorVersion = -1;
    private static final String[] supportedJMSXProps = new String[]{"JMSXUserID", "JMSXDeliveryCount", "JMSXAppID", "JMSXGroupID", "JMSXGroupSeq"};
    private static final String packageName = "com.ibm.ws.sib.api.jms.impl";
    private static final String regexSibBuildLevel = "(\\w+(\\d{4})\\.(\\d{2,3}))";
    private static final Pattern sibBuildLevelPattern = Pattern.compile("(\\w+(\\d{4})\\.(\\d{2,3}))");
    private static final Pattern sibOldVersionPattern = Pattern.compile(".*[\\w\\.]+\\s+\\[(\\w+(\\d{4})\\.(\\d{2,3}))\\].*");

    public String getJMSVersion() throws JMSException {
        return this.getJMSMajorVersion() + "." + this.getJMSMinorVersion();
    }

    public int getJMSMajorVersion() throws JMSException {
        if (jmsMajorVersion == -1) {
            JmsMetaDataImpl.retrieveSpecManifestData();
        }
        return jmsMajorVersion;
    }

    public int getJMSMinorVersion() throws JMSException {
        if (jmsMinorVersion == -1) {
            JmsMetaDataImpl.retrieveSpecManifestData();
        }
        return jmsMinorVersion;
    }

    public String getJMSProviderName() throws JMSException {
        if (provName == null) {
            JmsMetaDataImpl.retrieveProviderManifestData();
        }
        return provName;
    }

    public String getProviderVersion() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getProviderVersion");
        }
        if (provVersion == null) {
            JmsMetaDataImpl.retrieveProviderManifestData();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getProviderVersion", (Object)provVersion);
        }
        return provVersion;
    }

    public int getProviderMajorVersion() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getProviderMajorVersion");
        }
        if (provMajorVersion == -1) {
            JmsMetaDataImpl.retrieveProviderManifestData();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getProviderMajorVersion", (Object)provMajorVersion);
        }
        return provMajorVersion;
    }

    public int getProviderMinorVersion() throws JMSException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.entry((Object)this, (TraceComponent)tc, (String)"getProviderMinorVersion");
        }
        if (provMinorVersion == -1) {
            JmsMetaDataImpl.retrieveProviderManifestData();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((Object)this, (TraceComponent)tc, (String)"getProviderMinorVersion", (Object)provMinorVersion);
        }
        return provMinorVersion;
    }

    public Enumeration getJMSXPropertyNames() throws JMSException {
        Vector<String> v = new Vector<String>(supportedJMSXProps.length);
        for (int i = 0; i < supportedJMSXProps.length; ++i) {
            v.add(supportedJMSXProps[i]);
        }
        return v.elements();
    }

    private static void retrieveSpecManifestData() {
        block14: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"retrieveSpecManifestData");
            }
            try {
                Package jmsPackage = ConnectionMetaData.class.getPackage();
                if (jmsPackage == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"The package was null - unable to retrieve information");
                    }
                    break block14;
                }
                String version = jmsPackage.getSpecificationVersion();
                if (version == null) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Specification version from manifest was null");
                    }
                    break block14;
                }
                int index = version.indexOf(46);
                try {
                    if (index == -1) {
                        jmsMajorVersion = Integer.parseInt(version);
                        jmsMajorVersion = 0;
                        break block14;
                    }
                    jmsMajorVersion = Integer.parseInt(version.substring(0, index));
                    String minorVersion = version.substring(index + 1);
                    int minorIndex = minorVersion.indexOf(46);
                    jmsMinorVersion = Integer.parseInt(minorIndex == -1 ? minorVersion : minorVersion.substring(0, minorIndex));
                }
                catch (RuntimeException e2) {
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)("Unable to convert major or minor version number from spec version " + version + " to int"), (Object)e2);
                    }
                }
            }
            catch (RuntimeException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.api.jms.impl.JmsMetaDataImpl", (String)"retrieveSpecManifestData#1");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block14;
                SibTr.debug((TraceComponent)tc, (String)"Error retrieving spec manifest information", (Object)e);
            }
        }
        if (jmsMajorVersion == -1) {
            int n = jmsMajorVersion = ConnectionMetaData.class.getName().startsWith("jakarta") ? 3 : 2;
        }
        if (jmsMinorVersion == -1) {
            jmsMinorVersion = 0;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"retrieveSpecManifestData");
        }
    }

    private static void retrieveProviderManifestData() {
        block16: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                SibTr.entry((TraceComponent)tc, (String)"retrieveProviderManifestData");
            }
            try {
                JmsMetaDataImpl.setProblemDefaults();
                Package thisPackage = Package.getPackage(packageName);
                if (thisPackage != null) {
                    String version;
                    String tempProv = thisPackage.getImplementationVendor();
                    if (tempProv != null) {
                        provName = tempProv;
                    }
                    if ((version = thisPackage.getImplementationVersion()) != null) {
                        Matcher m = sibOldVersionPattern.matcher(version);
                        if (!m.matches()) {
                            version = "1.0.0";
                            m = sibBuildLevelPattern.matcher(version);
                        }
                        if (m.matches()) {
                            provVersion = m.group(1);
                            try {
                                provMajorVersion = Integer.valueOf(m.group(2));
                                provMinorVersion = Integer.valueOf(m.group(3));
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)tc, (String)("provMajorVersion=" + provMajorVersion + "provMinorVersion=" + provMinorVersion));
                                }
                                break block16;
                            }
                            catch (RuntimeException e2) {
                                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                                    SibTr.debug((TraceComponent)tc, (String)("Unable to convert major or minor version number from build level " + version + " to int"), (Object)e2);
                                }
                                break block16;
                            }
                        }
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            SibTr.debug((TraceComponent)tc, (String)("Unable to find a valid build level in " + version));
                        }
                        break block16;
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        SibTr.debug((TraceComponent)tc, (String)"Implementation version from manifest was null");
                    }
                    break block16;
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    SibTr.debug((TraceComponent)tc, (String)"The package was null - unable to retrieve information");
                }
            }
            catch (RuntimeException e) {
                FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.sib.api.jms.impl.JmsMetaDataImpl", (String)"retrieveProviderManifestData#1");
                if (!TraceComponent.isAnyTracingEnabled() || !tc.isDebugEnabled()) break block16;
                SibTr.debug((TraceComponent)tc, (String)"Error retrieving provider manifest information", (Object)e);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            SibTr.exit((TraceComponent)tc, (String)"retrieveProviderManifestData");
        }
    }

    private static void setProblemDefaults() {
        provName = "IBM";
        provVersion = "1.0";
        provMajorVersion = 1;
        provMinorVersion = 0;
    }
}

