/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.common.http;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.webcontainer.srt.ISRTServletRequest;
import com.ibm.wsspi.http.channel.values.HttpHeaderKeys;
import javax.servlet.http.HttpServletRequest;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class AuthUtils {
    public static final TraceComponent tc = Tr.register(AuthUtils.class, null, null);
    static final long serialVersionUID = 930889543272689452L;

    @Sensitive
    public String getBearerTokenFromHeader(HttpServletRequest req) {
        String hdrValue = ISRTServletRequest.getHeader((HttpServletRequest)req, (HttpHeaderKeys)HttpHeaderKeys.HDR_AUTHORIZATION);
        return this.getBearerTokenFromHeader(hdrValue, "Bearer ");
    }

    @Sensitive
    public String getBearerTokenFromHeader(HttpServletRequest req, String headerName) {
        if (headerName == null) {
            return null;
        }
        if (!this.isAuthorizationHeader(headerName)) {
            return req.getHeader(headerName);
        }
        return this.getBearerTokenFromHeader(req);
    }

    @Sensitive
    public String getBearerTokenFromHeader(@Sensitive String rawHeaderValue, String scheme) {
        if (rawHeaderValue == null) {
            return rawHeaderValue;
        }
        if (scheme != null) {
            if ("Bearer ".equalsIgnoreCase((scheme = scheme.trim()).trim()) || "Bearer".equalsIgnoreCase(scheme.trim())) {
                if (rawHeaderValue.toLowerCase().startsWith("bearer ")) {
                    return rawHeaderValue.substring("bearer ".length()).trim();
                }
            } else if (rawHeaderValue.startsWith(scheme)) {
                return rawHeaderValue.substring(scheme.length()).trim();
            }
        }
        return rawHeaderValue;
    }

    private boolean isAuthorizationHeader(String headerName) {
        return "Authorization".equals(headerName);
    }
}

