/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.security.common.jwt.jws;

import com.ibm.websphere.ras.ProtectedString;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.common.crypto.CryptoUtils;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.http.HttpUtils;
import com.ibm.ws.security.common.jwk.impl.JWKSet;
import com.ibm.ws.security.common.jwk.impl.JwKRetriever;
import com.ibm.wsspi.ssl.SSLSupport;
import io.openliberty.security.common.jwt.exceptions.SharedKeyMissingException;
import io.openliberty.security.common.jwt.exceptions.UnsupportedSignatureAlgorithmException;
import io.openliberty.security.common.jwt.jwk.RemoteJwkData;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.Key;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.HmacKey;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class JwsVerificationKeyHelper {
    public static final Set<String> SUPPORTED_SIGNATURE_ALGORITHMS;
    private String configId;
    @Sensitive
    private ProtectedString sharedSecret;
    private RemoteJwkData remoteJwkData;
    private JWKSet jwkSet;
    static final long serialVersionUID = -842634126920425930L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    private JwsVerificationKeyHelper(Builder builder) {
        this.configId = builder.configId;
        this.sharedSecret = builder.sharedSecret;
        this.remoteJwkData = builder.remoteJwkData;
        this.jwkSet = builder.jwkSet;
    }

    public RemoteJwkData getRemoteJwkData() {
        return this.remoteJwkData;
    }

    public Key getVerificationKey(JsonWebStructure jws) throws Exception {
        String signatureAlgorithmFromJws = this.getSignatureAlgorithmFromJws(jws);
        if (signatureAlgorithmFromJws == null) {
            // empty if block
        }
        if (signatureAlgorithmFromJws.equalsIgnoreCase("none")) {
            return null;
        }
        if (signatureAlgorithmFromJws.startsWith("HS")) {
            return this.getSharedKey();
        }
        return this.retrievePublicKey(jws, signatureAlgorithmFromJws);
    }

    String getSignatureAlgorithmFromJws(JsonWebStructure jws) throws UnsupportedSignatureAlgorithmException {
        String algorithm = null;
        if (jws != null && jws instanceof JsonWebSignature) {
            algorithm = ((JsonWebSignature)jws).getAlgorithmHeaderValue();
        }
        if (SUPPORTED_SIGNATURE_ALGORITHMS.contains(algorithm)) {
            return algorithm;
        }
        throw new UnsupportedSignatureAlgorithmException(algorithm);
    }

    Key getSharedKey() throws SharedKeyMissingException {
        if (this.sharedSecret == null || this.sharedSecret.isEmpty()) {
            throw new SharedKeyMissingException();
        }
        String sharedSecretProtectedString = new String(this.sharedSecret.getChars());
        return new HmacKey(sharedSecretProtectedString.getBytes(StandardCharsets.UTF_8));
    }

    Key retrievePublicKey(JsonWebStructure jws, String signatureAlgorithmFromJws) throws IOException, Exception {
        String kid = jws.getKeyIdHeaderValue();
        String x5t = CryptoUtils.isFips140_3Enabled() ? null : jws.getX509CertSha1ThumbprintHeaderValue();
        String x5tS256 = jws.getX509CertSha256ThumbprintHeaderValue();
        JwKRetriever jwkRetriever = this.createJwkRetriever(signatureAlgorithmFromJws);
        return jwkRetriever.getPublicKeyFromJwk(kid, x5t, x5tS256, "sig", false);
    }

    JwKRetriever createJwkRetriever(String signatureAlgorithmFromJws) throws Exception {
        String jwksUri = this.remoteJwkData == null ? null : this.remoteJwkData.getJwksUri();
        SSLSupport sslSupport = this.remoteJwkData == null ? null : this.remoteJwkData.getSslSupport();
        JwKRetriever jwkRetriever = new JwKRetriever(this.configId, null, jwksUri, this.jwkSet, sslSupport, false, null, null, signatureAlgorithmFromJws);
        jwkRetriever.httpUtils = new HttpUtils(){
            static final long serialVersionUID = -727949461797227429L;
            private static final /* synthetic */ TraceComponent $$$tc$$$;

            public HttpGet createHttpGetMethod(String url, List<NameValuePair> commonHeaders) {
                HttpGet request = super.createHttpGetMethod(url, commonHeaders);
                if (JwsVerificationKeyHelper.this.remoteJwkData != null) {
                    RequestConfig requestConfig = RequestConfig.custom().setConnectTimeout(JwsVerificationKeyHelper.this.remoteJwkData.getJwksConnectTimeout()).setSocketTimeout(JwsVerificationKeyHelper.this.remoteJwkData.getJwksReadTimeout()).build();
                    request.setConfig(requestConfig);
                }
                return request;
            }

            @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
            static {
                $$$tc$$$ = Tr.register((String)"io.openliberty.security.common.jwt.jws.JwsVerificationKeyHelper$1", 1.class, null, null);
            }
        };
        return jwkRetriever;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.openliberty.security.common.jwt.jws.JwsVerificationKeyHelper", JwsVerificationKeyHelper.class, null, null);
        HashSet<String> supportedAlgorithms = new HashSet<String>();
        supportedAlgorithms.add("none");
        supportedAlgorithms.add("RS256");
        supportedAlgorithms.add("RS384");
        supportedAlgorithms.add("RS512");
        supportedAlgorithms.add("HS256");
        supportedAlgorithms.add("HS384");
        supportedAlgorithms.add("HS512");
        supportedAlgorithms.add("ES256");
        supportedAlgorithms.add("ES384");
        supportedAlgorithms.add("ES512");
        SUPPORTED_SIGNATURE_ALGORITHMS = Collections.unmodifiableSet(supportedAlgorithms);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class Builder {
        private String configId;
        @Sensitive
        private ProtectedString sharedSecret;
        private RemoteJwkData remoteJwkData;
        private JWKSet jwkSet;
        static final long serialVersionUID = 9021088606431837839L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public Builder configId(String configId) {
            this.configId = configId;
            return this;
        }

        public Builder sharedSecret(@Sensitive ProtectedString sharedSecret) {
            this.sharedSecret = sharedSecret;
            return this;
        }

        public Builder remoteJwkData(RemoteJwkData remoteJwkData) {
            this.remoteJwkData = remoteJwkData;
            return this;
        }

        public Builder jwkSet(JWKSet jwkSet) {
            this.jwkSet = jwkSet;
            return this;
        }

        public JwsVerificationKeyHelper build() {
            return new JwsVerificationKeyHelper(this);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"io.openliberty.security.common.jwt.jws.JwsVerificationKeyHelper$Builder", Builder.class, null, null);
        }
    }
}

