/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.graphql.bootstrap;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import graphql.schema.DataFetcher;
import graphql.schema.DataFetchingEnvironment;
import graphql.schema.FieldCoordinates;
import graphql.schema.GraphQLArgument;
import graphql.schema.GraphQLCodeRegistry;
import graphql.schema.GraphQLEnumType;
import graphql.schema.GraphQLFieldDefinition;
import graphql.schema.GraphQLInputObjectField;
import graphql.schema.GraphQLInputObjectType;
import graphql.schema.GraphQLInputType;
import graphql.schema.GraphQLInterfaceType;
import graphql.schema.GraphQLList;
import graphql.schema.GraphQLNonNull;
import graphql.schema.GraphQLObjectType;
import graphql.schema.GraphQLOutputType;
import graphql.schema.GraphQLScalarType;
import graphql.schema.GraphQLSchema;
import graphql.schema.GraphQLType;
import graphql.schema.GraphQLTypeReference;
import graphql.schema.TypeResolver;
import graphql.schema.visibility.BlockedFields;
import graphql.schema.visibility.DefaultGraphqlFieldVisibility;
import graphql.schema.visibility.GraphqlFieldVisibility;
import graphql.schema.visibility.NoIntrospectionGraphqlFieldVisibility;
import io.smallrye.graphql.SmallRyeGraphQLServerLogging;
import io.smallrye.graphql.bootstrap.Config;
import io.smallrye.graphql.bootstrap.DataFetcherFactory;
import io.smallrye.graphql.execution.Classes;
import io.smallrye.graphql.execution.context.SmallRyeContext;
import io.smallrye.graphql.execution.datafetcher.BatchDataFetcher;
import io.smallrye.graphql.execution.datafetcher.CollectionCreator;
import io.smallrye.graphql.execution.datafetcher.PropertyDataFetcher;
import io.smallrye.graphql.execution.error.ErrorInfoMap;
import io.smallrye.graphql.execution.event.EventEmitter;
import io.smallrye.graphql.execution.resolver.InterfaceOutputRegistry;
import io.smallrye.graphql.execution.resolver.InterfaceResolver;
import io.smallrye.graphql.json.JsonBCreator;
import io.smallrye.graphql.json.JsonInputRegistry;
import io.smallrye.graphql.scalar.GraphQLScalarTypes;
import io.smallrye.graphql.schema.model.Argument;
import io.smallrye.graphql.schema.model.EnumType;
import io.smallrye.graphql.schema.model.Field;
import io.smallrye.graphql.schema.model.Group;
import io.smallrye.graphql.schema.model.InputType;
import io.smallrye.graphql.schema.model.InterfaceType;
import io.smallrye.graphql.schema.model.Operation;
import io.smallrye.graphql.schema.model.Reference;
import io.smallrye.graphql.schema.model.ReferenceType;
import io.smallrye.graphql.schema.model.Schema;
import io.smallrye.graphql.schema.model.Type;
import io.smallrye.graphql.schema.model.Wrapper;
import io.smallrye.graphql.spi.ClassloadingService;
import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.json.Json;
import javax.json.JsonReader;
import javax.json.JsonReaderFactory;
import javax.json.bind.Jsonb;
import javax.json.bind.JsonbBuilder;

@TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class Bootstrap {
    private final Schema schema;
    private final Config config;
    private final EventEmitter eventEmitter;
    private final DataFetcherFactory dataFetcherFactory;
    private final Map<String, GraphQLEnumType> enumMap = new HashMap<String, GraphQLEnumType>();
    private final Map<String, GraphQLInterfaceType> interfaceMap = new HashMap<String, GraphQLInterfaceType>();
    private final Map<String, GraphQLInputObjectType> inputMap = new HashMap<String, GraphQLInputObjectType>();
    private final Map<String, GraphQLObjectType> typeMap = new HashMap<String, GraphQLObjectType>();
    private GraphQLSchema graphQLSchema;
    private final GraphQLCodeRegistry.Builder codeRegistryBuilder = GraphQLCodeRegistry.newCodeRegistry();
    private final ClassloadingService classloadingService = ClassloadingService.get();
    private static final String QUERY = "Query";
    private static final String QUERY_DESCRIPTION = "Query root";
    private static final String MUTATION = "Mutation";
    private static final String MUTATION_DESCRIPTION = "Mutation root";
    private static final String COMMA = ",";
    private static final Jsonb JSONB;
    private static final JsonReaderFactory jsonReaderFactory;
    private static final String CONTEXT = "io.smallrye.graphql.api.Context";
    static final long serialVersionUID = -425129488701496214L;
    private static final /* synthetic */ TraceComponent $$$tc$$$;

    public static GraphQLSchema bootstrap(Schema schema) {
        return Bootstrap.bootstrap(schema, null);
    }

    public static GraphQLSchema bootstrap(Schema schema, Config config) {
        if (schema != null && schema.hasOperations()) {
            Bootstrap bootstrap = new Bootstrap(schema, config);
            bootstrap.generateGraphQLSchema();
            return bootstrap.graphQLSchema;
        }
        SmallRyeGraphQLServerLogging.log.emptyOrNullSchema();
        return null;
    }

    private Bootstrap(Schema schema, Config config) {
        this.schema = schema;
        this.config = config;
        this.dataFetcherFactory = new DataFetcherFactory(config);
        this.eventEmitter = EventEmitter.getInstance(config);
        SmallRyeContext.setSchema(schema);
    }

    private void generateGraphQLSchema() {
        GraphQLSchema.Builder schemaBuilder = GraphQLSchema.newSchema();
        this.createGraphQLEnumTypes();
        this.createGraphQLInterfaceTypes();
        this.createGraphQLObjectTypes();
        this.createGraphQLInputObjectTypes();
        this.addQueries(schemaBuilder);
        this.addMutations(schemaBuilder);
        schemaBuilder.additionalTypes(new HashSet<GraphQLEnumType>(this.enumMap.values()));
        schemaBuilder.additionalTypes(new HashSet<GraphQLInterfaceType>(this.interfaceMap.values()));
        schemaBuilder.additionalTypes(new HashSet<GraphQLObjectType>(this.typeMap.values()));
        schemaBuilder.additionalTypes(new HashSet<GraphQLInputObjectType>(this.inputMap.values()));
        this.codeRegistryBuilder.fieldVisibility(this.getGraphqlFieldVisibility());
        schemaBuilder = schemaBuilder.codeRegistry(this.codeRegistryBuilder.build());
        ErrorInfoMap.register(this.schema.getErrors());
        schemaBuilder = this.eventEmitter.fireBeforeSchemaBuild(schemaBuilder);
        this.graphQLSchema = schemaBuilder.build();
    }

    private void addQueries(GraphQLSchema.Builder schemaBuilder) {
        GraphQLObjectType.Builder queryBuilder = GraphQLObjectType.newObject().name(QUERY).description(QUERY_DESCRIPTION);
        if (this.schema.hasQueries()) {
            this.addRootObject(queryBuilder, this.schema.getQueries(), QUERY);
        }
        if (this.schema.hasGroupedQueries()) {
            this.addGroupedRootObject(queryBuilder, this.schema.getGroupedQueries(), QUERY);
        }
        GraphQLObjectType query = queryBuilder.build();
        schemaBuilder.query(query);
    }

    private void addMutations(GraphQLSchema.Builder schemaBuilder) {
        GraphQLObjectType mutation;
        GraphQLObjectType.Builder mutationBuilder = GraphQLObjectType.newObject().name(MUTATION).description(MUTATION_DESCRIPTION);
        if (this.schema.hasMutations()) {
            this.addRootObject(mutationBuilder, this.schema.getMutations(), MUTATION);
        }
        if (this.schema.hasGroupedMutations()) {
            this.addGroupedRootObject(mutationBuilder, this.schema.getGroupedMutations(), MUTATION);
        }
        if ((mutation = mutationBuilder.build()).getFieldDefinitions() != null && !mutation.getFieldDefinitions().isEmpty()) {
            schemaBuilder.mutation(mutation);
        }
    }

    private void addRootObject(GraphQLObjectType.Builder rootBuilder, Set<Operation> operations, String rootName) {
        for (Operation operation : operations) {
            operation = this.eventEmitter.fireCreateOperation(operation);
            GraphQLFieldDefinition graphQLFieldDefinition = this.createGraphQLFieldDefinitionFromOperation(rootName, operation);
            rootBuilder.field(graphQLFieldDefinition);
        }
    }

    private void addGroupedRootObject(GraphQLObjectType.Builder rootBuilder, Map<Group, Set<Operation>> operationMap, String rootName) {
        Set<Map.Entry<Group, Set<Operation>>> operationsSet = operationMap.entrySet();
        for (Map.Entry<Group, Set<Operation>> operationsEntry : operationsSet) {
            Group group = operationsEntry.getKey();
            Set<Operation> operations = operationsEntry.getValue();
            final GraphQLObjectType namedType = this.createNamedType(rootName, group, operations);
            GraphQLFieldDefinition.Builder graphQLFieldDefinitionBuilder = GraphQLFieldDefinition.newFieldDefinition().name(group.getName()).description(group.getDescription());
            graphQLFieldDefinitionBuilder.type((GraphQLOutputType)namedType);
            DataFetcher datafetcher = new DataFetcher(){
                static final long serialVersionUID = -452341649819683411L;
                private static final /* synthetic */ TraceComponent $$$tc$$$;

                public Object get(DataFetchingEnvironment dfe) throws Exception {
                    return namedType.getName();
                }

                @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
                static {
                    $$$tc$$$ = Tr.register((String)"io.smallrye.graphql.bootstrap.Bootstrap$1", 1.class, null, null);
                }
            };
            GraphQLFieldDefinition namedField = graphQLFieldDefinitionBuilder.build();
            this.codeRegistryBuilder.dataFetcherIfAbsent(FieldCoordinates.coordinates((String)rootName, (String)namedField.getName()), datafetcher);
            rootBuilder.field(namedField);
        }
    }

    private GraphQLObjectType createNamedType(String parent, Group group, Set<Operation> operations) {
        String namedTypeName = group.getName() + parent;
        GraphQLObjectType.Builder objectTypeBuilder = GraphQLObjectType.newObject().name(namedTypeName).description(group.getDescription());
        for (Operation operation : operations) {
            operation = this.eventEmitter.fireCreateOperation(operation);
            GraphQLFieldDefinition graphQLFieldDefinition = this.createGraphQLFieldDefinitionFromOperation(namedTypeName, operation);
            objectTypeBuilder = objectTypeBuilder.field(graphQLFieldDefinition);
        }
        GraphQLObjectType graphQLObjectType = objectTypeBuilder.build();
        return graphQLObjectType;
    }

    private void createGraphQLEnumTypes() {
        if (this.schema.hasEnums()) {
            for (EnumType enumType : this.schema.getEnums().values()) {
                this.createGraphQLEnumType(enumType);
            }
        }
    }

    private void createGraphQLEnumType(EnumType enumType) {
        GraphQLEnumType.Builder enumBuilder = GraphQLEnumType.newEnum().name(enumType.getName()).description(enumType.getDescription());
        for (String value : enumType.getValues()) {
            enumBuilder = enumBuilder.value(value);
        }
        GraphQLEnumType graphQLEnumType = enumBuilder.build();
        this.enumMap.put(enumType.getClassName(), graphQLEnumType);
    }

    private void createGraphQLInterfaceTypes() {
        if (this.schema.hasInterfaces()) {
            for (InterfaceType interfaceType : this.schema.getInterfaces().values()) {
                this.createGraphQLInterfaceType(interfaceType);
            }
        }
    }

    private void createGraphQLInterfaceType(InterfaceType interfaceType) {
        GraphQLInterfaceType.Builder interfaceTypeBuilder = GraphQLInterfaceType.newInterface().name(interfaceType.getName()).description(interfaceType.getDescription());
        if (interfaceType.hasFields()) {
            interfaceTypeBuilder = interfaceTypeBuilder.fields(this.createGraphQLFieldDefinitionsFromFields(interfaceType.getName(), interfaceType.getFields().values()));
        }
        if (interfaceType.hasInterfaces()) {
            Set<Reference> interfaces = interfaceType.getInterfaces();
            for (Reference i : interfaces) {
                interfaceTypeBuilder = interfaceTypeBuilder.withInterface(GraphQLTypeReference.typeRef((String)i.getName()));
            }
        }
        GraphQLInterfaceType graphQLInterfaceType = interfaceTypeBuilder.build();
        this.codeRegistryBuilder.typeResolver(graphQLInterfaceType, (TypeResolver)new InterfaceResolver(interfaceType));
        this.interfaceMap.put(interfaceType.getName(), graphQLInterfaceType);
    }

    private void createGraphQLInputObjectTypes() {
        if (this.schema.hasInputs()) {
            for (InputType inputType : this.schema.getInputs().values()) {
                this.createGraphQLInputObjectType(inputType);
            }
        }
    }

    private void createGraphQLInputObjectType(InputType inputType) {
        GraphQLInputObjectType.Builder inputObjectTypeBuilder = GraphQLInputObjectType.newInputObject().name(inputType.getName()).description(inputType.getDescription());
        if (inputType.hasFields()) {
            inputObjectTypeBuilder = inputObjectTypeBuilder.fields(this.createGraphQLInputObjectFieldsFromFields(inputType.getFields().values()));
            JsonInputRegistry.register(inputType);
        }
        GraphQLInputObjectType graphQLInputObjectType = inputObjectTypeBuilder.build();
        this.inputMap.put(inputType.getName(), graphQLInputObjectType);
    }

    private void createGraphQLObjectTypes() {
        if (this.schema.hasTypes()) {
            for (Type type : this.schema.getTypes().values()) {
                this.createGraphQLObjectType(type);
            }
        }
    }

    private void createGraphQLObjectType(Type type) {
        GraphQLObjectType.Builder objectTypeBuilder = GraphQLObjectType.newObject().name(type.getName()).description(type.getDescription());
        if (type.hasFields()) {
            objectTypeBuilder = objectTypeBuilder.fields(this.createGraphQLFieldDefinitionsFromFields(type.getName(), type.getFields().values()));
        }
        if (type.hasOperations()) {
            for (Operation operation : type.getOperations().values()) {
                String name = operation.getName();
                if (!type.hasBatchOperation(name)) {
                    operation = this.eventEmitter.fireCreateOperation(operation);
                    GraphQLFieldDefinition graphQLFieldDefinition = this.createGraphQLFieldDefinitionFromOperation(type.getName(), operation);
                    objectTypeBuilder = objectTypeBuilder.field(graphQLFieldDefinition);
                    continue;
                }
                SmallRyeGraphQLServerLogging.log.duplicateOperation(operation.getName());
            }
        }
        if (type.hasBatchOperations()) {
            for (Operation operation : type.getBatchOperations().values()) {
                operation = this.eventEmitter.fireCreateOperation(operation);
                GraphQLFieldDefinition graphQLFieldDefinition = this.createGraphQLFieldDefinitionFromBatchOperation(type.getName(), operation);
                objectTypeBuilder = objectTypeBuilder.field(graphQLFieldDefinition);
            }
        }
        if (type.hasInterfaces()) {
            Set<Reference> interfaces = type.getInterfaces();
            for (Reference i : interfaces) {
                if (!this.interfaceMap.containsKey(i.getName())) continue;
                GraphQLInterfaceType graphQLInterfaceType = this.interfaceMap.get(i.getName());
                objectTypeBuilder = objectTypeBuilder.withInterface(graphQLInterfaceType);
            }
        }
        GraphQLObjectType graphQLObjectType = objectTypeBuilder.build();
        this.typeMap.put(type.getName(), graphQLObjectType);
        InterfaceOutputRegistry.register(type, graphQLObjectType);
    }

    private GraphQLFieldDefinition createGraphQLFieldDefinitionFromBatchOperation(String operationTypeName, Operation operation) {
        GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(operation.getName()).description(operation.getDescription());
        fieldBuilder = fieldBuilder.type(this.createGraphQLOutputType(operation, true));
        if (operation.hasArguments()) {
            fieldBuilder = fieldBuilder.arguments(this.createGraphQLArguments(operation.getArguments()));
        }
        BatchDataFetcher datafetcher = new BatchDataFetcher(operation, this.config);
        GraphQLFieldDefinition graphQLFieldDefinition = fieldBuilder.build();
        this.codeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)operationTypeName, (String)graphQLFieldDefinition.getName()), datafetcher);
        return graphQLFieldDefinition;
    }

    private GraphQLFieldDefinition createGraphQLFieldDefinitionFromOperation(String operationTypeName, Operation operation) {
        GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(operation.getName()).description(operation.getDescription());
        fieldBuilder = fieldBuilder.type(this.createGraphQLOutputType(operation, false));
        if (operation.hasArguments()) {
            fieldBuilder = fieldBuilder.arguments(this.createGraphQLArguments(operation.getArguments()));
        }
        GraphQLFieldDefinition graphQLFieldDefinition = fieldBuilder.build();
        DataFetcher datafetcher = this.dataFetcherFactory.getDataFetcher(operation);
        this.codeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)operationTypeName, (String)graphQLFieldDefinition.getName()), datafetcher);
        return graphQLFieldDefinition;
    }

    private List<GraphQLFieldDefinition> createGraphQLFieldDefinitionsFromFields(String ownerName, Collection<Field> fields) {
        ArrayList<GraphQLFieldDefinition> graphQLFieldDefinitions = new ArrayList<GraphQLFieldDefinition>();
        for (Field field : fields) {
            graphQLFieldDefinitions.add(this.createGraphQLFieldDefinitionFromField(ownerName, field));
        }
        return graphQLFieldDefinitions;
    }

    private GraphQLFieldDefinition createGraphQLFieldDefinitionFromField(String ownerName, Field field) {
        GraphQLFieldDefinition.Builder fieldBuilder = GraphQLFieldDefinition.newFieldDefinition().name(field.getName()).description(field.getDescription());
        fieldBuilder = fieldBuilder.type(this.createGraphQLOutputType(field, false));
        GraphQLFieldDefinition graphQLFieldDefinition = fieldBuilder.build();
        PropertyDataFetcher datafetcher = new PropertyDataFetcher(field);
        this.codeRegistryBuilder.dataFetcher(FieldCoordinates.coordinates((String)ownerName, (String)graphQLFieldDefinition.getName()), (DataFetcher)datafetcher);
        return graphQLFieldDefinition;
    }

    private List<GraphQLInputObjectField> createGraphQLInputObjectFieldsFromFields(Collection<Field> fields) {
        ArrayList<GraphQLInputObjectField> graphQLInputObjectFields = new ArrayList<GraphQLInputObjectField>();
        for (Field field : fields) {
            graphQLInputObjectFields.add(this.createGraphQLInputObjectFieldFromField(field));
        }
        return graphQLInputObjectFields;
    }

    private GraphQLInputObjectField createGraphQLInputObjectFieldFromField(Field field) {
        GraphQLInputObjectField.Builder inputFieldBuilder = GraphQLInputObjectField.newInputObjectField().name(field.getName()).description(field.getDescription());
        inputFieldBuilder = inputFieldBuilder.type(this.createGraphQLInputType(field));
        if (field.hasDefaultValue()) {
            inputFieldBuilder = inputFieldBuilder.defaultValue(this.sanitizeDefaultValue(field));
        }
        return inputFieldBuilder.build();
    }

    private GraphQLInputType createGraphQLInputType(Field field) {
        GraphQLInputType graphQLInputType = this.referenceGraphQLInputType(field);
        Wrapper wrapper = this.dataFetcherFactory.unwrap(field, false);
        if (wrapper != null && wrapper.isCollectionOrArray()) {
            if (wrapper.isNotEmpty()) {
                graphQLInputType = GraphQLNonNull.nonNull((GraphQLType)graphQLInputType);
            }
            do {
                if (wrapper.isCollectionOrArray()) {
                    graphQLInputType = GraphQLList.list((GraphQLType)graphQLInputType);
                    wrapper = wrapper.getWrapper();
                    continue;
                }
                wrapper = null;
            } while (wrapper != null);
        }
        if (field.isNotNull()) {
            graphQLInputType = GraphQLNonNull.nonNull((GraphQLType)graphQLInputType);
        }
        return graphQLInputType;
    }

    private GraphQLOutputType createGraphQLOutputType(Field field, boolean isBatch) {
        GraphQLOutputType graphQLOutputType = this.referenceGraphQLOutputType(field);
        Wrapper wrapper = this.dataFetcherFactory.unwrap(field, isBatch);
        if (wrapper != null && wrapper.isCollectionOrArray()) {
            if (wrapper.isNotEmpty()) {
                graphQLOutputType = GraphQLNonNull.nonNull((GraphQLType)graphQLOutputType);
            }
            do {
                if (wrapper.isCollectionOrArray()) {
                    graphQLOutputType = GraphQLList.list((GraphQLType)graphQLOutputType);
                    wrapper = wrapper.getWrapper();
                    continue;
                }
                wrapper = null;
            } while (wrapper != null);
        }
        if (field.isNotNull()) {
            graphQLOutputType = GraphQLNonNull.nonNull((GraphQLType)graphQLOutputType);
        }
        return graphQLOutputType;
    }

    private GraphQLOutputType referenceGraphQLOutputType(Field field) {
        Reference reference = this.getCorrectFieldReference(field);
        ReferenceType type = reference.getType();
        String className = reference.getClassName();
        String name = reference.getName();
        switch (type) {
            case SCALAR: {
                return this.getCorrectScalarType(reference);
            }
            case ENUM: {
                return (GraphQLOutputType)this.enumMap.get(className);
            }
        }
        return GraphQLTypeReference.typeRef((String)name);
    }

    private GraphQLInputType referenceGraphQLInputType(Field field) {
        Reference reference = this.getCorrectFieldReference(field);
        ReferenceType type = reference.getType();
        String className = reference.getClassName();
        String name = reference.getName();
        switch (type) {
            case SCALAR: {
                return this.getCorrectScalarType(reference);
            }
            case ENUM: {
                return (GraphQLInputType)this.enumMap.get(className);
            }
        }
        return GraphQLTypeReference.typeRef((String)name);
    }

    private Reference getCorrectFieldReference(Field field) {
        if (field.getReference().hasMapping()) {
            return field.getReference().getMapping().getReference();
        }
        if (field.hasMapping()) {
            return field.getMapping().getReference();
        }
        return field.getReference();
    }

    private GraphQLScalarType getCorrectScalarType(Reference fieldReference) {
        return GraphQLScalarTypes.getScalarByName(fieldReference.getName());
    }

    private List<GraphQLArgument> createGraphQLArguments(List<Argument> arguments) {
        ArrayList<GraphQLArgument> graphQLArguments = new ArrayList<GraphQLArgument>();
        for (Argument argument : arguments) {
            if (argument.isSourceArgument() || argument.getReference().getClassName().equals(CONTEXT)) continue;
            graphQLArguments.add(this.createGraphQLArgument(argument));
        }
        return graphQLArguments;
    }

    private GraphQLArgument createGraphQLArgument(Argument argument) {
        GraphQLArgument.Builder argumentBuilder = GraphQLArgument.newArgument().name(argument.getName()).description(argument.getDescription());
        if (argument.hasDefaultValue()) {
            argumentBuilder = argumentBuilder.defaultValue(this.sanitizeDefaultValue(argument));
        }
        GraphQLInputType graphQLInputType = this.referenceGraphQLInputType(argument);
        Wrapper wrapper = this.dataFetcherFactory.unwrap(argument, false);
        if (wrapper != null && wrapper.isCollectionOrArray()) {
            if (wrapper.isNotEmpty()) {
                graphQLInputType = GraphQLNonNull.nonNull((GraphQLType)graphQLInputType);
            }
            do {
                if (wrapper.isCollectionOrArray()) {
                    graphQLInputType = GraphQLList.list((GraphQLType)graphQLInputType);
                    wrapper = wrapper.getWrapper();
                    continue;
                }
                wrapper = null;
            } while (wrapper != null);
        }
        if (argument.isNotNull()) {
            graphQLInputType = GraphQLNonNull.nonNull((GraphQLType)graphQLInputType);
        }
        argumentBuilder = argumentBuilder.type(graphQLInputType);
        return argumentBuilder.build();
    }

    private Object sanitizeDefaultValue(Field field) {
        String jsonString = field.getDefaultValue();
        if (jsonString == null) {
            return null;
        }
        if (this.isJsonString(jsonString)) {
            Class<?> type;
            Wrapper wrapper = this.dataFetcherFactory.unwrap(field, false);
            if (wrapper != null && wrapper.isCollectionOrArray()) {
                type = this.classloadingService.loadClass(field.getWrapper().getWrapperClassName());
                if (Collection.class.isAssignableFrom(type)) {
                    type = CollectionCreator.newCollection(field.getWrapper().getWrapperClassName()).getClass();
                }
            } else {
                type = this.classloadingService.loadClass(field.getReference().getClassName());
            }
            Jsonb jsonB = JsonBCreator.getJsonB(type.getName());
            Reference reference = this.getCorrectFieldReference(field);
            ReferenceType referenceType = reference.getType();
            if (referenceType.equals((Object)ReferenceType.INPUT) || referenceType.equals((Object)ReferenceType.TYPE)) {
                return jsonB.fromJson(jsonString, Map.class);
            }
            return jsonB.fromJson(jsonString, type);
        }
        if (Classes.isNumberLikeType(field.getReference().getGraphQlClassName())) {
            return new BigDecimal(jsonString);
        }
        if (Classes.isBoolean(field.getReference().getGraphQlClassName())) {
            return Boolean.parseBoolean(jsonString);
        }
        return jsonString;
    }

    @FFDCIgnore(value={Exception.class})
    private boolean isJsonString(String string) {
        if (string != null && !string.isEmpty() && (string.contains("{") || string.contains("["))) {
            boolean bl;
            StringReader stringReader;
            block14: {
                stringReader = new StringReader(string);
                JsonReader jsonReader = jsonReaderFactory.createReader((Reader)stringReader);
                try {
                    jsonReader.readValue();
                    bl = true;
                    if (jsonReader == null) break block14;
                }
                catch (Throwable throwable) {
                    try {
                        try {
                            FFDCFilter.processException((Throwable)throwable, (String)"io.smallrye.graphql.bootstrap.Bootstrap", (String)"696", (Object)this, (Object[])new Object[]{string});
                            if (jsonReader != null) {
                                try {
                                    jsonReader.close();
                                }
                                catch (Throwable throwable2) {
                                    FFDCFilter.processException((Throwable)throwable2, (String)"io.smallrye.graphql.bootstrap.Bootstrap", (String)"696", (Object)this, (Object[])new Object[]{string});
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Throwable throwable3) {
                            FFDCFilter.processException((Throwable)throwable3, (String)"io.smallrye.graphql.bootstrap.Bootstrap", (String)"696", (Object)this, (Object[])new Object[]{string});
                            try {
                                stringReader.close();
                            }
                            catch (Throwable throwable4) {
                                FFDCFilter.processException((Throwable)throwable4, (String)"io.smallrye.graphql.bootstrap.Bootstrap", (String)"696", (Object)this, (Object[])new Object[]{string});
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                jsonReader.close();
            }
            stringReader.close();
            return bl;
        }
        return false;
    }

    private GraphqlFieldVisibility getGraphqlFieldVisibility() {
        String fieldVisibility;
        if (this.config != null && (fieldVisibility = this.config.getFieldVisibility()) != null && !fieldVisibility.isEmpty()) {
            if (fieldVisibility.equals("no-introspection")) {
                return NoIntrospectionGraphqlFieldVisibility.NO_INTROSPECTION_FIELD_VISIBILITY;
            }
            String[] patterns = fieldVisibility.split(COMMA);
            BlockedFields.Builder blockedFields = BlockedFields.newBlock();
            for (String pattern : patterns) {
                blockedFields = blockedFields.addPattern(pattern);
            }
            return blockedFields.build();
        }
        return DefaultGraphqlFieldVisibility.DEFAULT_FIELD_VISIBILITY;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        $$$tc$$$ = Tr.register((String)"io.smallrye.graphql.bootstrap.Bootstrap", Bootstrap.class, null, null);
        JSONB = JsonbBuilder.create();
        jsonReaderFactory = Json.createReaderFactory(null);
    }
}

