/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxb;

import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapters;
import javax.xml.namespace.QName;
import org.apache.cxf.Bus;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.common.jaxb.JAXBUtils;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.common.util.ReflectionUtil;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.jaxb.FactoryClassCreator;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxb.Utils;
import org.apache.cxf.service.ServiceModelVisitor;
import org.apache.cxf.service.model.MessageInfo;
import org.apache.cxf.service.model.MessagePartInfo;
import org.apache.cxf.service.model.OperationInfo;
import org.apache.cxf.service.model.ServiceInfo;
import org.apache.cxf.service.model.UnwrappedOperationInfo;

@TraceObjectField(fieldName="LOG", fieldDesc="Ljava/util/logging/Logger;")
class JAXBContextInitializer
extends ServiceModelVisitor {
    private static final Logger LOG = LogUtils.getL7dLogger(JAXBContextInitializer.class);
    private Set<Class<?>> classes;
    private Collection<Object> typeReferences;
    private Set<Class<?>> globalAdapters;
    private Map<String, Object> unmarshallerProperties;
    private Bus bus;
    static final long serialVersionUID = 4151669502306279775L;

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    JAXBContextInitializer(Bus bus, ServiceInfo serviceInfo, Set<Class<?>> classes, Collection<Object> typeReferences, Map<String, Object> unmarshallerProperties) {
        super(serviceInfo);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBContextInitializer", "<init>", new Object[]{bus, serviceInfo, classes, typeReferences, unmarshallerProperties});
        }
        this.globalAdapters = new HashSet();
        this.classes = classes;
        this.typeReferences = typeReferences;
        this.unmarshallerProperties = unmarshallerProperties;
        this.bus = bus;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "<init>", (Object)this);
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    public void begin(MessagePartInfo part) {
        boolean isFromWrapper;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBContextInitializer", "begin", new Object[]{part});
        }
        boolean isLoggableFinest = LOG.isLoggable(Level.FINEST);
        Class<?> clazz = part.getTypeClass();
        if (clazz == null) {
            if (isLoggableFinest) {
                LOG.finest("begin: MessagePart typeClass is null, returning");
            }
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "begin");
            }
            return;
        }
        if (Exception.class.isAssignableFrom(clazz)) {
            if (isLoggableFinest) {
                LOG.finest("begin: Setting custom_exception property to true");
            }
            part.setProperty(JAXBDataBinding.class.getName() + ".CUSTOM_EXCEPTION", (Object)Boolean.TRUE);
        }
        if ((isFromWrapper = part.getMessageInfo().getOperation().isUnwrapped()) && !Boolean.TRUE.equals(part.getProperty("messagepart.isheader"))) {
            UnwrappedOperationInfo uop = (UnwrappedOperationInfo)part.getMessageInfo().getOperation();
            OperationInfo op = uop.getWrappedOperation();
            MessageInfo inf = null;
            if (uop.getInput() == part.getMessageInfo()) {
                inf = op.getInput();
            } else if (uop.getOutput() == part.getMessageInfo()) {
                inf = op.getOutput();
            }
            if (inf != null && inf.getFirstMessagePart().getTypeClass() != null) {
                if (isLoggableFinest) {
                    LOG.finest("begin: Wrapper already has a type class, return");
                }
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "begin");
                }
                return;
            }
        }
        if (isFromWrapper && clazz.isArray() && !Byte.TYPE.equals(clazz.getComponentType())) {
            clazz = clazz.getComponentType();
            if (isLoggableFinest) {
                LOG.finest("begin: Clazz componentType: " + (clazz != null ? clazz.getName() : "null"));
            }
        }
        Annotation[] a = (Annotation[])part.getProperty("parameter.annotations");
        this.checkForAdapter(clazz, a);
        Class<?> genericType = (Class<?>)part.getProperty("generic.type");
        if (genericType != null) {
            if (isLoggableFinest) {
                LOG.finest("begin: genericType: " + genericType.getTypeName());
            }
            boolean isList = Collection.class.isAssignableFrom(clazz);
            if (isFromWrapper) {
                if (genericType instanceof Class && ((Class)genericType).isArray()) {
                    Class cl2 = genericType;
                    if (cl2.isArray() && !Byte.TYPE.equals(cl2.getComponentType())) {
                        genericType = cl2.getComponentType();
                    }
                    this.addType(genericType);
                } else if (!isList) {
                    this.addType(genericType);
                }
            } else {
                this.addType(genericType, true);
            }
            if (isList && genericType instanceof ParameterizedType) {
                ParameterizedType pt = (ParameterizedType)((Object)genericType);
                if (pt.getActualTypeArguments().length > 0 && pt.getActualTypeArguments()[0] instanceof Class) {
                    Class<?> arrayCls = Array.newInstance((Class)pt.getActualTypeArguments()[0], 0).getClass();
                    clazz = arrayCls;
                    if (isLoggableFinest) {
                        LOG.finest("begin: Setting typeclass 1 to : " + (clazz != null ? clazz.getName() : "null"));
                    }
                    part.setTypeClass(clazz);
                    if (isFromWrapper) {
                        this.addType(clazz.getComponentType(), true);
                    }
                } else if (pt.getActualTypeArguments().length > 0 && pt.getActualTypeArguments()[0] instanceof GenericArrayType) {
                    GenericArrayType gat = (GenericArrayType)pt.getActualTypeArguments()[0];
                    gat.getGenericComponentType();
                    Class<?> arrayCls = Array.newInstance((Class)gat.getGenericComponentType(), 0).getClass();
                    clazz = Array.newInstance(arrayCls, 0).getClass();
                    if (isLoggableFinest) {
                        LOG.finest("begin: Setting typeclass 2 to : " + (clazz != null ? clazz.getName() : "null"));
                    }
                    part.setTypeClass(clazz);
                    if (isFromWrapper) {
                        this.addType(clazz.getComponentType(), true);
                    }
                }
            }
            if (isFromWrapper && isList) {
                clazz = null;
            }
        }
        if (clazz != null) {
            Object ref;
            if (!isFromWrapper && clazz.getAnnotation(XmlRootElement.class) == null && clazz.getAnnotation(XmlType.class) != null && StringUtils.isEmpty((String)clazz.getAnnotation(XmlType.class).name()) && (ref = JAXBContextInitializer.createTypeReference(part.getName(), clazz)) != null) {
                this.typeReferences.add(ref);
            }
            if (isLoggableFinest) {
                LOG.finest("begin: addClass: " + (clazz != null ? clazz.getName() : "null"));
            }
            this.addClass(clazz);
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "begin");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void checkForAdapter(Class<?> clazz, Annotation[] anns) {
        XmlJavaTypeAdapters adapt;
        Type t;
        XmlJavaTypeAdapter xjta;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBContextInitializer", "checkForAdapter", new Object[]{clazz, anns});
        }
        if (anns != null) {
            for (Annotation a : anns) {
                Type t2;
                if (!XmlJavaTypeAdapter.class.isAssignableFrom(a.annotationType()) || (t2 = Utils.getTypeFromXmlAdapter((XmlJavaTypeAdapter)a)) == null) continue;
                this.addType(t2);
            }
        }
        if ((xjta = clazz.getAnnotation(XmlJavaTypeAdapter.class)) != null && (t = Utils.getTypeFromXmlAdapter(xjta)) != null) {
            this.addType(t);
        }
        if (clazz.getPackage() != null && (adapt = clazz.getPackage().getAnnotation(XmlJavaTypeAdapters.class)) != null) {
            for (XmlJavaTypeAdapter a : adapt.value()) {
                this.globalAdapters.add(a.type());
            }
            for (XmlJavaTypeAdapter a : adapt.value()) {
                Type t3 = Utils.getTypeFromXmlAdapter(a);
                if (t3 == null) continue;
                this.addType(t3);
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "checkForAdapter");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addType(Type cls) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBContextInitializer", "addType", new Object[]{cls});
        }
        this.addType(cls, false);
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "addType");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void addType(Type cls, boolean allowArray) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBContextInitializer", "addType", new Object[]{cls, allowArray});
        }
        if (cls instanceof Class) {
            if (this.globalAdapters.contains(cls)) {
                if (LOG == null || !LOG.isLoggable(Level.FINER)) return;
                LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "addType");
                return;
            }
            if (((Class)cls).isArray() && !allowArray) {
                this.addClass(((Class)cls).getComponentType());
            } else {
                this.addClass((Class)cls);
            }
        } else if (cls instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)cls;
            this.addType(parameterizedType.getRawType());
            if (!parameterizedType.getRawType().equals(Enum.class)) {
                for (Type t2 : parameterizedType.getActualTypeArguments()) {
                    if (!this.shouldTypeBeAdded(t2, parameterizedType)) continue;
                    this.addType(t2);
                }
            }
        } else if (cls instanceof GenericArrayType) {
            Class ct;
            GenericArrayType gt = (GenericArrayType)cls;
            Type componentType = gt.getGenericComponentType();
            if (componentType instanceof Class) {
                ct = (Class)componentType;
            } else if (componentType instanceof ParameterizedType) {
                ParameterizedType parameterizedType = (ParameterizedType)componentType;
                Type rawType = parameterizedType.getRawType();
                if (!(rawType instanceof Class)) {
                    throw new IllegalArgumentException("Unable to determine type for " + rawType);
                }
                ct = (Class)rawType;
                if (!parameterizedType.getRawType().equals(Enum.class)) {
                    for (Type t2 : parameterizedType.getActualTypeArguments()) {
                        if (!this.shouldTypeBeAdded(t2, parameterizedType)) continue;
                        this.addType(t2);
                    }
                }
            } else {
                TypeVariable tv = (TypeVariable)componentType;
                Type[] bounds = tv.getBounds();
                if (bounds == null || bounds.length != 1) throw new IllegalArgumentException("Unable to determine type for: " + tv);
                if (!(bounds[0] instanceof Class)) throw new IllegalArgumentException("Unable to determine type for: " + tv);
                ct = (Class)bounds[0];
            }
            ct = Array.newInstance(ct, 0).getClass();
            this.addClass(ct);
        } else if (cls instanceof WildcardType) {
            for (Type t : ((WildcardType)cls).getUpperBounds()) {
                this.addType(t);
            }
            for (Type t : ((WildcardType)cls).getLowerBounds()) {
                this.addType(t);
            }
        } else if (cls instanceof TypeVariable) {
            for (Type t : ((TypeVariable)cls).getBounds()) {
                this.addType(t);
            }
        }
        if (LOG == null || !LOG.isLoggable(Level.FINER)) return;
        LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "addType");
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private boolean shouldTypeBeAdded(Type t2, ParameterizedType parameterizedType) {
        Type[] bounds;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBContextInitializer", "shouldTypeBeAdded", new Object[]{t2, parameterizedType});
        }
        if (!(t2 instanceof TypeVariable)) {
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "shouldTypeBeAdded", bl);
            }
            return bl;
        }
        TypeVariable typeVariable = (TypeVariable)t2;
        for (Type bound : bounds = typeVariable.getBounds()) {
            if (!(bound instanceof ParameterizedType) || !bound.equals(parameterizedType)) continue;
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "shouldTypeBeAdded", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "shouldTypeBeAdded", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    void addClass(Class<?> claz) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBContextInitializer", "addClass", new Object[]{claz});
        }
        if (Throwable.class.isAssignableFrom(claz)) {
            if (!Throwable.class.equals(claz) && !Exception.class.equals(claz)) {
                this.walkReferences(claz);
            }
            this.addClass(String.class);
        } else {
            if (claz.getName().startsWith("java.") || claz.getName().startsWith("javax.") || claz.getName().startsWith("jakarta.")) {
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "addClass");
                }
                return;
            }
            Class<?> cls = JAXBUtils.getValidClass(claz);
            if (cls == null && ReflectionUtil.getDeclaredConstructors(claz).length > 0 && !Modifier.isAbstract(claz.getModifiers())) {
                if (LOG.isLoggable(Level.FINEST)) {
                    LOG.finest("Class " + claz.getName() + " does not have a default constructor which JAXB requires.");
                }
                Object factory = this.createFactory(claz);
                this.unmarshallerProperties.put("com.sun.xml.bind.ObjectFactory", factory);
                cls = claz;
            }
            if (null != cls) {
                XmlJavaTypeAdapter xjta;
                XmlSeeAlso xsa;
                if (this.classes.contains(cls)) {
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "addClass");
                    }
                    return;
                }
                if (!cls.isInterface()) {
                    this.classes.add(cls);
                }
                if ((xsa = cls.getAnnotation(XmlSeeAlso.class)) != null) {
                    for (Class c : xsa.value()) {
                        this.addClass(c);
                    }
                }
                if ((xjta = cls.getAnnotation(XmlJavaTypeAdapter.class)) != null) {
                    Type t = Utils.getTypeFromXmlAdapter(xjta);
                    if (t != null) {
                        this.addType(t);
                    }
                    if (LOG != null && LOG.isLoggable(Level.FINER)) {
                        LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "addClass");
                    }
                    return;
                }
                if (cls.getSuperclass() != null) {
                    this.addClass(cls.getSuperclass());
                }
                if (!cls.isInterface()) {
                    this.walkReferences(cls);
                }
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "addClass");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private void walkReferences(Class<?> cls) {
        Type t;
        XmlJavaTypeAdapter xjta;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBContextInitializer", "walkReferences", new Object[]{cls});
        }
        if (cls == null) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "walkReferences");
            }
            return;
        }
        if (cls.getName().startsWith("java.") || cls.getName().startsWith("javax.") || cls.getName().startsWith("jakarta.")) {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "walkReferences");
            }
            return;
        }
        XmlAccessType accessType = Utils.getXmlAccessType(cls);
        if (accessType != XmlAccessType.PROPERTY) {
            Field[] fields = ReflectionUtil.getDeclaredFields(cls);
            for (AccessibleObject accessibleObject : fields) {
                if (!JAXBContextInitializer.isFieldAccepted((Field)accessibleObject, accessType)) continue;
                xjta = Utils.getFieldXJTA((Field)accessibleObject);
                if (xjta != null && (t = Utils.getTypeFromXmlAdapter(xjta)) != null) {
                    this.addType(t);
                    continue;
                }
                this.addType(((Field)accessibleObject).getGenericType());
            }
            this.walkReferences(cls.getSuperclass());
        }
        if (accessType != XmlAccessType.FIELD) {
            Method[] methods = ReflectionUtil.getDeclaredMethods(cls);
            for (AccessibleObject accessibleObject : methods) {
                if (!JAXBContextInitializer.isMethodAccepted((Method)accessibleObject, accessType)) continue;
                xjta = Utils.getMethodXJTA((Method)accessibleObject);
                if (xjta != null && (t = Utils.getTypeFromXmlAdapter(xjta)) != null) {
                    this.addType(t);
                    continue;
                }
                this.addType(((Method)accessibleObject).getGenericReturnType());
                for (Type t2 : ((Method)accessibleObject).getGenericParameterTypes()) {
                    this.addType(t2);
                }
            }
        }
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "walkReferences");
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static boolean isFieldAccepted(Field field, XmlAccessType accessType) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBContextInitializer", "isFieldAccepted", new Object[]{field, accessType});
        }
        if (field.isAnnotationPresent(XmlTransient.class) || Modifier.isTransient(field.getModifiers())) {
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "isFieldAccepted", bl);
            }
            return bl;
        }
        if (Modifier.isStatic(field.getModifiers())) {
            boolean bl = field.isAnnotationPresent(XmlAttribute.class);
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "isFieldAccepted", bl);
            }
            return bl;
        }
        if (accessType == XmlAccessType.PUBLIC_MEMBER && !Modifier.isPublic(field.getModifiers())) {
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "isFieldAccepted", bl);
            }
            return bl;
        }
        if (accessType == XmlAccessType.NONE || accessType == XmlAccessType.PROPERTY) {
            boolean bl = JAXBContextInitializer.checkJaxbAnnotation(field.getAnnotations());
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "isFieldAccepted", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "isFieldAccepted", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static boolean isMethodAccepted(Method method, XmlAccessType accessType) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBContextInitializer", "isMethodAccepted", new Object[]{method, accessType});
        }
        if (Modifier.isStatic(method.getModifiers()) || method.isAnnotationPresent(XmlTransient.class) || !Modifier.isPublic(method.getModifiers()) || "getClass".equals(method.getName())) {
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "isMethodAccepted", bl);
            }
            return bl;
        }
        if (method.getReturnType() == Void.class || method.getReturnType() == Void.TYPE || method.getParameterTypes().length != 0 || method.getDeclaringClass().equals(Throwable.class) && !"getMessage".equals(method.getName()) || !method.getName().startsWith("get") && !method.getName().startsWith("is")) {
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "isMethodAccepted", bl);
            }
            return bl;
        }
        int beginIndex = 3;
        if (method.getName().startsWith("is")) {
            beginIndex = 2;
        }
        AccessibleObject setter = null;
        try {
            setter = method.getDeclaringClass().getMethod("set" + method.getName().substring(beginIndex), method.getReturnType());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (setter != null) {
            if (setter.isAnnotationPresent(XmlTransient.class) || !Modifier.isPublic(((Method)setter).getModifiers())) {
                boolean bl = false;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    bl = bl;
                    LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "isMethodAccepted", bl);
                }
                return bl;
            }
        } else if (!Collection.class.isAssignableFrom(method.getReturnType()) && !Throwable.class.isAssignableFrom(method.getDeclaringClass())) {
            boolean bl = false;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "isMethodAccepted", bl);
            }
            return bl;
        }
        if (accessType == XmlAccessType.NONE || accessType == XmlAccessType.FIELD) {
            boolean bl = JAXBContextInitializer.checkJaxbAnnotation(method.getAnnotations());
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "isMethodAccepted", bl);
            }
            return bl;
        }
        boolean bl = true;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "isMethodAccepted", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    static boolean checkJaxbAnnotation(Annotation[] annotations) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBContextInitializer", "checkJaxbAnnotation", new Object[]{annotations});
        }
        Package jaxbAnnotationsPackage = XmlElement.class.getPackage();
        for (Annotation annotation : annotations) {
            if (annotation.annotationType().getPackage() != jaxbAnnotationsPackage) continue;
            boolean bl = true;
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                bl = bl;
                LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "checkJaxbAnnotation", bl);
            }
            return bl;
        }
        boolean bl = false;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            bl = bl;
            LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "checkJaxbAnnotation", bl);
        }
        return bl;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private static Object createTypeReference(QName n, Class<?> cls) {
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            LOG.entering("org.apache.cxf.jaxb.JAXBContextInitializer", "createTypeReference", new Object[]{n, cls});
        }
        Class refClass = null;
        try {
            refClass = ClassLoaderUtils.loadClass((String)"com.sun.xml.bind.api.TypeReference", JAXBContextInitializer.class);
        }
        catch (Throwable ex) {
            try {
                refClass = ClassLoaderUtils.loadClass((String)"com.sun.xml.internal.bind.api.TypeReference", JAXBContextInitializer.class);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (refClass != null) {
            Object t;
            block9: {
                try {
                    t = refClass.getConstructor(QName.class, Type.class, new Annotation[0].getClass()).newInstance(n, cls, new Annotation[0]);
                    if (LOG == null || !LOG.isLoggable(Level.FINER)) break block9;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                t = t;
                LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "createTypeReference", t);
            }
            return t;
        }
        Object v1 = null;
        if (LOG != null && LOG.isLoggable(Level.FINER)) {
            v1 = v1;
            LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "createTypeReference", v1);
        }
        return v1;
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.JSR47TracingMethodAdapter"})
    private Object createFactory(Class<?> cls) {
        Object obj;
        block4: {
            if (LOG != null && LOG.isLoggable(Level.FINER)) {
                LOG.entering("org.apache.cxf.jaxb.JAXBContextInitializer", "createFactory", new Object[]{cls});
            }
            FactoryClassCreator creator = (FactoryClassCreator)this.bus.getExtension(FactoryClassCreator.class);
            Class<?> factoryClass = creator.createFactory(cls);
            try {
                obj = factoryClass.newInstance();
                if (LOG == null || !LOG.isLoggable(Level.FINER)) break block4;
            }
            catch (Exception exception) {
                Object v1 = null;
                if (LOG != null && LOG.isLoggable(Level.FINER)) {
                    v1 = v1;
                    LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "createFactory", v1);
                }
                return v1;
            }
            obj = obj;
            LOG.exiting("org.apache.cxf.jaxb.JAXBContextInitializer", "createFactory", obj);
        }
        return obj;
    }
}

