/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions.remote;

import java.util.Map;
import org.eclipse.persistence.indirection.IndirectContainer;
import org.eclipse.persistence.indirection.ValueHolderInterface;
import org.eclipse.persistence.internal.descriptors.DescriptorIterator;
import org.eclipse.persistence.internal.indirection.UnitOfWorkValueHolder;
import org.eclipse.persistence.internal.sessions.remote.ObjectDescriptor;
import org.eclipse.persistence.internal.sessions.remote.RemoteSessionController;
import org.eclipse.persistence.internal.sessions.remote.RemoteValueHolder;
import org.eclipse.persistence.mappings.ObjectReferenceMapping;

public class ReplaceValueHoldersIterator
extends DescriptorIterator {
    RemoteSessionController controller;

    private ReplaceValueHoldersIterator() {
    }

    public ReplaceValueHoldersIterator(RemoteSessionController controller) {
        this();
        this.initialize(controller);
    }

    protected ObjectDescriptor buildObjectDescriptor(Object object) {
        return this.controller.buildObjectDescriptor(object);
    }

    protected RemoteValueHolder buildRemoteValueHolderFor(ValueHolderInterface valueHolder) {
        RemoteValueHolder remoteValueHolder = null;
        if (valueHolder instanceof RemoteValueHolder) {
            remoteValueHolder = (RemoteValueHolder)valueHolder;
        } else {
            if (valueHolder instanceof UnitOfWorkValueHolder && ((UnitOfWorkValueHolder)valueHolder).getWrappedValueHolder() instanceof RemoteValueHolder) {
                return (RemoteValueHolder)((UnitOfWorkValueHolder)valueHolder).getWrappedValueHolder();
            }
            remoteValueHolder = new RemoteValueHolder();
            remoteValueHolder.setWrappedServerValueHolder(valueHolder);
            remoteValueHolder.setMapping(this.getCurrentMapping());
        }
        this.saveRemoteValueHolder(remoteValueHolder);
        return remoteValueHolder;
    }

    protected void initialize(RemoteSessionController controller) {
        this.controller = controller;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalIterateIndirectContainer(IndirectContainer container) {
        ValueHolderInterface<Object> containedValueHolder = container.getValueHolder();
        if (containedValueHolder instanceof RemoteValueHolder) {
            containedValueHolder = ((RemoteValueHolder)containedValueHolder).getWrappedServerValueHolder();
        }
        ValueHolderInterface valueHolderInterface = containedValueHolder;
        synchronized (valueHolderInterface) {
            ValueHolderInterface valueHolder = container.getValueHolder();
            RemoteValueHolder remoteValueHolder = this.buildRemoteValueHolderFor(valueHolder);
            container.setValueHolder(remoteValueHolder);
            remoteValueHolder.setServerIndirectionObject(container);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void internalIterateValueHolder(ValueHolderInterface originalValueHolder) {
        ValueHolderInterface<Object> rootValueHolder = originalValueHolder;
        if (rootValueHolder instanceof RemoteValueHolder) {
            rootValueHolder = ((RemoteValueHolder)rootValueHolder).getWrappedServerValueHolder();
        }
        ValueHolderInterface<Object> valueHolderInterface = rootValueHolder;
        synchronized (valueHolderInterface) {
            ValueHolderInterface valueHolder = (ValueHolderInterface)this.getCurrentMapping().getAttributeValueFromObject(this.getVisitedParent());
            RemoteValueHolder remoteValueHolder = this.buildRemoteValueHolderFor(valueHolder);
            if (valueHolder != remoteValueHolder) {
                if (this.getCurrentMapping().isOneToOneMapping()) {
                    this.setOneToOneMappingSettingsIn(remoteValueHolder);
                }
                this.getCurrentMapping().setAttributeValueInObject(this.getVisitedParent(), remoteValueHolder);
            }
        }
    }

    @Override
    protected void iterate(Object object) {
        ((Map)this.getResult()).put(object, this.buildObjectDescriptor(object));
    }

    protected void saveRemoteValueHolder(RemoteValueHolder remoteValueHolder) {
        this.controller.saveRemoteValueHolder(remoteValueHolder);
    }

    protected void setOneToOneMappingSettingsIn(RemoteValueHolder remoteValueHolder) {
        ObjectReferenceMapping oneToOneMapping = (ObjectReferenceMapping)this.getCurrentMapping();
        if (oneToOneMapping.getDescriptor().getObjectBuilder().isPrimaryKeyMapping(oneToOneMapping)) {
            remoteValueHolder.setRow(oneToOneMapping.extractPrimaryKeyRowForSourceObject(this.getVisitedParent(), this.getSession()));
        }
        remoteValueHolder.setTargetObjectPrimaryKeys(oneToOneMapping.extractPrimaryKeysForReferenceObject(this.getVisitedParent(), this.getSession()));
    }
}

