/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.oauth20.web;

import com.google.gson.JsonArray;
import com.ibm.oauth.core.api.OAuthResult;
import com.ibm.oauth.core.api.attributes.AttributeList;
import com.ibm.oauth.core.api.error.OAuthException;
import com.ibm.oauth.core.api.error.OidcServerException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20BadParameterFormatException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20DuplicateParameterException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20Exception;
import com.ibm.oauth.core.api.error.oauth20.OAuth20InvalidClientException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20InvalidGrantTypeException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20InvalidRedirectUriException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20InvalidResponseTypeException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20InvalidScopeException;
import com.ibm.oauth.core.api.error.oauth20.OAuth20MissingParameterException;
import com.ibm.oauth.core.internal.oauth20.OAuth20Util;
import com.ibm.oauth.core.internal.oauth20.OAuthResultImpl;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.oauth20.api.OAuth20Provider;
import com.ibm.ws.security.oauth20.api.OidcOAuth20Client;
import com.ibm.ws.security.oauth20.api.OidcOAuth20ClientProvider;
import com.ibm.ws.security.oauth20.exception.OAuth20BadParameterException;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClient;
import com.ibm.ws.security.oauth20.plugins.OidcBaseClientScopeReducer;
import com.ibm.ws.security.oauth20.util.OAuth20ProviderUtils;
import com.ibm.ws.security.oauth20.util.OidcOAuth20Util;
import com.ibm.ws.security.oauth20.web.WebUtils;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.security.Principal;
import java.util.Arrays;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class ClientAuthorization {
    private static TraceComponent tc = Tr.register(ClientAuthorization.class, (String)"OAUTH", (String)"com.ibm.ws.security.oauth20.internal.resources.OAuthMessages");
    private static final Set<String> requiredAttributes = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("client_id", "client_secret", "response_type", "state", "scope")));
    static final long serialVersionUID = 3786780699358912780L;

    /*
     * WARNING - void declaration
     */
    public OAuthResult validateAuthorization(OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response) throws OidcServerException {
        OAuthResult retVal = null;
        AttributeList attrList = new AttributeList();
        OidcBaseClient client = null;
        String grantType = null;
        try {
            this.validateUsername(request, attrList);
            String[] stateParams = request.getParameterValues("state");
            if (stateParams != null) {
                attrList.setAttribute("state", "urn:ibm:names:query:param", stateParams);
            }
            client = this.validateClientId(request, attrList, provider);
            String clientId = client.getClientId();
            this.validateRedirectUri(request, attrList, client);
            String responseType = this.validateResponseTypeAndReturn(request, provider, clientId);
            grantType = this.getRequestedGrantType(request, responseType);
            this.validateGrantTypes(provider, request, clientId, responseType);
            if (!this.isValidResponseTypeForAuthorizationCodeGrantType(responseType, grantType) && !this.isValidResponseTypeForImplicitGrantType(responseType, grantType)) {
                throw new OAuth20InvalidResponseTypeException("security.oauth20.error.invalid.responsetype", responseType);
            }
            attrList.setAttribute("response_type", "urn:ibm:names:query:param", new String[]{responseType});
            if (stateParams != null && stateParams.length > 1) {
                throw new OAuth20DuplicateParameterException("security.oauth20.error.duplicate.parameter", "state");
            }
            this.validateScopes(request, attrList, client, clientId);
        }
        catch (OAuth20Exception stateParams) {
            void e;
            FFDCFilter.processException((Throwable)stateParams, (String)"com.ibm.ws.security.oauth20.web.ClientAuthorization", (String)"115", (Object)this, (Object[])new Object[]{provider, request, response});
            retVal = new OAuthResultImpl(1, attrList, (OAuthException)e);
        }
        if (retVal == null) {
            retVal = this.validateMisc(request, client, grantType, attrList);
        }
        return retVal;
    }

    @FFDCIgnore(value={OAuth20BadParameterException.class})
    public OAuthResult validateMisc(HttpServletRequest request, OidcBaseClient client, String grantType, AttributeList attrList) throws OidcServerException {
        try {
            if ("implicit".equals(grantType)) {
                OAuth20ProviderUtils.validateResource(request, attrList, client);
            }
            Enumeration e = request.getParameterNames();
            while (e.hasMoreElements()) {
                String name = (String)e.nextElement();
                if (requiredAttributes.contains(name)) continue;
                attrList.setAttribute(name, "urn:ibm:names:oauth:request", request.getParameterValues(name));
            }
        }
        catch (OAuth20BadParameterException e) {
            WebUtils.throwOidcServerException(request, e);
        }
        return new OAuthResultImpl(0, attrList);
    }

    private void validateUsername(HttpServletRequest request, AttributeList attrList) {
        Principal principal = request.getUserPrincipal();
        String username = principal == null ? null : principal.getName();
        attrList.setAttribute("username", "urn:ibm:names:oauth:request", new String[]{username});
    }

    private OidcBaseClient validateClientId(HttpServletRequest request, AttributeList attrList, OAuth20Provider provider) throws OAuth20Exception {
        String[] clientIdParams = request.getParameterValues("client_id");
        if (clientIdParams == null) {
            throw new OAuth20MissingParameterException("security.oauth20.error.missing.parameter", "client_id", null);
        }
        attrList.setAttribute("client_id", "urn:ibm:names:query:param", clientIdParams);
        if (clientIdParams.length > 1) {
            throw new OAuth20DuplicateParameterException("security.oauth20.error.duplicate.parameter", "client_id");
        }
        String clientId = clientIdParams[0];
        if (clientId == null || clientId.length() == 0) {
            throw new OAuth20MissingParameterException("security.oauth20.error.missing.parameter", "client_id", null);
        }
        OidcBaseClient client = OAuth20ProviderUtils.getOidcOAuth20Client(provider, clientId);
        if (client == null || !client.isEnabled()) {
            throw new OAuth20InvalidClientException("security.oauth20.error.invalid.client", clientId, false);
        }
        return client;
    }

    private void validateRegisteredRedirectUri(AttributeList attrList, JsonArray registeredUris, OidcBaseClient client) throws OAuth20Exception {
        if (registeredUris == null || registeredUris.size() != 1 || client.getAllowRegexpRedirects()) {
            throw new OAuth20MissingParameterException("security.oauth20.error.missing.parameter", "redirect_uri", null);
        }
        if (!OidcOAuth20Util.validateRedirectUris(registeredUris, false)) {
            throw new OAuth20InvalidRedirectUriException("security.oauth20.error.invalid.registered.redirecturi", OidcOAuth20Util.getSpaceDelimitedString(registeredUris), null);
        }
        String[] registeredRedirectUri = new String[]{registeredUris.get(0).getAsString()};
        attrList.setAttribute("redirect_uri", "urn:ibm:names:query:param", registeredRedirectUri);
    }

    private void validateRedirectUri(HttpServletRequest request, AttributeList attrList, OidcBaseClient client) throws OAuth20Exception {
        String[] redirectUriParams = request.getParameterValues("redirect_uri");
        if (redirectUriParams != null) {
            attrList.setAttribute("redirect_uri", "urn:ibm:names:query:param", redirectUriParams);
        }
        if (redirectUriParams != null && redirectUriParams.length > 1) {
            throw new OAuth20DuplicateParameterException("security.oauth20.error.duplicate.parameter", "redirect_uri");
        }
        String redirectUri = redirectUriParams == null ? null : redirectUriParams[0];
        JsonArray registeredUris = client.getRedirectUris();
        if (redirectUri == null || redirectUri.length() == 0) {
            this.validateRegisteredRedirectUri(attrList, registeredUris, client);
        } else {
            if (!OAuth20Util.validateRedirectUri(redirectUri)) {
                throw new OAuth20InvalidRedirectUriException("security.oauth20.error.invalid.redirecturi", redirectUri, null);
            }
            if (registeredUris == null || registeredUris.size() == 0 || !OidcOAuth20Util.jsonArrayContainsString(registeredUris, redirectUri, client.getAllowRegexpRedirects())) {
                throw new OAuth20InvalidRedirectUriException("security.oauth20.error.invalid.redirecturi.mismatch", redirectUri, OidcOAuth20Util.getSpaceDelimitedString(registeredUris), null);
            }
        }
    }

    private void validateScopes(HttpServletRequest request, AttributeList attrList, OidcBaseClient client, String clientId) throws OAuth20Exception {
        String[] scopes;
        if (request.getAttribute("OidcRequest") != null) {
            this.checkForMissingScopeInTheRequest(request);
            this.checkForEmptyRegisteredScopeSet(client, clientId);
        }
        if ((scopes = this.getReducedScopes(client, request, clientId, true)) != null) {
            attrList.setAttribute("scope", "urn:ibm:names:oauth:request", scopes);
        }
    }

    protected boolean isValidResponseTypeForAuthorizationCodeGrantType(String responseType, String grantType) {
        if (responseType == null || grantType == null) {
            return false;
        }
        return "code".equals(responseType) && grantType.equals("authorization_code");
    }

    protected boolean isValidResponseTypeForImplicitGrantType(String responseType, String grantType) {
        String[] rtParts;
        if (responseType == null || grantType == null) {
            return false;
        }
        boolean containsValidRt = false;
        for (String rt : rtParts = responseType.split(" ")) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Checking individual response type: " + rt), (Object[])new Object[0]);
            }
            if (!rt.equals("token") && !rt.equals("id_token")) continue;
            containsValidRt = true;
            break;
        }
        return containsValidRt && grantType.equals("implicit");
    }

    protected void checkForEmptyRegisteredScopeSet(OidcBaseClient client, String clientId) throws OAuth20InvalidScopeException {
        String registeredScopes;
        if (client != null && ((registeredScopes = client.getScope()) == null || registeredScopes.trim().length() == 0)) {
            throw new OAuth20InvalidScopeException("security.oauth20.error.missing.registered.scope", null, clientId);
        }
    }

    protected void checkForMissingScopeInTheRequest(HttpServletRequest request) throws OAuth20InvalidScopeException {
        String[] scopeParams = request.getParameterValues("scope");
        if (scopeParams == null) {
            throw new OAuth20InvalidScopeException("security.oauth20.error.missing.scope", "OpenID Connect request");
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("IDC Request scopeParams:" + OAuth20Util.arrayToSpaceString(scopeParams)), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - void declaration
     */
    public OAuthResult validateAndHandle2LegsScope(OAuth20Provider provider, HttpServletRequest request, HttpServletResponse response, String clientId) {
        AttributeList attrList = new AttributeList();
        OAuthResultImpl retVal = new OAuthResultImpl(0, attrList);
        try {
            OidcBaseClient client;
            String grantType;
            String[] grantTypeParams = request.getParameterValues("grant_type");
            if (!this.validateGrantTypes(provider, request, clientId)) {
                throw new OAuth20InvalidGrantTypeException("security.oauth20.error.invalid.granttype", grantTypeParams[0]);
            }
            String string = grantType = grantTypeParams == null ? null : grantTypeParams[0];
            if (!("client_credentials".equals(grantType) || "urn:ietf:params:oauth:grant-type:jwt-bearer".equals(grantType) || "password".equals(grantType))) {
                return retVal;
            }
            if (request.getAttribute("OidcRequest") == null) {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"This is an OAuth20 request", (Object[])new Object[0]);
                }
                attrList.setAttribute("request_feature", "urn:ibm:names:oauth:param:request", new String[]{"oauth2"});
                if ("client_credentials".equals(grantType) || "password".equals(grantType)) {
                    String[] scopeParams;
                    if (tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)"Since this is OAuth20 request, client_credetinals and resource_owner will go back to the old behavior", (Object[])new Object[0]);
                    }
                    if ((scopeParams = request.getParameterValues("scope")) != null && scopeParams.length > 1) {
                        throw new OAuth20DuplicateParameterException("security.oauth20.error.duplicate.parameter", "scope");
                    }
                    if (scopeParams != null && scopeParams.length == 1) {
                        String scopeStr = scopeParams[0];
                        String[] scopes = scopeStr.split(" ");
                        attrList.setAttribute("scope", "urn:ibm:names:oauth:param:request", this.getUniqueArray(scopes));
                        request.setAttribute("urn:ibm:names:oauth:param:request", (Object)attrList);
                    }
                    return retVal;
                }
            } else {
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"This is an OIDC request", (Object[])new Object[0]);
                }
                attrList.setAttribute("request_feature", "urn:ibm:names:oauth:param:request", new String[]{"oidc"});
                this.checkForMissingScopeInTheRequest(request);
            }
            if ((client = OAuth20ProviderUtils.getOidcOAuth20Client(provider, clientId)) == null) {
                throw new OAuth20InvalidClientException("security.oauth20.error.invalid.client", clientId, false);
            }
            String[] reducedScopes = this.getReducedScopes(client, request, clientId, false);
            this.checkForEmptyScopeList(reducedScopes, request, client, clientId);
            if (this.isClientAutoAuthorized(provider, request, clientId)) {
                attrList.setAttribute("scope", "urn:ibm:names:oauth:param:request", this.getUniqueArray(reducedScopes));
                request.setAttribute("urn:ibm:names:oauth:param:request", (Object)attrList);
            } else {
                String preAuthzScopes = client.getPreAuthorizedScope();
                if (preAuthzScopes == null || preAuthzScopes.isEmpty()) {
                    Tr.error((TraceComponent)tc, (String)"JWT_SERVER_NO_PRE_AUTHORIZED_SCOPE_ERR", (Object[])new Object[]{clientId});
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_SERVER_NO_PRE_AUTHORIZED_SCOPE_ERR", (Object[])new Object[]{clientId});
                    throw new OAuth20Exception("invalid_scope", msg, null);
                }
                OidcBaseClientScopeReducer reducer = new OidcBaseClientScopeReducer(client);
                for (int i = 0; i < reducedScopes.length; ++i) {
                    String scope = reducedScopes[i];
                    if (scope == null || scope.length() <= 0 || reducer.hasClientPreAuthorizedScope(scope)) continue;
                    Tr.error((TraceComponent)tc, (String)"JWT_SERVER_SCOPE_NOT_PRE_AUTHORIZED_ERR", (Object[])new Object[]{scope, clientId});
                    String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_SERVER_SCOPE_NOT_PRE_AUTHORIZED_EXTERNAL_ERR", (Object[])new Object[]{clientId});
                    throw new OAuth20Exception("invalid_scope", msg, null);
                }
                attrList.setAttribute("scope", "urn:ibm:names:oauth:param:request", reducedScopes);
                request.setAttribute("urn:ibm:names:oauth:param:request", (Object)attrList);
            }
        }
        catch (OAuth20Exception grantTypeParams) {
            void e;
            FFDCFilter.processException((Throwable)grantTypeParams, (String)"com.ibm.ws.security.oauth20.web.ClientAuthorization", (String)"451", (Object)this, (Object[])new Object[]{provider, request, response, clientId});
            retVal = new OAuthResultImpl(1, attrList, (OAuthException)e);
        }
        return retVal;
    }

    public String getRequestedScopes(HttpServletRequest request) {
        String[] scopeParams = request.getParameterValues("scope");
        if (scopeParams != null) {
            return scopeParams[0];
        }
        return null;
    }

    public boolean validateGrantTypes(OAuth20Provider provider, HttpServletRequest request, String clientId) throws OAuth20Exception {
        return this.validateGrantTypes(provider, request, clientId, null);
    }

    public boolean validateGrantTypes(OAuth20Provider provider, HttpServletRequest request, String clientId, String responseType) throws OAuth20Exception {
        String requestedGrantType = this.getRequestedGrantType(request, responseType);
        if (requestedGrantType == null) {
            return false;
        }
        boolean isGrantTypeValid = false;
        String[] grantTypes = requestedGrantType.split(" ");
        Set<String> reducedGrantTypes = this.getReducedGrantTypes(provider, clientId);
        for (int i = 0; i < grantTypes.length; ++i) {
            String gtype = grantTypes[i].trim();
            if (gtype == null || gtype.length() <= 0) continue;
            if (!this.isRequestedGrantTypeRegistered(gtype, reducedGrantTypes)) {
                throw new OAuth20InvalidGrantTypeException("security.oauth20.error.invalid.granttype", gtype);
            }
            isGrantTypeValid = true;
        }
        return isGrantTypeValid;
    }

    private Set<String> getRegisteredGrantTypes(OAuth20Provider provider, String clientId) throws OAuth20Exception {
        JsonArray arrayJson;
        OidcBaseClient client;
        OidcOAuth20ClientProvider clientProvider;
        HashSet<String> gtSet = new HashSet<String>();
        if (provider != null && (clientProvider = provider.getClientProvider()) != null && (client = clientProvider.get(clientId)) != null && (arrayJson = client.getGrantTypes()) != null) {
            for (int i = 0; i < arrayJson.size(); ++i) {
                gtSet.add(arrayJson.get(i).getAsString());
            }
        }
        return gtSet;
    }

    private Set<String> getGrantTypesAllowed(OAuth20Provider provider) throws OAuth20Exception {
        String[] grantTypes;
        HashSet<String> gtSet = new HashSet<String>();
        if (provider != null && (grantTypes = provider.getGrantTypesAllowed()) != null) {
            for (int i = 0; i < grantTypes.length; ++i) {
                gtSet.add(grantTypes[i].toString());
            }
        }
        return gtSet;
    }

    private Set<String> getSetIntersection(Set<String> set1, Set<String> set2) throws OAuth20Exception {
        HashSet<String> intersection = new HashSet<String>(set1);
        intersection.retainAll(set2);
        return intersection;
    }

    public Set<String> getReducedGrantTypes(OAuth20Provider provider, String clientId) throws OAuth20Exception {
        Set<String> registeredGrantTypes = this.getRegisteredGrantTypes(provider, clientId);
        Set<String> grantTypesAllowed = this.getGrantTypesAllowed(provider);
        return this.getSetIntersection(registeredGrantTypes, grantTypesAllowed);
    }

    private boolean isRequestedGrantTypeRegistered(String requested, Set<String> registered) {
        if (registered == null || registered.isEmpty()) {
            return true;
        }
        return registered.contains(requested);
    }

    public String[] getUniqueArray(String[] scopes) {
        HashSet<String> scopeSet = new HashSet<String>();
        for (int i = 0; scopes != null && i < scopes.length; ++i) {
            String scope = scopes[i];
            scopeSet.add(scope);
        }
        return scopeSet.toArray(new String[scopeSet.size()]);
    }

    public String[] getReducedScopes(OidcOAuth20Client client, HttpServletRequest request, String clientId, boolean isEmptyScopeSetAllowed) throws OAuth20Exception {
        String[] scopeParams = request.getParameterValues("scope");
        if (scopeParams != null && scopeParams.length > 1) {
            throw new OAuth20DuplicateParameterException("security.oauth20.error.duplicate.parameter", "scope");
        }
        if (scopeParams == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Scope parameter was not found", (Object[])new Object[0]);
            }
            return null;
        }
        OidcBaseClientScopeReducer reducer = null;
        if (client == null) {
            throw new OAuth20InvalidClientException("security.oauth20.error.invalid.client", clientId, false);
        }
        reducer = new OidcBaseClientScopeReducer((OidcBaseClient)client);
        String scopeStr = scopeParams[0];
        String[] scopes = scopeStr.split(" ");
        HashSet<String> scopeSet = new HashSet<String>();
        for (int i = 0; i < scopes.length; ++i) {
            String scope = scopes[i].trim();
            if (scope == null || scope.length() <= 0) continue;
            if (OAuth20Util.validateScopeString(scope)) {
                if (this.isScopeRegistered(reducer, scope, isEmptyScopeSetAllowed)) {
                    scopeSet.add(scope);
                    continue;
                }
                if (!tc.isDebugEnabled()) continue;
                Tr.debug((TraceComponent)tc, (String)("The requested scope [" + scope + "] is not registered and is therefore ignored."), (Object[])new Object[0]);
                continue;
            }
            throw new OAuth20BadParameterFormatException("security.oauth20.error.parameter.format", "scope", scope);
        }
        return scopeSet.toArray(new String[0]);
    }

    public String getRegisteredScopes(OidcOAuth20Client client) {
        if (client != null) {
            return client.getScope();
        }
        return null;
    }

    protected boolean urlsMatch(String a, String b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.equals(b)) {
            return true;
        }
        boolean result = false;
        if (a.startsWith("https:") && a.contains(":443/")) {
            a = a.replace(":443/", "/");
        }
        if (b.startsWith("https:") && b.contains(":443/")) {
            b = b.replace(":443/", "/");
        }
        if (a.startsWith("http:") && a.contains(":80/")) {
            a = a.replace(":80/", "/");
        }
        if (b.startsWith("http:") && b.contains(":80/")) {
            b = b.replace(":80/", "/");
        }
        result = a.equals(b);
        return result;
    }

    protected boolean isClientAutoAuthorized(OAuth20Provider provider, HttpServletRequest request) {
        String clientId = request.getParameter("client_id");
        return this.isClientAutoAuthorized(provider, request, clientId);
    }

    boolean isClientAutoAuthorized(OAuth20Provider provider, HttpServletRequest request, String clientId) {
        String[] allowedClients;
        String autoAuthzName = provider.getAutoAuthorizeParam();
        if (autoAuthzName == null || autoAuthzName.isEmpty()) {
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Auto authorize param configured, checking if set to true", (Object[])new Object[0]);
        }
        String autoAuthzValue = request.getParameter(autoAuthzName);
        boolean autoAuthorize = provider.isAutoAuthorize();
        if (!autoAuthorize && !"true".equalsIgnoreCase(autoAuthzValue)) {
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"Auto authorize param is true, loading automatically authorized clients", (Object[])new Object[0]);
        }
        if ((allowedClients = provider.getAutoAuthorizeClients()) == null || allowedClients.length < 1) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Authauthz param enabled but no allowed clients, strange to see an autoauthz request.", (Object[])new Object[0]);
            }
            return false;
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Checking if client [" + clientId + "] is automatically authorized"), (Object[])new Object[0]);
        }
        for (String client : allowedClients) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Checking against allowed client: " + client), (Object[])new Object[0]);
            }
            if (clientId == null || !clientId.equals(client)) continue;
            return true;
        }
        return false;
    }

    protected boolean isScopeRegistered(OidcBaseClientScopeReducer reducer, String scope, boolean isEmptyScopeSetAllowed) throws OAuth20Exception {
        boolean registered = false;
        if (reducer.isNullEmptyScope()) {
            registered = isEmptyScopeSetAllowed;
        } else if (reducer.hasClientScope(scope)) {
            registered = true;
        }
        return registered;
    }

    public boolean isPreAuthorizedScope(OAuth20Provider provider, String clientId, String[] scopes) throws OAuth20Exception {
        if (scopes == null || scopes.length == 0) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Null or no scopes provided", (Object[])new Object[0]);
            }
            return false;
        }
        if (provider == null) {
            return false;
        }
        OidcOAuth20ClientProvider clientProvider = provider.getClientProvider();
        if (clientProvider == null) {
            return false;
        }
        OidcBaseClient client = clientProvider.get(clientId);
        if (client == null) {
            throw new OAuth20InvalidClientException("security.oauth20.error.invalid.client", clientId, false);
        }
        String preAuthzScopes = client.getPreAuthorizedScope();
        if (preAuthzScopes == null || preAuthzScopes.isEmpty()) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No pre-authorized scopes found in the client configuration", (Object[])new Object[0]);
            }
            return false;
        }
        OidcBaseClientScopeReducer reducer = new OidcBaseClientScopeReducer(client);
        for (int i = 0; i < scopes.length; ++i) {
            String scope = scopes[i].trim();
            if (scope == null || scope.length() <= 0 || reducer.hasClientPreAuthorizedScope(scope)) continue;
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Scope [" + scope + "] was not a client pre-authorized scope"), (Object[])new Object[0]);
            }
            return false;
        }
        return true;
    }

    public Set<String> getRegisteredClientResponseTypes(OAuth20Provider provider, String clientId) throws OAuth20Exception {
        JsonArray arrayJson;
        OidcBaseClient client;
        OidcOAuth20ClientProvider clientProvider;
        HashSet<String> gtSet = new HashSet<String>();
        if (provider != null && (clientProvider = provider.getClientProvider()) != null && (client = clientProvider.get(clientId)) != null && (arrayJson = client.getResponseTypes()) != null) {
            for (int i = 0; i < arrayJson.size(); ++i) {
                gtSet.add(arrayJson.get(i).getAsString());
            }
        }
        return gtSet;
    }

    public String validateResponseTypeAndReturn(HttpServletRequest request, OAuth20Provider provider, String clientId) throws OAuth20Exception {
        String[] requestedResponseTypes;
        String[] responseTypeParams = request.getParameterValues("response_type");
        if (responseTypeParams == null) {
            throw new OAuth20MissingParameterException("security.oauth20.error.missing.parameter", "response_type", null);
        }
        if (responseTypeParams.length > 1) {
            throw new OAuth20DuplicateParameterException("security.oauth20.error.duplicate.parameter", "response_type");
        }
        String responseType = responseTypeParams[0];
        if (responseType == null || responseType.length() == 0) {
            throw new OAuth20MissingParameterException("security.oauth20.error.missing.parameter", "response_type", null);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Got response type from request: [" + responseType + "]"), (Object[])new Object[0]);
        }
        Set<String> clientResponseTypes = this.getRegisteredClientResponseTypes(provider, clientId);
        for (String reqResponseType : requestedResponseTypes = responseType.split(" ")) {
            Boolean found = false;
            for (String clientResponseType : clientResponseTypes) {
                String[] clientRtParts;
                if (tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Checking requested response type [" + reqResponseType + "] against registered response type: [" + clientResponseType + "]"), (Object[])new Object[0]);
                }
                for (String clientRt : clientRtParts = clientResponseType.split(" ")) {
                    if (!clientRt.equals(reqResponseType)) continue;
                    found = true;
                    break;
                }
                if (!found.booleanValue()) continue;
                break;
            }
            if (found.booleanValue()) continue;
            throw new OAuth20InvalidResponseTypeException("security.oauth20.error.invalid.responsetype", responseType);
        }
        return responseType;
    }

    public String getRequestedGrantType(HttpServletRequest request, String responseType) throws OAuth20Exception {
        String[] grantTypeParams = request.getParameterValues("grant_type");
        if (grantTypeParams == null) {
            if (responseType == null) {
                return "unknown";
            }
            if (responseType.equals("code")) {
                return "authorization_code";
            }
            if (this.isValidResponseTypeForImplicitGrantType(responseType, "implicit")) {
                return "implicit";
            }
            return "unknown";
        }
        if (grantTypeParams.length > 1) {
            Tr.error((TraceComponent)tc, (String)"JWT_SERVER_DUPLICATED_PARAMETERS_ERR", (Object[])new Object[]{"grant_type"});
            throw new OAuth20DuplicateParameterException("security.oauth20.error.duplicate.parameter", "grant_type");
        }
        return grantTypeParams[0];
    }

    /*
     * WARNING - void declaration
     */
    public OAuthResult checkForEmptyScopeSetAfterConsent(String[] scopes, OAuthResult oauthResult, HttpServletRequest request, OAuth20Provider provider, String clientId) {
        try {
            OidcBaseClient client = OAuth20ProviderUtils.getOidcOAuth20Client(provider, clientId);
            this.checkForEmptyScopeList(scopes, request, client, clientId);
        }
        catch (OAuth20Exception client) {
            void oe;
            FFDCFilter.processException((Throwable)client, (String)"com.ibm.ws.security.oauth20.web.ClientAuthorization", (String)"985", (Object)this, (Object[])new Object[]{scopes, oauthResult, request, provider, clientId});
            if (oauthResult != null) {
                return new OAuthResultImpl(1, oauthResult.getAttributeList(), (OAuthException)oe);
            }
            return new OAuthResultImpl(1, new AttributeList(), (OAuthException)oe);
        }
        return oauthResult;
    }

    private void checkForEmptyScopeList(String[] scopes, HttpServletRequest request, OidcBaseClient client, String clientId) throws OAuth20Exception {
        if (scopes == null || scopes.length == 0) {
            String requestedScopeStr = this.getRequestedScopes(request);
            String[] requestedScopes = null;
            if (requestedScopeStr != null) {
                requestedScopes = requestedScopeStr.split(" ");
            }
            String registeredScopeStr = this.getRegisteredScopes(client);
            String[] registeredScopes = null;
            if (registeredScopeStr != null) {
                registeredScopes = registeredScopeStr.split(" ");
            }
            throw new OAuth20InvalidScopeException("security.oauth20.error.empty.scope", requestedScopes, registeredScopes, clientId);
        }
    }

    public String[] getReducedScopes(OAuth20Provider provider, HttpServletRequest request, String clientId, boolean isEmptyScopeSetAllowed) throws OAuth20Exception {
        OidcBaseClient client = OAuth20ProviderUtils.getOidcOAuth20Client(provider, clientId);
        return this.getReducedScopes(client, request, clientId, isEmptyScopeSetAllowed);
    }
}

