/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.util;

import com.ibm.ejs.ras.TraceNLS;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.TruncatableThrowable;
import com.ibm.ws.webcontainer.servlet.DefaultErrorReporter;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;

public class ApplicationErrorUtils {
    private static final TraceComponent tc = Tr.register(ApplicationErrorUtils.class, (String)"webcontainer", (String)"com.ibm.ws.webcontainer.resources.LShimMessages");
    private static final TraceNLS nls = TraceNLS.getTraceNLS(ApplicationErrorUtils.class, (String)"com.ibm.ws.webcontainer.resources.LShimMessages");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getTrimmedStackHtml(Throwable ex) {
        StringBuilder buffer = new StringBuilder();
        TruncatableThrowable niceException = new TruncatableThrowable(ex);
        String toolsLink = System.getProperty("was4d.error.page");
        boolean isAnonymous = toolsLink == null;
        BufferedReader reader = null;
        try {
            String errorHtml = !isAnonymous ? "pretty-error.html" : "minimal-error.html";
            reader = new BufferedReader(new InputStreamReader(ApplicationErrorUtils.class.getResourceAsStream(errorHtml), StandardCharsets.UTF_8));
            String line = reader.readLine();
            while (line != null) {
                if (line.contains("{toolsLink}")) {
                    line = line.replace("{toolsLink}", "http://" + toolsLink + "/");
                }
                buffer.append(line);
                buffer.append("\r\n");
                if (line.contains("id=\"box\"")) {
                    int keyIndex;
                    String linkCloser;
                    String linkOpener;
                    if (toolsLink != null) {
                        buffer.append("<div id=\"title\">Application Error</div>");
                    }
                    StackTraceElement topSte = niceException.getStackTraceEliminatingDuplicateFrames()[0];
                    String failingClassAndLine = topSte.getClassName() + "." + topSte.getMethodName() + "():" + topSte.getLineNumber();
                    if (toolsLink != null) {
                        linkOpener = "<a href=\"javascript:IDELink('" + failingClassAndLine + "')\">";
                        linkCloser = "</a>";
                    } else {
                        linkOpener = "";
                        linkCloser = "";
                    }
                    String key = "SRVE0777E";
                    String exceptionText = "";
                    String defaultString = "SRVE0777E: Exception thrown by application class ''{0}.{1}:{2}''\n{3}";
                    String formatted = nls.getFormattedMessage("SRVE0777E", new Object[]{linkOpener + topSte.getClassName(), topSte.getMethodName(), topSte.getLineNumber() + linkCloser, exceptionText}, defaultString);
                    if (isAnonymous && (keyIndex = formatted.indexOf("SRVE0777E")) >= 0) {
                        formatted = formatted.substring(keyIndex + "SRVE0777E".length() + 1);
                    }
                    buffer.append("\n<div id=\"error\">");
                    buffer.append(formatted);
                    buffer.append("</div>");
                    buffer.append("\n<div id=\"code\">");
                    ApplicationErrorUtils.printException(niceException, toolsLink, buffer);
                    buffer.append("\n</div>\n");
                }
                line = reader.readLine();
            }
        }
        catch (IOException iOException) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return buffer.toString();
    }

    private static void printException(TruncatableThrowable niceException, String toolsLink, StringBuilder buffer) {
        StackTraceElement[] trimmedStackTrace = niceException.getStackTraceEliminatingDuplicateFrames();
        String clazzName = niceException.getWrappedException().getClass().getName();
        String escapeMessage = DefaultErrorReporter.encodeChars(niceException.getMessage());
        String message = escapeMessage != null ? clazzName + ": " + escapeMessage : clazzName;
        buffer.append("\n" + message + "<br>");
        buffer.append("\n<div id=\"stack\">");
        if (trimmedStackTrace.length > 0) {
            for (StackTraceElement stackElement : trimmedStackTrace) {
                String toString = TruncatableThrowable.printStackTraceElement((StackTraceElement)stackElement);
                if (toolsLink != null && toString.indexOf(40) > 0) {
                    String methodName = stackElement.getMethodName();
                    String failingClassAndMethod = stackElement.getClassName() + "." + methodName;
                    buffer.append("at ");
                    buffer.append(failingClassAndMethod);
                    String fileName = stackElement.getFileName();
                    if (fileName != null) {
                        buffer.append("(<a href=\"javascript:IDELink('");
                        buffer.append(failingClassAndMethod + "():" + stackElement.getLineNumber());
                        buffer.append("')\">");
                        buffer.append(fileName);
                        buffer.append(":");
                        buffer.append(stackElement.getLineNumber());
                        buffer.append("</a>)");
                    }
                } else {
                    buffer.append(toString);
                }
                buffer.append("<br>");
            }
        }
        buffer.append("\n</div>");
        TruncatableThrowable cause = niceException.getCause();
        if (cause != null) {
            buffer.append("Caused by: ");
            ApplicationErrorUtils.printException(cause, toolsLink, buffer);
        }
    }

    public static void issueAppExceptionMessage(String key, Throwable ex) {
        StackTraceElement[] stackTrace = ex.getStackTrace();
        if (stackTrace != null && stackTrace.length > 0) {
            StackTraceElement topSte = stackTrace[0];
            Tr.error((TraceComponent)tc, (String)key, (Object[])new Object[]{topSte.getClassName(), topSte.getMethodName(), topSte.getLineNumber(), new TruncatableThrowable(ex)});
        } else {
            Tr.error((TraceComponent)tc, (String)key, (Object[])new Object[]{"unknown", "unknown", "unknown", new TruncatableThrowable(ex)});
        }
    }
}

