/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.classloading.configuration;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.kernel.productinfo.ProductInfo;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;
import org.osgi.service.component.annotations.Modified;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(service={GlobalClassloadingConfiguration.class}, immediate=true, configurationPolicy=ConfigurationPolicy.REQUIRE, configurationPid={"com.ibm.ws.classloading.global"}, property={"service.vendor=IBM"})
public class GlobalClassloadingConfiguration {
    private static String USE_JAR_URLS_KEY = "useJarUrls";
    private static String LIBRARY_PRECEDENCE_KEY = "libraryPrecedence";
    static final TraceComponent tc = Tr.register(GlobalClassloadingConfiguration.class, null, null);
    private final AtomicBoolean issuedBetaMessage = new AtomicBoolean(false);
    private volatile boolean useJarUrls = false;
    private volatile LibraryPrecedence libraryPrecedence = LibraryPrecedence.afterApp;
    static final long serialVersionUID = 1273901704779686705L;

    @Activate
    protected void activate(Map<String, Object> properties) {
        this.modified(properties);
    }

    @Modified
    protected void modified(Map<String, Object> props) {
        this.useJarUrls = (Boolean)props.get(USE_JAR_URLS_KEY);
        LibraryPrecedence checkValue = LibraryPrecedence.valueOf((String)props.get(LIBRARY_PRECEDENCE_KEY));
        if (checkValue == LibraryPrecedence.beforeApp) {
            if (!ProductInfo.getBetaEdition()) {
                checkValue = LibraryPrecedence.afterApp;
                if (this.issuedBetaMessage.compareAndSet(false, true)) {
                    Tr.info((TraceComponent)tc, (String)("BETA: The attribute '" + LIBRARY_PRECEDENCE_KEY + "' can only be used with the Open Liberty BETA."), (Object[])new Object[0]);
                }
            } else if (this.issuedBetaMessage.compareAndSet(false, true)) {
                Tr.info((TraceComponent)tc, (String)("BETA: The attribute '" + LIBRARY_PRECEDENCE_KEY + "' is being used with the value '" + (Object)((Object)checkValue) + "'"), (Object[])new Object[0]);
            }
        }
        this.libraryPrecedence = checkValue;
    }

    public boolean useJarUrls() {
        return this.useJarUrls;
    }

    public LibraryPrecedence libraryPrecedence() {
        return this.libraryPrecedence;
    }

    public static enum LibraryPrecedence {
        beforeApp,
        afterApp;

    }
}

