/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.cache.servlet;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.servlet.cache.DynamicContentProvider;
import com.ibm.websphere.servlet.cache.ServletCacheResponse;
import com.ibm.ws.cache.servlet.CacheProxyOutputStream;
import com.ibm.ws.cache.servlet.CacheProxyWriter;
import com.ibm.ws.cache.servlet.ESISupport;
import com.ibm.ws.cache.servlet.FragmentComposer;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.webcontainer.servlet.IExtendedResponse;
import com.ibm.wsspi.webcontainer.util.IResponseOutput;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.Cookie;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.Locale;
import java.util.Vector;

public class CacheProxyResponse
extends HttpServletResponseWrapper
implements IResponseOutput,
ServletCacheResponse {
    private static TraceComponent tc = Tr.register(CacheProxyResponse.class, (String)"WebSphere Dynamic Cache", (String)"com.ibm.ws.cache.resources.dynacache");
    protected FragmentComposer fragmentComposer = null;
    boolean _gotWriter = false;
    boolean _gotOutputStream = false;
    protected boolean composerActive = true;
    private boolean containsESIContent = false;
    boolean bufferOutput = false;
    CacheProxyWriter bufferedWriter = null;
    CacheProxyOutputStream bufferedOutputStream = null;
    CacheProxyWriter writer = null;
    CacheProxyOutputStream outputStream = null;
    boolean doneFlushBuffer = false;
    boolean ard = false;
    int statusCode = 0;

    public CacheProxyResponse(HttpServletResponse proxiedResponse) {
        super(proxiedResponse);
    }

    public void finished() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Releasing: " + this + " for GC"), (Object[])new Object[0]);
        }
        this.fragmentComposer = null;
        this.bufferedWriter = null;
        this.bufferedOutputStream = null;
        this.composerActive = false;
    }

    public Vector[] getHeaderTable() {
        return ((IExtendedResponse)this.getResponse()).getHeaderTable();
    }

    protected void setBufferingOutput(boolean buffer) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)(" setBufferingOutput=" + buffer + " " + this), (Object[])new Object[0]);
        }
        this.bufferOutput = buffer;
    }

    protected boolean isBufferingOutput() {
        return this.bufferOutput;
    }

    protected void flushOutput() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("flushOutput(), bufferedWriter is " + this.bufferedWriter + ", bufferedOutputStream is " + (Object)((Object)this.bufferedOutputStream) + " " + this), (Object[])new Object[0]);
        }
        if (this.bufferedWriter != null && this.bufferedOutputStream != null) {
            throw new IllegalStateException("cannot buffer both text and bytes");
        }
        if (this.bufferedWriter != null) {
            CharArrayWriter writer = (CharArrayWriter)this.bufferedWriter.getWriter();
            writer.writeTo(this.getResponse().getWriter());
            writer.reset();
            this.bufferedWriter = null;
        } else if (this.bufferedOutputStream != null) {
            ByteArrayOutputStream stream = (ByteArrayOutputStream)this.bufferedOutputStream.getOutputStream();
            stream.writeTo((OutputStream)this.getResponse().getOutputStream());
            stream.reset();
            this.bufferedOutputStream = null;
        }
        this.bufferOutput = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"flushOutput()");
        }
    }

    public void setFragmentComposer(FragmentComposer fragmentComposer) {
        this.fragmentComposer = fragmentComposer;
    }

    public FragmentComposer getFragmentComposer() {
        return this.fragmentComposer;
    }

    public void setComposerActive(boolean active) {
        this.composerActive = active;
    }

    public boolean getComposerActive() {
        return this.composerActive;
    }

    public void flushBuffer() throws IOException {
        this.doneFlushBuffer = true;
        if (!this.bufferOutput) {
            if (this.getResponse() instanceof IResponseOutput) {
                ((IResponseOutput)this.getResponse()).flushBuffer(true);
            } else {
                this.getResponse().flushBuffer();
            }
        }
    }

    public void flushBuffer(boolean flushToWire) throws IOException {
        this.doneFlushBuffer = true;
        if (!this.bufferOutput) {
            if (this.getResponse() instanceof IResponseOutput) {
                ((IResponseOutput)this.getResponse()).flushBuffer(flushToWire);
            } else {
                this.getResponse().flushBuffer();
            }
        }
    }

    public boolean isCommitted() {
        boolean isCommitted = false;
        CacheProxyResponse surrogateResponse = this;
        while (surrogateResponse instanceof HttpServletResponseWrapper) {
            if (surrogateResponse instanceof CacheProxyResponse) {
                CacheProxyResponse tempResponse = surrogateResponse;
                if (tempResponse.writer != null && tempResponse.writer.writerFlushed || tempResponse.outputStream != null && tempResponse.outputStream.outputStreamFlushed) {
                    isCommitted = true;
                    break;
                }
            }
            surrogateResponse = (HttpServletResponse)((HttpServletResponseWrapper)surrogateResponse).getResponse();
        }
        if (!isCommitted) {
            return this.getResponse().isCommitted();
        }
        return isCommitted;
    }

    public ServletOutputStream getOutputStream() throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getOutputStream: " + this), (Object[])new Object[0]);
        }
        this._gotOutputStream = true;
        this.outputStream = (CacheProxyOutputStream)this.fragmentComposer.getOutputStream();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("getOutputStream: " + this + " returning: " + (Object)((Object)this.outputStream)), (Object[])new Object[0]);
        }
        return this.outputStream;
    }

    public PrintWriter getWriter() throws IOException {
        this._gotWriter = true;
        if (this.fragmentComposer == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("fragmentComposer is null: " + this), (Object[])new Object[0]);
            }
        } else {
            this.writer = (CacheProxyWriter)this.fragmentComposer.getPrintWriter();
        }
        return this.writer;
    }

    public ServletOutputStream getBufferedOutputStream() throws IOException {
        if (!this.bufferOutput) {
            throw new IllegalStateException("shouldn't call getBufferedOutputStream() when not buffering output");
        }
        this.getResponse().getOutputStream();
        if (this.bufferedOutputStream == null) {
            this.bufferedOutputStream = this.ard ? new CacheProxyOutputStream(new ByteArrayOutputStream(), this.fragmentComposer) : new CacheProxyOutputStream(new ByteArrayOutputStream());
        }
        return this.bufferedOutputStream;
    }

    public PrintWriter getBufferedWriter() throws IOException {
        if (!this.bufferOutput) {
            throw new IllegalStateException("shouldn't call getBufferedWriter() when not buffering output");
        }
        this.getResponse().getWriter();
        if (this.bufferedWriter == null) {
            this.bufferedWriter = this.ard ? new CacheProxyWriter((Writer)new CharArrayWriter(), this.fragmentComposer) : new CacheProxyWriter(new CharArrayWriter());
        }
        return this.bufferedWriter;
    }

    public void resetBuffer() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resetBuffer", (Object[])new Object[]{this});
        }
        if (this.composerActive) {
            this.fragmentComposer.resetBuffer();
        }
        super.resetBuffer();
        if (this.bufferedOutputStream != null) {
            ((ByteArrayOutputStream)this.bufferedOutputStream.getOutputStream()).reset();
        }
        if (this.bufferedWriter != null) {
            ((CharArrayWriter)this.bufferedWriter.getWriter()).reset();
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resetBuffer");
        }
    }

    public void reset() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"reset", (Object[])new Object[]{this});
        }
        this.resetBuffer();
        super.reset();
        this.ard = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"reset");
        }
    }

    public boolean getContainsESIContent() {
        return this.containsESIContent;
    }

    public void setContainsESIContent(boolean b) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setContainsESIContent(" + b + "), containsESIContent is " + this.containsESIContent + ", parent is " + this.fragmentComposer.getParent()), (Object[])new Object[0]);
        }
        if (this.containsESIContent == b) {
            return;
        }
        this.containsESIContent = b;
        FragmentComposer fc = this.fragmentComposer.getParent();
        if (fc != null) {
            fc.getResponse().setContainsESIContent(this.containsESIContent);
        }
    }

    public void setBufferSize(int size) {
        if (this.composerActive) {
            this.fragmentComposer.setBufferSize(size);
        }
        super.setBufferSize(size);
    }

    public int getBufferSize() {
        if (this.composerActive) {
            return this.fragmentComposer.getBufferSize();
        }
        return super.getBufferSize();
    }

    public void setHeader(String key, String value) {
        if (this.composerActive) {
            this.fragmentComposer.setHeader(key, value, true);
        }
        super.setHeader(key, value);
    }

    public void addHeader(String key, String value) {
        if (this.composerActive) {
            this.fragmentComposer.setHeader(key, value, false);
        }
        super.addHeader(key, value);
    }

    public void addCookie(Cookie cookie) {
        if (this.composerActive) {
            this.fragmentComposer.addCookie(cookie);
        }
        super.addCookie(cookie);
    }

    @Override
    public void addDynamicContentProvider(DynamicContentProvider dynamicContentProvider) throws IOException {
        if (this.composerActive) {
            this.fragmentComposer.addDynamicContentProvider(dynamicContentProvider);
        }
    }

    public void setDateHeader(String name, long value) {
        if (this.composerActive) {
            this.fragmentComposer.setDateHeader(name, value, true);
        }
        super.setDateHeader(name, value);
    }

    public void addDateHeader(String name, long value) {
        if (this.composerActive) {
            this.fragmentComposer.setDateHeader(name, value, false);
        }
        super.addDateHeader(name, value);
    }

    public void setIntHeader(String name, int value) {
        if (this.composerActive) {
            this.fragmentComposer.setIntHeader(name, value, true);
        }
        super.setIntHeader(name, value);
    }

    public void addIntHeader(String name, int value) {
        if (this.composerActive) {
            this.fragmentComposer.setIntHeader(name, value, false);
        }
        super.addIntHeader(name, value);
    }

    public void setStatus(int statusCode) {
        if (this.composerActive) {
            this.fragmentComposer.setStatus(statusCode);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setStatus: statusCode=" + statusCode), (Object[])new Object[0]);
        }
        this.statusCode = statusCode;
        super.setStatus(statusCode);
    }

    @Deprecated
    public void setStatus(int statusCode, String comment) {
        if (this.composerActive) {
            this.fragmentComposer.setStatus(statusCode, comment);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setStatus: statusCode=" + statusCode), (Object[])new Object[0]);
        }
        this.statusCode = statusCode;
        super.setStatus(statusCode, comment);
    }

    @Deprecated
    public void sendError(int statusCode) {
        if (this.composerActive) {
            this.fragmentComposer.setStatus(statusCode);
        }
        this.statusCode = statusCode;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("sendError: statusCode=" + statusCode), (Object[])new Object[0]);
        }
        try {
            super.sendError(statusCode);
        }
        catch (IOException ex) {
            FFDCFilter.processException((Throwable)ex, (String)(this.getClass().getName() + ".sendError()"), (String)"509", (Object)this);
        }
    }

    @Deprecated
    public void sendError(int statusCode, String comment) {
        if (this.composerActive) {
            this.fragmentComposer.setStatus(statusCode, comment);
        }
        this.statusCode = statusCode;
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("sendError: statusCode=" + statusCode), (Object[])new Object[0]);
        }
        try {
            super.sendError(statusCode, comment);
        }
        catch (IOException ex) {
            FFDCFilter.processException((Throwable)ex, (String)(this.getClass().getName() + ".sendError()"), (String)"532", (Object)this);
        }
    }

    public void setContentLength(int contentLength) {
        if (this.composerActive) {
            this.fragmentComposer.setContentLength(contentLength);
        }
        super.setContentLength(contentLength);
    }

    public void setCharacterEncoding(String charEnc) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setCharacterEncoding: " + charEnc), (Object[])new Object[0]);
        }
        super.setCharacterEncoding(charEnc);
        if (this.composerActive) {
            this.fragmentComposer.setCharacterEncoding(charEnc);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setCharacterEncoding");
        }
    }

    public void setContentType(String contentType) {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("setContentType: " + contentType), (Object[])new Object[0]);
        }
        super.setContentType(contentType);
        if (this.composerActive) {
            this.fragmentComposer.setContentType(contentType);
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"setContentType");
        }
    }

    public void setLocale(Locale locale) {
        super.setLocale(locale);
        if (this.composerActive) {
            this.fragmentComposer.setLocale(locale);
        }
    }

    public void sendRedirect(String location) throws IOException {
        ESISupport.handleESIPostProcessing(this, this.fragmentComposer.getFragmentInfo(), false);
        if (this.composerActive) {
            this.fragmentComposer.sendRedirect(location);
        }
        super.sendRedirect(location);
    }

    @Override
    public void setDoNotConsume(boolean doNotConsume) {
        if (this.composerActive) {
            this.fragmentComposer.setDoNotConsume(doNotConsume);
        }
    }

    public boolean writerObtained() {
        return this._gotWriter;
    }

    public boolean outputStreamObtained() {
        return this._gotOutputStream;
    }

    public void setArd(boolean a) {
        this.ard = a;
    }
}

