/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.cdi40.internal.weld;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.internal.config.CDIConfiguration;
import com.ibm.ws.cdi.internal.interfaces.BeansXmlParser;
import com.ibm.ws.cdi.internal.interfaces.WebSphereCDIDeployment;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import java.net.URL;
import org.jboss.weld.bootstrap.spi.BeanDiscoveryMode;
import org.jboss.weld.bootstrap.spi.BeansXml;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(name="io.openliberty.cdi40.internal.weld.CDI40BeanParserImpl", service={BeansXmlParser.class}, property={"service.vendor=IBM"})
public class CDI40BeansXmlParserImpl
implements BeansXmlParser {
    private static final TraceComponent tc = Tr.register(CDI40BeansXmlParserImpl.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
    @Reference(name="cdiContainerConfig", service=CDIConfiguration.class)
    private CDIConfiguration cdiContainerConfig;
    static final long serialVersionUID = 1591115226053693575L;

    public BeansXml parse(WebSphereCDIDeployment cdiDeployment, URL beansXmlUrl) {
        URL parsedURL;
        boolean emptyBeansXmlCDI3Compatibility = this.cdiContainerConfig.emptyBeansXmlCDI3Compatibility();
        BeanDiscoveryMode emptyBeansXMLMode = emptyBeansXmlCDI3Compatibility ? BeanDiscoveryMode.ALL : BeanDiscoveryMode.ANNOTATED;
        BeansXml beansXml = cdiDeployment.getBootstrap().parse(beansXmlUrl, emptyBeansXMLMode);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled() && (parsedURL = beansXml.getUrl()) != null && beansXml != null && beansXml.getVersion() == null) {
            Tr.debug((TraceComponent)tc, (String)("Archive contains a non-empty beans.xml file without a version defined: " + beansXmlUrl), (Object[])new Object[0]);
        }
        return beansXml;
    }
}

