/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.cdi40.internal.weld;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.cdi.CDIException;
import com.ibm.ws.cdi.internal.interfaces.CDIRuntime;
import com.ibm.ws.cdi.internal.interfaces.ExtensionArchive;
import com.ibm.ws.cdi.internal.interfaces.ExtensionArchiveProvider;
import com.ibm.ws.cdi.internal.interfaces.WebSphereBeanDeploymentArchive;
import com.ibm.ws.cdi.internal.interfaces.WebSphereCDIDeployment;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.cdi40.internal.weld.LiteExtensionArchive;
import jakarta.enterprise.inject.build.compatible.spi.BuildCompatibleExtension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.ConfigurationPolicy;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
@Component(configurationPolicy=ConfigurationPolicy.IGNORE)
public class LiteExtensionProvider
implements ExtensionArchiveProvider {
    private static final TraceComponent tc = Tr.register(LiteExtensionProvider.class, (String)"JCDI", (String)"com.ibm.ws.cdi.internal.resources.CDI");
    static final long serialVersionUID = 4830257316731339493L;

    public Collection<ExtensionArchive> getArchives(CDIRuntime cdiRuntime, WebSphereCDIDeployment deployment) throws CDIException {
        HashMap<ClassLoader, Set> extensions = new HashMap<ClassLoader, Set>();
        for (WebSphereBeanDeploymentArchive bda : deployment.getWebSphereBeanDeploymentArchives()) {
            for (String bceClassName : bda.getBuildCompatibleExtensionClassNames()) {
                Class<? extends BuildCompatibleExtension> bceClass = this.loadBuildCompatibleExtension(bceClassName, bda.getClassLoader());
                extensions.computeIfAbsent(bceClass.getClassLoader(), x -> new HashSet()).add(bceClass);
            }
        }
        ArrayList<ExtensionArchive> newArchives = new ArrayList<ExtensionArchive>();
        for (Map.Entry entry : extensions.entrySet()) {
            ClassLoader cl = (ClassLoader)entry.getKey();
            ArrayList<Class<? extends BuildCompatibleExtension>> classes = new ArrayList<Class<? extends BuildCompatibleExtension>>((Collection)entry.getValue());
            newArchives.add(new LiteExtensionArchive(cdiRuntime, cl, classes));
        }
        return newArchives;
    }

    /*
     * WARNING - void declaration
     */
    private Class<? extends BuildCompatibleExtension> loadBuildCompatibleExtension(String className, ClassLoader cl) throws CDIException {
        try {
            Class<?> clazz = cl.loadClass(className);
            return clazz.asSubclass(BuildCompatibleExtension.class);
        }
        catch (ClassNotFoundException clazz) {
            void e;
            FFDCFilter.processException((Throwable)clazz, (String)"io.openliberty.cdi40.internal.weld.LiteExtensionProvider", (String)"72", (Object)this, (Object[])new Object[]{className, cl});
            Tr.error((TraceComponent)tc, (String)"bce.not.loadable.CWOWB1013E", (Object[])new Object[]{className});
            throw new CDIException(Tr.formatMessage((TraceComponent)tc, (String)"bce.not.loadable.CWOWB1013E", (Object[])new Object[]{className}), (Throwable)e);
        }
        catch (ClassCastException e) {
            FFDCFilter.processException((Throwable)e, (String)"io.openliberty.cdi40.internal.weld.LiteExtensionProvider", (String)"75", (Object)this, (Object[])new Object[]{className, cl});
            Tr.error((TraceComponent)tc, (String)"bce.does.not.implement.bce.CWOWB1014E", (Object[])new Object[]{className});
            throw new CDIException(Tr.formatMessage((TraceComponent)tc, (String)"bce.does.not.implement.bce.CWOWB1014E", (Object[])new Object[]{className}), (Throwable)e);
        }
    }
}

