/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.javaee.ddmodel;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.ras.annotation.Trivial;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ffdc.annotation.FFDCIgnore;
import com.ibm.ws.javaee.dd.PlatformVersion;
import com.ibm.ws.javaee.ddmodel.BooleanType;
import com.ibm.ws.javaee.ddmodel.IDType;
import com.ibm.ws.javaee.ddmodel.IntegerType;
import com.ibm.ws.javaee.ddmodel.LongType;
import com.ibm.ws.javaee.ddmodel.ProtectedStringType;
import com.ibm.ws.javaee.ddmodel.QNameType;
import com.ibm.ws.javaee.ddmodel.StringType;
import com.ibm.ws.javaee.ddmodel.TokenType;
import com.ibm.ws.kernel.service.util.DesignatedXMLInputFactory;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.wsspi.adaptable.module.Container;
import com.ibm.wsspi.adaptable.module.Entry;
import com.ibm.wsspi.adaptable.module.NonPersistentCache;
import com.ibm.wsspi.adaptable.module.UnableToAdaptException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLResolver;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public abstract class DDParser
implements PlatformVersion {
    protected static final TraceComponent tc = Tr.register(DDParser.class, (String)"ddmodel", (String)"com.ibm.ws.javaee.internal.ddmodel.resources.DDModelMessages");
    protected static final int UNUSED_MAX_SCHEMA_VERSION = -1;
    public final int maxVersion;
    protected final Entry adaptableEntry;
    protected final String ddEntryPath;
    protected final Container rootContainer;
    private static final Object adaptNull = new Object();
    private final Map<Class<?>, Object> adaptCache = new HashMap(1);
    private final String expectedRootName;
    public int version;
    public int eePlatformVersion;
    public String dtdPublicId;
    public String namespace;
    public String namespaceOriginal;
    public String idNamespace;
    protected ParsableElement rootParsable;
    public String rootElementLocalName;
    public ComponentIDMap idMap = new ComponentIDMap();
    protected String currentElementLocalName;
    protected final Object describeRootParsable = new Object(){
        static final long serialVersionUID = -861607371388087383L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public String toString() {
            Diagnostics diag = new Diagnostics(DDParser.this.idMap);
            diag.describe(DDParser.this.rootParsable != null ? DDParser.this.rootParsable.toString() : "DDParser", DDParser.this.rootParsable);
            return diag.getDescription();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.javaee.ddmodel.DDParser$1", 1.class, (String)"ddmodel", (String)"com.ibm.ws.javaee.internal.ddmodel.resources.DDModelMessages");
        }
    };
    private XMLStreamReader xsr;
    protected StringBuilder contentBuilder = new StringBuilder();
    static final long serialVersionUID = 6769666524147414304L;

    public String formatMessage(String msgId, Object ... parms) {
        return Tr.formatMessage((TraceComponent)tc, (String)msgId, (Object[])parms);
    }

    public void warning(String message) {
        Tr.warning((TraceComponent)tc, (String)message, (Object[])new Object[0]);
    }

    public void error(String message) {
        Tr.error((TraceComponent)tc, (String)message, (Object[])new Object[0]);
    }

    protected void fatal(String message) throws ParseException {
        Tr.error((TraceComponent)tc, (String)message, (Object[])new Object[0]);
        throw new ParseException(message);
    }

    public DDParser(Container ddRootContainer, Entry ddEntry, String expectedRootName) throws ParseException {
        this(ddRootContainer, ddEntry, -1, expectedRootName);
    }

    public DDParser(Container ddRootContainer, Entry ddEntry, int maxSchemaVersion, String expectedRootName) throws ParseException {
        this.maxVersion = maxSchemaVersion;
        this.adaptableEntry = ddEntry;
        this.ddEntryPath = ddEntry.getPath();
        this.rootContainer = ddRootContainer;
        this.expectedRootName = expectedRootName;
    }

    public Class<?> getCrossComponentType() {
        throw new UnsupportedOperationException("Cross components require a BND or EXT parser");
    }

    @Trivial
    public Entry getAdaptableEntry() {
        return this.adaptableEntry;
    }

    /*
     * WARNING - void declaration
     */
    protected InputStream openEntry() throws ParseException {
        try {
            return (InputStream)this.adaptableEntry.adapt(InputStream.class);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            void e;
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.javaee.ddmodel.DDParser", (String)"529", (Object)this, (Object[])new Object[0]);
            throw new ParseException(this.xmlError((Throwable)e), (Throwable)e);
        }
    }

    @Trivial
    public String getPath() {
        return this.ddEntryPath;
    }

    @Trivial
    public String getDeploymentDescriptorPath() {
        return this.ddEntryPath.substring(1);
    }

    /*
     * WARNING - void declaration
     */
    @Trivial
    public <T> T adaptRootContainer(Class<T> targetClass) throws ParseException {
        Object target = this.adaptCache.get(targetClass);
        if (target != null) {
            if (target == adaptNull) {
                return null;
            }
            if (target instanceof ParseException) {
                throw (ParseException)target;
            }
            return targetClass.cast(target);
        }
        try {
            Object result = this.rootContainer.adapt(targetClass);
            this.adaptCache.put(targetClass, result == null ? adaptNull : result);
            return (T)result;
        }
        catch (UnableToAdaptException result) {
            void e;
            FFDCFilter.processException((Throwable)result, (String)"com.ibm.ws.javaee.ddmodel.DDParser", (String)"580", (Object)this, (Object[])new Object[]{targetClass});
            Throwable cause = e.getCause();
            if (cause instanceof ParseException) {
                ParseException parseException = (ParseException)cause;
            }
            ParseException pe = new ParseException(this.xmlError((Throwable)e), (Throwable)e);
            this.adaptCache.put(targetClass, pe);
            throw pe;
        }
    }

    public <T> T cacheGet(Class<T> targetClass) {
        NonPersistentCache cache = null;
        try {
            cache = (NonPersistentCache)this.rootContainer.adapt(NonPersistentCache.class);
        }
        catch (UnableToAdaptException unableToAdaptException) {
            FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.javaee.ddmodel.DDParser", (String)"612", (Object)this, (Object[])new Object[]{targetClass});
        }
        return (T)(cache == null ? null : cache.getFromCache(targetClass));
    }

    public String getExpectedRootName() {
        return this.expectedRootName;
    }

    protected void validateRootElementName() throws ParseException {
        String useExpectedName = this.getExpectedRootName();
        if (!useExpectedName.equals(this.rootElementLocalName)) {
            throw new ParseException(this.unexpectedRootElement(useExpectedName));
        }
    }

    public String getDottedVersionText() {
        return PlatformVersion.getDottedVersionText((int)this.version);
    }

    public String getVersionText() {
        return PlatformVersion.getVersionText((int)this.version);
    }

    protected void patchNamespace(String namespaceOverride) {
        this.namespaceOriginal = this.namespace;
        this.namespace = namespaceOverride;
    }

    protected boolean matchNamespace(String localNamespace) {
        if (this.namespaceOriginal != null && this.namespaceOriginal.equals(localNamespace) || this.namespaceOriginal == null && localNamespace == null) {
            localNamespace = this.namespace;
        }
        if (this.namespace == null) {
            return localNamespace == null;
        }
        return this.namespace.equals(localNamespace);
    }

    public void putId(String elementName, String id, Object value) {
        Object oldValue = this.idMap.get(id);
        if (oldValue == null) {
            this.idMap.put(id, value);
            return;
        }
        if (oldValue == value) {
            return;
        }
        this.idMap.put(id, ComponentIDMap.DUPLICATE);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            String entryPath = this.describeEntry();
            int lineNo = this.getLineNumber();
            Tr.debug((TraceComponent)tc, (String)"Duplicate ID [ {0} ] in element [ {1} ] of [ {2} ] at line [ {3} ]", (Object[])new Object[]{id, elementName, entryPath, lineNo});
        }
    }

    @Trivial
    public ParsableElement getRootParsable() {
        return this.rootParsable;
    }

    @Trivial
    public String getNamespaceURI(String prefix) {
        return this.xsr.getNamespaceURI(prefix);
    }

    @Trivial
    public int getLineNumber() {
        return this.xsr == null ? -1 : this.xsr.getLocation().getLineNumber();
    }

    @Trivial
    public boolean isWhiteSpace() {
        return this.xsr.isWhiteSpace();
    }

    @Trivial
    public String getAttributeValue(String targetNS, String targetLocalName) {
        int attrCount = this.xsr.getAttributeCount();
        for (int attrNo = 0; attrNo < attrCount; ++attrNo) {
            String attrLocalName = this.xsr.getAttributeLocalName(attrNo);
            if (!targetLocalName.equals(attrLocalName)) continue;
            if (targetNS == null) {
                return this.xsr.getAttributeValue(attrNo);
            }
            String attrNS = this.xsr.getAttributeNamespace(attrNo);
            if (!(attrNS == null ? targetNS.isEmpty() : targetNS.equals(attrNS))) continue;
            return this.xsr.getAttributeValue(attrNo);
        }
        return null;
    }

    @Trivial
    public String getAttributeValue(int index) {
        return this.xsr.getAttributeValue(index);
    }

    public BooleanType parseBooleanAttributeValue(int index) throws ParseException {
        return this.parseBoolean(this.getAttributeValue(index));
    }

    public IDType parseIDAttributeValue(int index) throws ParseException {
        return this.parseID(this.getAttributeValue(index));
    }

    public IntegerType parseIntegerAttributeValue(int index) throws ParseException {
        return this.parseInteger(this.getAttributeValue(index));
    }

    public LongType parseLongAttributeValue(int index) throws ParseException {
        return this.parseLong(this.getAttributeValue(index));
    }

    public QNameType parseQNameAttributeValue(int index) throws ParseException {
        return this.parseQName(this.getAttributeValue(index));
    }

    public StringType parseStringAttributeValue(int index) throws ParseException {
        return this.parseString(this.getAttributeValue(index));
    }

    public ParsableListImplements<StringType, String> parseStringListAttributeValue(int index) throws ParseException {
        return this.parseTokenAttributeValue(index).split(this, " ");
    }

    public ProtectedStringType parseProtectedStringAttributeValue(int index) throws ParseException {
        return this.parseProtectedString(this.getAttributeValue(index));
    }

    public TokenType parseTokenAttributeValue(int index) throws ParseException {
        return this.parseToken(this.getAttributeValue(index));
    }

    public <T extends Enum<T>> T parseEnumAttributeValue(int index, Class<T> valueClass) throws ParseException {
        return this.parseEnum(this.getAttributeValue(index), valueClass);
    }

    @Trivial
    public void appendTextToContent() {
        this.contentBuilder.append(this.xsr.getText());
    }

    @Trivial
    public String getContentString(boolean untrimmed) {
        return this.getContentString();
    }

    @Trivial
    public String getContentString() {
        String content = this.contentBuilder.toString();
        this.contentBuilder.setLength(0);
        return content;
    }

    public ParsableElement parse() throws ParseException {
        this.parseRootElement();
        return this.rootParsable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void parseRootElement() throws ParseException {
        InputStream stream = null;
        try {
            stream = this.openEntry();
            DTDPublicIDResolver resolver = new DTDPublicIDResolver();
            try {
                this.xsr = this.createXMLStreamReader(resolver, stream);
                this.parseToRootElement();
                this.dtdPublicId = resolver.dtdPublicId;
                this.namespace = this.xsr.getNamespaceURI();
                this.currentElementLocalName = this.rootElementLocalName = this.xsr.getLocalName();
                this.rootParsable = this.createRootParsable();
                if (this.rootParsable != null) {
                    this.parse(this.rootParsable);
                }
            }
            finally {
                if (this.xsr != null) {
                    try {
                        this.xsr.close();
                    }
                    catch (XMLStreamException xMLStreamException) {
                        FFDCFilter.processException((Throwable)xMLStreamException, (String)"com.ibm.ws.javaee.ddmodel.DDParser", (String)"942", (Object)this, (Object[])new Object[0]);
                    }
                }
            }
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {
                    FFDCFilter.processException((Throwable)iOException, (String)"com.ibm.ws.javaee.ddmodel.DDParser", (String)"952", (Object)this, (Object[])new Object[0]);
                }
            }
        }
    }

    @FFDCIgnore(value={IllegalArgumentException.class, XMLStreamException.class})
    private XMLStreamReader createXMLStreamReader(XMLResolver resolver, InputStream stream) throws ParseException {
        try {
            XMLInputFactory inputFactory = DesignatedXMLInputFactory.newInstance();
            try {
                inputFactory.setProperty("javax.xml.stream.isSupportingLocationCoordinates", true);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            inputFactory.setXMLResolver(resolver);
            return inputFactory.createXMLStreamReader(stream);
        }
        catch (XMLStreamException e) {
            throw new ParseException(this.xmlError(e), e);
        }
    }

    @FFDCIgnore(value={XMLStreamException.class})
    private void parseToRootElement() throws ParseException {
        try {
            while (!this.xsr.isStartElement()) {
                if (!this.xsr.hasNext()) {
                    throw new ParseException(this.rootElementNotFound());
                }
                this.xsr.next();
            }
        }
        catch (XMLStreamException e) {
            e.printStackTrace(System.out);
            throw new ParseException(this.xmlError(e), e);
        }
    }

    @Trivial
    @FFDCIgnore(value={XMLStreamException.class})
    public void skipSubtree() throws ParseException {
        try {
            int depth = 0;
            while (this.xsr.hasNext()) {
                if (this.xsr.isStartElement()) {
                    ++depth;
                } else if (this.xsr.isEndElement() && --depth == 0) {
                    return;
                }
                this.xsr.next();
            }
            throw new ParseException(this.endElementNotFound());
        }
        catch (XMLStreamException e) {
            throw new ParseException(this.xmlError(e), e);
        }
    }

    protected abstract ParsableElement createRootParsable() throws ParseException;

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @FFDCIgnore(value={XMLStreamException.class})
    public void parse(ParsableElement parsable) throws ParseException {
        elementName = this.xsr.getName();
        this.currentElementLocalName = elementLocalName = this.xsr.getLocalName();
        attrCount = this.xsr.getAttributeCount();
        for (i = 0; i < attrCount; ++i) {
            attrNS = this.xsr.getAttributeNamespace(i);
            attrLocal = this.xsr.getAttributeLocalName(i);
            if (parsable.isIdAllowed() && "id".equals(attrLocal)) {
                if (this.idNamespace != null ? this.idNamespace.equals(attrNS) == false : attrNS != null) {
                    throw new ParseException(this.incorrectIDAttrNamespace(attrNS));
                }
                id = this.parseIDAttributeValue(i).getValue();
                this.putId(this.currentElementLocalName, id, parsable);
                continue;
            }
            if ("http://www.w3.org/2001/XMLSchema-instance".equals(attrNS)) {
                if ("nil".equals(attrLocal)) {
                    parsable.setNil(this.parseBooleanAttributeValue(i).getBooleanValue());
                    continue;
                }
                if ("schemaLocation".equals(attrLocal)) continue;
            }
            if (parsable.handleAttribute(this, attrNS, attrLocal, i)) continue;
            throw new ParseException(this.unexpectedAttribute(attrLocal));
        }
lbl20:
        // 2 sources

        try {
            block9: while (this.xsr.hasNext()) {
                switch (this.xsr.next()) {
                    case 4: 
                    case 12: {
                        if (parsable.handleContent(this)) continue block9;
                        throw new ParseException(this.unexpectedContent());
                    }
                    case 2: {
                        parsable.finish(this);
                        if (parsable != this.rootParsable) return;
                        while (this.xsr.hasNext()) {
                            this.xsr.next();
                        }
                        this.xsr.close();
                        return;
                    }
                    case 1: {
                        localName = this.xsr.getLocalName();
                        localNamespace = this.xsr.getNamespaceURI();
                        if (!this.matchNamespace(localNamespace)) {
                            throw new ParseException(this.incorrectChildElementNamespace(localNamespace, localName));
                        }
                        handledChild = parsable.handleChild(this, localName);
                        this.currentElementLocalName = elementLocalName;
                        if (handledChild) continue block9;
                        throw new ParseException(this.unexpectedChildElement(localName));
                    }
                    case 3: 
                    case 5: {
                        ** GOTO lbl20
                    }
                }
                eventType = this.xsr.getEventType();
                re = new RuntimeException("unexpected event " + eventType + " while processing element \"" + elementName + "\" of " + this.describeEntry() + ".");
                FFDCFilter.processException((Throwable)re, (String)"com.ibm.ws.javaee.ddmodel.DDParser", (String)"410", (Object)this);
            }
            throw new ParseException(this.endElementNotFound());
        }
        catch (XMLStreamException e) {
            throw new ParseException(this.xmlError(e), e);
        }
    }

    public BooleanType parseBoolean(String lexical) throws ParseException {
        return BooleanType.wrap(this, lexical);
    }

    public IDType parseID(String lexical) throws ParseException {
        return IDType.wrap(this, lexical);
    }

    public IntegerType parseInteger(String lexical) throws ParseException {
        return IntegerType.wrap(this, lexical);
    }

    public LongType parseLong(String lexical) throws ParseException {
        return LongType.wrap(this, lexical);
    }

    public QNameType parseQName(String lexical) throws ParseException {
        return QNameType.wrap(this, lexical);
    }

    public StringType parseString(String lexical) throws ParseException {
        return StringType.wrap(this, lexical);
    }

    public ProtectedStringType parseProtectedString(@Sensitive String lexical) throws ParseException {
        return ProtectedStringType.wrap(lexical);
    }

    public TokenType parseToken(String lexical) throws ParseException {
        return TokenType.wrap(this, lexical);
    }

    private <T extends Enum<T>> Object[] getValidEnumConstants(Class<T> valueClass) {
        Object[] constants = (Enum[])valueClass.getEnumConstants();
        if (!VersionedEnum.class.isAssignableFrom(valueClass)) {
            return constants;
        }
        ArrayList<Object> valid = new ArrayList<Object>(constants.length);
        for (Object value : constants) {
            VersionedEnum versionedValue = (VersionedEnum)value;
            if (this.version < versionedValue.getMinVersion()) continue;
            valid.add(value);
        }
        return valid.toArray();
    }

    @FFDCIgnore(value={IllegalArgumentException.class, IncompatibleClassChangeError.class})
    public <T extends Enum<T>> T parseEnum(String value, Class<T> valueClass) throws ParseException {
        VersionedEnum versionedConstant;
        T constant;
        try {
            try {
                constant = Enum.valueOf(valueClass, value);
            }
            catch (IncompatibleClassChangeError e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"rethrowing IncompatibleClassChangeError as IllegalArgumentException", (Object[])new Object[]{e});
                }
                throw new IllegalArgumentException(e);
            }
        }
        catch (IllegalArgumentException e) {
            throw new ParseException(this.invalidEnumValue(value, this.getValidEnumConstants(valueClass)), e);
        }
        if (constant instanceof VersionedEnum && this.version < (versionedConstant = (VersionedEnum)constant).getMinVersion()) {
            throw new ParseException(this.invalidEnumValue(value, this.getValidEnumConstants(valueClass)));
        }
        return constant;
    }

    protected static VersionData selectVersion(VersionData[] versions, String versionAttr, String publicId, String namespace, int maxSchemaVersion) {
        VersionData lastSelected = null;
        for (VersionData version : versions) {
            if (lastSelected != null && version.version > maxSchemaVersion) break;
            if (!version.accept(versionAttr, publicId, namespace)) continue;
            lastSelected = version;
        }
        return lastSelected;
    }

    public String describeEntry() {
        return DDParser.describeEntry(this.adaptableEntry, null, null);
    }

    public static String describeEntry(Entry initialEntry, Container initialRoot, String initialPath) {
        StringBuilder builder = new StringBuilder();
        Entry nextEntry = initialEntry;
        while (nextEntry != null || initialPath != null) {
            String path;
            Container nextRoot;
            String nextPath;
            if (nextEntry != null) {
                if (builder.length() > 0) {
                    builder.insert(0, " : ");
                }
                if ((nextPath = nextEntry.getPath()).length() > 1 && nextPath.charAt(0) == '/') {
                    nextPath = nextPath.substring(1);
                }
                nextRoot = nextEntry.getRoot();
            } else {
                nextPath = initialPath;
                initialPath = null;
                nextRoot = initialRoot;
            }
            builder.insert(0, nextPath);
            try {
                nextEntry = (Entry)nextRoot.adapt(Entry.class);
            }
            catch (UnableToAdaptException unableToAdaptException) {
                FFDCFilter.processException((Throwable)unableToAdaptException, (String)"com.ibm.ws.javaee.ddmodel.DDParser", (String)"1370", null, (Object[])new Object[]{initialEntry, initialRoot, initialPath});
                break;
            }
            if (nextEntry != null || (path = DDParser.getSimpleName(nextRoot)) == null || path.isEmpty()) continue;
            builder.insert(0, " : ");
            builder.insert(0, path);
        }
        String description = builder.toString();
        return description;
    }

    public static String getSimpleName(Container container) {
        String path = container.getPhysicalPath();
        if (path == null) {
            return null;
        }
        int slashOffset = (path = path.replace('\\', '/')).lastIndexOf(47);
        if (slashOffset != -1) {
            path = path.substring(slashOffset + 1);
        }
        return path;
    }

    public String requiredAttributeMissing(String attrLocal) {
        return Tr.formatMessage((TraceComponent)tc, (String)"required.attribute.missing", (Object[])new Object[]{this.describeEntry(), this.getLineNumber(), this.currentElementLocalName, attrLocal});
    }

    private String rootElementNotFound() {
        return Tr.formatMessage((TraceComponent)tc, (String)"root.element.not.found", (Object[])new Object[]{this.describeEntry(), this.getLineNumber()});
    }

    private String endElementNotFound() {
        return Tr.formatMessage((TraceComponent)tc, (String)"end.element.not.found", (Object[])new Object[]{this.describeEntry(), this.getLineNumber(), this.currentElementLocalName});
    }

    private String incorrectIDAttrNamespace(String attrNS) {
        return Tr.formatMessage((TraceComponent)tc, (String)"incorrect.id.attr.namespace", (Object[])new Object[]{this.describeEntry(), this.getLineNumber(), this.currentElementLocalName, attrNS, this.idNamespace});
    }

    private String unexpectedAttribute(String attrLocal) {
        return Tr.formatMessage((TraceComponent)tc, (String)"unexpected.attribute", (Object[])new Object[]{this.describeEntry(), this.getLineNumber(), this.currentElementLocalName, attrLocal});
    }

    public String unexpectedContent() {
        return Tr.formatMessage((TraceComponent)tc, (String)"unexpected.content", (Object[])new Object[]{this.describeEntry(), this.getLineNumber(), this.currentElementLocalName});
    }

    private String incorrectChildElementNamespace(String elementNS, String elementLocal) {
        return Tr.formatMessage((TraceComponent)tc, (String)"incorrect.child.element.namespace", (Object[])new Object[]{this.describeEntry(), this.getLineNumber(), this.currentElementLocalName, elementLocal, elementNS, this.namespace});
    }

    private String unexpectedChildElement(String elementLocal) {
        return Tr.formatMessage((TraceComponent)tc, (String)"unexpected.child.element", (Object[])new Object[]{this.describeEntry(), this.getLineNumber(), this.currentElementLocalName, elementLocal});
    }

    public String missingHRef(String hrefElementName) {
        return Tr.formatMessage((TraceComponent)tc, (String)"missing.href", (Object[])new Object[]{this.describeEntry(), this.getLineNumber(), hrefElementName});
    }

    public String invalidHRef(String hrefElementName, String href) {
        return Tr.formatMessage((TraceComponent)tc, (String)"invalid.href", (Object[])new Object[]{this.describeEntry(), this.getLineNumber(), hrefElementName, href});
    }

    public String invalidHRefPrefix(String hrefElementName, String href, String hrefPrefix, String expectedPrefix) {
        return Tr.formatMessage((TraceComponent)tc, (String)"invalid.href.prefix", (Object[])new Object[]{this.describeEntry(), this.getLineNumber(), hrefElementName, href, hrefPrefix, expectedPrefix});
    }

    public String incorrectHRefType(String hrefElementName, String href, Class<?> referentClass, Object referent) {
        return Tr.formatMessage((TraceComponent)tc, (String)"incorrect.href.type", (Object[])new Object[]{this.describeEntry(), this.getLineNumber(), hrefElementName, href, referentClass.getName(), referent.getClass().getName()});
    }

    public String unresolvedReference(String hrefElementName, String href, String hrefId, String hrefPath) {
        return Tr.formatMessage((TraceComponent)tc, (String)"unresolved.href", (Object[])new Object[]{this.describeEntry(), this.getLineNumber(), hrefElementName, href, hrefId, hrefPath});
    }

    public String tooManyElements(String element) {
        return Tr.formatMessage((TraceComponent)tc, (String)"at.most.one.occurrence", (Object[])new Object[]{this.describeEntry(), this.getLineNumber(), this.currentElementLocalName, element});
    }

    public String missingElement(String element) {
        return Tr.formatMessage((TraceComponent)tc, (String)"required.method.element.missing", (Object[])new Object[]{this.describeEntry(), this.getLineNumber(), this.currentElementLocalName, element});
    }

    private String xmlError(XMLStreamException e) {
        return Tr.formatMessage((TraceComponent)tc, (String)"xml.error", (Object[])new Object[]{this.describeEntry(), this.getLineNumber(), e.getMessage()});
    }

    private String xmlError(Throwable e) {
        return Tr.formatMessage((TraceComponent)tc, (String)"xml.error", (Object[])new Object[]{this.describeEntry(), this.getLineNumber(), e.toString()});
    }

    public String invalidEnumValue(String value, Object ... values) {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < values.length; ++i) {
            if (i != 0) {
                builder.append(", ");
            }
            builder.append(values[i]);
        }
        return Tr.formatMessage((TraceComponent)tc, (String)"invalid.enum.value", (Object[])new Object[]{this.describeEntry(), this.getLineNumber(), value, builder});
    }

    public String invalidIntValue(String value) {
        return Tr.formatMessage((TraceComponent)tc, (String)"invalid.int.value", (Object[])new Object[]{this.describeEntry(), this.getLineNumber(), value});
    }

    public String invalidLongValue(String value) {
        return Tr.formatMessage((TraceComponent)tc, (String)"invalid.long.value", (Object[])new Object[]{this.describeEntry(), this.getLineNumber(), value});
    }

    protected String missingDescriptorVersion() {
        return Tr.formatMessage((TraceComponent)tc, (String)"missing.descriptor.version", (Object[])new Object[]{this.describeEntry()});
    }

    protected String unsupportedDescriptorVersion(String ddVersion) {
        return Tr.formatMessage((TraceComponent)tc, (String)"unsupported.descriptor.version", (Object[])new Object[]{this.describeEntry(), this.getLineNumber(), ddVersion});
    }

    protected String unprovisionedDescriptorVersion(int schemaVersion, int maxSchemaVersion) {
        return Tr.formatMessage((TraceComponent)tc, (String)"unprovisioned.descriptor.version", (Object[])new Object[]{this.describeEntry(), this.getLineNumber(), schemaVersion, maxSchemaVersion});
    }

    protected String missingDescriptorNamespace(String ddNamespace) {
        return Tr.formatMessage((TraceComponent)tc, (String)"missing.descriptor.namespace", (Object[])new Object[]{this.describeEntry(), this.getLineNumber(), ddNamespace});
    }

    protected String unsupportedDescriptorNamespace(String ddNamespace) {
        return Tr.formatMessage((TraceComponent)tc, (String)"unsupported.descriptor.namespace", (Object[])new Object[]{this.describeEntry(), this.getLineNumber(), ddNamespace});
    }

    protected String incorrectDescriptorNamespace(String ddVersion, String ddNamespace, String expectedNamespace) {
        return Tr.formatMessage((TraceComponent)tc, (String)"incorrect.descriptor.namespace.for.version", (Object[])new Object[]{this.describeEntry(), this.getLineNumber(), ddVersion, ddNamespace, expectedNamespace});
    }

    protected String incorrectDescriptorNamespace(String ddNamespace, String expectedNamespace) {
        return Tr.formatMessage((TraceComponent)tc, (String)"incorrect.descriptor.namespace", (Object[])new Object[]{this.describeEntry(), this.getLineNumber(), ddNamespace, expectedNamespace});
    }

    protected String unsupportedDescriptorPublicId(String ddPublicId) {
        return Tr.formatMessage((TraceComponent)tc, (String)"unsupported.descriptor.public.id", (Object[])new Object[]{this.describeEntry(), this.getLineNumber(), ddPublicId});
    }

    protected String unexpectedRootElement(String expectedRootElementName) {
        return Tr.formatMessage((TraceComponent)tc, (String)"unexpected.root.element", (Object[])new Object[]{this.describeEntry(), this.getLineNumber(), this.rootElementLocalName, expectedRootElementName});
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class VersionData {
        public final String versionAttr;
        public final String namespace;
        public final String publicId;
        public final int version;
        public final int platformVersion;
        static final long serialVersionUID = 2924309825486171514L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public VersionData(String versionAttr, String publicId, String namespace, int version, int platformVersion) {
            this.versionAttr = versionAttr;
            this.namespace = namespace;
            this.publicId = publicId;
            this.version = version;
            this.platformVersion = platformVersion;
        }

        public boolean accept(String ddVersionAttr, String ddPublicId, String ddNamespace) {
            if (ddVersionAttr == null) {
                return this.publicId != null && this.publicId.equals(ddPublicId) || this.namespace != null && this.namespace.equals(ddNamespace);
            }
            return this.versionAttr.equals(ddVersionAttr);
        }

        public String toString() {
            return super.toString() + '(' + this.versionAttr + ", " + this.namespace + ", " + this.publicId + ", " + this.version + ", " + this.platformVersion + ')';
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.javaee.ddmodel.DDParser$VersionData", VersionData.class, (String)"ddmodel", (String)"com.ibm.ws.javaee.internal.ddmodel.resources.DDModelMessages");
        }
    }

    public static interface VersionedEnum {
        public int getMinVersion();
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    private static final class DTDPublicIDResolver
    implements XMLResolver {
        private String dtdPublicId;
        static final long serialVersionUID = -3296425260326631210L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        private DTDPublicIDResolver() {
        }

        @Override
        public Object resolveEntity(String publicID, String systemID, String baseURI, String namespace) throws XMLStreamException {
            this.dtdPublicId = publicID;
            return new ByteArrayInputStream(new byte[0]);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.javaee.ddmodel.DDParser$DTDPublicIDResolver", DTDPublicIDResolver.class, (String)"ddmodel", (String)"com.ibm.ws.javaee.internal.ddmodel.resources.DDModelMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class Diagnostics {
        private final ComponentIDMap idMap;
        private final StringBuilder sb;
        static final long serialVersionUID = 6037612684851487692L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public Diagnostics(ComponentIDMap idMap) {
            this(idMap, new StringBuilder());
        }

        @Trivial
        public Diagnostics(ComponentIDMap idMap, StringBuilder sb) {
            this.idMap = idMap;
            this.sb = sb;
        }

        @Trivial
        void describeWithIdIfSet(Parsable parsable) {
            String id;
            String string = id = this.idMap != null ? this.idMap.getIdForComponent(parsable) : null;
            if (id != null) {
                this.sb.append("[id<\"");
                this.sb.append(id);
                this.sb.append("\">]");
            }
            parsable.describe(this);
        }

        @Trivial
        public <T> void describeEnum(T enumValue) {
            if (enumValue != null) {
                this.sb.append(enumValue);
            }
        }

        @Trivial
        public <T> void describeEnum(String name, T enumValue) {
            this.sb.append(name);
            this.sb.append('<');
            if (enumValue != null) {
                this.sb.append(enumValue);
            } else {
                this.sb.append("null");
            }
            this.sb.append('>');
        }

        @Trivial
        public <T> void describeEnumIfSet(String name, T enumValue) {
            if (enumValue != null) {
                this.sb.append('[');
                this.sb.append(name);
                this.sb.append('<');
                this.sb.append(enumValue);
                this.sb.append('>');
                this.sb.append(']');
            }
        }

        @Trivial
        public void describe(String name, ParsableElement parsable) {
            this.sb.append(name);
            this.sb.append('<');
            if (parsable != null) {
                this.describeWithIdIfSet(parsable);
            } else {
                this.sb.append("null");
            }
            this.sb.append('>');
        }

        @Trivial
        public void describe(String name, ParsableList<? extends ParsableElement> parsableList) {
            this.sb.append(name);
            this.sb.append('(');
            if (parsableList != null) {
                parsableList.describe(this);
            } else {
                this.sb.append("null");
            }
            this.sb.append(')');
        }

        @Trivial
        public void describeIfSet(String name, ParsableElement parsable) {
            if (parsable != null) {
                this.sb.append('[');
                this.sb.append(name);
                this.sb.append('<');
                this.describeWithIdIfSet(parsable);
                this.sb.append('>');
                this.sb.append(']');
            }
        }

        @Trivial
        public void describeIfSet(String name, ParsableList<? extends ParsableElement> parsableList) {
            if (parsableList != null) {
                this.sb.append('[');
                this.sb.append(name);
                this.sb.append('(');
                parsableList.describe(this);
                this.sb.append(')');
                this.sb.append(']');
            }
        }

        @Trivial
        public void append(String string) {
            this.sb.append(string);
        }

        @Trivial
        public String getDescription() {
            return this.sb.toString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.javaee.ddmodel.DDParser$Diagnostics", Diagnostics.class, (String)"ddmodel", (String)"com.ibm.ws.javaee.internal.ddmodel.resources.DDModelMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class ComponentIDMap {
        public static final Object DUPLICATE;
        private final Map<String, Object> idToComponentMap = new HashMap<String, Object>();
        private Map<Object, String> componentToIdMap = null;
        private boolean didDisplayIds;
        static final long serialVersionUID = 3218001192253063726L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        Object get(String id) {
            return this.idToComponentMap.get(id);
        }

        @Trivial
        Object put(String id, Object ddComponent) {
            return this.idToComponentMap.put(id, ddComponent);
        }

        @Trivial
        public Object getComponentForId(String id) {
            Object comp = this.idToComponentMap.get(id);
            if (comp == DUPLICATE) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Lookup of duplicate ID [ {0} ] forced to null.", (Object[])new Object[]{id});
                }
                comp = null;
            } else if (comp == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Failed lookup of ID [ {0} ]", (Object[])new Object[]{id});
                    if (!this.didDisplayIds) {
                        this.didDisplayIds = true;
                        for (Map.Entry<String, Object> idEntry : this.idToComponentMap.entrySet()) {
                            Tr.debug((TraceComponent)tc, (String)"ID [ {0} ]: [ {1} ]", (Object[])new Object[]{idEntry.getKey(), idEntry.getValue()});
                        }
                    }
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Lookup of ID [ {0} ]: [ {1} ]", (Object[])new Object[]{id, comp});
            }
            return comp;
        }

        @Trivial
        public String getIdForComponent(Object ddComponent) {
            if (ddComponent == null) {
                return null;
            }
            if (ddComponent == DUPLICATE) {
                return null;
            }
            if (this.componentToIdMap == null) {
                IdentityHashMap<Object, String> useMap = new IdentityHashMap<Object, String>(this.idToComponentMap.size());
                for (Map.Entry<String, Object> idEntry : this.idToComponentMap.entrySet()) {
                    String id = idEntry.getKey();
                    Object component = idEntry.getValue();
                    if (component == DUPLICATE) continue;
                    useMap.put(component, id);
                }
                this.componentToIdMap = useMap;
            }
            return this.componentToIdMap.get(ddComponent);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.javaee.ddmodel.DDParser$ComponentIDMap", ComponentIDMap.class, (String)"ddmodel", (String)"com.ibm.ws.javaee.internal.ddmodel.resources.DDModelMessages");
            DUPLICATE = new Object();
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class ParsableListImplements<T extends ParsableElement, I>
    extends ParsableList<T> {
        static final long serialVersionUID = 3942763335496588872L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Trivial
        public List<I> getList() {
            return this.list;
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.javaee.ddmodel.DDParser$ParsableListImplements", ParsableListImplements.class, (String)"ddmodel", (String)"com.ibm.ws.javaee.internal.ddmodel.resources.DDModelMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class ParsableList<T extends ParsableElement>
    implements Parsable,
    Iterable<T> {
        protected List<T> list = new ArrayList<T>();
        static final long serialVersionUID = 4799125593231424026L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public T newInstance(DDParser parser) {
            throw new UnsupportedOperationException();
        }

        @Trivial
        public void addElement(ParsableElement element) {
            this.add(element);
        }

        @Trivial
        public void add(T t) {
            this.list.add(t);
        }

        @Override
        @Trivial
        public Iterator<T> iterator() {
            return this.list.iterator();
        }

        @Override
        @Trivial
        public void describe(Diagnostics diag) {
            boolean isFirst = true;
            for (ParsableElement t : this.list) {
                if (!isFirst) {
                    isFirst = false;
                    diag.sb.append(',');
                }
                diag.describeWithIdIfSet(t);
            }
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.javaee.ddmodel.DDParser$ParsableList", ParsableList.class, (String)"ddmodel", (String)"com.ibm.ws.javaee.internal.ddmodel.resources.DDModelMessages");
        }
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static abstract class ElementContentParsable
    implements ParsableElement {
        private boolean nilled;
        static final long serialVersionUID = -2826386306561723362L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        @Override
        @Trivial
        public final void setNil(boolean nilled) {
            this.nilled = nilled;
        }

        @Override
        @Trivial
        public final boolean isNil() {
            return this.nilled;
        }

        @Override
        @Trivial
        public boolean isIdAllowed() {
            return false;
        }

        @Override
        @Trivial
        public boolean handleAttribute(DDParser parser, String nsURI, String localName, int index) throws ParseException {
            return false;
        }

        @Override
        @Trivial
        public boolean handleContent(DDParser parser) throws ParseException {
            return parser.isWhiteSpace();
        }

        @Override
        @Trivial
        public void finish(DDParser parser) throws ParseException {
        }

        @Trivial
        protected String toTracingSafeString() {
            return super.toString();
        }

        @Trivial
        public final String toString() {
            return this.toTracingSafeString();
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.javaee.ddmodel.DDParser$ElementContentParsable", ElementContentParsable.class, (String)"ddmodel", (String)"com.ibm.ws.javaee.internal.ddmodel.resources.DDModelMessages");
        }
    }

    public static interface ParsableElement
    extends Parsable {
        public void setNil(boolean var1);

        public boolean isNil();

        public boolean isIdAllowed();

        public boolean handleAttribute(DDParser var1, String var2, String var3, int var4) throws ParseException;

        public boolean handleChild(DDParser var1, String var2) throws ParseException;

        public boolean handleContent(DDParser var1) throws ParseException;

        public void finish(DDParser var1) throws ParseException;
    }

    public static interface Parsable {
        public void describe(Diagnostics var1);
    }

    public static interface RootParsable {
        public void describe(StringBuilder var1);
    }

    @TraceObjectField(fieldName="$$$tc$$$", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
    @InjectedFFDC
    @TraceOptions
    public static class ParseException
    extends Exception {
        private static final long serialVersionUID = -2437543890927284677L;
        private static final /* synthetic */ TraceComponent $$$tc$$$;

        public ParseException(String translatedMessage) {
            super(translatedMessage);
        }

        public ParseException(String translatedMessage, Throwable t) {
            super(translatedMessage, t);
        }

        @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
        static {
            $$$tc$$$ = Tr.register((String)"com.ibm.ws.javaee.ddmodel.DDParser$ParseException", ParseException.class, (String)"ddmodel", (String)"com.ibm.ws.javaee.internal.ddmodel.resources.DDModelMessages");
        }
    }
}

