/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.channel.ssl.internal;

import com.ibm.websphere.channelfw.FlowType;
import com.ibm.websphere.channelfw.osgi.CHFWBundle;
import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.ws.channel.ssl.internal.AlpnSupportUtils;
import com.ibm.ws.channel.ssl.internal.SSLAlpnNegotiator;
import com.ibm.ws.channel.ssl.internal.SSLChannel;
import com.ibm.ws.channel.ssl.internal.SSLChannelData;
import com.ibm.ws.channel.ssl.internal.SSLConnectionContextImpl;
import com.ibm.ws.channel.ssl.internal.SSLDiscriminatorState;
import com.ibm.ws.channel.ssl.internal.SSLHandshakeCompletedCallback;
import com.ibm.ws.channel.ssl.internal.SSLLinkConfig;
import com.ibm.ws.channel.ssl.internal.SSLReadServiceContext;
import com.ibm.ws.channel.ssl.internal.SSLUtils;
import com.ibm.ws.channel.ssl.internal.SSLWriteServiceContext;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.wsspi.bytebuffer.WsByteBuffer;
import com.ibm.wsspi.bytebuffer.WsByteBufferUtils;
import com.ibm.wsspi.channelfw.ConnectionLink;
import com.ibm.wsspi.channelfw.ConnectionReadyCallback;
import com.ibm.wsspi.channelfw.OutboundConnectionLink;
import com.ibm.wsspi.channelfw.VirtualConnection;
import com.ibm.wsspi.channelfw.base.OutboundProtocolLink;
import com.ibm.wsspi.kernel.service.utils.FrameworkState;
import com.ibm.wsspi.tcpchannel.SSLConnectionContext;
import com.ibm.wsspi.tcpchannel.TCPConnectRequestContext;
import com.ibm.wsspi.tcpchannel.TCPConnectionContext;
import com.ibm.wsspi.tcpchannel.TCPReadCompletedCallback;
import com.ibm.wsspi.tcpchannel.TCPReadRequestContext;
import com.ibm.wsspi.tcpchannel.TCPWriteRequestContext;
import io.openliberty.wsoc.ssl.SSLContextEnabledAddress;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.ReadOnlyBufferException;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;

public class SSLConnectionLink
extends OutboundProtocolLink
implements ConnectionLink,
TCPConnectionContext {
    protected static final TraceComponent tc = Tr.register(SSLConnectionLink.class, (String)"SSLChannel", (String)"com.ibm.ws.channel.ssl.internal.resources.SSLChannelMessages");
    public static final String LINKCONFIG = "SSLLINKCONFIG";
    private SSLChannel sslChannel = null;
    private SSLLinkConfig linkConfig = null;
    private SSLEngine sslEngine = null;
    private SSLReadServiceContext readInterface = null;
    private SSLWriteServiceContext writeInterface = null;
    private TCPConnectionContext deviceServiceContext = null;
    protected TCPReadRequestContext deviceReadInterface = null;
    private TCPWriteRequestContext deviceWriteInterface = null;
    private SSLConnectionContext sslConnectionContext = null;
    private SSLDiscriminatorState discState = null;
    private volatile boolean connected = false;
    private volatile boolean closed = false;
    private boolean isInbound = false;
    private boolean syncConnectFailure = false;
    private int vcHashCode = 0;
    private SSLContext sslContext = null;
    private TCPConnectRequestContext targetAddress = null;
    private String alpnProtocol;
    private boolean http2Enabled = false;
    private SSLAlpnNegotiator.ThirdPartyAlpnNegotiator alpnNegotiator = null;
    private final Lock cleanupLock = new ReentrantLock();

    public SSLConnectionLink(SSLChannel inputChannel) {
        this.sslChannel = inputChannel;
        this.isInbound = inputChannel.getConfig().isInbound();
    }

    public void init(VirtualConnection inVC) {
        this.vcHashCode = inVC.hashCode();
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("init, vc=" + this.getVCHash()), (Object[])new Object[0]);
        }
        super.init(inVC);
        this.initInterfaces(new SSLConnectionContextImpl(this, !this.isInbound), new SSLReadServiceContext(this), new SSLWriteServiceContext(this));
        if (CHFWBundle.getServletConfiguredHttpVersionSetting() != null) {
            if (CHFWBundle.isHttp2DisabledByDefault()) {
                if (this.getChannel().getUseH2ProtocolAttribute() != null && this.getChannel().getUseH2ProtocolAttribute().booleanValue()) {
                    this.http2Enabled = true;
                    this.sslChannel.checkandInitALPN();
                }
            } else if (CHFWBundle.isHttp2EnabledByDefault() && (this.getChannel().getUseH2ProtocolAttribute() == null || this.getChannel().getUseH2ProtocolAttribute().booleanValue())) {
                this.http2Enabled = true;
                this.sslChannel.checkandInitALPN();
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"init");
        }
    }

    void initInterfaces(SSLConnectionContext sslConnectionContext, SSLReadServiceContext readInterface, SSLWriteServiceContext writeInterface) {
        this.sslConnectionContext = sslConnectionContext;
        this.readInterface = readInterface;
        this.writeInterface = writeInterface;
    }

    public void close(VirtualConnection inVC, Exception e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("close, vc=" + this.getVCHash()), (Object[])new Object[0]);
        }
        this.closed = true;
        this.cleanup();
        if (!this.sslChannel.getstop0Called() && this.getDeviceLink() != null) {
            this.getDeviceLink().close(inVC, e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"close");
        }
    }

    public void destroy(Exception e) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("destroy, vc=" + this.getVCHash()), (Object[])new Object[0]);
        }
        this.connected = false;
        this.cleanup();
        this.getVirtualConnection().getStateMap().remove(LINKCONFIG);
        if (this.syncConnectFailure) {
            super.destroy();
        } else {
            super.destroy(e);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"destroy");
        }
    }

    public void cleanup() {
        this.cleanupLock.lock();
        try {
            if (null != this.writeInterface) {
                this.writeInterface.close();
                this.writeInterface = null;
            }
            if (null != this.readInterface) {
                this.readInterface.close();
                this.readInterface = null;
            }
            if (null != this.getSSLEngine()) {
                if (this.sslChannel.getstop0Called()) {
                    this.connected = false;
                }
                SSLUtils.shutDownSSLEngine(this, this.isInbound, this.connected);
                this.sslEngine = null;
            }
            this.connected = false;
        }
        finally {
            this.cleanupLock.unlock();
        }
    }

    public Object getChannelAccessor() {
        return this;
    }

    public void setDeviceLink(ConnectionLink next) {
        super.setDeviceLink(next);
        this.deviceServiceContext = (TCPConnectionContext)this.getDeviceLink().getChannelAccessor();
        this.deviceReadInterface = this.deviceServiceContext.getReadInterface();
        this.deviceWriteInterface = this.deviceServiceContext.getWriteInterface();
    }

    public void ready(VirtualConnection inVC) {
        block19: {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("ready, vc=" + this.getVCHash()), (Object[])new Object[0]);
            }
            if (!this.closed && FrameworkState.isValid()) {
                try {
                    if (this.isInbound) {
                        Map stateMap = inVC.getStateMap();
                        this.discState = (SSLDiscriminatorState)stateMap.remove("SSLDiscState");
                        if (this.discState != null) {
                            this.sslEngine = this.discState.getEngine();
                            this.sslContext = this.discState.getSSLContext();
                            this.setLinkConfig((SSLLinkConfig)stateMap.get(LINKCONFIG));
                        } else if (this.sslContext == null || this.getSSLEngine() == null) {
                            this.sslContext = this.getChannel().getSSLContextForInboundLink(this, inVC);
                            this.sslEngine = SSLUtils.getSSLEngine(this.sslContext, this.sslChannel.getConfig().getFlowType(), this.getLinkConfig(), this);
                        }
                    } else if (this.sslContext == null || this.getSSLEngine() == null) {
                        this.sslContext = this.getChannel().getSSLContextForOutboundLink(this, inVC, this.targetAddress);
                        this.sslEngine = SSLUtils.getOutboundSSLEngine(this.sslContext, this.getLinkConfig(), this.targetAddress.getRemoteAddress().getHostName(), this.targetAddress.getRemoteAddress().getPort(), this);
                    }
                    if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                        Tr.debug((TraceComponent)tc, (String)("SSL engine hc=" + this.getSSLEngine().hashCode() + " associated with vc=" + this.getVCHash()), (Object[])new Object[0]);
                    }
                    this.connected = true;
                    if (this.isInbound) {
                        this.readyInbound(inVC);
                        break block19;
                    }
                    this.readyOutbound(inVC, true);
                }
                catch (Exception e) {
                    if (FrameworkState.isStopping()) {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Ignoring exception during server shutdown: " + e), (Object[])new Object[0]);
                        }
                    } else {
                        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                            Tr.debug((TraceComponent)tc, (String)("Caught exception during ready, " + e), (Object[])new Object[]{e});
                        }
                        FFDCFilter.processException((Throwable)e, (String)((Object)((Object)this)).getClass().getName(), (String)"238", (Object)((Object)this));
                    }
                    this.close(inVC, e);
                }
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"ready called after close so do nothing", (Object[])new Object[0]);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"ready");
        }
    }

    private void readyInbound(VirtualConnection inVC) {
        WsByteBuffer netBuffer;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("readyInbound, vc=" + this.getVCHash()), (Object[])new Object[0]);
        }
        if ((netBuffer = this.getDeviceReadInterface().getBuffer()) == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Received null buffer so closing connection.", (Object[])new Object[0]);
            }
            this.close(inVC, null);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("readyInbound, vc=" + this.getVCHash()));
            }
            return;
        }
        netBuffer.flip();
        WsByteBuffer decryptedNetBuffer = null;
        WsByteBuffer encryptedAppBuffer = null;
        SSLEngineResult result = null;
        boolean errorOccurred = false;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
            Tr.event((TraceComponent)tc, (String)("Initial read bytes: " + netBuffer.limit()), (Object[])new Object[0]);
        }
        if (this.discState == null) {
            decryptedNetBuffer = SSLUtils.allocateByteBuffer(this.getAppBufferSize(), this.sslChannel.getConfig().getDecryptBuffersDirect());
        } else {
            result = this.discState.getEngineResult();
            decryptedNetBuffer = this.discState.getDecryptedNetBuffer();
            netBuffer.position(this.discState.getNetBufferPosition());
            netBuffer.limit(this.discState.getNetBufferLimit());
        }
        encryptedAppBuffer = SSLUtils.allocateByteBuffer(this.getPacketBufferSize(), true);
        try {
            MyHandshakeCompletedCallback callback;
            if (this.discState == null) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("Before unwrap\r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo(netBuffer) + "\r\n\tdecBuf: " + SSLUtils.getBufferTraceInfo(decryptedNetBuffer)), (Object[])new Object[0]);
                }
                int savedLimit = SSLUtils.adjustBufferForJSSE(netBuffer, this.getPacketBufferSize());
                result = this.getSSLEngine().unwrap(netBuffer.getWrappedByteBuffer(), decryptedNetBuffer.getWrappedByteBuffer());
                if (0 < result.bytesProduced()) {
                    decryptedNetBuffer.flip();
                }
                if (TraceComponent.isAnyTracingEnabled() && tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)("After unwrap\r\n\tnetBuf: " + SSLUtils.getBufferTraceInfo(netBuffer) + "\r\n\tdecBuf: " + SSLUtils.getBufferTraceInfo(decryptedNetBuffer) + "\r\n\tstatus=" + (Object)((Object)result.getStatus()) + " HSstatus=" + (Object)((Object)result.getHandshakeStatus()) + " consumed=" + result.bytesConsumed() + " produced=" + result.bytesProduced()), (Object[])new Object[0]);
                }
                if (-1 != savedLimit) {
                    netBuffer.limit(savedLimit);
                }
                if (netBuffer.remaining() == 0) {
                    netBuffer.clear();
                }
            }
            if ((result = SSLUtils.handleHandshake(this, netBuffer, decryptedNetBuffer, encryptedAppBuffer, result, callback = new MyHandshakeCompletedCallback(this, netBuffer, decryptedNetBuffer, encryptedAppBuffer, FlowType.INBOUND), false)) != null) {
                if (callback != null && callback.getUpdatedNetBuffer() != null) {
                    netBuffer = callback.getUpdatedNetBuffer();
                }
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"readyInbound");
                }
                return;
            }
            this.readyInboundPostHandshake(netBuffer, decryptedNetBuffer, encryptedAppBuffer, result.getHandshakeStatus());
        }
        catch (IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught ioexception, " + ioe), (Object[])new Object[0]);
            }
            errorOccurred = true;
            this.getChannel().getHandshakeErrorTracker().noteHandshakeError(ioe, this.getRemoteAddress(), this.getRemotePort(), this.getLocalAddress(), this.getLocalPort());
            this.close(inVC, ioe);
        }
        catch (ReadOnlyBufferException robe) {
            FFDCFilter.processException((Throwable)robe, (String)((Object)((Object)this)).getClass().getName(), (String)"359", (Object)((Object)this));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught read-only exception, " + robe), (Object[])new Object[0]);
            }
            errorOccurred = true;
            this.close(inVC, robe);
        }
        if (errorOccurred) {
            if (decryptedNetBuffer != null) {
                decryptedNetBuffer.release();
                decryptedNetBuffer = null;
            }
            netBuffer.release();
            netBuffer = null;
            this.getDeviceReadInterface().setBuffers(null);
            if (encryptedAppBuffer != null) {
                encryptedAppBuffer.release();
                encryptedAppBuffer = null;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readyInbound");
        }
    }

    protected void readyInboundPostHandshake(WsByteBuffer netBuffer, WsByteBuffer decryptedNetBuffer, WsByteBuffer encryptedAppBuffer, SSLEngineResult.HandshakeStatus hsStatus) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("readyInboundPostHandshake, vc=" + this.getVCHash()), (Object[])new Object[0]);
        }
        encryptedAppBuffer.release();
        if (hsStatus == SSLEngineResult.HandshakeStatus.FINISHED) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Cleanup possible ALPN resources - handshake finished", (Object[])new Object[0]);
            }
            AlpnSupportUtils.getAlpnResult(this.getSSLEngine(), this);
            this.getChannel().onHandshakeFinish(this.getSSLEngine());
            if (netBuffer.remaining() == 0 || netBuffer.position() == 0) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Releasing netBuffer: " + netBuffer.hashCode()), (Object[])new Object[0]);
                }
                netBuffer.release();
                this.getDeviceReadInterface().setBuffers(null);
            } else if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("App data exists in netBuffer after handshake: " + netBuffer.remaining()), (Object[])new Object[0]);
            }
            this.readInterface.setBuffer(decryptedNetBuffer);
            MyReadCompletedCallback readCallback = new MyReadCompletedCallback(decryptedNetBuffer);
            if (null != this.readInterface.read(1L, readCallback, false, 0)) {
                this.determineNextChannel();
            }
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unhandled result from SSL engine: " + (Object)((Object)hsStatus)), (Object[])new Object[0]);
                Tr.debug((TraceComponent)tc, (String)"Cleanup possible ALPN resources on unhandled results", (Object[])new Object[0]);
            }
            AlpnSupportUtils.getAlpnResult(this.getSSLEngine(), this);
            netBuffer.release();
            this.getDeviceReadInterface().setBuffers(null);
            decryptedNetBuffer.release();
            SSLException ssle = new SSLException("Unhandled result from SSL engine: " + (Object)((Object)hsStatus));
            FFDCFilter.processException((Throwable)ssle, (String)((Object)((Object)this)).getClass().getName(), (String)"401", (Object)((Object)this));
            this.close(this.getVirtualConnection(), ssle);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readyInboundPostHandshake");
        }
    }

    private void readyOutbound(VirtualConnection inVC, boolean async) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("readyOutbound, vc=" + this.getVCHash()), (Object[])new Object[0]);
        }
        SSLChannelData config = this.sslChannel.getConfig();
        WsByteBuffer netBuffer = SSLUtils.allocateByteBuffer(this.getPacketBufferSize(), config.getEncryptBuffersDirect());
        WsByteBuffer decryptedNetBuffer = SSLUtils.allocateByteBuffer(this.getAppBufferSize(), config.getDecryptBuffersDirect());
        WsByteBuffer encryptedAppBuffer = SSLUtils.allocateByteBuffer(this.getPacketBufferSize(), true);
        SSLEngineResult sslResult = null;
        MyHandshakeCompletedCallback callback = null;
        IOException exception = null;
        if (async) {
            callback = new MyHandshakeCompletedCallback(this, netBuffer, decryptedNetBuffer, encryptedAppBuffer, FlowType.OUTBOUND);
        }
        try {
            sslResult = SSLUtils.handleHandshake(this, netBuffer, decryptedNetBuffer, encryptedAppBuffer, sslResult, callback, false);
            if (sslResult != null) {
                if (callback != null && callback.getUpdatedNetBuffer() != null) {
                    netBuffer = callback.getUpdatedNetBuffer();
                }
                this.readyOutboundPostHandshake(netBuffer, decryptedNetBuffer, encryptedAppBuffer, sslResult.getHandshakeStatus(), async);
            }
        }
        catch (IOException e) {
            exception = e;
        }
        catch (ReadOnlyBufferException e) {
            exception = new IOException("Caught exception: " + e);
        }
        if (exception != null) {
            FFDCFilter.processException((Throwable)exception, (String)((Object)((Object)this)).getClass().getName(), (String)"540", (Object)((Object)this));
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught exception during handshake after connect, " + exception), (Object[])new Object[0]);
            }
            if (netBuffer != null) {
                netBuffer.release();
                netBuffer = null;
                this.getDeviceReadInterface().setBuffers(null);
            }
            if (decryptedNetBuffer != null) {
                decryptedNetBuffer.release();
                decryptedNetBuffer = null;
            }
            if (encryptedAppBuffer != null) {
                encryptedAppBuffer.release();
                encryptedAppBuffer = null;
            }
            if (async) {
                this.close(inVC, exception);
            } else {
                this.syncConnectFailure = true;
                this.close(inVC, exception);
                throw exception;
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readyOutbound");
        }
    }

    protected void readyOutboundPostHandshake(WsByteBuffer netBuffer, WsByteBuffer decryptedNetBuffer, WsByteBuffer encryptedAppBuffer, SSLEngineResult.HandshakeStatus hsStatus, boolean async) throws IOException {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("readyOutboundPostHandshake, vc=" + this.getVCHash()), (Object[])new Object[0]);
        }
        IOException exception = null;
        if (hsStatus != SSLEngineResult.HandshakeStatus.FINISHED) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Unexpected results of handshake after connect, " + (Object)((Object)hsStatus)), (Object[])new Object[0]);
            }
            exception = new IOException("Unexpected results of handshake after connect, " + (Object)((Object)hsStatus));
        }
        this.getChannel().onHandshakeFinish(this.getSSLEngine());
        this.getDeviceReadInterface().setBuffers(null);
        if (netBuffer.remaining() == 0 || netBuffer.position() == 0) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Releasing netBuffer: " + netBuffer.hashCode()), (Object[])new Object[0]);
            }
            netBuffer.release();
        } else {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("App data exists in netBuffer after handshake: " + netBuffer.remaining()), (Object[])new Object[0]);
            }
            this.readInterface.setNetBuffer(netBuffer);
        }
        decryptedNetBuffer.release();
        encryptedAppBuffer.release();
        if (async) {
            if (exception != null) {
                this.close(this.getVirtualConnection(), exception);
            } else {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Calling ready method.", (Object[])new Object[0]);
                }
                super.ready(this.getVirtualConnection());
            }
        } else if (exception != null) {
            throw exception;
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"readyOutboundPostHandshake");
        }
    }

    private void handleRedundantConnect() {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("handleRedundantConnect, vc=" + this.getVCHash()), (Object[])new Object[0]);
        }
        this.cleanup();
        this.sslEngine = SSLUtils.getOutboundSSLEngine(this.sslContext, this.getLinkConfig(), this.targetAddress.getRemoteAddress().getHostName(), this.targetAddress.getRemoteAddress().getPort(), this);
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("New SSL engine=" + this.getSSLEngine().hashCode() + " for vc=" + this.getVCHash()), (Object[])new Object[0]);
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"handleRedundantConnect");
        }
    }

    public void connectAsynch(Object address) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("connectAsynch, vc=" + this.getVCHash()), (Object[])new Object[0]);
        }
        if (this.connected) {
            this.handleRedundantConnect();
        }
        this.targetAddress = (TCPConnectRequestContext)address;
        ((OutboundConnectionLink)this.getDeviceLink()).connectAsynch(address);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"connectAsynch");
        }
    }

    public void connect(Object address) throws Exception {
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("connect, vc=" + this.getVCHash()), (Object[])new Object[0]);
        }
        if (this.connected) {
            this.handleRedundantConnect();
        }
        this.targetAddress = (TCPConnectRequestContext)address;
        ((OutboundConnectionLink)this.getDeviceLink()).connect(address);
        this.connected = true;
        if (this.sslContext == null || this.getSSLEngine() == null) {
            if (address instanceof SSLContextEnabledAddress && ((SSLContextEnabledAddress)address).getSSLContext() != null) {
                this.initalizeSSLforWebsocket21(((SSLContextEnabledAddress)address).getSSLContext());
            } else {
                this.sslContext = this.getChannel().getSSLContextForOutboundLink(this, this.getVirtualConnection(), address);
                this.sslEngine = SSLUtils.getOutboundSSLEngine(this.sslContext, this.getLinkConfig(), this.targetAddress.getRemoteAddress().getHostName(), this.targetAddress.getRemoteAddress().getPort(), this);
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("SSL engine hc=" + this.getSSLEngine().hashCode() + " associated with vc=" + this.getVCHash()), (Object[])new Object[0]);
        }
        this.readyOutbound(this.getVirtualConnection(), false);
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"connect");
        }
    }

    private void initalizeSSLforWebsocket21(SSLContext sslContext) throws SSLException {
        this.sslContext = sslContext;
        this.sslEngine = sslContext.createSSLEngine(this.targetAddress.getRemoteAddress().getHostName(), this.targetAddress.getRemoteAddress().getPort());
        this.sslEngine.setUseClientMode(true);
        this.sslEngine.beginHandshake();
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("initalizeSSLforWebsocket21: Using passed in sslContext: " + this.sslContext), (Object[])new Object[0]);
        }
    }

    protected void determineNextChannel() {
        ConnectionReadyCallback linkOnApplicationSide;
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)("determineNextChannel, vc=" + this.getVCHash()), (Object[])new Object[0]);
        }
        if ((linkOnApplicationSide = this.getApplicationCallback()) != null) {
            linkOnApplicationSide.ready(this.getVirtualConnection());
        } else {
            int discriminationResult = 1;
            try {
                discriminationResult = this.getChannel().getDiscriminationProcess().discriminate(this.getVirtualConnection(), (Object)this.readInterface.getBuffers(), (ConnectionLink)this);
            }
            catch (Exception e) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)("Exception caught doing discriminate, " + e), (Object[])new Object[0]);
                }
                FFDCFilter.processException((Throwable)e, (String)((Object)((Object)this)).getClass().getName(), (String)"346", (Object)((Object)this));
                throw new RuntimeException("Exception caught doing discriminate, " + e);
            }
            switch (discriminationResult) {
                case 1: {
                    this.getApplicationCallback().ready(this.getVirtualConnection());
                    break;
                }
                case 0: {
                    WsByteBuffer[] buffers = this.getDeviceReadInterface().getBuffers();
                    for (int i = 0; i < buffers.length; ++i) {
                        if (buffers[i] != this.readInterface.netBuffer) continue;
                        buffers[i] = null;
                    }
                    WsByteBufferUtils.releaseBufferArray((WsByteBuffer[])buffers);
                    this.close(this.getVirtualConnection(), new Exception("Failure response from discrimination process."));
                    break;
                }
                case 2: {
                    this.readInterface.setBuffer(this.readInterface.getBuffer());
                    MoreDataNeededCallback callback = new MoreDataNeededCallback();
                    if (null == this.readInterface.read(1L, callback, false, 0)) break;
                    this.determineNextChannel();
                    break;
                }
                default: {
                    WsByteBufferUtils.releaseBufferArray((WsByteBuffer[])this.getDeviceReadInterface().getBuffers());
                    this.close(this.getVirtualConnection(), new Exception("Unknown response from discrimination process, " + discriminationResult));
                }
            }
        }
        if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"determineNextChannel");
        }
    }

    public void postConnectProcessing(VirtualConnection inVC) {
    }

    public SSLChannel getChannel() {
        return this.sslChannel;
    }

    public SSLEngine getSSLEngine() {
        return this.sslEngine;
    }

    public int getAppBufferSize() {
        return this.getSSLEngine().getSession().getApplicationBufferSize();
    }

    public int getPacketBufferSize() {
        return this.getSSLEngine().getSession().getPacketBufferSize();
    }

    public TCPReadRequestContext getDeviceReadInterface() {
        return this.deviceReadInterface;
    }

    public TCPWriteRequestContext getDeviceWriteInterface() {
        return this.deviceWriteInterface;
    }

    public TCPReadRequestContext getReadInterface() {
        return this.readInterface;
    }

    public TCPWriteRequestContext getWriteInterface() {
        return this.writeInterface;
    }

    public InetAddress getRemoteAddress() {
        return this.deviceServiceContext.getRemoteAddress();
    }

    public int getRemotePort() {
        return this.deviceServiceContext.getRemotePort();
    }

    public InetAddress getLocalAddress() {
        return this.deviceServiceContext.getLocalAddress();
    }

    public int getLocalPort() {
        return this.deviceServiceContext.getLocalPort();
    }

    public SSLConnectionContext getSSLContext() {
        return this.sslConnectionContext;
    }

    protected void setLinkConfig(SSLLinkConfig config) {
        this.linkConfig = config;
    }

    public SSLLinkConfig getLinkConfig() {
        return this.linkConfig;
    }

    protected int getVCHash() {
        return this.vcHashCode;
    }

    public void setAlpnProtocol(String protocol) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("setAlpnProtocol: " + protocol + " " + (Object)((Object)this)), (Object[])new Object[0]);
        }
        this.alpnProtocol = protocol;
        this.sslConnectionContext.setAlpnProtocol(protocol);
    }

    public String getAlpnProtocol() {
        return this.alpnProtocol;
    }

    protected boolean isAlpnEnabled() {
        return this.http2Enabled;
    }

    protected void setAlpnNegotiator(SSLAlpnNegotiator.ThirdPartyAlpnNegotiator negotiator) {
        this.alpnNegotiator = negotiator;
    }

    protected SSLAlpnNegotiator.ThirdPartyAlpnNegotiator getAlpnNegotiator() {
        return this.alpnNegotiator;
    }

    public class MoreDataNeededCallback
    implements TCPReadCompletedCallback {
        public void complete(VirtualConnection inVC, TCPReadRequestContext rsc) {
            SSLConnectionLink.this.determineNextChannel();
        }

        public void error(VirtualConnection inVC, TCPReadRequestContext rsc, IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught exception reading more data to determine next channel, " + ioe), (Object[])new Object[0]);
            }
            FFDCFilter.processException((Throwable)ioe, (String)this.getClass().getName(), (String)"2360", (Object)this);
            SSLConnectionLink.this.close(inVC, ioe);
        }
    }

    public class MyReadCompletedCallback
    implements TCPReadCompletedCallback {
        private WsByteBuffer decryptedNetBuffer;

        public MyReadCompletedCallback(WsByteBuffer _decryptedNetBuffer) {
            this.decryptedNetBuffer = _decryptedNetBuffer;
        }

        public void complete(VirtualConnection inVC, TCPReadRequestContext rsc) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("complete (read), vc=" + SSLConnectionLink.this.getVCHash()), (Object[])new Object[0]);
            }
            SSLConnectionLink.this.determineNextChannel();
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("complete (read), vc=" + SSLConnectionLink.this.getVCHash()));
            }
        }

        public void error(VirtualConnection inVC, TCPReadRequestContext rsc, IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("error (read), vc=" + SSLConnectionLink.this.getVCHash()), (Object[])new Object[0]);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught IOException during read, " + ioe), (Object[])new Object[0]);
            }
            if (this.decryptedNetBuffer != null) {
                this.decryptedNetBuffer.release();
            }
            this.decryptedNetBuffer = null;
            SSLConnectionLink.this.close(inVC, ioe);
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("error (read), vc=" + SSLConnectionLink.this.getVCHash()));
            }
        }
    }

    class MyHandshakeCompletedCallback
    implements SSLHandshakeCompletedCallback {
        private final SSLConnectionLink connLink;
        private WsByteBuffer netBuffer;
        private WsByteBuffer decryptedNetBuffer;
        private WsByteBuffer encryptedAppBuffer;
        private final FlowType flowType;
        private WsByteBuffer updatedNetBuffer = null;

        public MyHandshakeCompletedCallback(SSLConnectionLink _connLink, WsByteBuffer _netBuffer, WsByteBuffer _decryptedNetBuffer, WsByteBuffer _encryptedAppBuffer, FlowType _flowType) {
            this.connLink = _connLink;
            this.netBuffer = _netBuffer;
            this.decryptedNetBuffer = _decryptedNetBuffer;
            this.encryptedAppBuffer = _encryptedAppBuffer;
            this.flowType = _flowType;
        }

        @Override
        public void updateNetBuffer(WsByteBuffer newBuffer) {
            this.netBuffer = newBuffer;
            this.updatedNetBuffer = newBuffer;
        }

        @Override
        public WsByteBuffer getUpdatedNetBuffer() {
            return this.updatedNetBuffer;
        }

        @Override
        public void complete(SSLEngineResult sslResult) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.entry((TraceComponent)tc, (String)("complete (handshake), vc=" + SSLConnectionLink.this.getVCHash()), (Object[])new Object[0]);
            }
            SSLEngineResult.HandshakeStatus sslStatus = sslResult.getHandshakeStatus();
            if (this.flowType == FlowType.INBOUND) {
                this.connLink.readyInboundPostHandshake(this.netBuffer, this.decryptedNetBuffer, this.encryptedAppBuffer, sslStatus);
            } else {
                try {
                    this.connLink.readyOutboundPostHandshake(this.netBuffer, this.decryptedNetBuffer, this.encryptedAppBuffer, sslStatus, true);
                }
                catch (IOException e) {
                    SSLConnectionLink.this.close(SSLConnectionLink.this.getVirtualConnection(), e);
                }
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("complete (handshake), vc=" + SSLConnectionLink.this.getVCHash()));
            }
        }

        @Override
        public void error(IOException ioe) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("error (handshake), vc=" + SSLConnectionLink.this.getVCHash()), (Object[])new Object[0]);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Caught exception during unwrap, " + ioe), (Object[])new Object[0]);
            }
            if (this.flowType == FlowType.INBOUND) {
                if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                    Tr.debug((TraceComponent)tc, (String)"Cleanup possible ALPN resources - error callback", (Object[])new Object[0]);
                }
                AlpnSupportUtils.getAlpnResult(SSLConnectionLink.this.getSSLEngine(), this.connLink);
            }
            if (this.decryptedNetBuffer != null) {
                this.decryptedNetBuffer.release();
                this.decryptedNetBuffer = null;
            }
            if (this.netBuffer != null) {
                this.netBuffer.release();
                this.netBuffer = null;
                SSLConnectionLink.this.getDeviceReadInterface().setBuffers(null);
            }
            if (this.encryptedAppBuffer != null) {
                this.encryptedAppBuffer.release();
                this.encryptedAppBuffer = null;
            }
            if (this.flowType == FlowType.INBOUND) {
                SSLConnectionLink.this.close(this.connLink.getVirtualConnection(), ioe);
            } else if (ioe == null) {
                SSLConnectionLink.this.close(SSLConnectionLink.this.getVirtualConnection(), null);
            } else {
                SSLConnectionLink.this.close(SSLConnectionLink.this.getVirtualConnection(), ioe);
            }
            if (TraceComponent.isAnyTracingEnabled() && tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)("error (handshake), vc=" + SSLConnectionLink.this.getVCHash()));
            }
        }
    }
}

