/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.webcontainer.session;

import com.ibm.ejs.ras.TraceComponent;
import com.ibm.ejs.ras.TraceNLS;
import com.ibm.wsspi.webcontainer.logging.LoggerFactory;
import jakarta.servlet.SessionCookieConfig;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SessionCookieConfigImpl
implements SessionCookieConfig,
Cloneable {
    private static final String CLASS_NAME = SessionCookieConfigImpl.class.getName();
    private static final Logger logger = LoggerFactory.getInstance().getLogger("com.ibm.ws.webcontainer.session");
    private String comment = null;
    private String domain = null;
    private int maxAge = -1;
    private boolean maxAgeSet = false;
    private String name = null;
    private String path = null;
    private boolean httpOnly = true;
    private boolean httpOnlySet = false;
    private boolean secure = false;
    private boolean secureSet = false;
    private boolean contextInitialized = false;
    private static final boolean externalCall = true;
    private boolean programmaticChange = false;
    private static TraceNLS nls = TraceNLS.getTraceNLS(SessionCookieConfigImpl.class, (String)"com.ibm.ws.webcontainer.resources.Messages");

    public SessionCookieConfigImpl() {
    }

    public SessionCookieConfigImpl(String name, String domain, String path, String comment, int maxAge, boolean httpOnly, boolean secure) {
        this.name = name;
        this.domain = domain;
        this.path = path;
        this.comment = comment;
        this.maxAge = maxAge;
        this.httpOnly = httpOnly;
        this.secure = secure;
        if (TraceComponent.isAnyTracingEnabled() && logger.isLoggable(Level.FINE)) {
            logger.log(Level.FINE, CLASS_NAME, " Constructor ");
        }
    }

    public String getComment() {
        return this.comment;
    }

    public String getDomain() {
        return this.domain;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public String getName() {
        return this.name;
    }

    public String getPath() {
        return this.path;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public boolean isSecure() {
        return this.secure;
    }

    public void setComment(String c) {
        this.setComment(c, true);
    }

    public void setDomain(String d) {
        this.setDomain(d, true);
    }

    public void setHttpOnly(boolean b) {
        this.setHttpOnly(b, true);
    }

    public void setMaxAge(int m) {
        this.setMaxAge(m, true);
    }

    public void setName(String n) {
        this.setName(n, true);
    }

    public void setPath(String p) {
        this.setPath(p, true);
    }

    public void setSecure(boolean b) {
        this.setSecure(b, true);
    }

    public boolean isMaxAgeSet() {
        return this.maxAgeSet;
    }

    public boolean isHttpOnlySet() {
        return this.httpOnlySet;
    }

    public boolean isSecureSet() {
        return this.secureSet;
    }

    public void setContextInitialized() {
        this.contextInitialized = true;
    }

    public void setComment(String c, boolean externalCall) {
        if (externalCall) {
            this.programmaticChange = true;
        }
        if (this.contextInitialized) {
            this.throwWarning();
        }
        this.comment = c;
    }

    public void setDomain(String d, boolean externalCall) {
        if (externalCall) {
            this.programmaticChange = true;
        }
        if (this.contextInitialized) {
            this.throwWarning();
        }
        this.domain = d;
    }

    public void setHttpOnly(boolean b, boolean externalCall) {
        if (externalCall) {
            this.programmaticChange = true;
        }
        if (this.contextInitialized) {
            this.throwWarning();
        }
        this.httpOnly = b;
        this.httpOnlySet = true;
    }

    public void setMaxAge(int m, boolean externalCall) {
        if (externalCall) {
            this.programmaticChange = true;
        }
        if (this.contextInitialized) {
            this.throwWarning();
        }
        this.maxAge = m;
        this.maxAgeSet = true;
    }

    public void setName(String n, boolean externalCall) {
        if (externalCall) {
            this.programmaticChange = true;
        }
        if (this.contextInitialized) {
            this.throwWarning();
        }
        this.name = n;
    }

    public void setPath(String p, boolean externalCall) {
        if (externalCall) {
            this.programmaticChange = true;
        }
        if (this.contextInitialized) {
            this.throwWarning();
        }
        this.path = p;
    }

    public void setSecure(boolean b, boolean externalCall) {
        if (externalCall) {
            this.programmaticChange = true;
        }
        if (this.contextInitialized) {
            this.throwWarning();
        }
        this.secure = b;
        this.secureSet = true;
    }

    public SessionCookieConfigImpl clone() throws CloneNotSupportedException {
        SessionCookieConfigImpl temp = new SessionCookieConfigImpl(this.name, this.domain, this.path, this.comment, this.maxAge, this.httpOnly, this.secure);
        return temp;
    }

    private void throwWarning() {
        String msg = nls.getString("programmatic.sessions.already.been.initialized");
        throw new IllegalStateException(msg);
    }

    public boolean isProgrammaticChange() {
        return this.programmaticChange;
    }
}

