/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.security.jwt.internal;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.Sensitive;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.websphere.security.jwt.InvalidClaimException;
import com.ibm.websphere.security.jwt.InvalidTokenException;
import com.ibm.websphere.security.jwt.JwtToken;
import com.ibm.websphere.security.jwt.KeyException;
import com.ibm.websphere.security.jwt.KeyStoreServiceException;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.security.common.crypto.KeyAlgorithmChecker;
import com.ibm.ws.security.common.jwk.impl.JwKRetriever;
import com.ibm.ws.security.common.time.TimeUtils;
import com.ibm.ws.security.jwt.config.JwtConsumerConfig;
import com.ibm.ws.security.jwt.config.MpConfigProperties;
import com.ibm.ws.security.jwt.internal.JwtCache;
import com.ibm.ws.security.jwt.internal.JwtTokenConsumerImpl;
import com.ibm.ws.security.jwt.utils.JtiNonceCache;
import com.ibm.ws.security.jwt.utils.JweHelper;
import com.ibm.ws.security.jwt.utils.JwtUtils;
import com.ibm.ws.ssl.KeyStoreService;
import com.ibm.wsspi.kernel.service.utils.AtomicServiceReference;
import java.io.UnsupportedEncodingException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.StringTokenizer;
import org.jose4j.jws.JsonWebSignature;
import org.jose4j.jwt.JwtClaims;
import org.jose4j.jwt.MalformedClaimException;
import org.jose4j.jwt.NumericDate;
import org.jose4j.jwt.consumer.InvalidJwtException;
import org.jose4j.jwt.consumer.InvalidJwtSignatureException;
import org.jose4j.jwt.consumer.JwtConsumer;
import org.jose4j.jwt.consumer.JwtConsumerBuilder;
import org.jose4j.jwt.consumer.JwtContext;
import org.jose4j.jwx.JsonWebStructure;
import org.jose4j.keys.HmacKey;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class ConsumerUtil {
    private static final TraceComponent tc = Tr.register(ConsumerUtil.class, (String)"JWTBUILDER", (String)"com.ibm.ws.security.jwt.internal.resources.JWTMessages");
    private AtomicServiceReference<KeyStoreService> keyStoreService = null;
    private static TimeUtils timeUtils = new TimeUtils("yyyy-MM-dd'T'HH:mm:ssZ");
    private final JtiNonceCache jtiCache = new JtiNonceCache();
    static JwtCache jwtCache = null;
    private static final MpConfigProperties NO_MP_CONFIG_PROPERTIES = new MpConfigProperties();
    static final long serialVersionUID = 2110030139856161571L;

    public ConsumerUtil(AtomicServiceReference<KeyStoreService> kss) {
        this.keyStoreService = kss;
    }

    public JwtToken parseJwt(String jwtString, JwtConsumerConfig config) throws Exception {
        return this.parseJwt(jwtString, config, null);
    }

    public JwtToken parseJwt(String jwtString, JwtConsumerConfig config, MpConfigProperties properties) throws Exception {
        boolean isJwtContextAlreadyCached;
        JwtContext jwtContext = this.getJwtContextFromCache(jwtString, config);
        boolean bl = isJwtContextAlreadyCached = jwtContext != null;
        if (!isJwtContextAlreadyCached) {
            if (properties == null) {
                properties = NO_MP_CONFIG_PROPERTIES;
            }
            jwtContext = this.parseJwtAndGetJwtContext(jwtString, config, properties);
        }
        JwtTokenConsumerImpl jwtToken = new JwtTokenConsumerImpl(jwtContext);
        this.checkForReusedJwt(jwtToken, config);
        if (!isJwtContextAlreadyCached) {
            this.cacheJwtContext(jwtString, jwtContext, config, properties);
        }
        return jwtToken;
    }

    JwtContext parseJwtAndGetJwtContext(String jwtString, JwtConsumerConfig config, MpConfigProperties mpConfigProps) throws Exception {
        JwtContext jwtContext = this.parseJwtWithoutValidation(jwtString, config, mpConfigProps);
        if (config.isValidationRequired()) {
            this.validateJwtContext(jwtContext, config, mpConfigProps);
        }
        return jwtContext;
    }

    void checkForReusedJwt(JwtTokenConsumerImpl jwt, JwtConsumerConfig config) throws InvalidTokenException {
        if (!config.getTokenReuse()) {
            this.throwExceptionIfJwtReused(jwt);
        }
    }

    void throwExceptionIfJwtReused(JwtTokenConsumerImpl jwt) throws InvalidTokenException {
        if (this.jtiCache.contains(jwt)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("JWT token can only be submitted once. The issuer is " + jwt.getClaims().getIssuer() + ", and JTI is " + jwt.getClaims().getJwtId()), (Object[])new Object[0]);
            }
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_DUP_JTI_ERR", (Object[])new Object[]{jwt.getClaims().getIssuer(), jwt.getClaims().getJwtId()});
            throw new InvalidTokenException(errorMsg);
        }
    }

    Key getSigningKey(JwtConsumerConfig config, JwtContext jwtContext, MpConfigProperties mpConfigProps) throws KeyException {
        Key signingKey = null;
        if (config == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"JWT consumer config object is null", (Object[])new Object[0]);
            }
            return null;
        }
        signingKey = this.getSigningKeyBasedOnSignatureAlgorithm(config, jwtContext, mpConfigProps);
        if (signingKey == null && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"A signing key could not be found", (Object[])new Object[0]);
        }
        return signingKey;
    }

    Key getSigningKeyBasedOnSignatureAlgorithm(JwtConsumerConfig config, JwtContext jwtContext, MpConfigProperties mpConfigProps) throws KeyException {
        Key signingKey = null;
        String sigAlg = mpConfigProps.getConfiguredSignatureAlgorithm(config);
        boolean isAsymmetricAlgorithm = false;
        if (KeyAlgorithmChecker.isHSAlgorithm((String)sigAlg)) {
            signingKey = this.getSigningKeyForHS(sigAlg, config);
        } else if (KeyAlgorithmChecker.isRSAlgorithm((String)sigAlg)) {
            signingKey = this.getSigningKeyForRS(config, jwtContext, mpConfigProps);
            isAsymmetricAlgorithm = true;
        } else if (KeyAlgorithmChecker.isESAlgorithm((String)sigAlg)) {
            signingKey = this.getSigningKeyForES(config, jwtContext, mpConfigProps);
            isAsymmetricAlgorithm = true;
        }
        if (isAsymmetricAlgorithm && !KeyAlgorithmChecker.isPublicKeyValidType((Key)signingKey, (String)sigAlg)) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Public key " + signingKey + " does not match the parameters of the " + sigAlg + " algorithm"), (Object[])new Object[0]);
            }
            return null;
        }
        return signingKey;
    }

    /*
     * WARNING - void declaration
     */
    Key getSigningKeyForHS(String signatureAlgorithm, JwtConsumerConfig config) throws KeyException {
        Key signingKey = null;
        try {
            signingKey = this.getSharedSecretKey(config);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.jwt.internal.ConsumerUtil", (String)"183", (Object)this, (Object[])new Object[]{signatureAlgorithm, config});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_ERROR_GETTING_SHARED_KEY", (Object[])new Object[]{e.getLocalizedMessage()});
            throw new KeyException(msg, (Throwable)e);
        }
        return signingKey;
    }

    Key getSharedSecretKey(JwtConsumerConfig config) throws KeyException {
        if (config == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"JWT consumer config object is null", (Object[])new Object[0]);
            }
            return null;
        }
        String sharedKey = config.getSharedKey();
        return this.createKeyFromSharedKey(sharedKey);
    }

    /*
     * WARNING - void declaration
     */
    Key createKeyFromSharedKey(String sharedKey) throws KeyException {
        if (sharedKey == null || sharedKey.isEmpty()) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_MISSING_SHARED_KEY", (Object[])new Object[0]);
            throw new KeyException(msg);
        }
        try {
            return new HmacKey(sharedKey.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException msg) {
            FFDCFilter.processException((Throwable)msg, (String)"com.ibm.ws.security.jwt.internal.ConsumerUtil", (String)"214", (Object)this, (Object[])new Object[]{sharedKey});
            if (tc.isDebugEnabled()) {
                void e;
                Tr.debug((TraceComponent)tc, (String)("Caught exception getting shared key bytes: " + e.getLocalizedMessage()), (Object[])new Object[0]);
            }
            return null;
        }
    }

    boolean isPublicKeyPropsPresent(MpConfigProperties mpConfigProps) {
        return mpConfigProps.get("mp.jwt.verify.publickey") != null || mpConfigProps.get("mp.jwt.verify.publickey.location") != null;
    }

    Key getSigningKeyForRS(JwtConsumerConfig config, JwtContext jwtContext, MpConfigProperties mpConfigProps) throws KeyException {
        return this.getKeyFromJwkOrTrustStore(config, jwtContext, mpConfigProps);
    }

    Key getKeyFromJwkOrTrustStore(JwtConsumerConfig config, JwtContext jwtContext, MpConfigProperties mpConfigProps) throws KeyException {
        Key signingKey = null;
        signingKey = config.getJwkEnabled() || config.getTrustedAlias() == null && this.isPublicKeyPropsPresent(mpConfigProps) ? this.getKeyForJwkEnabled(config, jwtContext, mpConfigProps) : this.getKeyForJwkDisabled(config, mpConfigProps);
        return signingKey;
    }

    /*
     * WARNING - void declaration
     */
    Key getKeyForJwkEnabled(JwtConsumerConfig config, JwtContext jwtContext, MpConfigProperties mpConfigProps) throws KeyException {
        Key signingKey = null;
        try {
            signingKey = this.getJwksKey(config, jwtContext, mpConfigProps);
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.jwt.internal.ConsumerUtil", (String)"253", (Object)this, (Object[])new Object[]{config, jwtContext, mpConfigProps});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_ERROR_GETTING_JWK_KEY", (Object[])new Object[]{config.getJwkEndpointUrl(), e.getLocalizedMessage()});
            throw new KeyException(msg, (Throwable)e);
        }
        return signingKey;
    }

    protected Key getJwksKey(JwtConsumerConfig config, JwtContext jwtContext, MpConfigProperties mpConfigProps) throws Exception {
        JsonWebStructure jwtHeader = this.getJwtHeader(jwtContext);
        String kid = jwtHeader.getKeyIdHeaderValue();
        JwKRetriever jwkRetriever = this.createJwkRetriever(config, mpConfigProps);
        PublicKey signingKey = jwkRetriever.getPublicKeyFromJwk(kid, null, config.getUseSystemPropertiesForHttpClientConnections());
        return signingKey;
    }

    JwKRetriever createJwkRetriever(JwtConsumerConfig config, MpConfigProperties mpConfigProps) {
        JwKRetriever jwkRetriever = null;
        String configuredSignatureAlgorithm = mpConfigProps.getConfiguredSignatureAlgorithm(config);
        String publickey = (String)mpConfigProps.get("mp.jwt.verify.publickey");
        String keyLocation = (String)mpConfigProps.get("mp.jwt.verify.publickey.location");
        if (publickey != null || keyLocation != null) {
            jwkRetriever = new JwKRetriever(config.getId(), config.getSslRef(), config.getJwkEndpointUrl(), config.getJwkSet(), JwtUtils.getSSLSupportService(), config.isHostNameVerificationEnabled(), null, null, configuredSignatureAlgorithm, publickey, keyLocation);
        }
        if (jwkRetriever == null) {
            jwkRetriever = new JwKRetriever(config.getId(), config.getSslRef(), config.getJwkEndpointUrl(), config.getJwkSet(), JwtUtils.getSSLSupportService(), config.isHostNameVerificationEnabled(), null, null, configuredSignatureAlgorithm);
        }
        return jwkRetriever;
    }

    JsonWebStructure getJwtHeader(JwtContext jwtContext) throws Exception {
        List jsonStructures = jwtContext.getJoseObjects();
        if (jsonStructures == null || jsonStructures.isEmpty()) {
            throw new Exception("Invalid JsonWebStructure");
        }
        JsonWebStructure jwtHeader = (JsonWebStructure)jsonStructures.get(0);
        this.debugJwtHeader(jwtHeader);
        return jwtHeader;
    }

    void debugJwtHeader(JsonWebStructure jwtHeader) {
        if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("JsonWebStructure class: " + jwtHeader.getClass().getName() + " data:" + jwtHeader), (Object[])new Object[0]);
            if (jwtHeader instanceof JsonWebSignature) {
                JsonWebSignature signature = (JsonWebSignature)jwtHeader;
                Tr.debug((TraceComponent)tc, (String)("JsonWebSignature alg: " + signature.getAlgorithmHeaderValue() + " 3rd:'" + signature.getEncodedSignature() + "'"), (Object[])new Object[0]);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    Key getKeyForJwkDisabled(JwtConsumerConfig config, MpConfigProperties mpConfigProps) throws KeyException {
        Key signingKey = null;
        String trustedAlias = config.getTrustedAlias();
        String trustStoreRef = config.getTrustStoreRef();
        try {
            signingKey = this.getPublicKey(trustedAlias, trustStoreRef, mpConfigProps.getConfiguredSignatureAlgorithm(config));
        }
        catch (Exception exception) {
            void e;
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.jwt.internal.ConsumerUtil", (String)"326", (Object)this, (Object[])new Object[]{config, mpConfigProps});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_ERROR_GETTING_PUBLIC_KEY", (Object[])new Object[]{trustedAlias, trustStoreRef, e.getLocalizedMessage()});
            throw new KeyException(msg, (Throwable)e);
        }
        return signingKey;
    }

    Key getPublicKey(String trustedAlias, String trustStoreRef, String signatureAlgorithm) throws KeyStoreServiceException, KeyException {
        Key signingKey = this.getPublicKeyFromKeystore(trustedAlias, trustStoreRef, signatureAlgorithm);
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Trusted alias: " + trustedAlias + ", Truststore: " + trustStoreRef), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("RSAPublicKey: " + (signingKey instanceof RSAPublicKey)), (Object[])new Object[0]);
        }
        if (signingKey != null && !(signingKey instanceof PublicKey)) {
            signingKey = null;
        }
        return signingKey;
    }

    /*
     * WARNING - void declaration
     */
    Key getPublicKeyFromKeystore(String trustedAlias, String trustStoreRef, String signatureAlgorithm) throws KeyException {
        try {
            if (this.keyStoreService == null) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_TRUSTSTORE_SERVICE_NOT_AVAILABLE", (Object[])new Object[0]);
                throw new KeyStoreServiceException(msg);
            }
            return JwtUtils.getPublicKey(trustedAlias, trustStoreRef, (KeyStoreService)this.keyStoreService.getService());
        }
        catch (Exception msg) {
            void e;
            FFDCFilter.processException((Throwable)msg, (String)"com.ibm.ws.security.jwt.internal.ConsumerUtil", (String)"359", (Object)this, (Object[])new Object[]{trustedAlias, trustStoreRef, signatureAlgorithm});
            String msg2 = Tr.formatMessage((TraceComponent)tc, (String)"JWT_NULL_SIGNING_KEY_WITH_ERROR", (Object[])new Object[]{signatureAlgorithm, "x509", e.getLocalizedMessage()});
            throw new KeyException(msg2, (Throwable)e);
        }
    }

    Key getSigningKeyForES(JwtConsumerConfig config, JwtContext jwtContext, MpConfigProperties mpConfigProps) throws KeyException {
        return this.getKeyFromJwkOrTrustStore(config, jwtContext, mpConfigProps);
    }

    protected JwtContext parseJwtWithoutValidation(String jwtString, JwtConsumerConfig config, MpConfigProperties mpConfigProps) throws Exception {
        if (jwtString == null || jwtString.isEmpty()) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_CONSUMER_NULL_OR_EMPTY_STRING", (Object[])new Object[]{config.getId(), jwtString});
            throw new InvalidTokenException(errorMsg);
        }
        return this.parseNewJwtWithoutValidation(jwtString, config, mpConfigProps);
    }

    void checkJwtFormatAgainstConfigRequirements(String jwtString, JwtConsumerConfig config, MpConfigProperties mpConfigProps) throws InvalidTokenException {
        JwtClaims jweHeaderParameters = null;
        boolean isJWE = JweHelper.isJwe(jwtString);
        if (isJWE) {
            jweHeaderParameters = JweHelper.getJweHeaderParams(jwtString);
        }
        this.checkJwtFormatAgainstConfigRequirements(jwtString, config, mpConfigProps, isJWE, jweHeaderParameters);
    }

    private void checkJwtFormatAgainstConfigRequirements(String jwtString, JwtConsumerConfig config, MpConfigProperties mpConfigProps, boolean isJWE, JwtClaims jweHeaderParameters) throws InvalidTokenException {
        if (JweHelper.isJwsRequired(config, mpConfigProps) && !JweHelper.isJws(jwtString)) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"JWS_REQUIRED_BUT_TOKEN_NOT_JWS", (Object[])new Object[]{config.getId()});
            throw new InvalidTokenException(errorMsg);
        }
        if (JweHelper.isJweRequired(config, mpConfigProps) && !isJWE) {
            String errorMsg = Tr.formatMessage((TraceComponent)tc, (String)"JWE_REQUIRED_BUT_TOKEN_NOT_JWE", (Object[])new Object[]{config.getId()});
            throw new InvalidTokenException(errorMsg);
        }
        if (isJWE) {
            this.validateHeaders(config, mpConfigProps, jweHeaderParameters);
        }
    }

    JwtContext getJwtContextFromCache(@Sensitive String jwtString, JwtConsumerConfig config) {
        this.initializeCache();
        return (JwtContext)jwtCache.get(jwtString, config.getId());
    }

    private synchronized void initializeCache() {
        long timeoutMillis = 300000L;
        if (jwtCache == null) {
            jwtCache = new JwtCache(timeoutMillis);
        }
    }

    void cacheJwtContext(@Sensitive String jwtString, JwtContext jwtContext, JwtConsumerConfig config, MpConfigProperties mpConfigProps) {
        this.initializeCache();
        jwtCache.put(jwtString, config.getId(), jwtContext, this.getClockSkew(config, mpConfigProps));
    }

    JwtContext parseNewJwtWithoutValidation(@Sensitive String jwtString, JwtConsumerConfig config, MpConfigProperties mpConfigProps) throws InvalidTokenException, InvalidJwtException {
        JwtClaims jweHeaderParameters = null;
        boolean isJWE = JweHelper.isJwe(jwtString);
        if (isJWE) {
            jweHeaderParameters = JweHelper.getJweHeaderParams(jwtString);
        }
        this.checkJwtFormatAgainstConfigRequirements(jwtString, config, mpConfigProps, isJWE, jweHeaderParameters);
        if (isJWE) {
            jwtString = JweHelper.extractJwsFromJweToken(jwtString, config, mpConfigProps, jweHeaderParameters);
        }
        JwtConsumerBuilder builder = this.initializeJwtConsumerBuilderWithoutValidation(config);
        JwtConsumer firstPassJwtConsumer = builder.build();
        return firstPassJwtConsumer.process(jwtString);
    }

    protected void validateJwtContext(JwtContext jwtContext, JwtConsumerConfig config, MpConfigProperties mpConfigProps) throws Exception {
        Key key = this.getSigningKey(config, jwtContext, mpConfigProps);
        JwtClaims jwtClaims = jwtContext.getJwtClaims();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)("Key from config: " + key), (Object[])new Object[0]);
        }
        this.validateClaims(jwtClaims, jwtContext, config, mpConfigProps);
        this.validateSignatureAlgorithmWithKey(config, key, mpConfigProps);
        JwtConsumerBuilder consumerBuilder = this.initializeJwtConsumerBuilderWithValidation(config, jwtClaims, key);
        JwtConsumer jwtConsumer = consumerBuilder.build();
        this.processJwtContextWithConsumer(jwtConsumer, jwtContext);
    }

    private void validateHeaders(JwtConsumerConfig config, MpConfigProperties mpConfigProps, JwtClaims jweHeaderParameters) throws InvalidTokenException {
        String value;
        String keyManagementKeyAlgorithm = null;
        keyManagementKeyAlgorithm = config.getKeyManagementKeyAlgorithm();
        if (keyManagementKeyAlgorithm == null && (value = (String)mpConfigProps.get("mp.jwt.decrypt.key.algorithm")) != null) {
            keyManagementKeyAlgorithm = value;
        }
        if (keyManagementKeyAlgorithm != null) {
            String tokenAlg = (String)jweHeaderParameters.getClaimValue("alg");
            this.validateKeyManagementKeyAlgorithm(keyManagementKeyAlgorithm, tokenAlg);
        }
    }

    void validateKeyManagementKeyAlgorithm(String keyManagementKeyAlgorithm, String tokenAlg) throws InvalidTokenException {
        if (tokenAlg == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Decrypt key algorithm was not found in the JWE", (Object[])new Object[0]);
            }
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWE_MISSING_ALG_HEADER", (Object[])new Object[]{keyManagementKeyAlgorithm});
            throw new InvalidTokenException(msg);
        }
        if (!keyManagementKeyAlgorithm.equals(tokenAlg)) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWE_ALGORITHM_MISMATCH", (Object[])new Object[]{tokenAlg, keyManagementKeyAlgorithm});
            throw new InvalidTokenException(msg);
        }
    }

    JwtConsumerBuilder initializeJwtConsumerBuilderWithoutValidation(JwtConsumerConfig config) {
        JwtConsumerBuilder builder = new JwtConsumerBuilder();
        builder.setSkipAllValidators();
        builder.setDisableRequireSignature();
        builder.setSkipSignatureVerification();
        builder.setAllowedClockSkewInSeconds((int)(config.getClockSkew() / 1000L));
        return builder;
    }

    JwtConsumerBuilder initializeJwtConsumerBuilderWithValidation(JwtConsumerConfig config, JwtClaims jwtClaims, Key key) throws MalformedClaimException {
        JwtConsumerBuilder builder = new JwtConsumerBuilder();
        builder.setExpectedIssuer(jwtClaims.getIssuer());
        builder.setSkipDefaultAudienceValidation();
        builder.setRequireExpirationTime();
        builder.setVerificationKey(key);
        builder.setRelaxVerificationKeyValidation();
        builder.setAllowedClockSkewInSeconds((int)(config.getClockSkew() / 1000L));
        return builder;
    }

    private long getClockSkew(JwtConsumerConfig config, MpConfigProperties mpConfigProps) {
        long clockSkew = config.getClockSkew();
        if (clockSkew < 0L) {
            String value = (String)mpConfigProps.get("mp.jwt.verify.clock.skew");
            clockSkew = value != null ? Long.valueOf(value) * 1000L : 0L;
        }
        return clockSkew;
    }

    void validateClaims(JwtClaims jwtClaims, JwtContext jwtContext, JwtConsumerConfig config, MpConfigProperties mpConfigProps) throws MalformedClaimException, InvalidClaimException, InvalidTokenException {
        String value;
        String issuer = config.getIssuer();
        if (issuer == null) {
            issuer = (String)mpConfigProps.get("mp.jwt.verify.issuer");
        }
        long clockSkew = this.getClockSkew(config, mpConfigProps);
        long tokenAgeInMilliSeconds = 0L;
        tokenAgeInMilliSeconds = config.getTokenAge();
        if (tokenAgeInMilliSeconds == 0L && (value = (String)mpConfigProps.get("mp.jwt.verify.token.age")) != null) {
            tokenAgeInMilliSeconds = Long.valueOf(value) * 1000L;
        }
        this.validateIssuer(config.getId(), issuer, jwtClaims.getIssuer());
        this.validateAudience(config, jwtClaims.getAudience(), mpConfigProps);
        if (!this.validateAMRClaim(config.getAMRClaim(), this.getJwtAMRList(jwtClaims))) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_AMR_CLAIM_NOT_VALID", (Object[])new Object[]{this.getJwtAMRList(jwtClaims), config.getId(), config.getAMRClaim()});
            throw new InvalidClaimException(msg);
        }
        this.validateIatAndExp(jwtClaims, clockSkew, tokenAgeInMilliSeconds);
        this.validateNbf(jwtClaims, clockSkew);
        this.validateAlgorithm(jwtContext, mpConfigProps.getConfiguredSignatureAlgorithm(config));
    }

    void validateSignatureAlgorithmWithKey(JwtConsumerConfig config, Key key, MpConfigProperties mpConfigProps) throws InvalidClaimException {
        String signatureAlgorithm = mpConfigProps.getConfiguredSignatureAlgorithm(config);
        if (key == null && signatureAlgorithm != null && !signatureAlgorithm.equalsIgnoreCase("none")) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_MISSING_KEY", (Object[])new Object[]{signatureAlgorithm});
            throw new InvalidClaimException(msg);
        }
    }

    boolean validateIssuer(String consumerConfigId, String issuers, String tokenIssuer) throws InvalidClaimException {
        boolean isIssuer = false;
        if (issuers == null || issuers.isEmpty()) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_TRUSTED_ISSUERS_NULL", (Object[])new Object[]{tokenIssuer, consumerConfigId});
            throw new InvalidClaimException(msg);
        }
        StringTokenizer st = new StringTokenizer(issuers, ",");
        while (st.hasMoreTokens()) {
            String iss = st.nextToken().trim();
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)("Trusted issuer: " + iss), (Object[])new Object[0]);
            }
            if (!"ALL_ISSUERS".equals(iss) && (tokenIssuer == null || !tokenIssuer.equals(iss))) continue;
            isIssuer = true;
            break;
        }
        if (!isIssuer) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_ISSUER_NOT_TRUSTED", (Object[])new Object[]{tokenIssuer, consumerConfigId, issuers});
            throw new InvalidClaimException(msg);
        }
        return isIssuer;
    }

    void validateAudience(JwtConsumerConfig config, List<String> audiences, MpConfigProperties mpConfigProps) throws InvalidClaimException {
        List<String> allowedAudiences = mpConfigProps.getConfiguredAudiences(config);
        if (allowedAudiences == null && config.ignoreAudClaimIfNotConfigured()) {
            return;
        }
        if (!this.validateAudience(allowedAudiences, audiences)) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_AUDIENCE_NOT_TRUSTED", (Object[])new Object[]{audiences, config.getId(), allowedAudiences});
            throw new InvalidClaimException(msg);
        }
    }

    boolean validateAudience(List<String> allowedAudiences, List<String> audiences) {
        boolean valid = false;
        if (allowedAudiences != null && allowedAudiences.contains("ALL_AUDIENCES")) {
            return true;
        }
        if (allowedAudiences != null && audiences != null) {
            block0: for (String audience : audiences) {
                for (String allowedAud : allowedAudiences) {
                    if (!allowedAud.equals(audience)) continue;
                    valid = true;
                    continue block0;
                }
            }
        } else if (allowedAudiences == null && (audiences == null || audiences.isEmpty())) {
            valid = true;
        }
        return valid;
    }

    void validateIatAndExp(JwtClaims jwtClaims, long clockSkewInMilliseconds, long tokenAgeInMilliSeconds) throws InvalidClaimException {
        if (jwtClaims == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Missing JwtClaims object", (Object[])new Object[0]);
            }
            return;
        }
        NumericDate issueAtClaim = this.getIssuedAtClaim(jwtClaims);
        NumericDate expirationClaim = this.getExpirationClaim(jwtClaims);
        this.debugCurrentTimes(clockSkewInMilliseconds, issueAtClaim, expirationClaim);
        this.validateIssuedAtClaim(issueAtClaim, expirationClaim, clockSkewInMilliseconds, tokenAgeInMilliSeconds);
        this.validateExpirationClaim(expirationClaim, clockSkewInMilliseconds);
    }

    void debugCurrentTimes(long clockSkewInMilliseconds, NumericDate issueAtClaim, NumericDate expirationClaim) {
        if (tc.isDebugEnabled()) {
            long now = new Date().getTime();
            NumericDate currentTimeMinusSkew = NumericDate.fromMilliseconds((long)(now - clockSkewInMilliseconds));
            NumericDate currentTimePlusSkew = NumericDate.fromMilliseconds((long)(now + clockSkewInMilliseconds));
            Tr.debug((TraceComponent)tc, (String)("Checking iat [" + this.createDateString(issueAtClaim) + "] and exp [" + this.createDateString(expirationClaim) + "]"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Comparing against current time (minus clock skew of " + clockSkewInMilliseconds / 1000L + " seconds) [" + this.createDateString(currentTimeMinusSkew) + "]"), (Object[])new Object[0]);
            Tr.debug((TraceComponent)tc, (String)("Comparing against current time (plus clock skew of " + clockSkewInMilliseconds / 1000L + " seconds) [" + this.createDateString(currentTimePlusSkew) + "]"), (Object[])new Object[0]);
        }
    }

    void validateIssuedAtClaim(NumericDate issueAtClaim, NumericDate expirationClaim, long clockSkewInMilliseconds, long tokenAgeInMilliSeconds) throws InvalidClaimException {
        long now = new Date().getTime();
        NumericDate currentTimePlusSkew = NumericDate.fromMilliseconds((long)(now + clockSkewInMilliseconds));
        if (issueAtClaim != null && expirationClaim != null) {
            if (issueAtClaim.isAfter(currentTimePlusSkew)) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_IAT_AFTER_CURRENT_TIME", (Object[])new Object[]{this.createDateString(issueAtClaim), this.createDateString(currentTimePlusSkew), clockSkewInMilliseconds / 1000L});
                throw new InvalidClaimException(msg);
            }
            if (issueAtClaim.isOnOrAfter(expirationClaim)) {
                String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_IAT_AFTER_EXP", (Object[])new Object[]{this.createDateString(issueAtClaim), this.createDateString(expirationClaim)});
                throw new InvalidClaimException(msg);
            }
            this.checkTokenAge(issueAtClaim, clockSkewInMilliseconds, tokenAgeInMilliSeconds, currentTimePlusSkew);
        }
    }

    void checkTokenAge(NumericDate issueAtClaim, long clockSkewInMilliseconds, long tokenAgeInMilliSeconds, NumericDate currentTimePlusSkew) throws InvalidClaimException {
        if (tokenAgeInMilliSeconds <= 0L) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The JWT's token age verification is disabled because the tokenAge attribute and mp.jwt.verify.token.age property are both 0 or less.", (Object[])new Object[]{tokenAgeInMilliSeconds});
            }
            return;
        }
        long now = new Date().getTime();
        NumericDate issueAtClaimPlusTokenAge = issueAtClaim;
        issueAtClaimPlusTokenAge.addSeconds(tokenAgeInMilliSeconds / 1000L);
        NumericDate currentTimeMinusSkew = NumericDate.fromMilliseconds((long)(now - clockSkewInMilliseconds));
        if (issueAtClaimPlusTokenAge.isBefore(currentTimeMinusSkew)) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_TOKEN_AGED", (Object[])new Object[]{this.createDateString(issueAtClaim), this.createDateString(currentTimeMinusSkew), clockSkewInMilliseconds / 1000L, tokenAgeInMilliSeconds / 1000L});
            throw new InvalidClaimException(msg);
        }
    }

    void validateExpirationClaim(NumericDate expirationClaim, long clockSkewInMilliseconds) throws InvalidClaimException {
        long now = new Date().getTime();
        NumericDate currentTimeMinusSkew = NumericDate.fromMilliseconds((long)(now - clockSkewInMilliseconds));
        if (expirationClaim == null || !expirationClaim.isAfter(currentTimeMinusSkew)) {
            JwtUtils.setJwtSsoValidationPathExiredToken();
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_TOKEN_EXPIRED", (Object[])new Object[]{this.createDateString(expirationClaim), this.createDateString(currentTimeMinusSkew), clockSkewInMilliseconds / 1000L});
            throw new InvalidClaimException(msg);
        }
    }

    void validateNbf(JwtClaims jwtClaims, long clockSkewInMilliseconds) throws InvalidClaimException {
        if (jwtClaims == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Missing JwtClaims object", (Object[])new Object[0]);
            }
            return;
        }
        NumericDate nbf = this.getNotBeforeClaim(jwtClaims);
        this.validateNotBeforeClaim(nbf, clockSkewInMilliseconds);
    }

    void validateNotBeforeClaim(NumericDate nbfClaim, long clockSkewInMilliseconds) throws InvalidClaimException {
        long now = new Date().getTime();
        NumericDate currentTimePlusSkew = NumericDate.fromMilliseconds((long)(now + clockSkewInMilliseconds));
        if (nbfClaim != null && nbfClaim.isOnOrAfter(currentTimePlusSkew)) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_TOKEN_BEFORE_NBF", (Object[])new Object[]{this.createDateString(nbfClaim), this.createDateString(currentTimePlusSkew), clockSkewInMilliseconds / 1000L});
            throw new InvalidClaimException(msg);
        }
    }

    /*
     * WARNING - void declaration
     */
    NumericDate getIssuedAtClaim(JwtClaims jwtClaims) throws InvalidClaimException {
        NumericDate iatClaim = null;
        try {
            iatClaim = jwtClaims.getIssuedAt();
        }
        catch (MalformedClaimException malformedClaimException) {
            void e;
            FFDCFilter.processException((Throwable)malformedClaimException, (String)"com.ibm.ws.security.jwt.internal.ConsumerUtil", (String)"795", (Object)this, (Object[])new Object[]{jwtClaims});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_CONSUMER_MALFORMED_CLAIM", (Object[])new Object[]{"iat", e.getLocalizedMessage()});
            throw new InvalidClaimException(msg, (Throwable)e);
        }
        return iatClaim;
    }

    /*
     * WARNING - void declaration
     */
    NumericDate getExpirationClaim(JwtClaims jwtClaims) throws InvalidClaimException {
        NumericDate expClaim = null;
        try {
            expClaim = jwtClaims.getExpirationTime();
        }
        catch (MalformedClaimException malformedClaimException) {
            void e;
            FFDCFilter.processException((Throwable)malformedClaimException, (String)"com.ibm.ws.security.jwt.internal.ConsumerUtil", (String)"807", (Object)this, (Object[])new Object[]{jwtClaims});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_CONSUMER_MALFORMED_CLAIM", (Object[])new Object[]{"exp", e.getLocalizedMessage()});
            throw new InvalidClaimException(msg, (Throwable)e);
        }
        return expClaim;
    }

    /*
     * WARNING - void declaration
     */
    NumericDate getNotBeforeClaim(JwtClaims jwtClaims) throws InvalidClaimException {
        NumericDate nbfClaim = null;
        try {
            nbfClaim = jwtClaims.getNotBefore();
        }
        catch (MalformedClaimException malformedClaimException) {
            void e;
            FFDCFilter.processException((Throwable)malformedClaimException, (String)"com.ibm.ws.security.jwt.internal.ConsumerUtil", (String)"819", (Object)this, (Object[])new Object[]{jwtClaims});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_CONSUMER_MALFORMED_CLAIM", (Object[])new Object[]{"nbf", e.getLocalizedMessage()});
            throw new InvalidClaimException(msg, (Throwable)e);
        }
        return nbfClaim;
    }

    void validateAlgorithm(JwtContext jwtContext, String requiredAlg) throws InvalidTokenException {
        if (requiredAlg == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"No required signature algorithm was specified", (Object[])new Object[0]);
            }
            return;
        }
        String tokenAlg = this.getAlgorithmFromJwtHeader(jwtContext);
        this.validateAlgorithm(requiredAlg, tokenAlg);
    }

    void validateAlgorithm(String requiredAlg, String tokenAlg) throws InvalidTokenException {
        if (tokenAlg == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Signature algorithm was not found in the JWT", (Object[])new Object[0]);
            }
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_MISSING_ALG_HEADER", (Object[])new Object[]{requiredAlg});
            throw new InvalidTokenException(msg);
        }
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"JWT is signed with algorithm: ", (Object[])new Object[]{tokenAlg});
            Tr.debug((TraceComponent)tc, (String)"JWT is required to be signed with algorithm: ", (Object[])new Object[]{requiredAlg});
        }
        if (!requiredAlg.equals(tokenAlg)) {
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_ALGORITHM_MISMATCH", (Object[])new Object[]{tokenAlg, requiredAlg});
            throw new InvalidTokenException(msg);
        }
    }

    /*
     * WARNING - void declaration
     */
    void processJwtContextWithConsumer(JwtConsumer jwtConsumer, JwtContext jwtContext) throws InvalidTokenException, InvalidJwtException {
        try {
            jwtConsumer.processContext(jwtContext);
        }
        catch (InvalidJwtSignatureException invalidJwtSignatureException) {
            void e;
            FFDCFilter.processException((Throwable)invalidJwtSignatureException, (String)"com.ibm.ws.security.jwt.internal.ConsumerUtil", (String)"860", (Object)this, (Object[])new Object[]{jwtConsumer, jwtContext});
            String msg = Tr.formatMessage((TraceComponent)tc, (String)"JWT_INVALID_SIGNATURE", (Object[])new Object[]{e.getLocalizedMessage()});
            throw new InvalidTokenException(msg, (Throwable)e);
        }
        catch (InvalidJwtException e) {
            FFDCFilter.processException((Throwable)e, (String)"com.ibm.ws.security.jwt.internal.ConsumerUtil", (String)"863", (Object)this, (Object[])new Object[]{jwtConsumer, jwtContext});
            Throwable cause = this.getRootCause((Exception)((Object)e));
            if (cause != null && cause instanceof InvalidKeyException) {
                throw e;
            }
            throw e;
        }
    }

    String getAlgorithmFromJwtHeader(JwtContext jwtContext) {
        if (jwtContext == null) {
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"JwtContext is null", (Object[])new Object[0]);
            }
            return null;
        }
        JsonWebStructure jwtHeader = null;
        try {
            jwtHeader = this.getJwtHeader(jwtContext);
        }
        catch (Exception exception) {
            FFDCFilter.processException((Throwable)exception, (String)"com.ibm.ws.security.jwt.internal.ConsumerUtil", (String)"885", (Object)this, (Object[])new Object[]{jwtContext});
            if (tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"Failed to obtain JWT header", (Object[])new Object[0]);
            }
            return null;
        }
        String algHeader = jwtHeader.getAlgorithmHeaderValue();
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"JWT is signed with algorithm: ", (Object[])new Object[]{algHeader});
        }
        return algHeader;
    }

    Throwable getRootCause(Exception e) {
        Exception rootCause = null;
        Throwable tmpCause = e;
        while (tmpCause != null) {
            rootCause = tmpCause;
            tmpCause = rootCause.getCause();
        }
        return rootCause;
    }

    String createDateString(NumericDate date) {
        if (date == null) {
            return null;
        }
        return timeUtils.createDateString(1000L * date.getValue());
    }

    List<String> getJwtAMRList(JwtClaims jwtClaims) throws MalformedClaimException {
        String claimName = "amr";
        Object amrObject = jwtClaims.getClaimValue(claimName);
        if (amrObject instanceof String) {
            return Collections.singletonList(jwtClaims.getStringClaimValue(claimName));
        }
        if (!(amrObject instanceof List) && amrObject != null) {
            throw new MalformedClaimException("The value of the 'amr' claim is not an array of strings or a single string value.");
        }
        return jwtClaims.getStringListClaimValue(claimName);
    }

    boolean validateAMRClaim(List<String> allowedAmrClaim, List<String> jwtAMRClaims) {
        boolean valid = false;
        if (allowedAmrClaim != null && jwtAMRClaims != null) {
            if (allowedAmrClaim.size() == 1) {
                List<String> allowedAMRSingle = Arrays.asList(allowedAmrClaim.get(0).split(" "));
                if (jwtAMRClaims.containsAll(allowedAMRSingle)) {
                    valid = true;
                }
            } else {
                for (String allowedAMR : allowedAmrClaim) {
                    List<String> allowedAMRSingle = Arrays.asList(allowedAMR.split(" "));
                    if (!jwtAMRClaims.equals(allowedAMRSingle)) continue;
                    valid = true;
                    break;
                }
            }
        } else if (allowedAmrClaim == null) {
            valid = true;
        }
        return valid;
    }
}

