/*
 * Decompiled with CFR 0.152.
 */
package io.openliberty.smallrye.metrics.cdi.adapters;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.websphere.ras.annotation.TraceOptions;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import io.openliberty.microprofile.metrics50.helper.Util;
import io.openliberty.smallrye.metrics.cdi.adapters.LegacyMetricsExtensionAdapter;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.Produces;
import jakarta.enterprise.inject.spi.InjectionPoint;
import jakarta.inject.Inject;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Timer;

@ApplicationScoped
@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
@TraceOptions
public class MetricProducerAdapter {
    static Class<?> srMetricProducerClass;
    static Object srMetricProducerObj;
    private static final TraceComponent tc;
    static final long serialVersionUID = 138616635110724273L;

    @Inject
    public MetricProducerAdapter(LegacyMetricsExtensionAdapter extensionAdapter) {
        srMetricProducerClass = Util.SR_METRICS_PRODUCER_CLASS;
        if (srMetricProducerClass == null) {
            if (TraceComponent.isAnyTracingEnabled() && tc.isDebugEnabled()) {
                Tr.debug((TraceComponent)tc, (String)"The SmallRye MetricProducer class was not resolved.", (Object[])new Object[0]);
            }
        } else {
            try {
                srMetricProducerObj = srMetricProducerClass.getConstructor(Util.SR_LEGACY_METRIC_REGISTRY_EXTENSION_CLASS).newInstance(Util.SR_LEGACY_METRIC_REGISTRY_EXTENSION_CLASS.cast(extensionAdapter.getLegacyMetricExtensionObject()));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
                FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.smallrye.metrics.cdi.adapters.MetricProducerAdapter", (String)"64", (Object)this, (Object[])new Object[]{extensionAdapter});
            }
        }
    }

    @Produces
    public <T extends Number> Gauge<T> getGauge(InjectionPoint ip) {
        if (srMetricProducerObj == null) {
            return null;
        }
        try {
            Method method = srMetricProducerObj.getClass().getMethod("getGauge", InjectionPoint.class);
            return (Gauge)method.invoke(srMetricProducerObj, ip);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.smallrye.metrics.cdi.adapters.MetricProducerAdapter", (String)"82", (Object)this, (Object[])new Object[]{ip});
            return null;
        }
    }

    @Produces
    public Counter getCounter(InjectionPoint ip) {
        if (srMetricProducerObj == null) {
            return null;
        }
        try {
            Method method = srMetricProducerObj.getClass().getMethod("getCounter", InjectionPoint.class);
            return (Counter)method.invoke(srMetricProducerObj, ip);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.smallrye.metrics.cdi.adapters.MetricProducerAdapter", (String)"101", (Object)this, (Object[])new Object[]{ip});
            return null;
        }
    }

    @Produces
    public Timer getTimer(InjectionPoint ip) {
        if (srMetricProducerObj == null) {
            return null;
        }
        try {
            Method method = srMetricProducerObj.getClass().getMethod("getTimer", InjectionPoint.class);
            return (Timer)method.invoke(srMetricProducerObj, ip);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.smallrye.metrics.cdi.adapters.MetricProducerAdapter", (String)"120", (Object)this, (Object[])new Object[]{ip});
            return null;
        }
    }

    @Produces
    public Histogram getHistogram(InjectionPoint ip) {
        if (srMetricProducerObj == null) {
            return null;
        }
        try {
            Method method = srMetricProducerObj.getClass().getMethod("getHistogram", InjectionPoint.class);
            return (Histogram)method.invoke(srMetricProducerObj, ip);
        }
        catch (IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException exception) {
            FFDCFilter.processException((Throwable)exception, (String)"io.openliberty.smallrye.metrics.cdi.adapters.MetricProducerAdapter", (String)"139", (Object)this, (Object[])new Object[]{ip});
            return null;
        }
    }

    @InjectedTrace(value={"com.ibm.ws.ras.instrument.internal.bci.LibertyTracingMethodAdapter"})
    static {
        tc = Tr.register(MetricProducerAdapter.class, null, null);
    }
}

