/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.recoverylog.spi;

import com.ibm.websphere.ras.Tr;
import com.ibm.websphere.ras.TraceComponent;
import com.ibm.websphere.ras.annotation.InjectedTrace;
import com.ibm.websphere.ras.annotation.ManualTrace;
import com.ibm.websphere.ras.annotation.TraceObjectField;
import com.ibm.ws.ffdc.FFDCFilter;
import com.ibm.ws.ras.instrument.annotation.InjectedFFDC;
import com.ibm.ws.recoverylog.spi.Configuration;
import com.ibm.ws.recoverylog.spi.RLSController;
import com.ibm.ws.recoverylog.spi.RLSInvalidSuspendTokenException;
import com.ibm.ws.recoverylog.spi.RLSSuspendToken;
import com.ibm.ws.recoverylog.spi.RLSSuspendTokenManager;
import com.ibm.ws.recoverylog.spi.RLSTimeoutRangeException;
import com.ibm.ws.recoverylog.spi.RLSUtils;

@TraceObjectField(fieldName="tc", fieldDesc="Lcom/ibm/websphere/ras/TraceComponent;")
@InjectedFFDC
public class RLSControllerImpl
implements RLSController {
    private static final TraceComponent tc = Tr.register(RLSControllerImpl.class, (String)"Transaction", (String)"com.ibm.ws.recoverylog.resources.RecoveryLogMsgs");
    static Object SUSPEND_LOCK = new Object();
    private static RLSSuspendTokenManager _tokenManager = RLSSuspendTokenManager.getInstance();
    private static boolean _isSuspended;
    static final long serialVersionUID = 7605675306773699983L;

    RLSControllerImpl() {
        if (tc.isDebugEnabled()) {
            Tr.debug((TraceComponent)tc, (String)"RLSControllerImpl", (Object[])new Object[]{this});
        }
    }

    @Override
    @ManualTrace
    public void resume(RLSSuspendToken token) throws RLSInvalidSuspendTokenException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resume", (Object[])new Object[]{token});
        }
        RLSControllerImpl.resumeRLS(token);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resume");
        }
    }

    @Override
    @ManualTrace
    public void resume(byte[] tokenBytes) throws RLSInvalidSuspendTokenException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resume", (Object[])new Object[]{RLSUtils.toHexString(tokenBytes)});
        }
        RLSSuspendToken token = Configuration.getRecoveryLogComponent().createRLSSuspendToken(tokenBytes);
        RLSControllerImpl.resumeRLS(token);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resume");
        }
    }

    @Override
    @ManualTrace
    public RLSSuspendToken suspend(int timeout) throws RLSTimeoutRangeException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"suspend", (Object[])new Object[]{timeout});
        }
        RLSSuspendToken token = RLSControllerImpl.suspendRLS(timeout);
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"suspend");
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    private static RLSSuspendToken suspendRLS(int timeout) throws RLSTimeoutRangeException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"suspendRLS", (Object[])new Object[]{timeout});
        }
        if (timeout < 0 || timeout > 1000000000) {
            if (tc.isEventEnabled()) {
                Tr.event((TraceComponent)tc, (String)"Timeout value is out of range - throwing RLSTimeoutRangeException", (Object[])new Object[]{timeout});
            }
            if (tc.isEntryEnabled()) {
                Tr.exit((TraceComponent)tc, (String)"suspend", (Object)"RLSTimeoutRangeException");
            }
            throw new RLSTimeoutRangeException();
        }
        RLSSuspendToken token = null;
        Object object = SUSPEND_LOCK;
        synchronized (object) {
            Tr.warning((TraceComponent)tc, (String)"CWRLS0020_SNAPSHOT_SAFE", (Object[])new Object[0]);
            token = _tokenManager.registerSuspend(timeout);
            Tr.info((TraceComponent)tc, (String)"CWRLS0001_SUSPEND_RLS", (Object[])new Object[]{token});
            _isSuspended = true;
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"suspendRLS", (Object)token);
        }
        return token;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @ManualTrace
    private static void resumeRLS(RLSSuspendToken token) throws RLSInvalidSuspendTokenException {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"resumeRLS", (Object[])new Object[]{token});
        }
        Object object = SUSPEND_LOCK;
        synchronized (object) {
            try {
                _tokenManager.registerResume(token);
            }
            catch (RLSInvalidSuspendTokenException rLSInvalidSuspendTokenException) {
                void exc;
                FFDCFilter.processException((Throwable)rLSInvalidSuspendTokenException, (String)"com.ibm.ws.recoverylog.spi.RLSControllerImpl", (String)"178", null, (Object[])new Object[]{token});
                FFDCFilter.processException((Throwable)exc, (String)"com.ibm.ws.recoverylog.spi.RecoveryLogService.resume", (String)"120");
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Rethrow RLSInvalidSuspendTokenException - attempt to resume an invalid token", (Object[])new Object[]{token});
                }
                if (tc.isEntryEnabled()) {
                    Tr.exit((TraceComponent)tc, (String)"resumeRLS", (Object)exc);
                }
                throw exc;
            }
            if (_tokenManager.isResumable()) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"There are no outstanding suspends - resuming recovery log service", (Object[])new Object[0]);
                }
                Tr.info((TraceComponent)tc, (String)"CWRLS0002_RESUME_RLS", (Object[])new Object[]{token});
                _isSuspended = false;
                SUSPEND_LOCK.notifyAll();
            } else {
                Tr.info((TraceComponent)tc, (String)"CWRLS0021_RESUME_ATTEMPT_RLS", (Object[])new Object[]{token});
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"There are still outstanding suspensions - recovery log service remains suspended", (Object[])new Object[0]);
                }
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"resumeRLS");
        }
    }

    static boolean isSuspended() {
        return _isSuspended;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ManualTrace
    static void notifyTimeout() {
        if (tc.isEntryEnabled()) {
            Tr.entry((TraceComponent)tc, (String)"notifyTimeout", (Object[])new Object[0]);
        }
        Object object = SUSPEND_LOCK;
        synchronized (object) {
            if (_tokenManager.isResumable()) {
                if (tc.isEventEnabled()) {
                    Tr.event((TraceComponent)tc, (String)"Resuming recovery log service following a suspension timeout", (Object[])new Object[0]);
                }
                _isSuspended = false;
                Tr.info((TraceComponent)tc, (String)"CWRLS0023_RESUME_RLS", (Object[])new Object[0]);
                SUSPEND_LOCK.notifyAll();
            }
        }
        if (tc.isEntryEnabled()) {
            Tr.exit((TraceComponent)tc, (String)"notifyTimeout");
        }
    }
}

